! This is the program to set up variables for running rafuliougu. 
! It can be also replaced by variable input from coupled models like WRF. 
! Vertical profiles of the atmosphere (pressure, temperature, humidity, 
! ozone mixing ratio) are required for running model. 
! Optional inputs include location (latitudem longitude), time (day, time)
! and cloud properties(piwc, plwc, prwc, pgwc, pde, pre). 

program fu_liou_gu_main

  use fu_liou_gu_table, only: mbs,mbir,nv,nv1,nvx,mxac,mxat       &
                       &     ,ngas,naero,nfract,nu0,u0,ss         &
                       &     ,itps,nfraca,ivd,npde,npde_zone,pderandom      &
                       &     ,umco,umo2,umno,umso2,umno2,umch3cl
                        
  use fu_liou_gu, only: rad,rad_cld,findu0,aer_scale_hgt
  
  implicit none
  real, dimension(nv1) :: pp, pt, ph, po, temp
  real, dimension(nv1) ::  fds  = 0.,  &
 &                         fus  = 0.,  &
 &                         fdir = 0.,  &
 &                         fuir = 0.,  &
 &                         fd   = 0.,  &
 &                         fu   = 0.
  real, dimension(nv)  ::  dts  = 0.,  &
 &                         dtir = 0.,  &
 &                         dt   = 0.

  real                 :: alat, alon, day, time
  real, dimension(nv)  :: piwc, plwc, prwc, pgwc, pde, pre, cldamnt
  real                 :: tau_aer, tot
  real, dimension(mxac):: fraca = -9999., tauindividual
  integer     :: i, iac
  character   :: reading = "Y"
! -- add by Yu for aerosol 
  real,dimension(mxat,mxac) :: a_wlis,a_taus
  real,dimension(nvx,mxac)  :: aprofs
  real                      :: sh_aer(mxac)
! - add over
  real :: as(mbs), ee(mbir), pts
  data as / mbs * 0.1 /
  data ee / mbir * 1.0 /


! -- add for input profile
  character*8 :: name(3)
  data name/'ktrp.lay','kmls.lay','ksaw.lay'/
!        character*8 nam
! -- added over

! -- add for de-iwc (NPDE=2)
  real :: amean(4),bmean(4),cmean(4)
  real :: amax(4),bmax(4),cmax(4)
  real :: amin(4),bmin(4),cmin(4)

  data amin /0.54763e01, 0, 0.43976e01, 0.47890e01/
  data bmin /0.55175, 0, 0.11286, 0.34200/
  data cmin /0.26934e-1, 0, 0, -0.58155e-2/

  data amean /0.54199e01, 0.43257e01, 0.52375e01, 0.4851e01/
  data bmean /0.35211, 0.26535, 0.13142, 0.33159/
  data cmean /0.1268e-1, 0.21864e-1, 0., 0.26189e-1/

  data amax /0.53544e01, 0.51222e01, 0.53341e01, 0.48755e01/
  data bmax /0.30605, 0.38239, 0.10258, 0.35331/
  data cmax /0.11531e-1, 0.27872e-1, 0, 0.36475e-1/

  real :: iwc_mean(4), iwc_max(4), iwc_min(4)
  data iwc_min /5.e-5, 0, 0, 0/
  data iwc_mean /9.2125e-7, 0.0024, 0, 0/
  data iwc_max /1.75e-6, 0.0011, 0, 0.0082/

  real :: pdeiwc_mean(4), pdeiwc_max(4), pdeiwc_min(4)
  data pdeiwc_min /14.2067, 29, 0, 0/ 
  data pdeiwc_mean /19.6, 33.81, 0, 0/ 
  data pdeiwc_max /27.76, 45.18, 0, 55.7/ 

  integer :: ncoef
!  real    :: diff, diff_min, diff_max
  real temp_i, ran1, x
  real diff, diff_min, diff_max
  real pde_max, pde_mean, pde_min, pde_ran
  real pde_min_temp, pde_max_temp
  real palpha, pbeta, pgama, peta, pde0, piwc0, pco0, paot
  real a1denom, a2num, a2denom
  real temp_iwc, temp_t, temp_de, pt_temp 
! -- add over

!C--- for NPDE = 4, De-IWC-AOT using satellite data
  real palpha_all(4),pbeta_all(4), pgamma_all(4), peta_all(4)
  real pde0_all(4), piwc0_all(4), pco0_all(4)
!C--- dim: 1=Global; 2=South America; 3=Africa; 4=Asia
  data palpha_all /1.322, 1.396, 1.842, 1.509/
  data pbeta_all /0.544, 1.095, 1.823, 0.973/
  data pgamma_all /0.407, 0.533, 0.520, 0.921/
  data peta_all /0.085, 0.007, 0.005, 0.188/
  data pde0_all /48.383, 55.536, 53.144, 35.03/
  data piwc0_all /1.165, 1.7, 2.277, 2.204/
  data pco0_all /7.322, 88.532, 157.24, 6.723/
!c--- add over
! -- add over

! --if naero=1, aerosol effect included; naero=0, no aerosol considered
!  naero  = 1    
! --if nfraca=1, use precribed total AOD, aerosol types and fractions; 
!      nfraca=2, input total AOD, aerosol types and fractions from screen;
!      nfraca=3, input aerosol types and optical depths. 
! --if nfract=1, partly cloudy. Then need to set ngroup,nclouds,nsubcld in para.file 
!  nfract = 0   
!  nfraca = 2 

! -- set parameters for solar radiation
  ss = 1366.
  if (nu0.eq.0) u0 = 0.5042183
  if (nu0.eq.1) then
    write(*,*) 'Latitude (-90.0~90.0):'
    read(*,*) alat
    write(*,*) 'Longitude (-180.0~180.0):'
    read(*,*) alon
    write(*,*) 'Day in year (1~365):'
    read(*,*) day
    write(*,*) 'Time in hours (e.g. 14.50 for 2:30pm):'
    read(*,*) time
    call findu0(day,alat,alon,time,u0)
  end if
! -- setting over

! -----------------------------------------------------------
! -- read in profile or get value from model
  open ( unit = 08, file = 'ktrop.lay', status = 'old' )
  read ( 08, * ) ( pp(i), pt(i), ph(i), po(i), &
   &      temp(i),i = 1, nv1 )
! -- read in from different profile
!        iprofile=4
!        if(iprofile.lt.4) then
!         nam=name(iprofile)
!         call vtc_AFGL(nam)
!        else
!         call vtc_us1976
!        end if
  pts = pt(nv1)
  do i = 1, nv
    if (ph(i).lt.1.e-20) ph(i)=1.e-20
  end do  
! -- reading over

! --- gas concentration
!----------------------------------------------------------------
  if (ngas.eq.0) then
    umco=0.
    umo2=0.
    umno=0.
    umso2=0.
    umno2=0.
    umch3cl=0.
  end if

! -- set up cloud water content
  do i = 1, nv
    plwc(i) = 0.0
    piwc(i) = 0.0
    pgwc(i) = 0.0
    prwc(i) = 0.0
    if (npde .eq. 0) then
      pde(i) = 85.0            !prescribed ice crystal size
    end if
    pre(i) = 10.0              !prescribed droplet size
    cldamnt(i) = 1.0
  end do
! --- if one level of cloud, piwc can be prescribed here
!  piwc(25) = 0.015


!C******************************************************************
!C--- if cloud profiles available, read in variables such as
!      cloud water content, size, cloud amount 
!C--- uncomment the following and modify according to the data format
!C******************************************************************
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  open ( unit = 09, file = 'cloud.lay', status = 'old' )
!  read ( 09, * ) ( piwc(i), plwc(i), prwc(i), pgwc(i),&
! & pde(i), pre(i), cldamnt(i),i = 1, nv)
! -- reading over
! ---------------------------------------------------------------
! -- setting over

!C******************************************************************
!C******************************************************************
!C--- calculate ice crystal size (De) if size not available
!C******************************************************************
!C******************************************************************

  do i = 1,nv
!C******************************************************************
!C--- NPDE=1, papa. in terms of IWC & T (Gu & Liou, 2006)
!C***********************************************************************
   if (NPDE.eq.1.and.piwc(i).gt.0.) then
    !C--- for temperature between 213K and 253K
    if (pt(i).lt.253.0.and.pt(i).gt.213.) then
      TEMP_IWC = exp(-7.6 & 
     &   +4.*exp(-0.2443e-3*(253.-pt(i))**2.445))
                                                                                      TEMP_T = pt(i) - 273.  
      TEMP_DE = 326.3+12.42*TEMP_T+0.197*TEMP_T*TEMP_T & 
     &   +0.0012*TEMP_T**3 
      pde(i) = (piwc(i)/TEMP_IWC)**(1./3.)*TEMP_DE 
      if (pde(i).gt.150.) pde(i)=150.  
      if (pde(i).lt.10.) pde(i)=10.
    else 
      !C--- for temperature outside 213K and 253K
      pde(i) = 85.
    endif 
!c--- end if temperature for NPDE=1 
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!C***********************************************************************
!C---- NPDE=2, new de para. in terms of iwc (Liou et al. 2008)
!C***********************************************************************
   else if (NPDE.eq.2.and.piwc(i).gt.0.) then


        if(piwc(i).gt.0.) then
! -- npde=1, para. for tropical area---
          if (npde_zone.eq.1) ncoef = 1
! -- npde = 2, cold & warm cirrus case in midlatitude
          if (npde_zone.eq.2) then
            pt_temp=pt(i)
! -- force to use warm midlatitude formulation
!        pt_temp = 243
            if (pt_temp.le.233) then
              ncoef = 2
            else
              ncoef =3
            endif
          endif
! -- npde = 3, polar region 
          if (npde_zone.eq.3) ncoef = 4 
 
! - for IWC larger than critical value 
!           if (piwc(i).gt.iwc_mean(ncoef)) then
            temp_i = alog(piwc(i))
! -- calculate ln(De)
            pde_mean = amean(ncoef)+bmean(ncoef)*temp_i &
     &                      +cmean(ncoef)*temp_i**2.
            pde_max = amax(ncoef)+bmax(ncoef)*temp_i &
     &                      +cmax(ncoef)*temp_i**2.
            pde_min = amin(ncoef)+bmin(ncoef)*temp_i &
     &                      +cmin(ncoef)*temp_i**2.

! -- calculate de
            pde_mean = exp(pde_mean)
            pde_max = exp(pde_max)
            pde_min = exp(pde_min)

! -- if IWC smaller than critical, use a constant value
            if (piwc(i).le.iwc_mean(ncoef)) pde_mean &
     &          = pdeiwc_mean(ncoef) 
            if (piwc(i).le.iwc_max(ncoef)) pde_max &
     &          = pdeiwc_max(ncoef) 
            if (piwc(i).le.iwc_min(ncoef)) pde_min &
     &          = pdeiwc_min(ncoef) 
            if (pde_max.eq.1) pde_max &
     &          = pdeiwc_max(ncoef)
            if (pde_min.eq.1) pde_min &
     &          = pdeiwc_min(ncoef)
 
! --  generate a random number between pde_min and pde_max
            call random_number(x)
            ran1 = x
            diff_max = pde_max - pde_mean
            diff_min = pde_mean - pde_min
            diff = diff_max

! - using smaller difference 
            if (diff_min.lt.diff_max) diff = diff_min 
! - using larger difference 
!          if (diff_min.gt.diff_max) diff = diff_min 

            pde_min_temp = pde_mean - diff
            pde_max_temp = pde_mean + diff
            pde_ran = (pde_max_temp-pde_min_temp)*ran1 + pde_min_temp

! --- constraint
!            if (pde_ran .gt. pde_max) pde_ran = pde_max
!            if (pde_ran .lt. pde_min) pde_ran = pde_min
!      print *, 'pde_mean, max, min,ran=', pde_mean,pde_max,pde_min
!     &        ,   pde_ran
! -- calculate De
            if (pderandom) then
              pde(i) = pde_ran
            else
              pde(i) = pde_mean
            endif 
          endif 
! -- end of npde

! -- if De smaller than 10 or larger than 150, Fu-Liou can't handle
          if (pde(i).lt.10.) pde(i) = 10.
          if (pde(i).gt.150.) pde(i) = 150.
!      print *, niwc, pde(i)
!c--- end of npde=2

!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!c--- NPDE=0, prescribed pde
!C******************************************************************
!     else if (NPDE.eq.0) then
!      if (piwc(i).gt.0.) then
!CCCCCCCCCCCC-------- CTRL value --------CCCCCCCCCCCCCC
!!        pde(i) = 11.
!        pde(i) = 85.
!      endif


     endif
    end do
! -- end of De calculation

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! -- read in aerosol AOD and type 
!aerosol type: 01) marine; 
!              02) continental; 
!              03) urban; 
!              04) 0.5 um mineral dust; 
!              05) 1.0 um mineral dust; 
!              06) 2.0 um mineral dust; 
!              07) 4.0 um mineral dust; 
!              08) 8.0 um mineral dust; 
!              09) insoluble; 
!              10) water soluble (8 RH%); 
!              11) soot; 
!              12) sea salt (accumulation mode) (8 RH%); 
!              13) sea salt (coarse mode) (8 RH%);
!              14) mineral dust (nucleation mode); 
!              15) mineral dust (accumulation mode);
!              16) mineral dust (coarse mode); 
!              17) mineral dust (transport mode);
!              18) sulfate droplets (8 RH%) 
 if (naero.gt.0) then
  Select case(nfraca)
  case(1) ! -- precribed aerosol information
    tau_aer    = 0.2  !total aerosol optical depth
    fraca(2)   = 0.9  !fraction of continental aerosols
    fraca(11)  = 0.1  !fraction of soot aerosols
    do iac = 1, mxac
      if (fraca(iac).ge.-999.) itps(iac) = 1
    end do

  case(2) ! -- type in aerosol types and fractions
    write (*,*) "Please type in total AOD: "
    read (*,*) tau_aer
    write (*,*) "01) marine; "
    write (*,*) "02) continental; "
    write (*,*) "03) urban; "
    write (*,*) "04) 0.5 um mineral dust; "
    write (*,*) "05) 1.0 um mineral dust; "
    write (*,*) "06) 2.0 um mineral dust; "
    write (*,*) "07) 4.0 um mineral dust; "
    write (*,*) "08) 8.0 um mineral dust; "
    write (*,*) "09) insoluble; "
    write (*,*) "10) water soluble (8 RH%); "
    write (*,*) "11) soot; "
    write (*,*) "12) sea salt (accumulation mode) (8 RH%); "
    write (*,*) "13) sea salt (coarse mode) (8 RH%); "
    write (*,*) "14) mineral dust (nucleation mode); "
    write (*,*) "15) mineral dust (accumulation mode); "
    write (*,*) "16) mineral dust (coarse mode); "
    write (*,*) "17) mineral dust (transport mode); "
    write (*,*) "18) sulfate droplets (8 RH%) "
    do while (reading.eq."Y".or.reading.eq."y")
      write (*,*) "Please select an aerosol type (an integer from 1-18):"
      read (*,*) iac
      itps(iac) = 1
      write (*,*) "Please type in corresponding fraction:"
      read (*,*) fraca(iac)
      write (*,*) "Continue inputting? (Y or N)"
      read (*,*) reading
    end do

  case(3) ! -- type in aerosol optical depths
    write (*,*) "01) marine; "
    write (*,*) "02) continental; "
    write (*,*) "03) urban; "
    write (*,*) "04) 0.5 um mineral dust; "
    write (*,*) "05) 1.0 um mineral dust; "
    write (*,*) "06) 2.0 um mineral dust; "
    write (*,*) "07) 4.0 um mineral dust; "
    write (*,*) "08) 8.0 um mineral dust; "
    write (*,*) "09) insoluble; "
    write (*,*) "10) water soluble (8 RH%); "
    write (*,*) "11) soot; "
    write (*,*) "12) sea salt (accumulation mode) (8 RH%); "
    write (*,*) "13) sea salt (coarse mode) (8 RH%); "
    write (*,*) "14) mineral dust (nucleation mode); "
    write (*,*) "15) mineral dust (accumulation mode); "
    write (*,*) "16) mineral dust (coarse mode); "
    write (*,*) "17) mineral dust (transport mode); "
    write (*,*) "18) sulfate droplets (8 RH%) "
    tau_aer = 0.0
    tauindividual = -9999.
    do while (reading.eq."Y".or.reading.eq."y")
      write (*,*) "Please select an aerosol type (an integer from 1-18):"
      read (*,*) iac
      itps(iac) = 1
      write (*,*) "Please type in corresponding optical depth:"
      read (*,*) tauindividual(iac)
      tau_aer = tau_aer + tauindividual(iac)
      write (*,*) "Continue inputting? (Y or N)"
      read (*,*) reading
    end do
    do iac = 1, mxac
      if (itps(iac).eq.1) fraca(iac) = tauindividual(iac) / tau_aer
    end do
    
  case default
    stop 'nfraca: Bad aerosol input'
    
  end Select
! end of reading aerosol AOD & type

! -- read aerosol vertical profile
    a_wlis =-9999.
    a_taus =-9999.
    sh_aer=3.

    do iac=1,mxac
      if (itps(iac).eq.1) then
        if (ivd.eq.1) then
          call aer_scale_hgt(pp,sh_aer(iac),aprofs(1:nv,iac))
        else if (ivd.eq.2) then
          write(*,*) 'Input profile(in percentage) for aerosol Type', iac
          write(*,*) '----Top of Atmosphere----'
          do i =1,nv
            write(*,*) 'Layer', i
            read(*,*) aprofs(i,iac)
          end do
          write(*,*) '---------Surface---------'
          write(*,*)
          tot = sum(aprofs(1:nv,iac))
          if(tot.eq.0.) stop 'No VERTICAL Profile OF AEROSOL TAU '
          aprofs(1:nv,iac) = aprofs(1:nv,iac) / tot
        end if

        a_wlis(1,iac)= 0.53                          !Wavelength (microns) corresponding to "a_tau"
        a_taus(1,iac)= tau_aer* fraca(iac)
      end if
    end do
  end if
! -- reading over for aerosol

! -- main radiation code for both short- and longwave
  if (nfract.eq.0) then
    call rad (pp,pt,ph,po,                         &
   &          piwc,plwc,pgwc,prwc,pde,pre,cldamnt, &
   &          fds,fus,dts,fdir,fuir,dtir,fd,fu,dt, &
   &          a_wlis,a_taus,aprofs,                &
   &          as,pts,ee                            & 
   &         )
  endif
  if (nfract.eq.1) then
    call rad_cld ( pp,pt,ph,po,                         &
   &               piwc,plwc,pgwc,prwc,pde,pre,cldamnt, &
   &               fds,fus,dts,fdir,fuir,dtir,fd,fu,dt, &
   &               a_wlis,a_taus,aprofs,                &
   &               as,pts,ee                            & 
   &              )
  endif
! -- over
   
  write(6,*)'remember the output file name'
  open (unit=18,file='fluxes.out',status='unknown')
! --- output files for cloud forcing
!        open (unit=9,file='flux_s.out',status='unknown')
!        open (unit=10,file='flux_ir.out',status='unknown')
!        open (unit=11,file='tau.out',status='unknown')
!        open (unit=12,file='cld_alb.out',status='unknown')
!
! - write output for TOA and SFC fluxes
!        write(9,*) piwp, fds(1)-fus(1), fds(nv1)-fus(nv1)
!        write(10,*) piwp, fuir(1), fuir(nv1)-fdir(nv1)
!      write(12,*) piwp, fus(195)/fds(195)

! - write cloud optical depth
!        write(11,*) piwp, tt(203)-tt(195) 
! --- tai for only one level
!        write(11,*) piwp, tt(241)-tt(240) 
!
!      write(18,*)day,alat,alon,time
  write(18,*)'u0=',u0, 'incident=', ss*u0

!       solar and terrestrial radiative fluxes
  write ( 18, 28 )
  write ( 18, 30 ) fds(1), fds(nv1), fus(1), fus(nv1)
  write ( 18, 30 )
  write ( 18, 29 )
  write ( 18, 30 ) fdir(1), fdir(nv1), fuir(1), fuir(nv1)
  write ( 18, 30 )
  write ( 18, 32 )
  write(18,30)((pp(i)+pp(i+1))/2.,dts(i),dtir(i),dt(i),i= 1,nv)
  write ( 18, 33)
  write(18,31)(pp(i),fds(i),fus(i),fdir(i),fuir(i),i= 1,nv1)
28  format ('   FS(top,down)  FS(bot,down)    FS(top,up)    FS(bot,up&
   &)')
29  format ('  FIR(top,down) FIR(bot,down)   FIR(top,up)   FIR(bot,up&
   &)')
30  format (1x,4e14.4)
31  format (1x,5e14.4)
32  format ('       PRESSURE    SW-HEATING    IR-HEATING   ALL-HEATIN&
   &G')
33  format ('       PRESSURE       FS-DOWN         FS-UP      FIR-DOWN&
   &        FIR-UP')
 
  stop
end
