! This module contains all the physical part to calculate radiative transfer. 
! The subroutine 'rafuliougu' provides the output of radiation. 

module fu_liou_gu
!  use fu_liou_gu_table, only: 

  implicit none
  public rad, rad_cld, findu0, aer_scale_hgt
  private 

  CONTAINS

!    subroutine findoz(pp,po,nv1,poz,oz,n)
!      implicit none
!      integer n
!      real pp(nv1),po(nv1),poz(n),oz(n)
!      do 100 i=1,nv1
!        call interval(poz,n,pp(i),index)
!        call intrpl(poz(index),oz(index),poz(index+1)
!     &      ,oz(index+1),pp(i),po(i))
!        write(11,*) pp(i),po(i),poz(i),oz(i)
!      write(6,*)i, pp(i),po(i),poz(i),oz(i)
!100   continue
!      return
!    end

!
!  To find the location of the intermediate point in an matrix.
!


!    subroutine interval(x,n,xmid,index)
!      dimension x(n)
!      ia=1
!      ib=n
!      if(xmid.gt.x(n).or.xmid.lt.x(1)) then
!       write(6,*) 'Temperature or radiance is
!     &out of the range of the look-up table',x(1),xmid,x(n),n
!        if(xmid.lt.x(1))then
!          index=1
!          return
!        else
!          index=n-1
!          return
!        endif
!      endif
!5     index=(ia+ib)/2
!      if((xmid-x(index)).ge.0.0)then
!        ia=index
!      else
!        ib=index
!      endif
!      if(index.eq.ia.and.ib.eq.index+1) return
!      goto 5
!      return
!    end
!
!       Liner interpolation between two points.
!
!      subroutine intrpl(x1,y1,x2,y2,x,y)
!      slope=(y2-y1)/(x2-x1)
!      y=y1+slope*(x-x1)
!      return
!      end

!
!      Find the solar zenith angle.
!
      subroutine findu0(day,alat,alon,time,u0) 
      implicit none
      real :: day, alat, alon, time, u0
      real :: lamda, pi, d, sig, del, h
      pi=3.1415926536
      lamda=alat*pi/180.

      d=2.*pi*day/365.
      sig=d+ pi/180.*(279.9340+1.914827*sin(d) &
     &      -0.7952*cos(d)+0.019938*sin(2.*d)-0.00162*cos(2.*d))
      del=asin(sin(23.4439*pi/180.)*sin(sig))
      h=2.*pi*(time-12.)/24.
      u0=sin(lamda)*sin(del)+cos(lamda)*cos(del)*cos(h)
      write(6,*)'u0',u0,'h',h*180./pi,'del=',del*180./pi
      return
      end subroutine

      subroutine aer_scale_hgt(pp,h,aprof)
      use fu_liou_gu_table, only: nv
      implicit none
      real    :: pp(nv+1)
      real    :: aprof(nv)
      integer :: i
      real    :: h, pbar, z, tot
      do i=1,nv
        pbar= ( pp(i)+pp(i+1) ) *0.5
        z= 8.0* log( pp(nv+1) /pbar )
        aprof(i)= exp(-z/h)
!       print'(4f10.1,f10.2)',pp(i),pp(i+1),pbar,z,aprof(i)
      enddo
      tot= sum(aprof(1:nv))
!       print*,tot
      aprof = 100*(aprof/tot) !! aprof in %
!      print'(34f10.2)',(aprof(i),i=1,nv)
      return
      end subroutine

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!C

! --- Add aerosol calculation
! --- By Yu Gu, 01/2003
! ---CFC added 06/2007
!$Id: rad_gcm1.f,v 1.1 2002/02/15 23:37:41 gu Exp gu $

! *********************************************************************
! In this radiation scheme,  six  and  12 bands are selected for solar 
! and thermal IR regions, respectively. The spectral division is below: 
! 0.2 - 0.7 um, 0.7 - 1.3 um, 1.3 - 1.9 um, 1.9 - 2.5 um, 2.5 -3.5 um,
! 3.5 - 4.0 um, and 2200 - 1900 cm**-1, 1900 - 1700 cm**-1, 1700 -1400
! cm**-1,  1400 - 1250 cm**-1,  1250 - 1100 cm**-1, 1100 - 980 cm**-1,
! 980 - 800 cm**-1,  800 - 670 cm**-1,  670 - 540 cm**-1, 540 - 400 cm
! **-1,  400 - 280 cm**-1,  280 - 0 cm**-1,  where  the index  for the
! spectral band ( ib = 1, 2, ..., 18 ) is defined.
!
!                       **********************
!                       *  INPUT PARAMETERS  *
!                       **********************
!              as(mbs)   solar surface albedo, mbs = 6
!              u0        cosine of solar zenith angle
!              ss        solar constant ( W / m ** 2 )
!              pts       surface temperature ( K )
!              ee(mbir)  IR surface emissivity, mbir = 12
!              pp(nv1)   atmospheric pressure ( mb )
!              pt(nv1)   atmospheric temperature ( K )
!              ph(nv1)   water vapor mixing ratio ( kg / kg )
!              po(nv1)   ozone mixing ratio ( kg / kg )
!              pre(nv)   effective radius of water cloud ( um )
!              plwc(nv)  liquid water content ( g / m ** 3 )
!              pde(nv)   effective size of ice cloud ( um )
!              piwc(nv)  ice water content ( g / m ** 3 )
!              prwc(nv)  rain water content ( g / m ** 3 )
!              pgwc(nv)  graupel water content ( g / m ** 3 )
!              umco2     concentration of CO2 (ppmv)
!              umch4     concentration of CH4 (ppmv)
!              umn2o     concentration of N2O (ppmv)
!
! Note:  (1)  as(mbs) and ee(mbir) consider the substantial wavelength
!             dependence of surface albedos and emissivities.
!        (2)  For CO2, CH4 and N2O, uniform mixing is assumed  through
!             the atmosphere with concentrations of 330, 1.6 and  0.28
!             ppmv, respectively.  The  concentrations  can be changed
!             through 'common /umcon/ umco2, umch4, umn2o '.
!        (3)  nv, nv1, ndfs, mdfs, ndfs4, mb, mbs, mbir,  and  n!  are  
!             given through 'para.file'. 
!        (4)  nv1 and 1 are the surface and top levels, respectively.
!
!                       **********************
!                       *  OUTPUT PARAMETERS  *
!                       **********************
!              fds(nv1)   downward solar flux ( W / m ** 2 )
!              fus(nv1)   upward solar flux ( W / m **2 )
!              dts(nv)    solar heating rate ( K / day )
!              fdir(nv1)  downward IR flux ( W / m ** 2 )
!              fuir(nv1)  upward IR flux ( W / m **2 )
!              dtir(nv)   IR heating rate ( K / day )
!              fd(nv1)    downward net flux ( W / m ** 2 )
!              fu(nv1)    upward net flux ( W / m **2 )
!              dt(nv)     net heating rate ( K / day )
!
! Note:  Solar, IR, and net represent 0.2 - 0.4 um, 2200 - 0 cm**-1,
!        and  entire spectral regions, respectively.
!
!*********************************************************************
      subroutine rad (pp,pt,ph,po,                          &
                      piwc,plwc,pgwc,prwc,pde,pre,cldamnt,  &
                      fds,fus,dts,fdir,fuir,dtir,fd,fu,dt,  &
                      a_wlis,a_taus,aprofs,                 &
                      as,pts,ee                             & 
                     )
                     
      use fu_liou_gu_table, only : mbs,mbir,mb,mbx,mby,nvx,      &
                                   nv,nv1,nc,mxat,mxac,          &
                                   naero,nfract,nice,ngas,       &
                                   umco,umo2,umno,umso2,         &
                                   umno2,umch3cl,                &
                                   no2s,nco2s,nso2s,nch4s,nnol,  &
                                   nno2l,nso2l,nch3cll,ncos,     &
                                   nn2os,nh2ocs,nh2os,no3s,      &
                                   nh2ol,no3l,nco2l,nn2ol,       &
                                   nch4l,nCFC11l,nCFC12l,        &
                                   u0,ss,ivd,iaform,n_atau,itps, &
                                   edding,quadra,hemisp,         &
                                   fourssl,twossl,foursir,twosir
      implicit none

      real, intent(in), dimension(nv1)  :: pp, pt, ph, po
      real, intent(out), dimension(nv1) :: fds, fus, fdir, fuir, fd, fu
      real, intent(out), dimension(nv)  :: dts,dtir, dt
      real, dimension(nv)               :: piwc, plwc, pgwc, prwc, &
     &                                     pde, pre, cldamnt
      real                              :: as(mbs), ee(mbir), pts
      
      real, dimension(nv1)              :: fu1, fd1
      real                              :: bf(nv1), bs
!      real area_group(3,2), cld_group(3)
!      integer n_group(3), nb(3), n_loop(3)
!      real, dimension(nv,2) :: wc1_2, wc2_2, wc3_2, wc4_2, wc_2, 
!     &                         tt_2, tc_2
      real, dimension(nv)  :: wc1, wc2, wc3, wc4, wc, tt
      real, dimension(nv1) :: fds_tot, fus_tot, fdir_tot, fuir_tot, &
     &                        fd_tot, fu_tot 
      real    :: ctau(nv)
      real    :: hk, fuq1, fuq2, xx, dz(nv), trp(nv)
      integer :: ib, mbn, kg1_num, kg2_num, iac, ig1, ig2, i     !cycle control
      real, dimension(nvx,mbx,mxac) :: a_tau1,a_ssa1,a_asy1, &
     &                                 a_tau2,a_ssa2,a_asy2
      real,dimension(mxat,mxac)     :: a_wlis,a_taus
      real,dimension(nvx,mxac)      :: aprofs
      real :: ti(nv), wi(nv), wwi(nv,4)
      real :: tw(nv), ww(nv), www(nv,4)
      real :: tr(nv), wr(nv), wwr(nv,4)
      real :: trn(nv), wrn(nv), wwrn(nv,4)
      real :: tgr(nv), wgr(nv), wwgr(nv,4)
      real :: tae(nvx,mxac), wae(nvx,mxac), wwae(nvx,4,mxac)
      real :: tgm(nv), tg(nv)

!!!!!!!!!!!!!!!!!c
! kg(mb) is the number of intervals to perform the g-quadrature in
! each band to consider the nongray gaseous absorption.  In total,
! we need to perform 121 spectral calculations in  the  scattering
! problem for each atmospheric profile.
      integer, dimension(mb) :: kg, kg1, kg2
      data kg / 10, 8, 12, 7, 12, 5,  &
     &            2, 3, 4, 4, 3, 5, 2, 10, 12, 7, 7, 8 /

!!!!C! -- change by Zhang Feng for trace gases
      data kg1 / 10, 12, 12, 20, 20, 20, &
     &            2, 3, 4, 4, 3, 5, 2, 10, 12, 7, 7, 8 /
      data kg2 /1, 12, 1, 20, 20, 1, &
     &            1, 1, 1, 1, 1, 1, 1, 1 , 1, 1, 1, 1 /
!!!!!! - change over
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      real :: f0 = 1.0 / 3.14159

! --change by Yu
!      if (pts.gt.345.) pts = pt(nv1)
      if (pts.gt.320.) pts = 320. 
      if (pts.lt.180.) pts = 180. 
! -- change over
      call thicks(pp,pt,ph,po,dz)
      call rayle2(pp,pt,ph,po,trp)
      if ( u0 .le. 1.0e-4 ) then
        mbn = mbs + 1
      else
        mbn = 1
      endif


! -- add by Yu (01/2003) for aerosol
      if (naero.eq.1) then
        call aerosol_init(pp,pt,ph,po,dz,        &
                          a_tau1,a_ssa1,a_asy1,  &
                          a_tau2,a_ssa2,a_asy2,  &
                          a_wlis,a_taus,aprofs   &
                         )
      endif
! - over
      do ib = mbn, mb
        if (nice.eq.1) then
! --------- using new coefficients by ZF
          call ice_new_ZF ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi ) 
        else if (nice.eq.2) then
! --------- using new coefficients by Qing for combine 
          call ice_new_comb ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.3) then
! --------- using new coefficients by Qing for tropics 
          call ice_new_trop ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.4) then
! --------- using new coefficients by Qing for midlat 
          call ice_new_midlat ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.5) then
! --------- using FLIce98 
          call ice_98 ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.6) then
! --------- using single ice by Feng using new data Ping Yang 2000 
          call ice_singleice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.7) then
! --------- using single ice by Qing using new data Ping Yang 2005
          call ice_new_Single ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )        
        else
! --------- use old ice coefficients FLIce93
          call ice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        endif

        call water_fl ( ib,pre,plwc,pde,piwc,dz,tw,ww,www )
        call rain ( ib,prwc,dz,trn,wrn,wwrn )
        call graup ( ib,pgwc, dz, tgr,wgr,wwgr )

! -- add for aerosol by Yu (01/2003)
! --------- 4/1/97 (3)
! No more ipr option
!       if (ib.ne.1) then
! - nor sub-intervals
        if (naero.eq.1) then
          call aerosolxy (ib,'x',a_tau1,a_ssa1,a_asy1,      &
                          a_tau2,a_ssa2,a_asy2,tae,wae,wwae &
                         )
          ctau(ib)=0.
          do i=1,nv
            do iac=1,mxac
              if (itps(iac).eq.1) ctau(ib)=ctau(ib)+tae(i,iac)
            end do
          end do
        end if
! --------- 4/1/97 (3)
! -------------------------over

        call rayle ( ib,trp,tr,wr,wwr )
        call gascon ( ib,tgm,pp,pt,ph,po )
        if ( ib .gt. mbs ) then
          call planck ( ib,pts,pp,pt,ph,po,bf,bs )
        endif

! --- change by Yu for new trace gases
        if (ngas.eq.0) then
          kg1_num=kg(ib)
          kg2_num=1
        end if
        if (ngas.eq.1) then
          kg1_num=kg1(ib)
          kg2_num=kg2(ib)
        end if


!         do 30 ig = 1, kg(ib)
        do ig1 = 1, kg1_num 
          do ig2 = 1, kg2_num 
! -- changed by Yu for new gases, 11/2006
            if (ngas.eq.0) then           
!            call gases ( ib, ig, hk )
              call gases ( ib, ig1, hk,pp,pt,ph,po,tg )
            end if
            if (ngas.eq.1) then           
              call gases_new ( ib, ig1,ig2, hk,pp,pt,ph,po,tg )
            end if
! -- change over

! -- no partly cloudy,no aerosol
!        if (naero.eq.0.and.nfract.eq.0) then
!            call comscp
!        endif
! -- partly cloudy, no aerosol 
!        if (naero.eq.0.and.nfract.eq.1) then
!            call comscp_new 
!        endif
! -- no partly cloudy, but have aerosol 
!        if (naero.eq.1.and.nfract.eq.0) then
!***************************************************
! --- use control para. in the comscp_aero subroutine
            call comscp_aero ( ti,wi,wwi,tw,ww,www,           &
                               trn,wrn,wwrn,tgr,wgr,wwgr,     &
                               tr,wr,wwr,tgm,tg,tae,wae,wwae, &
                               wc1,wc2,wc3,wc4,wc,tt          &
                             )
!*****************************************************
!        endif
! -- aerosol added 
!        if (naero.eq.1.and.nfract.eq.1) then
!            call comscp_aero_cld 
!        endif

! -- solve radiative transfer equation
            if ( ib .le. mbs ) then
              if ( fourssl ) then
                call qfts ( ib, as(ib), f0, &
               &            wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
              endif
              if ( twossl ) then
                quadra = .false.
                hemisp = .false.
                edding = .true.
                call qftsts ( ib, as(ib), f0, &
     &                        wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
              endif
              do i = 1, nv1
                fds(i) = fds(i) + fd1(i) * hk
                fus(i) = fus(i) + fu1(i) * hk
40            end do
            else
              if ( foursir ) then
                call qfti ( ib, ee(ib-mbs), bf, bs, &
               &            wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
              endif
              if ( twosir ) then
                quadra = .false.
                edding = .false.
                hemisp = .true.
! -- 2-4-stream combination for IR
                call qftisf ( ib, ee(ib-mbs), bf, bs,      &
     &                        wc1, wc2, wc3, wc4, wc, tt,  &
     &                        fu1, fd1 ) 
! -- 2-stream for IR 
!                  call qftits ( ib, ee(ib-mbs) )
              endif
! 11/4/95 (end)
              do i = 1, nv1
                fdir(i) = fdir(i) + fd1(i) * hk
                fuir(i) = fuir(i) + fu1(i) * hk
              end do
            endif
          end do  
        end do  
      end do

      fuq1 = ss / 1340.0
! In this model, we used the solar spectral irradiance determined by
! Thekaekara (1973), and 1340.0 W/m**2 is the solar energy contained 
! in the spectral region 0.2 - 4.0 um.
      fuq2 = bs * 0.03 * 3.14159 * ee(12)  !0.03? ee(12)?
! fuq2 is the surface emitted flux in the band 0 - 280 cm**-1 with a
! hk of 0.03.
      do i = 1, nv1
        fds(i) = fds(i) * fuq1
        fus(i) = fus(i) * fuq1
        fuir(i) = fuir(i) + fuq2
        fd(i) = fds(i) + fdir(i)
        fu(i) = fus(i) + fuir(i)
      end do

      do i = 1, nv
        xx = fds(i) -fus(i) - fds(i+1) + fus(i+1)
        dts(i) = 8.4392 * xx / ( pp(i+1) - pp(i) )
! 8.4392 = 9.8 * (24 * 3600) / (1008 * 100), 100 is because pp is expressed in mb
        xx = fdir(i) -fuir(i) - fdir(i+1) + fuir(i+1)
        dtir(i) = 8.4392 * xx / ( pp(i+1) - pp(i) )
        dt(i) = dts(i) + dtir(i)
      end do
      return
      end subroutine


! 20110826
! --- Radiation program for fractional cloud cover---!
! --- By Yu Gu, 02/15/02
! --- Add aerosol calculation
! --- By Yu Gu, 01/2003
!$Id: rad_gcm1.f,v 1.1 2002/02/15 23:37:41 gu Exp gu $

! *********************************************************************
! In this radiation scheme,  six  and  12 bands are selected for solar 
! and thermal IR regions, respectively. The spectral division is below: 
! 0.2 - 0.7 um, 0.7 - 1.3 um, 1.3 - 1.9 um, 1.9 - 2.5 um, 2.5 -3.5 um,
! 3.5 - 4.0 um, and 2200 - 1900 cm**-1, 1900 - 1700 cm**-1, 1700 -1400
! cm**-1,  1400 - 1250 cm**-1,  1250 - 1100 cm**-1, 1100 - 980 cm**-1,
! 980 - 800 cm**-1,  800 - 670 cm**-1,  670 - 540 cm**-1, 540 - 400 cm
! **-1,  400 - 280 cm**-1,  280 - 0 cm**-1,  where  the index  for the
! spectral band ( ib = 1, 2, ..., 18 ) is defined.
!
!                       **********************
!                       *  INPUT PARAMETERS  *
!                       **********************
!              as(mbs)   solar surface albedo, mbs = 6
!              u0        cosine of solar zenith angle
!              ss        solar constant ( W / m ** 2 )
!              pts       surface temperature ( K )
!              ee(mbir)  IR surface emissivity, mbir = 12
!              pp(nv1)   atmospheric pressure ( mb )
!              pt(nv1)   atmospheric temperature ( K )
!              ph(nv1)   water vapor mixing ratio ( kg / kg )
!              po(nv1)   ozone mixing ratio ( kg / kg )
!              pre(nv)   effective radius of water cloud ( um )
!              plwc(nv)  liquid water content ( g / m ** 3 )
!              pde(nv)   effective size of ice cloud ( um )
!              piwc(nv)  ice water content ( g / m ** 3 )
!              prwc(nv)  rain water content ( g / m ** 3 )
!              pgwc(nv)  graupel water content ( g / m ** 3 )
!              umco2     concentration of CO2 (ppmv)
!              umch4     concentration of CH4 (ppmv)
!              umn2o     concentration of N2O (ppmv)
!
! Note:  (1)  as(mbs) and ee(mbir) consider the substantial wavelength
!             dependence of surface albedos and emissivities.
!        (2)  For CO2, CH4 and N2O, uniform mixing is assumed  through
!             the atmosphere with concentrations of 330, 1.6 and  0.28
!             ppmv, respectively.  The  concentrations  can be changed
!             through 'common /umcon/ umco2, umch4, umn2o '.
!        (3)  nv, nv1, ndfs, mdfs, ndfs4, mb, mbs, mbir,  and  n!  are  
!             given through 'para.file'. 
!        (4)  nv1 and 1 are the surface and top levels, respectively.
!
!                       **********************
!                       *  OUTPUT PARAMETERS  *
!                       **********************
!              fds(nv1)   downward solar flux ( W / m ** 2 )
!              fus(nv1)   upward solar flux ( W / m **2 )
!              dts(nv)    solar heating rate ( K / day )
!              fdir(nv1)  downward IR flux ( W / m ** 2 )
!              fuir(nv1)  upward IR flux ( W / m **2 )
!              dtir(nv)   IR heating rate ( K / day )
!              fd(nv1)    downward net flux ( W / m ** 2 )
!              fu(nv1)    upward net flux ( W / m **2 )
!              dt(nv)     net heating rate ( K / day )
!
! Note:  Solar, IR, and net represent 0.2 - 0.4 um, 2200 - 0 cm**-1,
!        and  entire spectral regions, respectively.
!
! *********************************************************************
      subroutine rad_cld (pp,pt,ph,po,                          &
                          piwc,plwc,pgwc,prwc,pde,pre,cldamnt,  &
                          fds,fus,dts,fdir,fuir,dtir,fd,fu,dt,  &
                          a_wlis,a_taus,aprofs,                 &
                          as,pts,ee                             & 
                         )
                     
      use fu_liou_gu_table, only : mbs,mbir,mb,mbx,mby,nvx,      &
                                   nv,nv1,mxat,mxac,             &
                                   naero,nfract,nice,ngas,       &
                                   umco,umo2,umno,umso2,         &
                                   umno2,umch3cl,                &
                                   no2s,nco2s,nso2s,nch4s,nnol,  &
                                   nno2l,nso2l,nch3cll,ncos,     &
                                   nn2os,nh2ocs,nh2os,no3s,      &
                                   nh2ol,no3l,nco2l,nn2ol,       &
                                   nch4l,nCFC11l,nCFC12l,        &
                                   u0,ss,ivd,iaform,n_atau,itps, &
                                   edding,quadra,hemisp,         &
                                   nclouds,ngroup,nsubcld,       &
                                   fourssl,twossl,foursir,twosir
      implicit none
      real, intent(in), dimension(nv1)  :: pp, pt, ph, po
      real, intent(out), dimension(nv1) :: fds, fus, fdir, fuir, fd, fu
      real, intent(out), dimension(nv)  :: dts,dtir, dt
      real, dimension(nv)               :: piwc, plwc, pgwc, prwc, &
     &                                     pde, pre, cldamnt
      real                              :: as(mbs), ee(mbir), pts
      
      real, dimension(nv1)              :: fu1, fd1
      real                              :: bf(nv1), bs
      real, dimension(nv)   :: wc1, wc2, wc3, wc4, wc, tt
! -- add for partial clouds
      real    :: area_group(3,2), cld_group(3)
      integer :: n_group(3), nb(3), n_loop(3)
      real, dimension(nv,2) :: wc1_2, wc2_2, wc3_2, wc4_2, wc_2,  &
     &                         tt_2, tc_2
      integer :: nc1, nc2, nc3, k, kl, kk
! -- add for partial clouds
      real, dimension(nv1)  :: fds_tot, fus_tot, fdir_tot, fuir_tot, &
     &                         fd_tot, fu_tot 
      real    :: ctau(nv)
      real    :: hk, fuq1, fuq2, xx, dz(nv), trp(nv)
      integer :: ib, mbn, kg1_num, kg2_num, iac, ig1, ig2, i    !cycle control
      real, dimension(nvx,mbx,mxac) :: a_tau1,a_ssa1,a_asy1, &
     &                                 a_tau2,a_ssa2,a_asy2
      real,dimension(mxat,mxac)     :: a_wlis,a_taus
      real,dimension(nvx,mxac)      :: aprofs      
      real :: ti(nv), wi(nv), wwi(nv,4)
      real :: tw(nv), ww(nv), www(nv,4)
      real :: trn(nv), wrn(nv), wwrn(nv,4)
      real :: tgr(nv), wgr(nv), wwgr(nv,4)
      real :: tae(nvx,mxac), wae(nvx,mxac), wwae(nvx,4,mxac)
      real :: tgm(nv)      
      real :: tr(nv), wr(nv), wwr (nv,4), tg(nv)
      real :: area

! - add for aerosol by Yu 02/2003
!      real :: taes(0:4)
! -- add by Yu for aerosol

! kg(mb) is the number of intervals to perform the g-quadrature in
! each band to consider the nongray gaseous absorption.  In total,
! we need to perform 121 spectral calculations in  the  scattering
! problem for each atmospheric profile.
      integer, dimension(mb) :: kg, kg1, kg2
      data kg / 10, 8, 12, 7, 12, 5,  &
     &            2, 3, 4, 4, 3, 5, 2, 10, 12, 7, 7, 8 /
!!!!! -- change by Zhang Feng for trace gases
      data kg1 / 10, 12, 12, 20, 20, 20, &
     &            2, 3, 4, 4, 3, 5, 2, 10, 12, 7, 7, 8 /
      data kg2 /1, 12, 1, 20, 20, 1, &
     &            1, 1, 1, 1, 1, 1, 1, 1 , 1, 1, 1, 1 /
!!!!!! - change over

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      real :: f0 = 1.0 / 3.14159

! --change by Yu
      if (pts.gt.345.) pts = pt(nv1)
      if (pts.gt.320.) pts = 320. 
      if (pts.lt.180.) pts = 180. 
! -- change over
      call thicks(pp,pt,ph,po,dz)
      call rayle2(pp,pt,ph,po,trp)
      if ( u0 .le. 1.0e-4 ) then
        mbn = mbs + 1
      else
        mbn = 1
      endif


! -- add by Yu (01/2003) for aerosol
      if (naero.eq.1) then
        call aerosol_init(pp,pt,ph,po,dz,        &
                          a_tau1,a_ssa1,a_asy1,  &
                          a_tau2,a_ssa2,a_asy2,  &
                          a_wlis,a_taus,aprofs   &
                         )
      endif
! - over

      do ib = mbn, mb
        if (nice.eq.1) then
! --------- using new coefficients
          call ice_new_ZF ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.2) then
! --------- using new coefficients by Qing for combine 
          call ice_new_comb ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.3) then
! --------- using new coefficients by Qing for tropics 
          call ice_new_trop ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.4) then
! --------- using new coefficients by Qing for midlat 
          call ice_new_midlat ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.5) then
! --------- using FLIce98 
          call ice_98 ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.6) then
! --------- using single ice by Feng using new data Ping Yang 2000 
          call ice_singleice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else if (nice.eq.7) then
! --------- using single ice by Qing using new data Ping Yang 2005
          call ice_new_Single ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        else
! --------- use old ice coefficients FLIce93
          call ice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
        endif

        call water_fl ( ib,pre,plwc,pde,piwc,dz,tw,ww,www )
        call rain ( ib,prwc,dz,trn,wrn,wwrn )
        call graup ( ib,pgwc,dz, tgr,wgr,wwgr )

! -- add for serodol by Yu (01/2003)
! --------- 4/1/97 (3)
! No more ipr option
!       if (ib.ne.1) then
! - nor sub-intervals
        if (naero.eq.1) then
          call aerosolxy (ib,'x',a_tau1,a_ssa1,a_asy1,      &
                          a_tau2,a_ssa2,a_asy2,tae,wae,wwae &
                         )
          ctau(ib)=0.
          do i=1,nv
            do iac=1,mxac
              if (itps(iac).eq.1) ctau(ib)=ctau(ib)+tae(i,iac)
            end do
          end do
        endif
! --------- 4/1/97 (3)
! -------------------------over

        call rayle ( ib,trp,tr,wr,wwr )
        call gascon ( ib,tgm,pp,pt,ph,po )
        if ( ib .gt. mbs ) then
          call planck ( ib,pts,pp,pt,ph,po,bf,bs )
        endif

! -- changed by Yu for new gases, 11/2006
        if (ngas.eq.0) then
          kg1_num=kg(ib)
          kg2_num=1
        end if
        if (ngas.eq.1) then
          kg1_num=kg1(ib)
          kg2_num=kg2(ib)
        end if
! -- change over


!          do 30 ig = 1, kg(ib)
        do ig1 = 1, kg1_num
          do ig2 = 1, kg2_num
! -- changed by Yu for new gases, 11/2006
            if (ngas.eq.0) then
!             call gases ( ib, ig, hk )
              call gases ( ib, ig1, hk,pp,pt,ph,po,tg )
            end if
            if (ngas.eq.1) then
              call gases_new ( ib, ig1,ig2, hk,pp,pt,ph,po,tg )
            end if
! -- change over

! -- no partly cloudy,no aerosol
!        if (naero.eq.0.and.nfract.eq.0) then
!            call comscp
!        endif
! -- partly cloudy, no aerosol 
!        if (naero.eq.0.and.nfract.eq.1) then
!            call comscp_new 
!        endif
! -- no partly cloudy, but have aerosol 
!        if (naero.eq.1.and.nfract.eq.0) then
!            call comscp_aero 
!v        endif
! -- aerosol added 
!        if (naero.eq.1.and.nfract.eq.1) then
! ***************************************************
! --- use control para. in the comscp_aero subroutine
            call comscp_aero_cld ( cldamnt,area_group,cld_group,      &
     &                             n_group,nb,                        &
     &                             ti,wi,wwi,tw,ww,www,               &
     &                             trn,wrn,wwrn,tgr,wgr,wwgr,         &
     &                             tr,wr,wwr,tgm,tg,tae,wae,wwae,     &
     &                             wc1,wc2,wc3,wc4,wc,tt,tc_2,        &
     &                             wc1_2,wc2_2,wc3_2,wc4_2,wc_2,tt_2  &
     &                           )
! ***************************************************
!        endif

! -- 02/13/02 Yu Gu
! -- change by Yu for fractional cloud - calculate radiation for each section
            do nc1 = nb(1), n_group(1)
              do nc2 = nb(2), n_group(2)
                do nc3 = nb(3), n_group(3)
 
                  n_loop(1) = nc1
                  n_loop(2) = nc2
                  n_loop(3) = nc3
! -- fractional area for each section
                  area = area_group(1,nc1)*area_group(2,nc2) &
     &                           *area_group(3,nc3)

! -- calculated total tao for layer above cloud layers
                  tt_2(1,1) = tc_2(1,1)
                  tt_2(1,2) = tc_2(1,2)
!                  do i = 2, nv-nclouds
                  do i = 2, nv-nsubcld*ngroup
                    tt_2(i,1) = tt_2(i-1,1) + tc_2(i,1)
                    tt_2(i,2) = tt_2(i-1,2) + tc_2(i,2)
220               end do

! -- assign the optical properties for each section 
! -- for layers above cloud layers 
!                  do k = 1,nv-nclouds
                  do k = 1, nv-nsubcld*ngroup
                    wc1(k) = wc1_2(k,1) 
                    wc2(k) = wc2_2(k,1) 
                    wc3(k) = wc3_2(k,1) 
                    wc4(k) = wc4_2(k,1) 
                    wc(k) = wc_2(k,1)
                    tt(k) = tt_2(k,1)
                  enddo
            
! -- for cloudy layers
                  do k=1,ngroup
!                    kl = (k-1)*nsubcld + nv1-nclouds 
                    kl = (k-1)*nsubcld + nv1-nsubcld*ngroup 
                    do kk = kl, kl+nsubcld-1 
                      wc1(kk) = wc1_2(kk, n_loop(k))
                      wc2(kk) = wc2_2(kk, n_loop(k))
                      wc3(kk) = wc3_2(kk, n_loop(k))
                      wc4(kk) = wc4_2(kk, n_loop(k))
                      wc(kk) = wc_2(kk, n_loop(k))
                      tt(kk) = tt(kk-1) + tc_2(kk,n_loop(k))
                    enddo
                  enddo
! -- over

!  11/4/95 (begin)
                  if ( ib .le. mbs ) then
                    if ( fourssl ) then
                      call qfts ( ib, as(ib), f0, &
                     &            wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
                    endif
                    if ( twossl ) then
                      quadra = .false.
                      hemisp = .false.
                      edding = .true.
                      call qftsts ( ib, as(ib), f0, &
     &                              wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
                    endif
                    do i = 1, nv1
!                  fds(i) = fds(i) + fd1(i) * hk
!                 fus(i) = fus(i) + fu1(i) * hk
                      fds(i) = fds(i) + fd1(i) * hk * area
                          fus(i) = fus(i) + fu1(i) * hk * area           
40                  end do
                  else
                    if ( foursir ) then
                      call qfti ( ib, ee(ib-mbs), bf, bs, &
               &                  wc1,wc2,wc3,wc4,wc,tt,fu1,fd1 )
                    endif
                    if ( twosir ) then
                      quadra = .false.
                      edding = .false.
                      hemisp = .true.
! -- 2-4-stream combination for IR
                      call qftisf ( ib, ee(ib-mbs), bf, bs, &
     &                              wc1, wc2, wc3, wc4, wc, tt, &
     &                              fu1, fd1 )
! -- 2-stream  for IR
!                  call qftits ( ib, ee(ib-mbs) )
                    endif
!  11/4/95 (end)
                    do i = 1, nv1
!                  fdir(i) = fdir(i) + fd1(i) * hk
!                  fuir(i) = fuir(i) + fu1(i) * hk
                      fdir(i) = fdir(i) + fd1(i) * hk * area
                      fuir(i) = fuir(i) + fu1(i) * hk * area
50                  end do
                  endif
                end do
              end do
            end do
31        end do  
30      end do  
20    end do

      fuq1 = ss / 1340.0
! In this model, we used the solar spectral irradiance determined by
! Thekaekara (1973), and 1340.0 W/m**2 is the solar energy contained 
! in the spectral region 0.2 - 4.0 um.
      fuq2 = bs * 0.03 * 3.14159 * ee(12)
! fuq2 is the surface emitted flux in the band 0 - 280 cm**-1 with a
! hk of 0.03.
      do i = 1, nv1
        fds(i) = fds(i) * fuq1
        fus(i) = fus(i) * fuq1
        fuir(i) = fuir(i) + fuq2
        fd(i) = fds(i) + fdir(i)
        fu(i) = fus(i) + fuir(i)
60    end do

      do i = 1, nv
        xx = fds(i) -fus(i) - fds(i+1) + fus(i+1)
        dts(i) = 8.4392 * xx / ( pp(i+1) - pp(i) )
        xx = fdir(i) -fuir(i) - fdir(i+1) + fuir(i+1)
        dtir(i) = 8.4392 * xx / ( pp(i+1) - pp(i) )
        dt(i) = dts(i) + dtir(i)
70    end do
      return
      end subroutine



      subroutine thicks(pp,pt,ph,po,dz) 
! *********************************************************************
! dz is the thickness of a layer in units of km.
! *********************************************************************
      use fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real, dimension(nv)  :: dz(nv)
      integer i
      do i = 1, nv
        dz(i) = 0.0146337 * ( pt(i) + pt(i+1) )  &
     &         * alog( pp(i+1) / pp(i) )
      end do
      return
      end subroutine


      subroutine ice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_0,bp=>bp_0,       &
                                   cps=>cps_0,cpir=>cpir_0, &
                                   dps=>dps_0,mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4, fd
      integer :: i ,ib, ibr
      
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &           ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &           bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
            fd = dps(1,ib) + dps(2,ib) * fw1 + &
     &         dps(3,ib) * fw2 + dps(4,ib) * fw3
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) = ( 1.0 - fd ) * wf1 + 3.0 * fd
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) = ( 1.0 - fd ) * wf2 + 5.0 * fd
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) = ( 1.0 - fd ) * wf3 + 7.0 * fd
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) = ( 1.0 - fd ) * wf4 + 9.0 * fd
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
      return
      end subroutine

!************************************************
! -- ice single-scattering parameterization by Feng using Ping Yang 2000 data
      subroutine ice_singleice ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_6,bp=>bp_6,             &
                                         cps=>cps_6,cpir=>cpir_6, &
                                         dps=>dps_6,mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4, fd
      integer :: i, ib, ibr

      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &           ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &           bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
            fd = dps(1,ib) + dps(2,ib) * fw1 + &
     &         dps(3,ib) * fw2 + dps(4,ib) * fw3
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) = ( 1.0 - fd ) * wf1 + 3.0 * fd
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) = ( 1.0 - fd ) * wf2 + 5.0 * fd
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) = ( 1.0 - fd ) * wf3 + 7.0 * fd
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) = ( 1.0 - fd ) * wf4 + 9.0 * fd
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
      return
      end subroutine

!************************************************
! -- using FLIce98 for ice single-scattering parameterization
      subroutine ice_98 ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
!      USE RadParams
!##        include 'rad_0698.h'
      use  fu_liou_gu_table, only: ap=>ap_5,bps=>bps_5,   &
                                   cp=>cp_5,dps=>dps_5,   &
                                   bpir=>bpir_5,mbs,nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real ti(nv), wi(nv), wwi(nv,4)
      real fw1, fw2, fw3, tau, omega, asy, fd, f, fw,  &
     &     gg, x1, x2, x3, x4, betae, betaa
      integer i, ib, ibr
      
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          if ( ib .le. mbs ) then
            tau = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &               ap(2,ib) / fw1 )
            omega = 1.0 - ( bps(1,ib) + bps(2,ib) * fw1 + &
     &               bps(3,ib) * fw2 + bps(4,ib) * fw3 )
            asy = cp(1,ib) + cp(2,ib) * fw1 + &
     &               cp(3,ib) * fw2 + cp(4,ib) * fw3
            fd = dps(1,ib) + dps(2,ib) * fw1 + &
     &               dps(3,ib) * fw2 + dps(4,ib) * fw3
            f = 0.5 / omega + fd
            fw = f * omega
            ti(i) = ( 1.0 - fw ) * tau
            wi(i) = ( 1.0 - f ) * omega / ( 1.0 - fw )
            gg = ( asy - f ) / ( 1.0 - f )
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          else
            ibr = ib - mbs
            betae = piwc(i) * ( ap(1,ib) + &
     &                 ap(2,ib) / fw1 + ap(3,ib) / fw2 )
            betaa = piwc(i) / fw1 * ( bpir(1,ibr) + bpir(2,ibr) * &
     &                 fw1 + bpir(3,ibr) * fw2 + bpir(4,ibr) * fw3 )
            asy = cp(1,ib) + cp(2,ib) * fw1 + &
     &                 cp(3,ib) * fw2 + cp(4,ib) * fw3
            ti(i) = dz(i) * 1000.0 * betae
            wi(i) = 1.0 - betaa / betae
            gg = asy
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
      return
      end subroutine
! Fu 07-08-98

!!!!!!!!!!!!!!!!!!!C
! -- using new coefficients for ice single-scattering parameterization
      subroutine ice_new_ZF ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_1,bp=>bp_1,       &
                                   cps=>cps_1,cpir=>cpir_1, &
                                   mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4
      integer :: i, ib, ibr
! changed by Z.F.
!      common /zf_solar/tizfs(nv,mbs),wizfs(nv,mbs),wwi1s(nv,mbs),
!     &            wwi2s(nv,mbs),wwi3s(nv,mbs),wwi4s(nv,mbs)
! changing over
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &       ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          if(ti(i).lt.0.0) write(*,*)'optical depth of ice=',ti(i)
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &       bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
! changed by Z.F.
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) =  wf1
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) =  wf2
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) =  wf3
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) =  wf4
! changing over
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
! added by Z.F.
!      if(ib.le.mbs) then
!        do i=1,nv
!          tizfs(i,ib)=ti(i)
!          wizfs(i,ib)=wi(i)
!          wwi1s(i,ib)=wwi(i,1)
!          wwi2s(i,ib)=wwi(i,2)
!          wwi3s(i,ib)=wwi(i,3)
!          wwi4s(i,ib)=wwi(i,4)
!        end do
!      end if

!        write(*,*)'ti=',ti
!        write(*,*)'wi=',wi
!        write(*,*)'wwi1=',(wwi(i,1),i=1,nv)
!        write(*,*)'wwi2=',(wwi(i,2),i=1,nv)
!        write(*,*)'wwi3=',(wwi(i,3),i=1,nv)
!        write(*,*)'wwi4=',(wwi(i,4),i=1,nv)

! adding over
      return
      end subroutine

!!!!!!!!!!!!!!!!!!!C
! -- using new coefficients for ice single-scattering parameterization
! -- by Qing Yue 2006
      subroutine ice_new_comb ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_2,bp=>bp_2,       &
                                   cps=>cps_2,cpir=>cpir_2, &
                                   mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4
      integer :: i, ib, ibr
      
      
! changed by Z.F.
!      common /zf_solar/tizfs(nv,mbs),wizfs(nv,mbs),wwi1s(nv,mbs),
!     &            wwi2s(nv,mbs),wwi3s(nv,mbs),wwi4s(nv,mbs)
! changing over
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &       ap(2,ib) / fw1 + ap(3,ib) / fw2 )
! -- uncomment the following if want to output optical depth for each band
!             write(*,*)'level=', i, 'optical depth of ice=',ti(i)
!             if(ti(i).lt.0.0) write(*,*)'optical depth of ice=',ti(i)
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &       bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
! changed by Z.F.
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) =  wf1
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) =  wf2
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) =  wf3
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) =  wf4
! changing over
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
! added by Z.F.
!      if(ib.le.mbs) then
!        do i=1,nv
!          tizfs(i,ib)=ti(i)
!          wizfs(i,ib)=wi(i)
!          wwi1s(i,ib)=wwi(i,1)
!          wwi2s(i,ib)=wwi(i,2)
!          wwi3s(i,ib)=wwi(i,3)
!          wwi4s(i,ib)=wwi(i,4)
!        end do
!      end if

!        write(*,*)'ti=',ti
!        write(*,*)'wi=',wi
!        write(*,*)'wwi1=',(wwi(i,1),i=1,nv)
!        write(*,*)'wwi2=',(wwi(i,2),i=1,nv)
!        write(*,*)'wwi3=',(wwi(i,3),i=1,nv)
!        write(*,*)'wwi4=',(wwi(i,4),i=1,nv)

! adding over

      return
      end subroutine

!!!!!!!!!!!!!!!!!!!C
! -- using new coefficients for ice single-scattering parameterization
! -- for tropics
      subroutine ice_new_trop ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_3,bp=>bp_3,              &
                                   cps=>cps_3,cpir=>cpir_3,  &
                                         mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4
      integer :: i ,ib, ibr
            

! changed by Z.F.
!      common /zf_solar/tizfs(nv,mbs),wizfs(nv,mbs),wwi1s(nv,mbs),
!     &            wwi2s(nv,mbs),wwi3s(nv,mbs),wwi4s(nv,mbs)
! changing over
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &       ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          if(ti(i).lt.0.0) write(*,*)'optical depth of ice=',ti(i)
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &       bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
! changed by Z.F.
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) =  wf1
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) =  wf2
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) =  wf3
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) =  wf4
! changing over
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
! added by Z.F.
!      if(ib.le.mbs) then
!        do i=1,nv
!          tizfs(i,ib)=ti(i)
!          wizfs(i,ib)=wi(i)
!          wwi1s(i,ib)=wwi(i,1)
!          wwi2s(i,ib)=wwi(i,2)
!          wwi3s(i,ib)=wwi(i,3)
!          wwi4s(i,ib)=wwi(i,4)
!        end do
!      end if

!        write(*,*)'ti=',ti
!        write(*,*)'wi=',wi
!        write(*,*)'wwi1=',(wwi(i,1),i=1,nv)
!        write(*,*)'wwi2=',(wwi(i,2),i=1,nv)
!        write(*,*)'wwi3=',(wwi(i,3),i=1,nv)
!        write(*,*)'wwi4=',(wwi(i,4),i=1,nv)

! adding over

      return
      end subroutine

!!!!!!!!!!!!!!!!!!!C
! -- using new coefficients for ice single-scattering parameterization
      subroutine ice_new_midlat ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_4,bp=>bp_4,             &
                                         cps=>cps_4,cpir=>cpir_4, &
                                         mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4
      integer :: i, ib, ibr      

! changed by Z.F.
!      common /zf_solar/tizfs(nv,mbs),wizfs(nv,mbs),wwi1s(nv,mbs),
!     &            wwi2s(nv,mbs),wwi3s(nv,mbs),wwi4s(nv,mbs)
! changing over
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &       ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          if(ti(i).lt.0.0) write(*,*)'optical depth of ice=',ti(i)
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &       bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
! changed by Z.F.
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) =  wf1
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) =  wf2
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) =  wf3
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) =  wf4
! changing over
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
! added by Z.F.
!      if(ib.le.mbs) then
!        do i=1,nv
!          tizfs(i,ib)=ti(i)
!          wizfs(i,ib)=wi(i)
!          wwi1s(i,ib)=wwi(i,1)
!          wwi2s(i,ib)=wwi(i,2)
!          wwi3s(i,ib)=wwi(i,3)
!          wwi4s(i,ib)=wwi(i,4)
!        end do
!      end if

!        write(*,*)'ti=',ti
!        write(*,*)'wi=',wi
!        write(*,*)'wwi1=',(wwi(i,1),i=1,nv)
!        write(*,*)'wwi2=',(wwi(i,2),i=1,nv)
!        write(*,*)'wwi3=',(wwi(i,3),i=1,nv)
!        write(*,*)'wwi4=',(wwi(i,4),i=1,nv)
! adding over
      return
      end subroutine


!!!!!!!!!!!!!!!!!!!C
! -- using new coefficients for ice single habit
! -- by Qing Yue 2006
      subroutine ice_new_Single ( ib,pre,pde,plwc,piwc,dz,ti,wi,wwi )
! *********************************************************************
! ti, wi, and wwi are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the scattering of ice clouds for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ap=>ap_7,bp=>bp_7,             &
                                         cps=>cps_7,cpir=>cpir_7, &
                                         mbs, nv
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: fw1, fw2, fw3, wf1, wf2, wf3, wf4, gg, x1, x2, x3, x4
      integer :: i, ib, ibr   
      
! changed by Z.F.
!      common /zf_solar/tizfs(nv,mbs),wizfs(nv,mbs),wwi1s(nv,mbs),
!     &            wwi2s(nv,mbs),wwi3s(nv,mbs),wwi4s(nv,mbs)
! changing over
      do i = 1, nv
        if ( piwc(i) .lt. 1.0e-5 ) then
          ti(i) = 0.0
          wi(i) = 0.0
          wwi(i,1) = 0.0
          wwi(i,2) = 0.0
          wwi(i,3) = 0.0
          wwi(i,4) = 0.0
        else
! The constant 1000.0 below is to consider the units of dz(i) is km.
          fw1 = pde(i)
          fw2 = fw1 * pde(i)
          fw3 = fw2 * pde(i)
          ti(i) = dz(i) * 1000.0 * piwc(i) * ( ap(1,ib) + &
     &       ap(2,ib) / fw1 + ap(3,ib) / fw2 )
          if(ti(i).lt.0.0) write(*,*)'optical depth of ice=',ti(i)
          wi(i) = 1.0 - ( bp(1,ib) + bp(2,ib) * fw1 + &
     &       bp(3,ib) * fw2 + bp(4,ib) * fw3 )
          if ( ib .le. mbs ) then
! changed by Z.F.
            wf1 = cps(1,1,ib) + cps(2,1,ib) * fw1 + &
     &         cps(3,1,ib) * fw2 + cps(4,1,ib) * fw3
            wwi(i,1) =  wf1
            wf2 = cps(1,2,ib) + cps(2,2,ib) * fw1 + &
     &         cps(3,2,ib) * fw2 + cps(4,2,ib) * fw3
            wwi(i,2) =  wf2
            wf3 = cps(1,3,ib) + cps(2,3,ib) * fw1 + &
     &         cps(3,3,ib) * fw2 + cps(4,3,ib) * fw3
            wwi(i,3) =  wf3
            wf4 = cps(1,4,ib) + cps(2,4,ib) * fw1 + &
     &         cps(3,4,ib) * fw2 + cps(4,4,ib) * fw3
            wwi(i,4) =  wf4
! changing over
          else
            ibr = ib - mbs
            gg = cpir(1,ibr) + cpir(2,ibr) * fw1 + &
     &         cpir(3,ibr) * fw2 + cpir(4,ibr) * fw3
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            wwi(i,1) = 3.0 * x1
            wwi(i,2) = 5.0 * x2
            wwi(i,3) = 7.0 * x3
            wwi(i,4) = 9.0 * x4
          endif
        endif
10    end do
! added by Z.F.
!      if(ib.le.mbs) then
!        do i=1,nv
!          tizfs(i,ib)=ti(i)
!          wizfs(i,ib)=wi(i)
!          wwi1s(i,ib)=wwi(i,1)
!          wwi2s(i,ib)=wwi(i,2)
!          wwi3s(i,ib)=wwi(i,3)
!          wwi4s(i,ib)=wwi(i,4)
!        end do
!      end if

!        write(*,*)'ti=',ti
!        write(*,*)'wi=',wi
!        write(*,*)'wwi1=',(wwi(i,1),i=1,nv)
!        write(*,*)'wwi2=',(wwi(i,2),i=1,nv)
!        write(*,*)'wwi3=',(wwi(i,3),i=1,nv)
!        write(*,*)'wwi4=',(wwi(i,4),i=1,nv)
! adding over
      return
      end subroutine


      subroutine water_fl ( ib,pre,plwc,pde,piwc,dz,tw,ww,www )
! *********************************************************************
! tw, ww, and www are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4) due to the Mie scattering of water clouds for a given layer. 
! By using the mean single scattering properties of the eight drop
! size distributions in each spectral band, the single scattering
! properties of a water cloud with the given liquid water content
! and effective radius are obtained by interpolating (Eqs. 4.25 -
! 4.27 of Fu, 1991). nc = 8
! *********************************************************************
      use  fu_liou_gu_table, only: re,fl,bz,wz,gz,      &
                                   nv,nc,mb
      implicit none

      real, dimension(nv) :: pre, plwc, pde, piwc, dz
      real    :: tw(nv), ww(nv), www(nv,4)
      integer :: ib
      real    :: x1, x2, x3, x4, gg
      integer :: i, j
      
      do i = 1, nv
        if ( plwc(i) .lt. 1.0e-5 ) then
          tw(i) = 0.0
          ww(i) = 0.0
          www(i,1) = 0.0
          www(i,2) = 0.0
          www(i,3) = 0.0
          www(i,4) = 0.0
        else
          if ( pre(i) .le. re(1) ) then
! A cloud with the effective radius smaller than 4.18 um is assumed
! to have an effective radius of 4.18 um with respect to the single
! scattering properties.  
            tw(i) = dz(i) * plwc(i) * bz(1,ib) / fl(1)
            ww(i) = wz(1,ib)
            x1 = gz(1,ib)
            x2 = x1 * gz(1,ib)
            x3 = x2 * gz(1,ib)
            x4 = x3 * gz(1,ib)
            www(i,1) = 3.0 * x1
            www(i,2) = 5.0 * x2
            www(i,3) = 7.0 * x3
            www(i,4) = 9.0 * x4
          elseif ( pre(i) .ge. re(nc) ) then
! A cloud with the effective radius larger than 31.23 um is assumed
! to have an effective radius of 31.18 um with respect to the single
! scattering properties.  
            tw(i) = dz(i) * plwc(i) * bz(nc,ib) / fl(nc)
            ww(i) = wz(nc,ib)
            x1 = gz(nc,ib)
            x2 = x1 * gz(nc,ib)
            x3 = x2 * gz(nc,ib)
            x4 = x3 * gz(nc,ib)
            www(i,1) = 3.0 * x1
            www(i,2) = 5.0 * x2
            www(i,3) = 7.0 * x3
            www(i,4) = 9.0 * x4
          else
            j = nc 
            do while (pre(i) .lt. re(j))
              j = j - 1
            end do
            tw(i) = dz(i) * plwc(i) * ( bz(j,ib) / fl(j) +  &
     &             ( bz(j+1,ib) / fl(j+1) - bz(j,ib) / fl(j) ) /  &
     &             ( 1.0 / re(j+1) - 1.0 / re(j) ) * ( 1.0 / pre(i) &
     &             - 1.0 / re(j) ) )
            ww(i) = wz(j,ib) + ( wz(j+1,ib) - wz(j,ib) ) / &
     &             ( re(j+1) - re(j) ) * ( pre(i) - re(j) )
            gg = gz(j,ib) + ( gz(j+1,ib) - gz(j,ib) ) / &
     &         ( re(j+1) - re(j) ) * ( pre(i) - re(j) )
            x1 = gg
            x2 = x1 * gg
            x3 = x2 * gg
            x4 = x3 * gg
            www(i,1) = 3.0 * x1
            www(i,2) = 5.0 * x2
            www(i,3) = 7.0 * x3
            www(i,4) = 9.0 * x4
          endif
        endif
10    end do
      return
      end subroutine



      subroutine rayle2(pp,pt,ph,po,trp) 
! *********************************************************************
! trp is P(mb)/T(K)*DZ(m) and the constant 14.6337=R(287)/g(9.806)/2.
! *********************************************************************
      use fu_liou_gu_table, only: nv1, nv
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real                 :: trp(nv)
      integer              :: i
      do i = 1, nv
        trp(i) = 14.6337 * ( pp(i) + pp(i+1) ) &
     &     * alog( pp(i+1) / pp(i) ) 
      end do
      return
      end subroutine

      subroutine rayle ( ib,trp,tr,wr,wwr )
! *********************************************************************
! tr, wr, and wwr are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and
! 4 ) due to the Rayleigh scattering for a given layer.
! *********************************************************************
      use  fu_liou_gu_table, only: ri,mbs,nv,u0
      implicit none

      real    :: trp(nv)
      real    :: tr(nv), wr(nv), wwr(nv,4)
      integer :: ib, i
      real    :: x
      
      if ( ib .le. mbs ) then
        if ( ib .eq. 1 ) then
          x = -3.902860e-6 * u0 * u0+6.120070e-6 * u0+4.177440e-6
        else
          x = ri(ib)
        endif
          do i = 1, nv
            tr(i) = trp(i) * x
            wr(i) = 1.0
            wwr(i,1) = 0.0
            wwr(i,2) = 0.5
            wwr(i,3) = 0.0
            wwr(i,4) = 0.0
100       end do
        else
        do i = 1, nv
          tr(i) = 0.0
          wr(i) = 0.0
          wwr(i,1) = 0.0
          wwr(i,2) = 0.0
          wwr(i,3) = 0.0
          wwr(i,4) = 0.0
200     end do
      endif
      return
      end subroutine



      subroutine rain ( ib,prwc,dz,trn,wrn,wwrn )
! *********************************************************************
! trn, wrn, and wwrn are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and 4 )
! due to the Mie scattering of rain for a given layer. 
!                        Jan. 19, 1993
! *********************************************************************
      use  fu_liou_gu_table, only: rwc,brn,wrnf,grn,nv
      implicit none

      real    :: prwc(nv), dz(nv)
      real    :: trn(nv), wrn(nv), wwrn(nv,4)
      integer :: ib, i
      real    :: x1, x2, x3, x4, y1, y2, y3, y4
      
      x1 = grn(ib)
      x2 = x1 * grn(ib)
      x3 = x2 * grn(ib)
      x4 = x3 * grn(ib)
      y1 = 3.0 * x1
      y2 = 5.0 * x2
      y3 = 7.0 * x3
      y4 = 9.0 * x4
      do i = 1, nv
        if ( prwc(i) .lt. 1.0e-5 ) then
          trn(i) = 0.0
          wrn(i) = 0.0
          wwrn(i,1) = 0.0
          wwrn(i,2) = 0.0
          wwrn(i,3) = 0.0
          wwrn(i,4) = 0.0
        else
          trn(i) = dz(i) * prwc(i) * brn(ib) / rwc
          wrn(i) = wrnf(ib)
          wwrn(i,1) = y1
          wwrn(i,2) = y2
          wwrn(i,3) = y3
          wwrn(i,4) = y4
        endif
10    end do
      return
      end subroutine




      subroutine graup ( ib,pgwc,dz, tgr,wgr,wwgr )
! *********************************************************************
! tgr, wgr, and wwgr are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and 4 )
! due to the Mie scattering of graupel for a given layer. 
!                        Jan. 19, 1993
! *********************************************************************
      use  fu_liou_gu_table, only: gwc,bg,wgf,gg,nv
      implicit none

      real    :: pgwc(nv), dz(nv)
      real    :: tgr(nv), wgr(nv), wwgr(nv,4)
      integer :: ib, i
      real    :: x1, x2, x3, x4, y1, y2, y3, y4
      
      x1 = gg(ib)
      x2 = x1 * gg(ib)
      x3 = x2 * gg(ib)
      x4 = x3 * gg(ib)
      y1 = 3.0 * x1
      y2 = 5.0 * x2
      y3 = 7.0 * x3
      y4 = 9.0 * x4
      do i = 1, nv
        if ( pgwc(i) .lt. 1.0e-5 ) then
          tgr(i) = 0.0
          wgr(i) = 0.0
          wwgr(i,1) = 0.0
          wwgr(i,2) = 0.0
          wwgr(i,3) = 0.0
          wwgr(i,4) = 0.0
        else
          tgr(i) = dz(i) * pgwc(i) * bg(ib) / gwc
          wgr(i) = wgf(ib)
          wwgr(i,1) = y1
          wwgr(i,2) = y2
          wwgr(i,3) = y3
          wwgr(i,4) = y4
        endif
10    end do
      return
      end subroutine




      subroutine gascon ( ib,tgm,pp,pt,ph,po )
! *********************************************************************
! tgm(nv) are the optical depthes due to water vapor continuum absorp-
! tion in nv layers for a given band ib. We include continuum absorp-
! tion in the 280 to 1250 cm**-1 region. vv(11)-vv(17) are the central
! wavenumbers of each band in this region. 
! *********************************************************************
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: tgm(nv)
      real    :: vv(18) = (/ 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
                             0.0, 0.0, 1175.0, 1040.0, 890.0, 735.0, &
     &                       605.0, 470.0, 340.0, 0.0 /)
      integer :: ib, i
     
      if ( ib .gt. 10 .and. ib .lt. 18 ) then
        call qopcon ( vv(ib),tgm,pp,pt,ph,po )
      else
        do i = 1, nv
          tgm(i) = 0.0
10      end do
      endif
      return
      end subroutine


      subroutine gases ( ib,ig,hk,pp,pt,ph,po,tg )
! *********************************************************************
! tg(nv) are the optical depthes due to nongray gaseous absorption, in
! nv layers for a given band ib and cumulative probability ig. 
! *********************************************************************
      use  fu_liou_gu_table, only:nv1,nv,                      &
                            &    umco2,umch4,umn2o,umo2,       &    
                            &    umno,umso2,umno2,umch3cl,     &  
                            &    umco,no2s,umCFC11,umCFC12,    &
                            &    nco2s,nso2s,nch4s,nnol,       &
                            &    nno2l,nso2l,nch3cll,ncos,     &
                            &    nn2os,nh2ocs,nh2os,no3s,      &
                            &    nh2ol,no3l,nco2l,nn2ol,       &
                            &    nch4l,nCFC11l,nCFC12l,        &
                            &    hk1=>hk_1,fk1o3=>fko3_1,      &
                            &    hk2=>hk_2,c2h2o=>coeh2o_2,    &
                            &    hk3=>hk_3,c3h2o=>coeh2o_3,  &
                            &    hk4=>hk_4,c4h2o=>coeh2o_4,  &
                            &    hk5=>hk_5,c5h2o=>coeh2o_5,  &
                            &    hk6=>hk_6,c6h2o=>coeh2o_6,  &
                            &    hk7=>hk_7,c7h2o=>coeh2o_7,  &
                            &    hk8=>hk_8,c8h2o=>coeh2o_8,  &
                            &    hk9=>hk_9,c9h2o=>coeh2o_9,  &
                            &    hk10=>hk_10,c10h2o=>coeh2o_10, &
                            &    c10ch4=>coech4_10,c10n2o=>coen2o_10, &
                            &    hk11=>hk_11,c11h2o=>coeh2o_11, &
                            &    c11ch4=>coech4_11,c11n2o=>coen2o_11, &
                            &    hk12=>hk_12,c12o3=>coeo3_12, &
                            &    c12h2o=>coeh2o_12, &
                            &    hk13=>hk_13,c13h2o=>coeh2o_13, &
                            &    hk14=>hk_14,c14hca=>coehca_14, &
                            &    c14hcb=>coehcb_14, &
                            &    hk15=>hk_15,c15hca=>coehca_15, &
                            &    c15hcb=>coehcb_15, &
                            &    hk16=>hk_16,c16h2o=>coeh2o_16, &
                            &    hk17=>hk_17,c17h2o=>coeh2o_17, &
                            &    hk18=>hk_18,c18h2o=>coeh2o_18
      implicit none
                             
      
      
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: tg(nv)
      integer :: ib, ig
      real    :: hk
      
!!!!!!!!!!!!!!!!!c

      real, dimension(nv1) :: fkg, fkga, fkgb, pq
      real, dimension(nv)  :: tg1, tg2, tg3
      real    :: fk
      integer :: i

      select case(ib) 
      case default
        stop
!-------------------------------------        
      case(1)
1       fk = fk1o3(ig)
        call qopo3s ( fk,tg,pp,pt,ph,po )
        hk = 619.618 * hk1(ig)
! In this band ( 50000 - 14500 cm**-1 ), we have considered the nongray
! gaseous absorption of O3.    619.618 is the solar energy contained in
! the band in units of Wm**-2.
      case(2)
2       call qks ( c2h2o(1,1,ig),fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = 484.295 * hk2(ig)
! In this band ( 14500 - 7700 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.  484.295 is the solar energy contained in
! the band in units of Wm**-2.
      case(3)
3       call qks ( c3h2o(1,1,ig),fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = 149.845 * hk3(ig)
! In this band ( 7700 - 5250 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 149.845 is the solar energy contained in
! the band in units of Wm**-2.
      case(4)
4       call qks ( c4h2o(1,1,ig),fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = 48.7302 * hk4(ig)
! In this band ( 5250 - 4000 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 48.7302 is the solar energy contained in
! the band in units of Wm**-2.
      case(5)
5       call qks ( c5h2o(1,1,ig),fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = 31.6576 * hk5(ig)
! In this band ( 4000 - 2850 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 31.6576 is the solar energy contained in
! the band in units of Wm**-2.
      case(6)
6       call qks ( c6h2o(1,1,ig),fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = 5.79927 * hk6(ig)
! In this band ( 2850 - 2500 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 5.79927 is the solar energy contained in
! the band in units of Wm**-2.
      case(7)
7       call qki ( c7h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk7(ig)
! In this band ( 2200 - 1900 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(8)
8       call qki ( c8h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk8(ig)
! In this band ( 1900 - 1700 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(9)
9       call qki ( c9h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk9(ig)
! In this band ( 1700 - 1400 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(10)
10      call qki ( c10h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg1,pp,pt,ph,po )
        call qki ( c10ch4, fkg,pp,pt,ph,po )
        call qopch4 ( fkg, tg2,pp,pt,ph,po ) 
        call qki ( c10n2o, fkg,pp,pt,ph,po )
        call qopn2o ( fkg, tg3,pp,pt,ph,po )
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i)/1.6*umch4 + tg3(i)/0.28*umn2o
205     end do
        hk = hk10(ig)
! In this band ( 1400 - 1250 cm**-1 ), we have considered the overlapping
! absorption of H2O, CH4, and N2O by approach one of Fu(1991).
      case(11)
11      call qki ( c11h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg1,pp,pt,ph,po )
        call qki ( c11ch4, fkg,pp,pt,ph,po )
        call qopch4 ( fkg, tg2,pp,pt,ph,po )
        call qki ( c11n2o, fkg,pp,pt,ph,po )
        call qopn2o ( fkg, tg3,pp,pt,ph,po )
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i)/1.6*umch4 + tg3(i)/0.28*umn2o
215     end do
        hk = hk11(ig)
! In this band ( 1250 - 1100 cm**-1 ), we have considered the overlapping
! absorption of H2O, CH4, and N2O by approach one of Fu(1991).
      case(12)
12      call qkio3 ( c12o3(1,1,ig), fkg,pp,pt,ph,po )
        call qopo3i ( fkg, tg1,pp,pt,ph,po )
        call qki ( c12h2o, fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg2,pp,pt,ph,po )
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i)
225     end do
        hk = hk12(ig)
! In this band ( 1100 - 980 cm**-1 ), we have considered the overlapping
! absorption of H2O and O3 by approach one of Fu(1991).
      case(13)
13      call qki ( c13h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk13(ig)
! In this band ( 980 - 800 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(14)
14      do i = 1, nv1
          if ( pp(i) .ge. 63.1 ) then
            pq(i) = ph(i)
          else
            pq(i) = 0.0
          endif
333     end do
        call qki ( c14hca(1,1,ig), fkga,pp,pt,ph,po )
        call qki ( c14hcb(1,1,ig), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkga(i)/330.0*umco2 + pq(i) * fkgb(i)
343     end do
        call qophc ( fkg, tg,pp,pt,ph,po)
        hk = hk14(ig)
! In this band ( 800 - 670 cm**-1), we have considered the overlapping
! absorption of H2O and CO2 by approach two of Fu(1991).
      case(15)
15      do i = 1, nv1
          if ( pp(i) .ge. 63.1 ) then
            pq(i) = ph(i)
          else
            pq(i) = 0.0
          endif
353     end do
        call qki ( c15hca(1,1,ig), fkga,pp,pt,ph,po )
        call qki ( c15hcb(1,1,ig), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkga(i)/330.0*umco2 + pq(i) * fkgb(i)
363     end do
        call qophc ( fkg, tg,pp,pt,ph,po)
        hk = hk15(ig)
! In this band ( 670 - 540 cm**-1), we have considered the overlapping
! absorption of H2O and CO2 by approach two of Fu(1991).
      case(16)
16      call qki ( c16h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk16(ig)
! In this band ( 540 - 400 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(17)
17      call qki ( c17h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk17(ig)
! In this band ( 400 - 280 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(18)
18      call qki ( c18h2o(1,1,ig), fkg,pp,pt,ph,po )
        call qoph2o ( fkg, tg,pp,pt,ph,po )
        hk = hk18(ig)
! In this band ( 280 - 000 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      end select
      return
      end subroutine


      subroutine qks ( coefks,fkg,pp,pt,ph,po )
! *********************************************************************
! fkg(nv1) are the gaseous absorption coefficients in units of (cm-atm)
! **-1 for a given cumulative probability in nv1 layers. coefks(3,11)
! are the coefficients to calculate the absorption coefficient at the
! temperature t for the 11 pressures by
!         ln k = a + b * ( t - 245 ) + ! * ( t - 245 ) ** 2
! and the absorption coefficient at conditions other than those eleven
! pressures is interpolated linearly with pressure (Fu, 1991).
! *********************************************************************
      use  fu_liou_gu_table, only: nv1   
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po, fkg
      real :: coefks(3,11)
      real :: stanp(11) = (/ 10.0, 15.8, 25.1, 39.8, 63.1, 100.0, &
     &                       158.0, 251.0, 398.0, 631.0, 1000.0 /)
      integer :: i1, i
      real    :: x1, x2, y1

      i1 = 1
      do i = 1, nv1
        if ( pp(i) .lt. stanp(1) ) then
          x1 = exp ( coefks(1,1) + coefks(2,1) * ( pt(i) - 245.0 ) &
         &      + coefks(3,1) * ( pt(i) - 245.0 ) ** 2 )
          fkg(i) = x1 * pp(i) / stanp(1)
        elseif ( pp(i) .ge. stanp(11) ) then
          y1 = ( pt(i) - 245.0 ) * ( pt(i) - 245.0 )
          x1 = exp ( coefks(1,10) + coefks(2,10) * ( pt(i) - 245.0 ) &
         &          + coefks(3,10) * y1 )
          x2 = exp ( coefks(1,11) + coefks(2,11) * ( pt(i) - 245.0 ) &
         &          + coefks(3,11) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(11) - stanp(10) ) &
         &          * ( pp(i) - stanp(10) )
        else

          do while ( pp(i) .ge. stanp(i1) ) 
            i1 = i1 + 1
          end do
          y1 = ( pt(i) - 245.0 ) * ( pt(i) - 245.0 )
          x1 = exp ( coefks(1,i1-1) + coefks(2,i1-1) * (pt(i)-245.0) &
         &          + coefks(3,i1-1) * y1 )
          x2 = exp ( coefks(1,i1) + coefks(2,i1) * ( pt(i) - 245.0 ) &
         &          + coefks(3,i1) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(i1) - stanp(i1-1) ) &
         &           * ( pp(i) - stanp(i1-1) )
       endif
      end do
      return
      end subroutine


      subroutine qki ( coefki, fkg,pp,pt,ph,po )
! *********************************************************************
! fkg(nv1) are the gaseous absorption coefficients in units of (cm-atm)
! **-1 for a given cumulative probability in nv1 layers. coefki(3,19)
! are the coefficients to calculate the absorption coefficient at the
! temperature t for the 19 pressures by
!         ln k = a + b * ( t - 245 ) + ! * ( t - 245 ) ** 2
! and the absorption coefficient at  conditions  other  than  those 19
! pressures is interpolated linearly with pressure (Fu, 1991).
! *********************************************************************
      use  fu_liou_gu_table, only: nv1   
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po, fkg
      real    :: coefki(3,19)
      integer :: i, i1
      real    ::  x1, x2, y1
      real :: stanp(19) = (/ 0.251, 0.398, 0.631, 1.000, 1.58, 2.51,  &
     &                   3.98, 6.31, 10.0, 15.8, 25.1, 39.8, 63.1, &
     &                   100.0, 158.0, 251.0, 398.0, 631.0, 1000.0 /)

      i1 = 1
      do i = 1, nv1
! -test
        if (pt(i).gt.345.) then
          pt(i) = 345.
        endif
        if (pt(i).lt.180.) then
          pt(i) = 180.
        endif
! -test over

        if ( pp(i) .lt. stanp(1) ) then
          x1 = exp ( coefki(1,1) + coefki(2,1) * ( pt(i) - 245.0 ) &
     &       + coefki(3,1) * ( pt(i) - 245.0 ) ** 2 )
          fkg(i) = x1 * pp(i) / stanp(1)
        elseif ( pp(i) .ge. stanp(19) ) then
          y1 = ( pt(i) - 245.0 ) * ( pt(i) - 245.0 )
          x1 = exp ( coefki(1,18) + coefki(2,18) * ( pt(i) - 245.0 ) &
     &           + coefki(3,18) * y1 )
          x2 = exp ( coefki(1,19) + coefki(2,19) * ( pt(i) - 245.0 ) &
     &           + coefki(3,19) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(19) - stanp(18) ) &
     &           * ( pp(i) - stanp(18) )
        else
          do while ( pp(i) .ge. stanp(i1) )
            i1 = i1 + 1
          end do
          y1 = ( pt(i) - 245.0 ) * ( pt(i) - 245.0 )
          x1 = exp ( coefki(1,i1-1) + coefki(2,i1-1) * (pt(i)-245.0) &
         &         + coefki(3,i1-1) * y1 )
          x2 = exp ( coefki(1,i1) + coefki(2,i1) * ( pt(i) - 245.0 ) &
         &         + coefki(3,i1) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(i1) - stanp(i1-1) ) &
         &         * ( pp(i) - stanp(i1-1) )
        endif
      end do
      return
      end subroutine


      subroutine qkio3 ( coefki, fkg,pp,pt,ph,po )
! *********************************************************************
! fkg(nv1) are the gaseous absorption coefficients in units of (cm-atm)
! **-1 for a given cumulative probability in nv1 layers. coefki(3,19)
! are the coefficients to calculate the absorption coefficient at the
! temperature t for the 19 pressures by
!         ln k = a + b * ( t - 250 ) + ! * ( t - 250 ) ** 2
! and the absorption coefficient at  conditions  other  than  those 19
! pressures is interpolated linearly with pressure (Fu, 1991).
! *********************************************************************
      use  fu_liou_gu_table, only: nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: coefki(3,19), fkg(nv1)
      integer :: i, i1
      real    :: x1, x2, y1
      real :: stanp(19) = (/0.251, 0.398, 0.631, 1.000, 1.58, 2.51,  &
     &                   3.98, 6.31, 10.0, 15.8, 25.1, 39.8, 63.1,   &
     &                   100.0, 158.0, 251.0, 398.0, 631.0, 1000.0/)

      i1 = 1
      do i = 1, nv1
        if ( pp(i) .lt. stanp(1) ) then
          x1 = exp ( coefki(1,1) + coefki(2,1) * ( pt(i) - 250.0 ) &
         &   + coefki(3,1) * ( pt(i) - 250.0 ) ** 2 )
          fkg(i) = x1 * pp(i) / stanp(1)
        elseif ( pp(i) .ge. stanp(19) ) then
          y1 = ( pt(i) - 250.0 ) * ( pt(i) - 250.0 )
          x1 = exp ( coefki(1,18) + coefki(2,18) * ( pt(i) - 250.0 ) &
         &      + coefki(3,18) * y1 )
          x2 = exp ( coefki(1,19) + coefki(2,19) * ( pt(i) - 250.0 ) &
         &      + coefki(3,19) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(19) - stanp(18) ) &
         &      * ( pp(i) - stanp(18) )
        else
          do while ( pp(i) .ge. stanp(i1) )
            i1 = i1 + 1
          end do
          y1 = ( pt(i) - 250.0 ) * ( pt(i) - 250.0 )
          x1 = exp ( coefki(1,i1-1) + coefki(2,i1-1) * (pt(i)-250.0) &
         &       + coefki(3,i1-1) * y1 )
          x2 = exp ( coefki(1,i1) + coefki(2,i1) * ( pt(i) - 250.0 ) &
         &       + coefki(3,i1) * y1 )
          fkg(i) = x1 + ( x2 - x1 ) / ( stanp(i1) - stanp(i1-1) ) &
         &       * ( pp(i) - stanp(i1-1) )
        end if
5     end do
      return
      end subroutine
!---------------------------------------------------
      subroutine qopo3s ( fk,tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real, dimension(nv) :: tg
      real    :: fk, fq
      integer :: i
      fq = 238.08 * fk
      do i = 1, nv
        tg(i) = ( po(i) + po(i+1) ) * ( pp(i+1) - pp(i) ) * fq
10    end do
!      do 20 i = 1, nv
!         tg(i) = tg(i) * 476.16 * fk
!20    continue
! 476.16 = 2.24e4 / M * 10.0 / 9.8, where M = 48 for O3.?
      return
      end subroutine
!----------------------------------------------------
      subroutine qoph2o ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      
      do i = 1, nv
        tg(i) = ( fkg(i) * ph(i) + fkg(i+1) * ph(i+1) ) &
     &         * ( pp(i+1) - pp(i) ) * 634.9205
10    end do
!      do 20 i = 1, nv
!         tg(i) = tg(i) * 1269.841
!20      continue
! 1269.841 = 2.24e4 / M * 10.0 / 9.8, where M = 18 for H2O.
      return
      end subroutine
!-----------------------------------------------------
      subroutine qopch4 ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      
      do i = 1, nv
        tg(i) = ( fkg(i)+fkg(i+1) ) *( pp(i+1)-pp(i) )* 6.3119e-4
10    end do
!     do 20 i = 1, nv
!         tg(i) = tg(i) * 1.26238e-3
!20      continue
! 1.26238e-3 = 2.24e4 / M * 10.0 / 9.8 * 1.6e-6 * M / 28.97, where 
! M = 16 for CH4.
      return
      end subroutine
!-------------------------------------------------------
      subroutine qopn2o ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      
      do i = 1, nv
        tg(i) = ( fkg(i)+fkg(i+1) ) * (pp(i+1)-pp(i))*1.10459e-4
10    end do
!      do 20 i = 1, nv
!         tg(i) = tg(i) * 2.20918e-4
!20      continue
! 2.20918e-4 = 2.24e4 / M * 10.0 / 9.8 * 0.28e-6 * M / 28.97, where
! M = 44 for N2O.
      return
      end subroutine
!--------------------------------------------------------
      subroutine qopo3i ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      
      do i = 1, nv
        tg(i) = ( fkg(i) * po(i) + fkg(i+1) * po(i+1) ) &
     &         * ( pp(i+1) - pp(i) ) * 238.08
10    end do
!      do 20 i = 1, nv
!         tg(i) = tg(i) * 476.16
!20      continue
      return
      end subroutine

!----------------------------------------------
      subroutine qophc ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      
      do i = 1, nv
        tg(i) = ( fkg(i) + fkg(i+1) ) * ( pp(i+1) - pp(i) ) * 0.5
10    end do
! See page 86 of Fu (1991).
      return
      end subroutine

!----------------------------------------------
      subroutine qopcon ( vv,tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none

      real, dimension(nv1) :: pp, pt, ph, po, &
     &                        ff, pe
      real    :: vv, tg(nv)
      real    :: x, y, z, r, s, w
      integer :: i
      
      x = 4.18
      y = 5577.8
      z = 0.00787
      r = 0.002
      s = ( x + y * exp ( - z * vv ) ) / 1013.25
      do i = 1, nv1
        pe(i) = pp(i) * ph(i) / ( 0.622 + 0.378 * ph(i) )
        w = exp ( 1800.0 / pt(i) - 6.08108 )
        ff(i) = s * ( pe(i) + r * pp(i) ) * w
      end do
      do i = 1, nv
        tg(i) = ( ff(i) * ph(i) + ff(i+1) * ph(i+1) )* &
     &         ( pp(i+1) - pp(i) ) * 0.5098835
      end do
!      do 7 i = 1, nv
!         tg(i) = tg(i) * 10.0 / 9.80616
!7      continue
      return
      end subroutine
!      function fk ( v, e, p, t )
! The units of fk is cm**2/g. See Eq. (A.19) of Fu (1991).
!      x = 4.18
!      y = 5577.8
!      z = 0.00787
!      r = 0.002
!      w = exp ( 1800.0 / t - 6.08108 )
!      fk = ( x + y * exp ( -z * v ) ) * ( e + r * p ) * w / 1013.25
!      return
!      end

! -- add for new gases

      subroutine qopo2 ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=32
      do i = 1, nv
        tg(i) = 0.5*(fkg(i)+fkg(i+1)) *(pp(i+1)-pp(i)) * &
       &         2.24e4/aM*10.0/9.8*2.0948E+05*1.0e-6*aM/28.97
10    end do
      return
      end subroutine

      subroutine qopco2 ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=44
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) * &
       &       2.24e4 / aM * 10.0 / 9.8 * 330.0 *1.0e-6* aM / 28.97
10    end do
! 2.24e4 / M * 10.0 / 9.8 * 330.0 * M / 28.97, where
! M = 44 for CO2.
      return
      end subroutine
      
      subroutine qopco ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=28
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) * &
       &         2.24e4 / aM * 10.0 / 9.8 * 0.16 *1.0e-6* aM / 28.97
10    end do
      return
      end subroutine

      subroutine qopno ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=30
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) * &
       &        2.24e4 / aM * 10.0 / 9.8 * 0.0005 *1.0e-6* aM / 28.97
10    end do
      return
      end subroutine

      subroutine qopch3cl ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=50.5
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) * &
       &        2.24e4 / aM * 10.0 / 9.8 * 0.5e-3 *1.0e-6* aM / 28.97
10    end do
      return
      end subroutine

      subroutine qopso2 ( fkg, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: fkg(nv1), tg(nv)
      integer :: i
      real    :: am=64
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) * &
       &        2.24e4 / aM * 10.0 / 9.8 * 0.001 *1.0e-6* aM / 28.97
10    end do
      return
      end subroutine
!!  change for new gases over

!!  add CFC begin: 2007.06 Yue
      subroutine qopCFC11 ( coefCFC, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: coefCFC, fkg(nv1), tg(nv)
      integer :: i
      real    :: aM=137.3684
      do i = 1,nv1
        fkg(i) = coefCFC
      enddo
      do i = 1, nv
        tg(i) = 0.5*( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) *  &
       &        2.24e4/aM*10.0/9.8*0.22e-3*1.0e-6*aM/28.97
10    end do

      return
      end subroutine
      
      subroutine qopCFC12 ( coefCFC, tg,pp,pt,ph,po )
      use  fu_liou_gu_table, only: nv,nv1
      implicit none
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: coefCFC, fkg(nv1), tg(nv)
      integer :: i
      real    :: aM=120.9138
      do i = 1,nv1
        fkg(i) = coefCFC
      enddo
      do i = 1, nv
        tg(i) = 0.5* ( fkg(i)+fkg(i+1) ) * ( pp(i+1)-pp(i) ) *  &
       &        2.24e4/aM*10.0/9.8*0.375e-3*1.0e-6*aM/28.97         
10    end do

      return
      end subroutine
!! CFC add end

! -- no partly cloudy
      subroutine comscp(ti,wi,wwi,tw,ww,www,trn,wrn,wwrn,tgr,wgr,wwgr,&
                        tr,wr,wwr,tgm,tg,wc1,wc2,wc3,wc4,wc,tt)
! *********************************************************************
! This subroutine is used to  COMbine Single-Scattering Properties  due
! to  ice crystals,  water droplets, and  Rayleigh molecules along with
! H2O continuum absorption and nongray gaseous absorption.  See Section
! 3.4 of Fu (1991). wc, wc1, wc2, wc3, and wc4, are total (or combined)
! single - scattering  albedo,  and   expansion   coefficients  of  the
! phase function ( 1, 2, 3, and 4 ) in nv layers. tt(nv) are the normal
! optical depth ( from the top of the atmosphere to a given level ) for
! level 2 - level nv1( surface ). The single-scattering  properties  of
! rain and graupel are also incorporated in ( Jan. 19, 1993 ).
! *********************************************************************
      use fu_liou_gu_table, only: nv
      implicit none
      
      real :: ti(nv), wi(nv), wwi(nv,4)
      real :: tw(nv), ww(nv), www(nv,4)
      real :: trn(nv), wrn(nv), wwrn(nv,4)
      real :: tgr(nv), wgr(nv), wwgr(nv,4)
      real :: tr(nv), wr(nv), wwr(nv,4)
      real :: tgm(nv)
      real :: tg(nv)
      real :: wc1(nv), wc2(nv), wc3(nv), wc4(nv), wc(nv), tt(nv)
      real :: tc(nv)
      integer :: i
      real :: tis, tws, trns, tgrs, fw
      
      do i = 1, nv
        tc(i) = ti(i) + tw(i) + tr(i) + tgm(i) + tg(i) + &
     &             trn(i) + tgr(i)
        tis = ti(i) * wi(i)
        tws = tw(i) * ww(i)
        trns = trn(i) * wrn(i)
        tgrs = tgr(i) * wgr(i)
        fw = tis + tws + tr(i) + trns + tgrs
        wc(i) =  fw / tc(i)
        if ( fw .lt. 1.0e-20 ) then
          wc1(i) = 0.0
          wc2(i) = 0.0
          wc3(i) = 0.0
          wc4(i) = 0.0
        else
          wc1(i) = ( tis * wwi(i,1) + tws * www(i,1) + &
     &       tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) )/fw
          wc2(i) = ( tis * wwi(i,2) + tws * www(i,2) + &
     &       tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) )/fw
          wc3(i) = ( tis * wwi(i,3) + tws * www(i,3) + &
     &       tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) )/fw
          wc4(i) = ( tis * wwi(i,4) + tws * www(i,4) + &
     &       tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) )/fw
        endif
10    end do
      tt(1) = tc(1)
      do i = 2, nv
        tt(i) = tt(i-1) + tc(i)
20    end do
      return
      end subroutine



!! -- partly cloudy
!      subroutine comscp_new
!! *********************************************************************
!! This subroutine is used to  COMbine Single-Scattering Properties  due
!! to  ice crystals,  water droplets, and  Rayleigh molecules along with
!! H2O continuum absorption and nongray gaseous absorption.  See Section
!! 3.4 of Fu (1991). wc, wc1, wc2, wc3, and wc4, are total (or combined)
!! single - scattering  albedo,  and   expansion   coefficients  of  the
!! phase function ( 1, 2, 3, and 4 ) in nv layers. tt(nv) are the normal
!! optical depth ( from the top of the atmosphere to a given level ) for
!! level 2 - level nv1( surface ). The single-scattering  properties  of
!! rain and graupel are also incorporated in ( Jan. 19, 1993 ).
!! *********************************************************************
!      
!      common /ic/ ti(nv), wi(nv), wwi(nv,4)
!      common /wat/ tw(nv), ww(nv), www(nv,4)
!      common /rai/ trn(nv), wrn(nv), wwrn(nv,4)
!      common /gra/ tgr(nv), wgr(nv), wwgr(nv,4)
!      common /ray/ tr(nv), wr(nv), wwr(nv,4)
!      common /con/ tgm(nv)
!      common /gas/ tg(nv)
!! -- add by Yu for fractional cloud
!      common /dfsin_2/ wc1_2(nv,2), wc2_2(nv,2), wc3_2(nv,2),  &
!     &                 wc4_2(nv,2),  &
!     &                     wc_2(nv,2), tt_2(nv,2)
!      common /delta_tao/ tc_2(nv,2)
!! - change over
!      common /dfsin/ wc1(nv), wc2(nv), wc3(nv), wc4(nv),  &
!     &                     wc(nv), tt(nv)
!! -- change by Yu, 02/13/02
!!      common /cld_a/cldamnt(nv), area_h(2), area_m(2), area_l(2)
!!      common /cld_c/n_h, n_m, n_l, cld_h, cld_m, cld_l
!      common /cld_a/cldamnt(nv), area_group(3,2)
!      common /cld_c/n_group(3), cld_group(3)
!      common /cld_loop/ nb(3)
!! - change over
!      dimension tc(nv)
!
!! -- change by Yu, 02/13/02
!! -- determine n_group(k), cld_group(k), and area_group(k,1), area_group(k,2) 
!! -- hight,middle, and low three cloud groups
!      do k=1,ngroup
!
!        kl = (k-1)*nsubcld + nv1-nclouds 
!        cld_group(k) = cldamnt(kl)
!        do i=kl+1,kl+nsubcld-1
!          if (cldamnt(i).gt.cld_group(k)) then
!            cld_group(k) = cldamnt(i)
!          endif
!        enddo
!! - partly cloudy
!        if (cld_group(k).gt.0.0.and.cld_group(k).lt.1.) then
!          n_group(k) = 2
!          nb(k) = 1
!          area_group(k,1) = 1. - cld_group(k)
!          area_group(k,2) = cld_group(k)
!! - clear
!        elseif(cld_group(k).eq.0.0) then
!          n_group(k) = 1
!          nb(k) = 1
!          area_group(k,1) = 1.
!          area_group(k,2) = 0. 
!! - overcast 
!        elseif(cld_group(k).eq.1.) then
!          n_group(k) = 2 
!          nb(k) = 2 
!          area_group(k,1) = 0.
!          area_group(k,2) = 1. 
!        endif
!
!      enddo
!! -- change over
!
!      do i = 1, nv
!! - add by Yu for clear
!        tc_2(i,1) = tr(i) + tgm(i) + tg(i) + &
!     &      trn(i) + tgr(i)
!! - change by Yu for overcast
!! -- adjust tau according to cloud amount
!        if (cldamnt(i).gt. 0.) then
!!         n_cld = (i-4)/3 
!          n_cld = (i-(nv1-nclouds))/nsubcld+1 
!          if (n_cld.gt.0) then
!! -- determine adjust parameter 
!            fcloud = cldamnt(i) / cld_group(n_cld)
!            if (fcloud.le.0.1) then
!              if (ti(i).le.15.) then
!                adj_pari = fcloud - fcloud * 0.5 * ti(i) / 15.
!              else
!                adj_pari = 0.5 * fcloud
!              endif
!              if (tw(i).le.15.) then
!                adj_parw = fcloud - fcloud * 0.5 * tw(i) / 15.
!              else
!                adj_parw = 0.5 * fcloud
!              endif
!            endif
!
!            if (fcloud.le.0.3.and.fcloud.gt.0.1) then
!              if (ti(i).le.15.) then
!                adj_pari = fcloud - fcloud * 0.33 * ti(i) / 15.
!              else
!                adj_pari = 0.67 * fcloud
!              endif
!              if (tw(i).le.15.) then
!                adj_parw = fcloud - fcloud * 0.33 * tw(i) / 15.
!              else
!                adj_parw = 0.67 * fcloud
!              endif
!            endif
!
!            if (fcloud.le.0.5.and.fcloud.gt.0.3) then
!              if (ti(i).le.15.) then
!                adj_pari = fcloud - fcloud * 0.4 * ti(i) / 15.
!              else
!                adj_pari = 0.6 * fcloud
!              endif
!              if (tw(i).le.15.) then
!                adj_parw = fcloud - fcloud * 0.4 * tw(i) / 15.
!              else
!                adj_parw = 0.6 * fcloud
!              endif
!            endif
!
!            if (fcloud.le.0.7.and.fcloud.gt.0.5) then
!              if (ti(i).le.15.) then
!                adj_pari = fcloud - fcloud * 0.286 * ti(i) / 15.
!              else
!                adj_pari = 0.714 * fcloud
!              endif
!              if (tw(i).le.15.) then
!                adj_parw = fcloud - fcloud * 0.286 * tw(i) / 15.
!              else
!                adj_parw = 0.714 * fcloud
!              endif
!            endif
!
!            if (fcloud.le.0.9.and.fcloud.gt.0.7) then
!              if (ti(i).le.15.) then
!                adj_pari = fcloud - fcloud * 0.11 * ti(i) / 15.
!              else
!                adj_pari = 0.89 * fcloud
!              endif
!              if (tw(i).le.15.) then
!                adj_parw = fcloud - fcloud * 0.11 * tw(i) / 15.
!              else
!                adj_parw = 0.89 * fcloud
!              endif
!            endif
!
!            if (fcloud.le.1..and.fcloud.gt.0.9) then
!              adj_pari = fcloud
!              adj_parw = fcloud
!            endif
!
!            if (ti(i).gt.0.) ti(i) = ti(i) * adj_pari * 0.6
!!     &       ti(i) = ti(i) * cldamnt(i) 
!!     &                   / cld_group(n_cld)
!            if (tw(i).gt.0.) tw(i) = tw(i) * adj_parw * 0.6
!!     &            tw(i) = tw(i) * cldamnt(i) 
!!     &                       / cld_group(n_cld)
!          endif
!        endif
!! - adjust over
!        tc_2(i,2) = ti(i) + tw(i) + tr(i) + tgm(i) + tg(i) + &
!     &             trn(i) + tgr(i)
!!      print *, 'i=',i,' tc=', tc_2(i,2)
!        tis = ti(i) * wi(i)
!        tws = tw(i) * ww(i) 
!        trns = trn(i) * wrn(i)
!        tgrs = tgr(i) * wgr(i)
!        fw1 = tr(i) + trns + tgrs
!        fw2 = tis + tws + tr(i) + trns + tgrs
!        wc_2(i,1) =  fw1 / tc_2(i,1)
!        wc_2(i,2) =  fw2 / tc_2(i,2)
!! - change by Yu for overcast (add one dimension in the array)
!        if ( fw2 .lt. 1.0e-20 ) then
!          wc1_2(i,2) = 0.0
!          wc2_2(i,2) = 0.0
!          wc3_2(i,2) = 0.0
!          wc4_2(i,2) = 0.0
!        else
!          wc1_2(i,2) = ( tis * wwi(i,1) + tws * www(i,1) + &
!     &    tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) )/fw2
!          wc2_2(i,2) = ( tis * wwi(i,2) + tws * www(i,2) + &
!     &    tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) )/fw2
!          wc3_2(i,2) = ( tis * wwi(i,3) + tws * www(i,3) + &
!     &    tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) )/fw2
!          wc4_2(i,2) = ( tis * wwi(i,4) + tws * www(i,4) + &
!     &    tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) )/fw2
!        endif
!! - add by Yu for clear (add one dimension in the array)
!        if ( fw1 .lt. 1.0e-20 ) then
!          wc1_2(i,1) = 0.0
!          wc2_2(i,1) = 0.0
!          wc3_2(i,1) = 0.0
!          wc4_2(i,1) = 0.0
!        else
!          wc1_2(i,1) = (  &
!     &    tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) )/fw1
!          wc2_2(i,1) = (  &
!     &    tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) )/fw1
!          wc3_2(i,1) = (  &
!     &    tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) )/fw1
!          wc4_2(i,1) = (  &
!     &    tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) )/fw1
!        endif
!          
!10    end do
!!      tt_2(1,1) = tc_2(1,1)
!!      tt_2(1,2) = tc_2(1,2)
!!      do 20 i = 2, nv
!!         tt_2(i,1) = tt_2(i-1,1) + tc_2(i,1)
!!         tt_2(i,2) = tt_2(i-1,2) + tc_2(i,2)
!!20      continue
!      return
!      end

! -- with aerosol, but no partly cloudy
      subroutine comscp_aero( ti,wi,wwi,tw,ww,www, &
     &                        trn,wrn,wwrn,tgr,wgr,wwgr, &
     &                        tr,wr,wwr,tgm,tg,tae,wae,wwae, &
     &                        wc1,wc2,wc3,wc4,wc,tt       &
     &                      )
! *********************************************************************
! This subroutine is used to  COMbine Single-Scattering Properties  due
! to  ice crystals,  water droplets, and  Rayleigh molecules along with
! H2O continuum absorption and nongray gaseous absorption.  See Section
! 3.4 of Fu (1991). wc, wc1, wc2, wc3, and wc4, are total (or combined)
! single - scattering  albedo,  and   expansion   coefficients  of  the
! phase function ( 1, 2, 3, and 4 ) in nv layers. tt(nv) are the normal
! optical depth ( from the top of the atmosphere to a given level ) for
! level 2 - level nv1( surface ). The single-scattering  properties  of
! rain and graupel are also incorporated in ( Jan. 19, 1993 ).
! *********************************************************************
! *********************************************************************
!  The single-scattering properties of aerosols are incorporated in.
! *********************************************************************
      use  fu_liou_gu_table, only: nv,nv1,nvx,mxac,          &
                                   naero,nfract,nice,ngas,   &
                                   ifg,ivd,itps,iaform,n_atau
      implicit none
      
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: tw(nv), ww(nv), www(nv,4)
      real    :: trn(nv), wrn(nv), wwrn(nv,4)
      real    :: tgr(nv), wgr(nv), wwgr(nv,4)
      real    :: tr(nv), wr(nv), wwr(nv,4)
      real    :: tgm(nv)
      real    :: tg(nv)
      real    :: tae(nvx,mxac), wae(nvx,mxac), wwae(nvx,4,mxac)
      
      real    :: wc1(nv), wc2(nv), wc3(nv), wc4(nv), wc(nv), tt(nv)
     
      real    :: tc(nv), tis, tws, trns, tgrs, taes(0:4), fw
      integer :: i, iac, j
      
      do i = 1, nv
        tc(i) = ti(i) + tw(i) + tr(i) + tgm(i) + tg(i) + &
       &        trn(i) + tgr(i)
! add for aerosol
!           if(naero.eq.1.and.ib.le.mbs) then
        if(naero.ge.1) then
          do iac=1,mxac
            if (itps(iac).eq.1) tc(i)=tc(i)+tae(i,iac)
          end do
        end if
! change over
        tis = ti(i) * wi(i)
        tws = tw(i) * ww(i)
        trns = trn(i) * wrn(i)
        tgrs = tgr(i) * wgr(i)
! add for aerosol
!           if(naero.eq.1.and.ib.le.mbs) then
        if(naero.ge.1) then
          taes(0:4)=0.0
          do iac=1,mxac
            if (itps(iac).eq.1) then
              taes(0)=taes(0)+tae(i,iac)*wae(i,iac)
              do j=1,4
                taes(j)=taes(j)+tae(i,iac)*wae(i,iac)*wwae(i,j,iac)
              end do
            end if
          end do
          fw = tis + tws + tr(i) + trns + tgrs+taes(0)
        else
          fw=tis+tws+tr(i)+trns+tgrs
        endif

        if(tc(i).eq.0.0) tc(i)=1.0e-25
          wc(i) =  fw / tc(i)
        if ( fw .lt. 1.0e-20 ) then
          wc1(i) = 0.0
          wc2(i) = 0.0
          wc3(i) = 0.0
          wc4(i) = 0.0
        else
!             if(naero.eq.1.and.ib.le.mbs) then
          if(naero.ge.1) then
            wc1(i) = ( tis * wwi(i,1) + tws * www(i,1) + &
     &       tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) &
     &       + taes(1) )/fw
            wc2(i) = ( tis * wwi(i,2) + tws * www(i,2) + &
     &       tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) &
     &       + taes(2) )/fw
            wc3(i) = ( tis * wwi(i,3) + tws * www(i,3) + &
     &       tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) &
     &       + taes(3) )/fw
            wc4(i) = ( tis * wwi(i,4) + tws * www(i,4) + &
     &       tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) &
     &       + taes(4) )/fw
          else
            wc1(i) = ( tis * wwi(i,1) + tws * www(i,1) + &
     &       tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1))/fw
            wc2(i) = ( tis * wwi(i,2) + tws * www(i,2) + &
     &       tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2))/fw
            wc3(i) = ( tis * wwi(i,3) + tws * www(i,3) + &
     &       tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3))/fw
            wc4(i) = ( tis * wwi(i,4) + tws * www(i,4) + &
     &       tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4))/fw
          endif
        endif
10    end do
      tt(1) = tc(1)
      do i = 2, nv
        tt(i) = tt(i-1) + tc(i)
20    end do
!        print *, 'tg=', tg
      return
      end subroutine


! -- with both aerosol and partly cloudy
      subroutine comscp_aero_cld ( cldamnt,area_group,cld_group,      &
     &                             n_group,nb,                        &
     &                             ti,wi,wwi,tw,ww,www,               &
     &                             trn,wrn,wwrn,tgr,wgr,wwgr,         &
     &                             tr,wr,wwr,tgm,tg,tae,wae,wwae,     &
     &                             wc1,wc2,wc3,wc4,wc,tt,tc_2,        &
     &                             wc1_2,wc2_2,wc3_2,wc4_2,wc_2,tt_2  &
     &                           )
! *********************************************************************
! This subroutine is used to  COMbine Single-Scattering Properties  due
! to  ice crystals,  water droplets, and  Rayleigh molecules along with
! H2O continuum absorption and nongray gaseous absorption.  See Section
! 3.4 of Fu (1991). wc, wc1, wc2, wc3, and wc4, are total (or combined)
! single - scattering  albedo,  and   expansion   coefficients  of  the
! phase function ( 1, 2, 3, and 4 ) in nv layers. tt(nv) are the normal
! optical depth ( from the top of the atmosphere to a given level ) for
! level 2 - level nv1( surface ). The single-scattering  properties  of
! rain and graupel are also incorporated in ( Jan. 19, 1993 ).
! *********************************************************************
!  The single-scattering properties of aerosols are incorporated in
!  (10/29/96) based on earlier version (5/17/95).
! *********************************************************************
      use  fu_liou_gu_table, only: nv,nv1,nvx,mxac,            &
                                   naero,nfract,nice,ngas,     &
                                   ifg,ivd,iaform,n_atau,itps, &
                                   ngroup,nclouds,nsubcld
      implicit none
      real, dimension(nv) :: cldamnt
      real    :: ti(nv), wi(nv), wwi(nv,4)
      real    :: tw(nv), ww(nv), www(nv,4)
      real    :: trn(nv), wrn(nv), wwrn(nv,4)
      real    :: tgr(nv), wgr(nv), wwgr(nv,4)
      real    :: tr(nv), wr(nv), wwr(nv,4)
      real    :: tgm(nv)
      real    :: tg(nv)
      real    :: tae(nvx,mxac), wae(nvx,mxac), wwae(nvx,4,mxac)
      
      real, dimension(nv) :: wc1, wc2, wc3, wc4, wc, tt
      real    :: tc(nv), tc_2(nv,2),tis, tws, trns, tgrs, &
     &           taes(0:4), fw, fw1, fw2, &
     &           fcloud, adj_pari, adj_parw
      integer :: i, iac, k, kl, n_cld, j
!--------------------------------------------------
! -- add by Yu for fractional cloud
      real, dimension(nv,2) :: wc1_2, wc2_2, wc3_2, wc4_2,  &
     &                         wc_2, tt_2
      real                  :: area_group(3,2), cld_group(3)
      integer               :: nb(3), n_group(3)
! - change over

! -- change by Yu, 02/13/02
! -- determine n_group(k), cld_group(k), and area_group(k,1), area_group(k,2) 

! -- Three cloud groups(ngroup=3): hight,middle, and low 
! -- cld_group(k) represents the cloud amount within a group; 
!       use the largest cloud amount within the group
! -- n_group = 1 if clear in a column; =2 if cloudy
! -- area_group(k,1) and area_group(k,2) are the areas 
!       for the clear and cloud portion in a group, respectively 
! -- nb(k)=1 if clear or partly cloudy in a column; = 2 if overcast 
! -- nb(k) and n_group(k) determine the cloud configuration in a column 
! -- There are 8 possible configurations (if nb=1 and n_group=2 for all groups)

      do k=1,ngroup
!        kl = (k-1)*ngroup + nv1 - nclouds 
!        kl = (k-1)*nsubcld + nv1 - nclouds 
        kl = (k-1)*nsubcld + nv1 - nsubcld*ngroup 
        cld_group(k) = cldamnt(kl)
        do i=kl+1,kl+nsubcld-1
          if (cldamnt(i).gt.cld_group(k)) then
            cld_group(k) = cldamnt(i)
          endif
        enddo
! - partly cloudy
        if (cld_group(k).gt.0.0.and.cld_group(k).lt.1.) then
          n_group(k) = 2
          nb(k) = 1
          area_group(k,1) = 1. - cld_group(k)
          area_group(k,2) = cld_group(k)
! - clear
        elseif(cld_group(k).eq.0.0) then
          n_group(k) = 1
          nb(k) = 1
          area_group(k,1) = 1.
          area_group(k,2) = 0. 
! - overcast 
        elseif(cld_group(k).eq.1.) then
          n_group(k) = 2 
          nb(k) = 2 
          area_group(k,1) = 0.
          area_group(k,2) = 1. 
        endif

      enddo
! -- change over

      do i = 1, nv
! - add by Yu for clear
        tc_2(i,1) = tr(i) + tgm(i) + tg(i) + &
     &             trn(i) + tgr(i)

! - add by Yu Gu for aerosol for clear condition (01/2003)
!
      if (naero.ge.1) then
        do iac = 1,mxac
          if (itps(iac).eq.1) tc_2(i,1) = tc_2(i,1) + tae(i,iac)
        enddo
      end if
! --------- 10/29/96 (5)
! --- change over

! - change by Yu for overcast
! -- adjust tau a!ording to cloud amount
        adj_pari = 0.
      if (cldamnt(i).gt. 0.) then
!           n_cld = (i-4)/3 
        n_cld = (i-(nv1-nsubcld*ngroup))/nsubcld+1 
        if (n_cld.gt.0) then
! -- determine adjust parameter 
          fcloud = cldamnt(i) / cld_group(n_cld)
          if (fcloud.le.0.1) then
            if (ti(i).le.15.) then
              adj_pari = fcloud - fcloud * 0.5 * ti(i) / 15.
            else
              adj_pari = 0.5 * fcloud
            endif
            if (tw(i).le.15.) then
              adj_parw = fcloud - fcloud * 0.5 * tw(i) / 15.
            else
              adj_parw = 0.5 * fcloud
            endif
          endif

          if (fcloud.le.0.3.and.fcloud.gt.0.1) then
            if (ti(i).le.15.) then
              adj_pari = fcloud - fcloud * 0.33 * ti(i) / 15.
            else
              adj_pari = 0.67 * fcloud
            endif
            if (tw(i).le.15.) then
              adj_parw = fcloud - fcloud * 0.33 * tw(i) / 15.
            else
              adj_parw = 0.67 * fcloud
            endif
          endif

          if (fcloud.le.0.5.and.fcloud.gt.0.3) then
            if (ti(i).le.15.) then
              adj_pari = fcloud - fcloud * 0.4 * ti(i) / 15.
            else
              adj_pari = 0.6 * fcloud
           endif
            if (tw(i).le.15.) then
              adj_parw = fcloud - fcloud * 0.4 * tw(i) / 15.
            else
              adj_parw = 0.6 * fcloud
            endif
          endif
  
          if (fcloud.le.0.7.and.fcloud.gt.0.5) then
            if (ti(i).le.15.) then
              adj_pari = fcloud - fcloud * 0.286 * ti(i) / 15.
            else
              adj_pari = 0.714 * fcloud
            endif
            if (tw(i).le.15.) then
              adj_parw = fcloud - fcloud * 0.286 * tw(i) / 15.
            else
              adj_parw = 0.714 * fcloud
            endif
          endif

          if (fcloud.le.0.9.and.fcloud.gt.0.7) then
            if (ti(i).le.15.) then
              adj_pari = fcloud - fcloud * 0.11 * ti(i) / 15.
            else
              adj_pari = 0.89 * fcloud
            endif
            if (tw(i).le.15.) then
              adj_parw = fcloud - fcloud * 0.11 * tw(i) / 15.
            else
              adj_parw = 0.89 * fcloud
            endif
          endif

          if (fcloud.le.1..and.fcloud.gt.0.9) then
            adj_pari = fcloud
            adj_parw = fcloud
          endif

!                print *, 'i=',i,'adj_pari=',adj_pari
          if (ti(i).gt.0.)  &
     &            ti(i) = ti(i) * adj_pari  &
     &                  * 1.0 
! -- include inhomogeneity effect
!     &                  * 0.6
!     &            ti(i) = ti(i) * cldamnt(i) 
!     &                       / cld_group(n_cld)
!                print *, 'i=',i,'adj_parw=',adj_parw
            if (tw(i).gt.0.)  &
     &            tw(i) = tw(i) * adj_parw  &
     &                  * 1.0 
! --- include inhomogeneity effect
!     &                  * 0.6
!     &            tw(i) = tw(i) * cldamnt(i) 
!     &                       / cld_group(n_cld)
            endif
          endif
! - adjust over
          tc_2(i,2) = ti(i) + tw(i) + tr(i) + tgm(i) + tg(i) + &
     &             trn(i) + tgr(i)

! - add by Yu Gu for aerosol (01/2003)
!
          if (naero.ge.1) then
            do iac = 1,mxac
              if (itps(iac).eq.1) tc_2(i,2) = tc_2(i,2) + tae(i,iac)
            enddo
          endif
! --------- 10/29/96 (5)
! --- change over

          tis = ti(i) * wi(i)
          tws = tw(i) * ww(i) 
          trns = trn(i) * wrn(i)
          tgrs = tgr(i) * wgr(i)
!           fw1 = tr(i) + trns + tgrs
!           fw2 = tis + tws + tr(i) + trns + tgrs

! -- add by Yu Gu (01/2003) for aerosol

! --------- 10/29/96 (6)
          if (naero.ge.1) then
            taes(0:4) = 0.0
            do iac = 1,mxac
              if (itps(iac).eq.1) then
                taes(0)=taes(0)+tae(i,iac)*wae(i,iac)
                do j=1,4
                  taes(j)=taes(j)+tae(i,iac)*wae(i,iac)*wwae(i,j,iac)
                enddo
              end if
            enddo

            fw1 = tr(i) + trns + tgrs + taes(0)
            fw2 = tis + tws + tr(i) + trns + tgrs + taes(0)
          else
! -- no aerosol
            fw1 = tr(i) + trns + tgrs
            fw2 = tis + tws + tr(i) + trns + tgrs
          endif

! --------- 10/29/96 (6)
          if ( tc_2(i,1) .eq. 0.0 ) tc_2(i,1) = 1.0e-20
          if ( tc_2(i,2) .eq. 0.0 ) tc_2(i,2) = 1.0e-20
          wc_2(i,1) =  fw1 / tc_2(i,1)
          wc_2(i,2) =  fw2 / tc_2(i,2)
! - change by Yu for overcast (add one dimension in the array)
          if ( fw2 .lt. 1.0e-20 ) then
            wc1_2(i,2) = 0.0
            wc2_2(i,2) = 0.0
            wc3_2(i,2) = 0.0
            wc4_2(i,2) = 0.0
          else
            if (naero.eq.0) then
              wc1_2(i,2) = ( tis * wwi(i,1) + tws * www(i,1) + &
     &      tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) )/fw2
              wc2_2(i,2) = ( tis * wwi(i,2) + tws * www(i,2) + &
     &      tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) )/fw2
              wc3_2(i,2) = ( tis * wwi(i,3) + tws * www(i,3) + &
     &      tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) )/fw2
              wc4_2(i,2) = ( tis * wwi(i,4) + tws * www(i,4) + &
     &      tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) )/fw2

          else
! - add by yu (01/2003) for aerosol
            wc1_2(i,2) = ( tis * wwi(i,1) + tws * www(i,1) + &
     &           tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1)  &
     &       + taes(1) )/fw2
            wc2_2(i,2) = ( tis * wwi(i,2) + tws * www(i,2) + &
     &           tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2)  &
     &       + taes(2) )/fw2
            wc3_2(i,2) = ( tis * wwi(i,3) + tws * www(i,3) + &
     &           tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3)  &
     &       + taes(3) )/fw2
            wc4_2(i,2) = ( tis * wwi(i,4) + tws * www(i,4) + &
     &           tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4)  &
     &       + taes(4) )/fw2
          endif
! - over for aerosol
        endif

! - add by Yu for clear (add one dimension in the array)
        if ( fw1 .lt. 1.0e-20 ) then
          wc1_2(i,1) = 0.0
          wc2_2(i,1) = 0.0
          wc3_2(i,1) = 0.0
          wc4_2(i,1) = 0.0
        else
          if (naero.eq.0) then
            wc1_2(i,1) = (   &
     &      tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1) )/fw1
            wc2_2(i,1) = (  &
     &      tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2) )/fw1
            wc3_2(i,1) = (  &
     &      tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) )/fw1
            wc4_2(i,1) = (  &
     &      tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4) )/fw1
! - add by yu (01/2003) for aerosol
          else
            wc1_2(i,1) = (   &
     &           tr(i) * wwr(i,1) + trns * wwrn(i,1) + tgrs * wwgr(i,1)  &
     &       + taes(1) )/fw1
            wc2_2(i,1) = (  &
     &           tr(i) * wwr(i,2) + trns * wwrn(i,2) + tgrs * wwgr(i,2)  &
     &       + taes(2) )/fw1
            wc3_2(i,1) = (  &
     &           tr(i) * wwr(i,3) + trns * wwrn(i,3) + tgrs * wwgr(i,3) &
     &       + taes(3) )/fw1
            wc4_2(i,1) = (  &
     &           tr(i) * wwr(i,4) + trns * wwrn(i,4) + tgrs * wwgr(i,4)  &
     &       + taes(4) )/fw1
          endif
        endif
10    end do
!      tt_2(1,1) = tc_2(1,1)
!      tt_2(1,2) = tc_2(1,2)
!      do 20 i = 2, nv
!         tt_2(i,1) = tt_2(i-1,1) + tc_2(i,1)
!         tt_2(i,2) = tt_2(i-1,2) + tc_2(i,2)
!20      continue
      return
      end subroutine



!      function planck1 ( t, w )
! **********************************************************************
! t is the temperature (K), w is the wavenumber (cm-1), and planck1 is
! the blackbody intensity function (W/m**2/Sr/cm-1).  See Eq. (2.8) of
! Fu (1991).
! **********************************************************************
!      a = 1.19107e-8
!      b = 1.43884
!      planck1 = a * w * w * w / ( exp ( b * w / t ) - 1.0 )
!      return
!      end

!      function bt ( t, ve, nd )
! **********************************************************************
! bt (W/m**2/Sr) is the blackbody intensity function integrated over a
! given band, which has a band width of nd*10 (cm-1) from the ve (cm-1).
! **********************************************************************
!      v1 = ve
!      bt = 0.0
!      do 10 j = 1, nd
!         v2 = v1 - 10.0
!         w = ( v1 + v2 ) * 0.5
!         x = planck1 ( t, w )
!         bt = bt + x
!         v1 = v2
!10      continue
!      bt = bt * 10.0
!      return
!      end

      subroutine planck ( ib,pts,pp,pt,ph,po,bf,bs )
! **********************************************************************
! bf and bs are the blackbody intensity function integrated over the
! band ib at the nv1 levels and at the surface, respectively.    The
! units of bf and bs are W/m**2/Sr. nd*10 is the band width from ve.
! **********************************************************************
      use  fu_liou_gu_table, only: mbir,mbs,nv1
      implicit none
      
      
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: bf(nv1), bs, pts
      real    :: ve(mbir), bt(nv1)
      integer :: nd(mbir)
      integer :: ib, i, j, nv11, ibr
      real    :: v1, v2, w, fq1, fq2, bts, x
      
      data ve / 2200.0, 1900.0, 1700.0, 1400.0, 1250.0, 1100.0, &
     &            980.0, 800.0, 670.0, 540.0, 400.0, 280.001 /
      data nd / 30, 20, 30, 15, 15, 12, &
     &            18, 13, 13, 14, 12, 28 /
      nv11 = nv1 + 1
      ibr = ib - mbs
      bts = 0.0
      do i = 1, nv1
        bt(i) = 0.0
      end do
      v1 = ve(ibr)
      do j = 1, nd(ibr)
        v2 = v1 - 10.0
        w = ( v1 + v2 ) * 0.5
        fq1 = 1.19107e-8 * w * w * w
        fq2 = 1.43884 * w
        do i = 1, nv11
          if ( i .eq. nv11 ) then
            x = fq1 / ( exp ( fq2 / pts ) - 1.0 )
            bts = bts + x
          else
            x = fq1 / ( exp ( fq2 / pt(i) ) - 1.0 )
            bt(i) = bt(i) + x
          endif
        end do
      v1 = v2
      end do
      do i = 1, nv1
        bf(i) = bt(i) * 10.0
      end do
      bs = bts * 10.0
      return
      end subroutine


! **********************************************************************
! coefficient calculations for four first-order differential equations.
! **********************************************************************
      subroutine coeff1 ( ib,w,w1,w2,w3,t0,t1,u0,f0,b )
      use fu_liou_gu_table, only: mbs,u,          &
     &                            p11d,p22d,p33d, &
     &                            p0d,p1d,p2d,p3d
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: w, w1, w2, w3, t0, t1, u0, f0
      real, intent(out)   :: b(4,3)
      integer :: i, j
      real    :: x, w0w, w1w, w2w, w3w, fw, q1, q2, q3, fq, c(4,5)
      
      x = 0.5 * w
      w0w = x
      w1w = x * w1
      w2w = x * w2
      w3w = x * w3
      if ( ib .le. mbs ) then
        fw = u0 * u0
        q1 = - w1w * u0
        q2 = w2w * ( 1.5 * fw - 0.5 )
        q3 = - w3w * ( 2.5 * fw - 1.5 ) * u0
      endif
      fq = 0.5 * w0w
      do i = 3, 4
        do j = 1, 4
          c(i,j) = fq + w1w * p11d(i,j) + &
     &            w2w * p22d(i,j) + w3w * p33d(i,j) 
          if ( i .eq. j ) then 
            c(i,j) = ( c(i,j) - 1.0 ) / u(i)
          else
            c(i,j) = c(i,j) / u(i)
          endif
20      end do
10    end do
      do i = 1, 4
        if ( ib .le. mbs ) then
          c(i,5) = w0w + q1 * p1d(i) + &
     &           q2 * p2d(i) + q3 * p3d(i) 
        else
          c(i,5) = 1.0
        endif
        c(i,5) = c(i,5) / u(i)
30    end do
      b(1,1) = c(4,4) - c(4,1)
      b(1,2) = c(4,4) + c(4,1)
      b(2,1) = c(4,3) - c(4,2)
      b(2,2) = c(4,3) + c(4,2)
      b(3,1) = c(3,4) - c(3,1)
      b(3,2) = c(3,4) + c(3,1)
      b(4,1) = c(3,3) - c(3,2)
      b(4,2) = c(3,3) + c(3,2)
      b(1,3) = c(4,5) - c(1,5)
      b(2,3) = c(3,5) - c(2,5)
      b(3,3) = c(3,5) + c(2,5)
      b(4,3) = c(4,5) + c(1,5)
      return
      end subroutine

! **********************************************************************
! coefficient calculations for second order differential equations.
! **********************************************************************
      subroutine coeff2 ( u0,b,a,d )
      implicit none
      
      real, intent(in)  :: u0
      real, intent(in)  :: b(4,3)
      real, intent(out) :: a(2,2,2), d(4)
      real              :: fw1, fw2, fw3, fw4
      
      fw1 = b(1,1) * b(1,2)
      fw2 = b(2,1) * b(3,2)
      fw3 = b(3,1) * b(2,2)
      fw4 = b(4,1) * b(4,2)
      a(2,2,1) = fw1 + fw2
      a(2,1,1) = b(1,1) * b(2,2) + b(2,1) * b(4,2)
      a(1,2,1) = b(3,1) * b(1,2) + b(4,1) * b(3,2)
      a(1,1,1) = fw3 + fw4
      a(2,2,2) = fw1 + fw3
      a(2,1,2) = b(1,2) * b(2,1) + b(2,2) * b(4,1)
      a(1,2,2) = b(3,2) * b(1,1) + b(4,2) * b(3,1)
      a(1,1,2) = fw2 + fw4
      d(1) = b(3,2) * b(4,3) + b(4,2) * b(3,3) + b(2,3) / u0
      d(2) = b(1,2) * b(4,3) + b(2,2) * b(3,3) + b(1,3) / u0
      d(3) = b(3,1) * b(1,3) + b(4,1) * b(2,3) + b(3,3) / u0
      d(4) = b(1,1) * b(1,3) + b(2,1) * b(2,3) + b(4,3) / u0
      return
      end subroutine

! **********************************************************************
! coefficient calculations for fourth-order differential equations.
! **********************************************************************
      subroutine coeff4 ( u0,a,d,z,b1,c1 )
      implicit none

      real, intent(in)   :: u0
      real, intent(in)   :: a(2,2,2), d(4)
      real, intent(out)  :: z(4), b1, c1
      real :: x
      
      x = u0 * u0
      b1 = a(2,2,1) + a(1,1,1)
      c1 = a(2,1,1) * a(1,2,1) - a(1,1,1) * a(2,2,1)
      z(1) = a(2,1,1) * d(3) + d(4) / x - a(1,1,1) * d(4)
      z(2) = a(1,2,1) * d(4) - a(2,2,1) *d(3) + d(3) / x
      z(3) = a(2,1,2) * d(1) + d(2) / x - a(1,1,2) * d(2)
      z(4) = a(1,2,2) * d(2) - a(2,2,2) * d(1) + d(1) / x
      return
      end subroutine

! **********************************************************************
! fk1 and fk2 are the eigenvalues.
! **********************************************************************
      subroutine coeffl ( ib,t0,t1,u0,f0,b,a,d,z,b1,c1, &
     &                    aa,zz,a1,z1,fk1,fk2 )
      use fu_liou_gu_table, only: mbs
      implicit none
      
      integer, intent(in)  :: ib
      real, intent(in)     :: t0, t1, u0, f0
      real, intent(in)     :: b(4,3)
      real, intent(in)     :: a(2,2,2), d(4)
      real, intent(inout)  :: z(4), b1, c1
      real, intent(out)    :: aa(4,4,2), zz(4,2), a1(4,4), z1(4),  &
     &                       fk1, fk2
      integer :: i
      real    :: dt, x, y, fw, fw1, fw2, a2, b2, zx, fq0, fq1
            
      dt = t1 - t0
      x = sqrt ( b1 * b1 + 4.0 * c1 )
      fk1 = sqrt ( ( b1 + x ) * 0.5 )
      fk2 = sqrt ( ( b1 - x ) * 0.5 )
      fw = u0 * u0
      x = 1.0 / ( fw * fw ) - b1 / fw - c1

! --------- 4/2/97 (4)
      if (abs (x) .lt. 1.0E-16) THEN
        if ( x .lt. 0.0) THEN
          x = -1.0E-6
        else
          x = 1.0E-6
        end if
      end if
! --------- 4/2/97 (4)

      fw = 0.5 * f0 / x
      z(1) = fw * z(1) 
      z(2) = fw * z(2) 
      z(3) = fw * z(3) 
      z(4) = fw * z(4) 
      z1(1) = 0.5 * ( z(1) + z(3) )
      z1(2) = 0.5 * ( z(2) + z(4) )
      z1(3) = 0.5 * ( z(2) - z(4) )
      z1(4) = 0.5 * ( z(1) - z(3) )
      a2 = ( fk1 * fk1 - a(2,2,1) ) / a(2,1,1)
      b2 = ( fk2 * fk2 - a(2,2,1) ) / a(2,1,1)
      x = b(1,1) * b(4,1) - b(3,1) * b(2,1)
      fw1 = fk1 / x
      fw2 = fk2 / x
      y = fw2 * ( b2 * b(2,1) - b(4,1) ) 
      zx = fw1 * ( a2 * b(2,1) - b(4,1) )
      a1(1,1) = 0.5 * ( 1 - y )
      a1(1,2) = 0.5 * ( 1 - zx )
      a1(1,3) = 0.5 * ( 1 + zx )
      a1(1,4) = 0.5 * ( 1 + y )
      y = fw2 * ( b(3,1) - b2 * b(1,1) ) 
      zx = fw1 * ( b(3,1) - a2 * b(1,1) ) 
      a1(2,1) = 0.5 * ( b2 - y )
      a1(2,2) = 0.5 * ( a2 - zx )
      a1(2,3) = 0.5 * ( a2 + zx )
      a1(2,4) = 0.5 * ( b2 + y )
      a1(3,1) = a1(2,4)
      a1(3,2) = a1(2,3)
      a1(3,3) = a1(2,2)
      a1(3,4) = a1(2,1)
      a1(4,1) = a1(1,4)
      a1(4,2) = a1(1,3)
      a1(4,3) = a1(1,2)
      a1(4,4) = a1(1,1)
      if ( ib .le. mbs ) then
        fq0 = exp ( - t0 / u0 )
        fq1 = exp ( - t1 / u0 )
      else
        fq0 = 1.0
        fq1 = exp ( - dt / u0 )
      endif
      x = exp ( - fk1 * dt )
      y = exp ( - fk2 * dt )
      do i = 1, 4
        zz(i,1) = z1(i) * fq0
        zz(i,2) = z1(i) * fq1
        aa(i,1,1) = a1(i,1)
        aa(i,2,1) = a1(i,2)
        aa(i,3,1) = a1(i,3) * x
        aa(i,4,1) = a1(i,4) * y
        aa(i,3,2) = a1(i,3)
        aa(i,4,2) = a1(i,4)
        aa(i,1,2) = a1(i,1) * y
        aa(i,2,2) = a1(i,2) * x
40    end do
      return
      end subroutine

! **********************************************************************
! See the paper by Liou, Fu and Ackerman (1988) for the formulation of
! the delta-four-stream approximation in a homogeneous layer.
! **********************************************************************
      subroutine coefft ( ib,w,w1,w2,w3,t0,t1,u0,f0, &
     &                    b,a,d,z,b1,c1,aa,zz,a1,z1,fk1,fk2 )
      implicit none
      
      integer, intent(in)  :: ib
      real, intent(in)     :: w, w1, w2, w3, t0, t1, u0, f0
      real                 :: u(4), b(4,3), &
     &                        a(2,2,2), d(4), &
     &                        z(4), b1, c1, &
     &                        aa(4,4,2), zz(4,2), a1(4,4), z1(4),  &
     &                        fk1, fk2
     
      call coeff1 ( ib,w,w1,w2,w3,t0,t1,u0,f0,b )
      call coeff2 ( u0,b,a,d )
      call coeff4 ( u0,a,d,z,b1,c1 )
      call coeffl ( ib,t0,t1,u0,f0,b,a,d,z,b1,c1, &
     &              aa,zz,a1,z1,fk1,fk2 )
      return
      end subroutine

! **********************************************************************
! In the limits of no scattering ( Fu, 1991 ), fk1 = 1.0 / u(3) and
! fk2 = 1.0 / u(4).
! **********************************************************************
      subroutine coefft0 ( ib,w,w1,w2,w3,t0,t1,u0,f0, &
     &                     aa,zz,a1,z1,fk1,fk2 )
      
      use  fu_liou_gu_table, only: mbs,u
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: w, w1, w2, w3, t0, t1, u0, f0
      real, intent(out)   :: aa(4,4,2), zz(4,2), a1(4,4), z1(4),  &
     &                       fk1, fk2
      integer             :: i, jj, j, k
      real                :: x, y, fw, temp, dt
      
      fk1 = 4.7320545
      fk2 = 1.2679491
      y = exp ( - ( t1 - t0 ) / u0 )
      fw = 0.5 * f0
      do i = 1, 4
        if ( ib .le. mbs ) then
          z1(i) = 0.0
          zz(i,1) = 0.0
          zz(i,2) = 0.0
        else
          jj = 5 - i
! - change by Yu Gu, 11/19/01
          temp = u(jj)/u0
!             if (temp.eq.-1.) temp = -1.001
          if (temp.eq.-1.) temp = -0.9999
            z1(i) = fw / ( 1.0 + temp )
!            z1(i) = fw / ( 1.0 + u(jj) / u0 )
! -- change over

            zz(i,1) = z1(i) 
            zz(i,2) = z1(i) * y
          endif
        do j = 1, 4
          a1(i,j) = 0.0
          do k = 1, 2
            aa(i,j,k) = 0.0
12        end do
11      end do
10    end do
      do i = 1, 4
        j = 5 - i
        a1(i,j) = 1.0
20    end do
      dt = t1 - t0
      x = exp ( - fk1 * dt )
      y = exp ( - fk2 * dt )
      aa(1,4,1) = y
      aa(2,3,1) = x
      aa(3,2,1) = 1.0
      aa(4,1,1) = 1.0
      aa(1,4,2) = 1.0
      aa(2,3,2) = 1.0
      aa(3,2,2) = x
      aa(4,1,2) = y
      return
      end subroutine

! **********************************************************************
! In the solar band  asbs is the surface albedo, while in the infrared
! band asbs is  blackbody intensity emitted at the surface temperature
! times surface emissivity.  In this subroutine, the delta-four-stream
! is applied to nonhomogeneous atmospheres. See comments in subroutine
! 'qcfel' for array AB(13,4*n).
! **********************************************************************
      subroutine qcfe ( ib,asbs,ee,w1,w2,w3,w,t,u0,f0,  &
     &                  fk1,fk2,a4,z4,g4 )  
      use  fu_liou_gu_table, only: ndfs, ndfs4, mbs
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: asbs, ee
      real, intent(in), dimension(ndfs) :: w1, w2, w3, w, t, u0, f0
      real, intent(out)   :: fk1(ndfs), fk2(ndfs), a4(4,4,ndfs),  &
     &                       z4(4,ndfs), g4(4,ndfs)
      real    :: b(4,3), a(2,2,2), d(4), z(4), b1, c1,  &
     &           aa(4,4,2), zz(4,2), a1(4,4), z1(4), fk1t, fk2t
      real    :: ab(13,ndfs4), bx(ndfs4), xx(ndfs4)      
      integer :: n, n4, i, j, k, ibn, i8, kf, i1, i2, i3, j1, j2, j3, &
     &           m1, m2, m18, m28
      real    :: wn, w1n, w2n, w3n, t0n, t1n, u0n, f0n
      real    :: fu(4,4), wu(4)
      real    :: v1, v2, v3, fw1, fw2
      
      n = ndfs
      n4 = ndfs4
      do i = 1, n4
        do j = 1, 13
          ab(j,i) = 0.0
        end do
      end do
      ibn = ib
      wn = w(1)
      w1n = w1(1)
      w2n = w2(1)
      w3n = w3(1)
      t0n = 0.0
      t1n = t(1)
      u0n = u0(1)
      f0n = f0(1)
      if ( wn .ge. 0.999999 ) then
        wn = 0.999999
      endif
      if ( wn .le. 1.0e-4 ) then
        call coefft0 ( ibn,wn,w1n,w2n,w3n,t0n,t1n,u0n,f0n, &
     &                 aa,zz,a1,z1,fk1t,fk2t )
        fk1(1) = fk1t
        fk2(1) = fk2t
      else
        call coefft ( ibn,wn,w1n,w2n,w3n,t0n,t1n,u0n,f0n, &
     &                b,a,d,z,b1,c1,aa,zz,a1,z1,fk1t,fk2t )
        fk1(1) = fk1t
        fk2(1) = fk2t
      endif
      do i = 1, 4
        z4(i,1) = z1(i)
        do j = 1, 4
          a4(i,j,1) = a1(i,j)
        end do
      end do
      do i = 1, 2
        bx(i) = - zz(i+2,1)
        i8 = i + 8
        do j = 1, 4
          ab(i8-j,j) = aa(i+2,j,1)
        end do
      end do
      do i = 1, 4
        wu(i) = zz(i,2)
        do j = 1, 4
          fu(i,j) = aa(i,j,2)
        end do
      end do
      do k = 2, n
        wn = w(k)
        w1n = w1(k)
        w2n = w2(k)
        w3n = w3(k)
        t0n = t(k-1)
        t1n = t(k)
        u0n = u0(k)
        f0n = f0(k)
        if ( wn .ge. 0.999999 ) then
          wn = 0.999999
        endif
        if ( wn .le. 1.0e-4 ) then
          call coefft0 ( ibn,wn,w1n,w2n,w3n,t0n,t1n,u0n,f0n, &
     &                   aa,zz,a1,z1,fk1t,fk2t )
          fk1(k) = fk1t
          fk2(k) = fk2t
        else
          call coefft ( ibn,wn,w1n,w2n,w3n,t0n,t1n,u0n,f0n, &
     &                  b,a,d,z,b1,c1,aa,zz,a1,z1,fk1t,fk2t )
          fk1(k) = fk1t
          fk2(k) = fk2t
        endif
        do i = 1, 4
          z4(i,k) = z1(i)
          do j = 1, 4
            a4(i,j,k) = a1(i,j)
          end do
        end do
        kf = k + k + k + k
        i1 = kf - 5
        i2 = i1 + 3
        j1 = kf - 7
        j2 = j1 + 3
        i3 = 0
        do i = i1, i2
          i3 = i3 + 1
          bx(i) = - wu(i3) + zz(i3,1)
          j3 = 0
          i8 = i + 8
          do j = j1, j2
            j3 = j3 + 1
            ab(i8-j,j) = fu(i3,j3)
          end do
          j3 = 0
          do j = j2 + 1, j2 + 4
            j3 = j3 + 1
            ab(i8-j,j) = - aa(i3,j3,1)
          end do
        end do
        do i = 1, 4
          wu(i) = zz(i,2)
          do j = 1, 4
            fu(i,j) = aa(i,j,2)
          end do
        end do
      end do
      if ( ib .le. mbs ) then
        v1 = 0.2113247 * asbs
        v2 = 0.7886753 * asbs
        v3 = asbs * u0(1) * f0(1) * exp ( - t(n) / u0(1) )
        m1 = n4 - 1
        m2 = n4
        m18 = m1 + 8
        m28 = m2 + 8
        fw1 = v1 * wu(3)
        fw2 = v2 * wu(4)
        bx(m1) = - ( wu(1) - fw1 - fw2 - v3 )
        bx(m2) = - ( wu(2) - fw1 - fw2 - v3 )
        do j = 1, 4
          j1 = n4 - 4 + j
          fw1 = v1 * fu(3,j)
          fw2 = v2 * fu(4,j)
          ab(m18-j1,j1) = fu(1,j) - fw1 - fw2
          ab(m28-j1,j1) = fu(2,j) - fw1 - fw2
        end do
      else
        v1 = 0.2113247 * ( 1.0 - ee )
        v2 = 0.7886753 * ( 1.0 - ee )
        v3 = asbs
        m1 = n4 - 1
        m2 = n4
        m18 = m1 + 8
        m28 = m2 + 8
        fw1 = v1 * wu(3)
        fw2 = v2 * wu(4)
        bx(m1) = - ( wu(1) - fw1 - fw2 - v3 )
        bx(m2) = - ( wu(2) - fw1 - fw2 - v3 )
        do j = 1, 4
          j1 = n4 - 4 + j
          fw1 = v1 * fu(3,j)
          fw2 = v2 * fu(4,j)
          ab(m18-j1,j1) = fu(1,j) - fw1 - fw2
          ab(m28-j1,j1) = fu(2,j) - fw1 - fw2
        end do
      endif
      call qcfel (ab,bx,xx)
      do k = 1, n
        j = k + k + k + k - 4
        do i = 1, 4
          j = j + 1
          g4(i,k) = xx(j)
        end do
      end do
      return
      end subroutine

! **********************************************************************
      subroutine qcfel (ab, b, x)
! **********************************************************************
! 1. `qcfel' is the abbreviation of ` qiu constants for each layer'.
! 2. The inhomogeneous atmosphere is divided into n adjacent homogeneous
!    layers where the  single scattering properties are constant in each
!    layer and allowed to vary from one to another. Delta-four-stream is
!    employed for each homogeneous layer. The boundary conditions at the
!    top and bottom of the atmosphere,  together with  continuity condi-
!    tions  at  layer interfaces lead to a system of algebraic equations
!    from which 4*n unknown constants in the problom can be solved.
! 3. This subroutine is used for solving the 4*n unknowns of A *X = B by
!    considering the fact that the coefficient matrix is a sparse matrix
!    with the precise pattern in this special problom.
! 4. The method is not different in principle from the general scheme of
!    Gaussian elimination with backsubstitution, but carefully optimized
!    so as to minimize arithmetic operations.  Partial  pivoting is used
!    to quarantee  method's numerical stability,  which will  not change
!    the basic pattern of sparsity of the matrix.
! 5. Scaling special problems so as to make  its nonzero matrix elements
!    have comparable magnitudes, which will ameliorate the stability.
! 6. a, b and x present A, B and X in A*X=B, respectively. and n4=4*n.
! 7. AB(13,4*n) is the matrix A in band storage, in rows 3 to 13; rows 1
!    and 2 and other unset elements should be set to zero on entry.
! 8. The jth column of A is stored in the jth column of the array AB  as
!    follows:
!            AB(8+i-j,j) = A(i,j) for max(1,j-5) <= i <= min(4*n,j+5).
!    Reversedly, we have
!            A(ii+jj-8,jj) = AB(ii,jj).
! **********************************************************************
      use fu_liou_gu_table, only: ndfs,ndfs4
      implicit none
      
      real    :: ab(13,ndfs4), b(ndfs4), x(ndfs4)
      integer :: i, j, k, l, m, n,  &
     &           i0, i0f, i0m1, im1, ifq, k44,  &
     &           m1f, m1, m2, m3, m4, m18, m28, m38, m48,  &
     &           n1, n2, n3, n4, n44
      real    :: p, t, xx, yy
      
      n = ndfs
      n4 = ndfs4
      do k = 1, n - 1
        k44 = 4 * k - 4
        do l= 1, 4
          m1 = k44 + l
          p = 0.0
          do i = 8, 14 - l
            if ( abs ( ab(i,m1) ) .gt. abs ( p ) ) then
              p = ab(i,m1)
              i0 = i
            endif
10        end do
          i0m1 = i0 + m1
          m18 = m1 + 8
          if ( i0 .ne. 8 ) then
            do j = m1, m1 + 8 - l
              i0f = i0m1 - j
              m1f = m18 - j
              t = ab(i0f,j)
              ab(i0f,j) = ab(m1f,j)
              ab(m1f,j) = t
15          end do
            i0f = i0m1 - 8
            t = b(i0f)
            b(i0f) = b(m1)
            b(m1) = t
20        end if
          yy = ab(8,m1)
          ab(8,m1) = 1.0
          do j = m1 + 1, m1 + 8 - l
            m1f = m18 - j
            ab(m1f,j) = ab(m1f,j) / yy
25        end do
          b(m1) = b(m1) / yy
          do i = 9, 14 - l
            xx = ab(i,m1)
            ab(i,m1) = 0.0
            im1 = i + m1
            do j = m1 + 1, m1 + 8 - l
              ifq = im1 - j
              m1f = m18 - j
              ab(ifq,j) = ab(ifq,j) - ab(m1f,j) * xx
35          end do
            ifq = im1 - 8
            b(ifq) = b(ifq) - b(m1) * xx
30        end do
3       end do
5     end do
      n44 = n4 - 4
      do l = 1, 3
        m1 = n44 + l
        p = 0.0
        do i = 8, 12 - l
          if ( abs ( ab(i,m1) ) .gt. abs ( p ) ) then
            p = ab(i,m1)
            i0 = i
          endif
45      end do
        i0m1 = i0 + m1
        m18 = m1 + 8
        if( i0 .ne. 8 ) then
          do j = m1, m1 + 4 - l
            i0f = i0m1 - j
            m1f = m18 - j
            t = ab(i0f,j)
            ab(i0f,j) = ab(m1f,j)
            ab(m1f,j) = t
50        end do
          i0f = i0m1 - 8
          t = b(i0f)
          b(i0f) = b(m1)
          b(m1) = t
55      end if
        yy = ab(8,m1)
        ab(8,m1) = 1.0
        do j = m1 + 1, m1 + 4 - l
          m1f = m18 - j
          ab(m1f,j) = ab(m1f,j) / yy
60      end do
        b(m1) = b(m1) / yy
        do i = 9, 12 - l
          xx = ab(i,m1)
          ab(i,m1) = 0.0
          im1 = i + m1
          do j = m1 + 1, m1 + 4 - l
            ifq = im1 - j
            m1f = m18 - j
            ab(ifq,j) = ab(ifq,j) - ab(m1f,j) * xx
70        end do
          ifq = im1 - 8
          b(ifq) = b(ifq) - b(m1) * xx
65      end do
40    end do
      yy = ab(8,n4)
      ab(8,n4) = 1.0
      b(n4) = b(n4) / yy
      n3 = n4 - 1
      n2 = n3 - 1
      n1 = n2 - 1
      x(n4) = b(n4)
      x(n3) = b(n3) - ab(7,n4) * x(n4)
      x(n2) = b(n2) - ab(7,n3) * x(n3) - ab(6,n4) * x(n4)
      x(n1) = b(n1) - ab(7,n2) * x(n2) - ab(6,n3) * x(n3) - &
     &      ab(5,n4) * x(n4)
      do k = 1, n - 1
        m4 = 4 * ( n - k )
        m3 = m4 - 1
        m2 = m3 - 1
        m1 = m2 - 1
        m48 = m4 + 8
        m38 = m3 + 8
        m28 = m2 + 8
        m18 = m1 + 8
        x(m4) = b(m4)
        do  m = m4 + 1, m4 + 4
          x(m4) = x(m4) - ab(m48-m,m) * x(m)
85      end do
        x(m3) = b(m3)
        do m = m3 + 1, m3 + 5
          x(m3) = x(m3) - ab(m38-m,m) * x(m)
90      end do
        x(m2) = b(m2)
        do m = m2 + 1, m2 + 6
          x(m2) = x(m2) - ab(m28-m,m) * x(m)
95      end do
        x(m1) = b(m1)
        do m = m1 + 1, m1 + 7
          x(m1) = x(m1) - ab(m18-m,m) * x(m)
100     end do
80    end do
      return
      end subroutine

! **********************************************************************
! In this subroutine, we incorporate a delta-function adjustment to
! a!ount for the  forward  diffraction  peak in the context of the 
! four-stream or two stream approximations ( Liou, Fu and Ackerman,
! 1988 ).  The w1(n), w2(n), w3(n), w(n), and t(n) are the adjusted
! parameters.
! **********************************************************************
      subroutine adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t )
      use  fu_liou_gu_table, only: fourssl,twossl,foursir,twosir,ndfs
      implicit none
       
      real, intent(in), dimension(ndfs)  :: ww1, ww2, ww3, ww4, ww, tt
      real, intent(out), dimension(ndfs) :: w1, w2, w3, w, t
      real, dimension(ndfs)              :: dtt, dt
      integer :: n, i
      real    :: tt0, f, fw
     
      n = ndfs
      tt0 = 0.0
      do i = 1, n
! 11/4/95 (begin)
        if ( fourssl .or. foursir ) then
          f = ww4(i) / 9.0
        else
          f = ww2(i) / 5.0
        endif
! 11/4/95 (end)
! - clear
        fw = 1.0 - f * ww(i) 
        w1(i) = ( ww1(i) - 3.0 * f ) / ( 1.0 - f )
        w2(i) = ( ww2(i) - 5.0 * f ) / ( 1.0 - f )
        w3(i) = ( ww3(i) - 7.0 * f ) / ( 1.0 - f )
        w(i) = ( 1.0 - f ) * ww(i) / fw
        dtt(i) = tt(i) - tt0
        tt0 = tt(i)
        dt(i) = dtt(i) * fw
10    end do
      t(1) = dt(1)
      do i = 2, n
        t(i) = dt(i) + t(i-1)
20    end do
      return
      end subroutine

! **********************************************************************
! The delta-four-stream approximation for nonhomogeneous atmospheres
! in the solar wavelengths (Fu, 1991). The input parameters are ndfs,
! mdfs, and ndfs4 through 'para.file',  ib, as, u0, f0 for solar and
! ib, bf, bs, ee for IR through arguments of  'qfts' and 'qfti', and
! ww1(ndfs), ww2(ndfs), ww3(ndfs), ww4(ndfs), ww(ndfs), and tt(ndfs)
! through common statement 'dfsin'.
! **********************************************************************
      subroutine qfts ( ib,as,f0,ww1,ww2,ww3,ww4,ww,tt,ffu,ffd )
      use  fu_liou_gu_table, only: ndfs, mdfs, u0
      implicit none
            
 !     common /dis/ a(4)
 !     common /point/ u(4)
      integer, intent(in)          :: ib
      real, intent(in)             :: as,  f0
      real, intent(in), dimension(ndfs)  :: ww1, ww2, ww3, ww4, ww, tt
      real, intent(out), dimension(mdfs) :: ffu, ffd
      real, dimension(ndfs)        :: w1, w2, w3, w4, w, t, u0a, f0a
      real    :: fk1(ndfs), fk2(ndfs), a4(4,4,ndfs),  &
     &           z4(4,ndfs), g4(4,ndfs)
      integer :: i, n, m, k, ii,jj
      real    :: asbs, ee, fw1, fw2, fw3, fw4, y, y1, x(4), fi(4)
      
      n = ndfs
      m = mdfs
      ee = 0.0
      asbs = as
      call adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t ) 
      do i = 1, n
        u0a(i) = u0
        f0a(i) = f0
5     end do
      call qcfe ( ib,asbs,ee,w1,w2,w3,w,t,u0a,f0a, &
     &            fk1,fk2,a4,z4,g4 )
      fw1 = 0.6638961
      fw2 = 2.4776962
      fw3 = u0 * 3.14159 * f0 
      do i = 1, m
        if ( i .eq. 1 ) then
          x(1) = 1.0
          x(2) = 1.0
          x(3) = exp ( - fk1(1) * t(1) )
          x(4) = exp ( - fk2(1) * t(1) )
          k = 1
          y = 1.0
        elseif ( i .eq. 2 ) then
          x(1) = exp ( - fk2(1) * t(1) )
          x(2) = exp ( - fk1(1) * t(1) )
          x(3) = 1.0
          x(4) = 1.0
          k = 1
          y = exp ( - t(1) / u0 )
        else
          k = i - 1
          y1 = t(k) - t(k-1)
          x(1) = exp ( - fk2(k) * y1 )
          x(2) = exp ( - fk1(k) * y1 )
          x(3) = 1.0
          x(4) = 1.0
          y = exp ( - t(k) / u0 )
        endif
        do jj = 1, 4
          fi(jj) = z4(jj,k) * y
37      end do
        do ii = 1, 4
          fw4 = g4(ii,k) * x(ii)
          do jj = 1, 4
            fi(jj) = fi(jj) + a4(jj,ii,k) * fw4
45        end do
40      end do
        ffu(i)= fw1 * fi(2) + fw2 * fi(1) 
        ffd(i)= fw1 * fi(3) + fw2 * fi(4) + fw3 * y
10    end do
      return
      end subroutine

! **********************************************************************
! The exponential approximation for the Planck function in optical depth
! is used for the infrared ( Fu, 1991). Since the direct solar radiation
! source has an exponential function form in terms of optical depth, the
! formulation of the delta-four-stream approximation for infrared  wave-
! lengths is the same as that for solar wavelengths. 
! **********************************************************************
      subroutine qfti ( ib,ee,bf,bs,ww1,ww2,ww3,ww4,ww,tt,ffu,ffd )
      use fu_liou_gu_table, only: ndfs,mdfs,nv1
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: ee, bf(nv1), bs
      real, intent(in), dimension(ndfs)  :: ww1, ww2, ww3, ww4, ww, tt
      real, intent(out), dimension(mdfs) :: ffu, ffd
      real, dimension(ndfs)              :: w1, w2, w3, w, t, u0, f0
      integer :: n, m, i, ii, jj, k
      real    :: asbs, t0, deltau, q1, q2, fw1, fw2, fw3, xy, y1
      real    :: x(4), fi(4)
      real    :: fk1(ndfs), fk2(ndfs), a4(4,4,ndfs),  &
     &           z4(4,ndfs), g4(4,ndfs)
      
      n = ndfs
      m = mdfs
      asbs = bs * ee
      call adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t )
      t0 = 0.0
      do i = 1, n
        q1 = alog ( bf(i+1) / bf(i) )
! -- change by Yu Gu, 11/13/01
        deltau = t(i) -t0
        if (deltau .lt. 1.e-12) deltau = 1.e-12
        q2 = 1.0 / deltau
!         q2 = 1.0 / ( t(i) - t0 )
! --change over

        f0(i) = 2.0 * ( 1.0 - w(i) ) * bf(i)
        if ( abs(q1) .le. 1.0e-10 ) then
          u0(i) = - 1.0e+10 / q2
        else
          u0(i) = - 1.0 / ( q1 * q2 )
        endif
! --------- 4/2/97 (5)
        if (abs(u0(i)) .gt. 4.25E+09) then
          if (u0(i) .lt. 0.0) then
            u0(i) = -4.25E+09
          else
            u0(i) = 4.25E+09
          end if
        end if
! --------- 4/2/97 (5)

        t0 = t(i)
3     end do
      call qcfe ( ib,asbs,ee,w1,w2,w3,w,t,u0,f0,fk1,fk2,a4,z4,g4 )
      fw1 = 0.6638958
      fw2 = 2.4776962
      do i = 1, m
        if ( i .eq. 1 ) then
          x(1) = 1.0
          x(2) = 1.0
          x(3) = exp ( - fk1(1) * t(1) )
          x(4) = exp ( - fk2(1) * t(1) )
          k = 1
          xy = 1.0
        elseif ( i .eq. 2 ) then
          x(1) = exp ( - fk2(1) * t(1) )
          x(2) = exp ( - fk1(1) * t(1) )
          x(3) = 1.0
          x(4) = 1.0
          k = 1
          xy =  exp ( - t(1) / u0(1) )
        else
          k = i - 1
          y1 = t(k) - t(k-1)
          x(1) = exp ( - fk2(k) * y1 )
          x(2) = exp ( - fk1(k) * y1 )
          x(3) = 1.0
          x(4) = 1.0
          xy =  exp ( - y1 / u0(k) )
        endif
        do jj = 1, 4
          fi(jj) = z4(jj,k) * xy
37      end do
        do ii = 1, 4
          fw3 = g4(ii,k) * x(ii)
          do jj = 1, 4
            fi(jj) = fi(jj) + a4(jj,ii,k) * fw3
45        end do
40      end do
        ffu(i)= fw1 * fi(2) + fw2 * fi(1)
        ffd(i)= fw1 * fi(3) + fw2 * fi(4)
10    end do
      return
      end subroutine


! 11/4/95 (begin)
      subroutine cfgts0 ( ib, w, w1, t0, t1, u0, f0, &
     &                    gamma1, gamma2, gamma3, gamma4, ugts1 )
! **********************************************************************
! This subroutine is used to calculate the Coefficients For Generalized
! Two-Stream scheme.  We can make choices between Eddington, quadrature
! and  hemispheri!  mean  schemes  through  logical variables 'edding',
! 'quadra', and 'hemisp'.  The  Eddington  and  quadrature  schemes are 
! discussed in detail by Liou (1992).  The  hemispheri!  mean scheme is 
! derived by assuming that the phase function is equal to 1 + g in  the 
! forward scattering hemisphere and 1 - g  in  the  backward scattering 
! hemisphere where g is the asymmetry factor.   The hemispheric mean is
! only used for infrared wavelengths (Toon et al. 1989).
! **********************************************************************
      use fu_liou_gu_table, only: mbs,edding,quadra,hemisp
      implicit none

      integer, intent(in) :: ib
      real, intent(in)    :: w, w1, t0, t1, u0, f0
      real, intent(out)   :: gamma1, gamma2, gamma3, gamma4, ugts1
      real x, y, z
      
      if ( edding ) then
        x = 0.25 * w1
        y = w * x
        gamma1 = 1.75 - w - y
        gamma2 = - 0.25 + w - y
        gamma3 = 0.0
        gamma4 = 0.0
        if ( ib .le. mbs ) then
          gamma3 = 0.5 - x * u0
          gamma4 = 1.0 - gamma3
        endif
        ugts1 = 0.5
      endif
      if ( quadra ) then
        x = 0.866 * w
        y = 0.2887 * w1
        z = y * w
        gamma1 = 1.732 - x - z
        gamma2 = x - z
        gamma3 = 0.0
        gamma4 = 0.0
        if ( ib .le. mbs ) then
          gamma3 = 0.5 - y * u0
          gamma4 = 1.0 - gamma3
        endif
        ugts1 = 0.57735
      endif
      if ( hemisp ) then
        x = w * w1 / 3.0
        gamma1 = 2.0 - w - x
        gamma2 = w - x
        gamma3 = 0.0
        gamma4 = 0.0
        ugts1 = 0.5
      endif
      return
      end subroutine


      subroutine cfgts ( ib, w, w1, t0, t1, u0, f0, &
     &                   lamda,gamma,cadd0,cadd1,cmin0,cmin1,g1g2 )
! **********************************************************************
! This subroutine is used to calculate the Coefficients For Generalized
! Two-Stream scheme. 
! **********************************************************************
      use fu_liou_gu_table, only: mbs
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: w, w1, t0, t1, u0, f0
      real :: lamda, gamma, cadd0, cadd1, cmin0, cmin1, g1g2
      real :: gamma1, gamma2, gamma3, gamma4, ugts1
      real :: fq, alfa, beta, fw, x, z
      
      call cfgts0 ( ib, w, w1, t0, t1, u0, f0, &
     &              gamma1, gamma2, gamma3, gamma4, ugts1 )
      lamda = sqrt ( ( gamma1 + gamma2 ) * ( gamma1 - gamma2 ) )
      gamma = gamma2 / ( gamma1 + lamda )
      g1g2 = gamma1 + gamma2
      fq = 1.0 / u0
      if ( ib .le. mbs ) then
        alfa = gamma3
        beta = gamma4
        fw = 3.1415927 * f0 * w * exp ( - fq * t0 )
      else
        alfa = 1.0
        beta = 1.0
        fw = 3.1415927 * f0
      endif
      x = exp ( - fq * ( t1 - t0 ) )
      z = lamda * lamda - fq * fq
! -- change by Yu Gu, 11/15/01
!      if (abs(z).lt.1.e-4) then
!      if (z.ge.0.) z = 1.e-4
!      if (z.lt.0.) z = -1.e-4
!      endif
      if(z.eq.0.) z = 1.e-4
! -- cgange over
      cadd0 = fw * ( ( gamma1 - fq ) * alfa + &
     &          beta * gamma2 ) / z
      cmin0 = fw * ( ( gamma1 + fq ) * beta + &
     &          alfa * gamma2 ) / z
      cadd1 = cadd0 * x
      cmin1 = cmin0 * x
      return
      end subroutine


      subroutine qcgts ( ib, asbs, ee, &
     &                   w1,w2,w3,w,t,u0,f0, &
     &                   lamdan,gamman,caddn,cminn, &
     &                   caddn0,cminn0,aa,bb,expn,g1g2n )
! **********************************************************************
! In the solar band  asbs is the surface albedo, while in the infrared
! band asbs is  blackbody intensity emitted at the surface temperature
! times surface emissivity.  In this subroutine,  the generalized two-
! stream is applied to nonhomogeneous atmospheres. ee is the IR surface
! emissivity. 
! **********************************************************************
      use fu_liou_gu_table, only: ndfs,ndfs2,mbs
      implicit none
      
      integer, intent(in)   :: ib
      real, intent(in)      :: asbs, ee
      real, intent(in), dimension(ndfs) :: w1, w2, w3, w, t, u0, f0
      real, dimension(ndfs) :: lamdan, gamman, caddn, cminn,  &
     &                         caddn0, cminn0, aa, bb, expn, g1g2n
      integer :: ibn, k ,k1, k2
      real    :: wn, w1n, t0n, t1n, u0n, f0n, rsfc, ssfc, wm1, wm2
      real, dimension(ndfs)  :: xn, yn, zn
      real, dimension(ndfs2) :: a, b, c, r, u, gam

      ibn = ib
      do k = 1, ndfs
        wn = w(k)
        w1n = w1(k)
        if ( k .eq. 1 ) then
          t0n = 0.0
        else
          t0n = t(k-1)
        endif
        t1n = t(k)
        u0n = u0(k)
        f0n = f0(k)
        if ( wn .ge. 0.999999 ) then
          wn = 0.999999
        endif
        call cfgts ( ib, wn, w1n, t0n, t1n, u0n, f0n, &
       &             lamdan(k), gamman(k), caddn0(k), caddn(k), &
       &             cminn0(k), cminn(k), g1g2n(k) )
        expn(k) = exp ( - lamdan(k) * ( t1n - t0n ) )
        xn(k) = gamman(k) * expn(k)
        yn(k) = ( expn(k) - gamman(k) ) / ( xn(k) - 1.0 )
        zn(k) = ( expn(k) + gamman(k) ) / ( xn(k) + 1.0 )
40    end do
      a(1) = 0.0
      b(1) = xn(1) + 1.0
      c(1) = xn(1) - 1.0
      r(1) = - cminn0(1)
      do k = 1, ndfs - 1
        k1 = k + k
        k2 = k + k + 1
        a(k1) = 1.0 + xn(k) - yn(k+1) * ( gamman(k) + expn(k) )
        b(k1) = 1.0 - xn(k) - yn(k+1) * ( gamman(k) - expn(k) )
        c(k1) = yn(k+1) * ( 1.0 + xn(k+1) ) - expn(k+1) - gamman(k+1)
        r(k1) = caddn0(k+1) - caddn(k) - yn(k+1) * &
       &      ( cminn0(k+1) - cminn(k) )
        a(k2) = gamman(k) - expn(k) - zn(k) * ( 1.0 - xn(k) )
        b(k2) = -1.0 - xn(k+1) + zn(k) * ( expn(k+1) + gamman(k+1) )
        c(k2) = zn(k) * ( expn(k+1) - gamman(k+1) ) - xn(k+1) + 1.0
        r(k2) = cminn0(k+1) - cminn(k) - zn(k) * &
       &      ( caddn0(k+1) - caddn(k) )
50    end do
      if ( ib .le. mbs ) then
        rsfc = asbs
        ssfc = 3.1415927 * u0(1) * exp(-t(ndfs)/u0(1)) * rsfc * &
       &       f0(1)
      else
        rsfc = 1.0 - ee
        ssfc = 3.1415927 * asbs
      endif
      wm1 = 1.0 - rsfc * gamman(ndfs)
      wm2 = xn(ndfs) - rsfc * expn(ndfs)
      a(ndfs2) = wm1 + wm2
      b(ndfs2) = wm1 - wm2
      c(ndfs2) = 0.0
      r(ndfs2) = rsfc * cminn(ndfs) - caddn(ndfs) + ssfc
      call tridag ( a, b, c, r, u, gam, ndfs2 )
      do k = 1, ndfs
        k1 = k + k - 1
        k2 = k + k
        aa(k) = u(k1) + u(k2)
        bb(k) = u(k1) - u(k2)
60    end do
      return
      end subroutine


      subroutine tridag ( a, b, c, r, u, gam, n )
! **********************************************************************
!
!   | b1 c1 0  ...                |   | u1   |   | r1   |                    
!   | a2 b2 c2 ...                |   | u2   |   | r2   |                
!   |          ...                | . | .    | = | .    |
!   |          ... an-1 bn-1 cn-1 |   | un-1 |   | rn-1 |                    
!   |              0    an   bn   |   | un   |   | rn   |                
!
! This  subroutine solves for  a vector U of length N the tridiagonal
! linear set given by above equation. A, B, ! and R are input vectors
! and are not modified (Numerical Recipes by Press et al. 1989).
! **********************************************************************
      implicit none
      integer :: n
      real, dimension(n) :: a, b, c, r, u, gam
      integer :: i, j
      real    :: bet
      if ( b(1) .eq. 0. ) pause
! If this happens then you should rewrite your equations as a set of
! order n-1, with u2 trivially eliminated.
      bet = b(1)
      u(1) = r(1) / bet

! Decomposition and forward substitution
      do j = 2, n
        gam(j) = c(j-1) / bet
        bet = b(j) - a(j) * gam(j)
        if ( bet .eq. 0. ) pause
! Algorithm fails; see Numerical Recipes.
        u(j) = ( r(j) - a(j) * u(j-1) ) / bet
11    end do
! Backsubstitution
      do j = n - 1, 1, -1
        u(j) = u(j) - gam(j+1) * u(j+1)
12    end do
      return
      end subroutine


      subroutine qftsts ( ib, as_in, f0, &
     &                    ww1,ww2,ww3,ww4,ww,tt, &
     &                    ffu,ffd )
! **********************************************************************
! The generalized two stream approximation for nonhomgeneous atmospheres
! in  the  solar  wavelengths.  The  input  parameters are those through
! 'para.file', through argument of 'qftsts' and through common statement
! 'dfsin' and 'gtslog'.
! **********************************************************************
      use fu_liou_gu_table, only: ndfs,mdfs,u0
      implicit none
      
      integer, intent(in) :: ib
      real, intent(in)    :: as_in, f0
      real, intent(in), dimension(ndfs)  :: ww1, ww2, ww3, ww4, ww, tt
      real, dimension(ndfs)              :: w1, w2, w3, w, t, u0a, f0a
      real, intent(out), dimension(mdfs) :: ffu, ffd
      real, dimension(ndfs) :: lamdan, gamman, caddn, cminn,  &
     &                         caddn0, cminn0, aa, bb, expn, g1g2n
      integer :: n, m, k, i
      real    :: ee, asbs, fw3, xx, yy(ndfs)
      
      n = ndfs
      m = mdfs
      ee = 0.0
      asbs = as_in
      call adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t )
      do i = 1, n
        u0a(i) = u0
        f0a(i) = f0
5     end do

      call qcgts ( ib, asbs, ee,  &
     &             w1,w2,w3,w,t,u0a,f0a, &
     &             lamdan,gamman,caddn,cminn, &
     &             caddn0,cminn0,aa,bb,expn,g1g2n )

      fw3 = u0 * 3.1415927 * f0
      do k = 1, ndfs
        yy(k) = exp(-t(k)/u0)
      enddo
      xx = aa(1) * expn(1)
      ffu(1) = xx + gamman(1) * bb(1) + caddn0(1)
      ffd(1) = gamman(1) * xx + bb(1) + cminn0(1) + fw3
      do i = 2, m
        k = i - 1
        xx = bb(k) * expn(k)
        ffu(i) = aa(k) + gamman(k) * xx + caddn(k)
        ffd(i) = gamman(k) * aa(k) + xx + cminn(k) + fw3 * yy(k)
10    end do
      return
      end subroutine


      subroutine qftits ( ib, as_in, f0, u0,     &
     &                    ww1,ww2,ww3,ww4,ww,tt, &
     &                    ffu,ffd )
! **********************************************************************
! The exponential approximation for the Planck function in optical depth
! is used for the infrared ( Fu, 1991). Since the direct solar radiation
! source has an exponential function form in terms of optical depth, the
! formulation of generalized two stream approximation for infrared  wave
! lengths is the same as that for solar wavelengths. 
! The generalized two stream approximation for nonhomgeneous atmospheres
! in the infrared wavelengths.  The  input  parameters are those through
! 'para.file', through argument of 'qftits' and through common statement
! 'dfsin', 'gtslog', and 'planci'.
! **********************************************************************

      use fu_liou_gu_table, only: ndfs,mdfs,nv1
      implicit none
      
      integer, intent(in)    :: ib
      real, intent(in)       :: as_in
      real, dimension(ndfs)  :: f0, u0
      real, intent(in), dimension(ndfs)  :: ww1, ww2, ww3, ww4, ww, tt
      real, dimension(ndfs)              :: w1, w2, w3, w, t, u0a, f0a
      real, intent(out), dimension(mdfs) :: ffu, ffd
      real, dimension(ndfs) :: lamdan, gamman, caddn, cminn,  &
     &                         caddn0, cminn0, aa, bb, expn, g1g2n
      integer :: n, m, k, i
      real    :: asbs, fw3, xx, yy(ndfs), t0, q1, q2, deltau
      real    :: ee, bf(nv1), bs
      
      n = ndfs
      m = mdfs
      asbs = bs * ee
      call adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t ) 
      t0 = 0.0
      do i = 1, n
        q1 = alog ( bf(i+1) / bf(i) )
! -- change by Yu Gu, 11/13/01
        deltau = t(i) -t0
        if (deltau .lt. 1.e-12) deltau = 1.e-12
        q2 = 1.0 / deltau
!         q2 = 1.0 / ( t(i) - t0 )
! --change over

        f0(i) = 2.0 * ( 1.0 - w(i) ) * bf(i)
        if ( abs(q1) .le. 1.0e-10 ) then
          u0(i) = - 1.0e+10 / q2
        else
          u0(i) = - 1.0 / ( q1 * q2 )
        endif
        t0 = t(i)
3     end do
      call qcgts ( ib, asbs, ee,  &
     &             w1,w2,w3,w,t,u0a,f0a, &
     &             lamdan,gamman,caddn,cminn, &
     &             caddn0,cminn0,aa,bb,expn,g1g2n ) 
      xx = aa(1) * expn(1)
      ffu(1) = xx + gamman(1) * bb(1) + caddn0(1)
      ffd(1) = gamman(1) * xx + bb(1) + cminn0(1) 
      do i = 2, m
        k = i - 1
        xx = bb(k) * expn(k)
        ffu(i) = aa(k) + gamman(k) * xx + caddn(k)
        ffd(i) = gamman(k) * aa(k) + xx + cminn(k)
10    end do
      return
      end subroutine

      subroutine qftisf ( ib, ee, bf, bs, &
     &                    ww1, ww2, ww3, ww4, ww, tt, &
     &                    ffu, ffd )
! **********************************************************************
! In this subroutine, the two- and four- stream combination  scheme  or
! the source function technique (Toon et al. 1989) is used to calculate
! the IR radiative fluxes. The exponential approximation for the Planck
! function in optical depth is used ( Fu, 1991).
! At IR wavelengths, the two-stream results are not exact in the limit
! of no scattering. It also introduces large error in the case of sca-
! ttering. Since the no-scattering limit is of considerable significance
! at IR wavelengths, we have used  the source function technique  that
! would be exact in the limit of the pure absorption and would also en-
! hance the a!uracy of the two-stream approach when scattering o!urs
! in the IR wavelengths.
! Here, we use nq Gauss points to obtain the fluxes: when nq=2, we use
! double Gaussian quadrature as in Fu and Liou (1993) for  four-stream
! approximation; when nq = 3, we use the regular Gauss quadrature  but
! u1*w1+u2*w2+u3*w3=1.0.
! **********************************************************************
      use fu_liou_gu_table, only: nq,ndfs,mdfs,quadra,nv1
      implicit none
      
      integer :: ib
      real    :: ee, bf(nv1), bs
      real, dimension(ndfs) :: ww1, ww2, ww3, ww4, ww, tt
      real, dimension(ndfs) :: w1, w2, w3, w, t, u0, f0
      real, dimension(mdfs) :: ffu, ffd
      
      real, dimension(ndfs) :: lamdan, gamman, caddn, cminn, &
                               caddn0, cminn0, aa, bb, expn, g1g2n
      real, dimension(ndfs) :: fuq1, fuq2, fg, fh, fj, fk
      real, dimension(mdfs,nq) :: fiu, fid
      integer :: n, m, i, j, i1
      real    :: ugts1, asbs, t0, q1, q2, deltau, xgy, x, y1, y, z, &
     &           xx, yy, tempugbeta, tempxxp1, tempxxm1, ugbeta
      real    :: alfa(ndfs+1), beta(ndfs)
      real    :: fx(ndfs,nq), fy(ndfs), fz1(ndfs,nq), fz2(ndfs,nq)
      real    ::  ug(2)   = (/ 0.2113248, 0.7886752 /), &
     &            wg(2)   = (/ 0.5, 0.5 /), &
     &            ugwg(2) = (/ 0.105662, 0.394338 /)
 
      
      if ( quadra ) then
        ugts1 = 0.57735
      else
        ugts1 = 0.5
      endif
      n = ndfs
      m = mdfs
      asbs = bs * ee
      call adjust ( ww1,ww2,ww3,ww4,ww,tt,w1,w2,w3,w,t ) 
      t0 = 0.0
      do i = 1, n
        q1 = alog ( bf(i+1) / bf(i) )
! -- change by Yu Gu, 11/13/01
        deltau = t(i) -t0
        if (deltau .lt. 1.e-12) deltau = 1.e-12
        q2 = 1.0 / deltau
!          q2 = 1.0 / ( t(i) - t0 )
! --change over

        f0(i) = 2.0 * ( 1.0 - w(i) ) * bf(i)
        if ( abs(q1) .le. 1.0e-10 ) then
          u0(i) = - 1.0e+10 / q2
        else
          u0(i) = - 1.0 / ( q1 * q2 )
        endif
        t0 = t(i)
        beta(i) = - 1.0 / u0(i)
      enddo
      call qcgts ( ib, asbs, ee,  &
     &             w1,w2,w3,w,t,u0,f0, &
     &             lamdan,gamman,caddn,cminn, &
     &             caddn0,cminn0,aa,bb,expn,g1g2n )
      do i = 1, n
! --- change by Yu Gu, 11/15/01
        xgy = lamdan(i)*lamdan(i) - beta(i) * beta(i)
!           if (abs(xgy).lt.1.e-4) then
!      if (xgy.ge.0.) xgy = 1.e-4
!      if (xgy.lt.0.) xgy = -1.e-4
!      endif
        if(xgy.eq.0.) xgy = 1.e-4
        x = 2.0 * ( 1.0 - w(i) ) * w(i) / xgy
!          x = 2.0 * ( 1.0 - w(i) ) * w(i) / ( lamdan(i) *
!     &         lamdan(i) - beta(i) * beta(i) )
! -- change over

        y1 = w1(i) / 3.0
        y = 2.0 * ( 1.0 - w(i) * y1 )
        z = -y1 * beta(i)
        fuq1(i) = x * ( y - z ) + 1.0 - w(i)
        fuq2(i) = x * ( y + z ) + 1.0 - w(i)
      enddo
      do i = 1, n + 1
        alfa(i) = 6.2832 * bf(i)
      enddo
      x = 1.0 / ugts1
      do i = 1, n
        y = gamman(i) * ( x + lamdan(i) )
        z = x - lamdan(i)
        fg(i) = aa(i) * z
        fh(i) = bb(i) * y
        fj(i) = aa(i) * y
        fk(i) = bb(i) * z
      enddo
      do j = 1, nq
        fid(1,j) = 0.0
      enddo
      do j = 1, nq
        t0 = 0.0
        do i = 2, mdfs
          i1 = i - 1
          fx(i1,j) = exp ( - ( t(i1) - t0 ) / ug(j) )
          fy(i1) = expn(i1)
          xx = lamdan(i1) * ug(j)
! --change by Yu Gu, 12/04/01
          tempugbeta = ug(j) * beta(i1) + 1.0
          tempxxp1 = xx + 1.0
          tempxxm1 = xx - 1.0
          if (tempugbeta.eq.0.) tempugbeta = 1.e-4
          if (tempxxp1.eq.0.) tempxxp1 = 1.e-4
          if (tempxxm1.eq.0.) tempxxm1 = 1.e-4

!        if (tempugbeta.eq.0.) tempugbeta = 0.0001
!        if (tempugbeta.eq.0.) tempugbeta = 1.e-4
! - change over
!           fz1(i1,j) = ( 1.0 - fx(i1,j) * fy(i1) ) / ( xx + 1.0 )
!           fz2(i1,j) = ( fx(i1,j) - fy(i1) ) / ( xx - 1.0 )
          fz1(i1,j) = ( 1.0 - fx(i1,j) * fy(i1) ) / ( tempxxp1 )
          fz2(i1,j) = ( fx(i1,j) - fy(i1) ) / ( tempxxm1 )

          fid(i,j) = fid(i1,j) * fx(i1,j) + fj(i1) * fz1(i1,j) + &
     &                fk(i1) * fz2(i1,j) + &
     &                1.0  / ( tempugbeta ) * &
!     &                1.0  / ( ug(j) * beta(i1) + 1.0 ) *
     &                ( alfa(i) - alfa(i1) * fx(i1,j) ) * fuq2(i1)
          t0 = t(i1)
        enddo
      enddo
      yy = 0.0
      do j = 1, nq
        yy = yy + ugwg(j) * fid(mdfs,j)
      enddo
      xx = yy * ( 1.0 - ee ) * 2.0 + 6.2831854 * ee * bs
      do j = 1, nq
        fiu(mdfs,j) = xx
      enddo
      do j = 1, nq
        do i = mdfs - 1, 1, -1
! -- change by Yu Gu, 11/15/01
          ugbeta = ug(j)*beta(i)
          if (ugbeta.eq.1.) ugbeta = 1.0001
! -- change over

          fiu(i,j) = fiu(i+1,j) * fx(i,j) + fg(i) * fz2(i,j) + &
         &           fh(i) * fz1(i,j) + &
! -- change by Yu Gu, 11/15/01
!     &                1.0 / ( ug(j) * beta(i) - 1.0 ) *
         &           1.0 / ( ugbeta - 1.0 ) * &
! -- change over
         &           ( alfa(i+1) * fx(i,j) - alfa(i) ) * fuq1(i)
        enddo
      enddo
      do i = 1, mdfs
        ffu(i) = 0.0
        ffd(i) = 0.0
      enddo
      do i = 1, mdfs
        do j = 1, nq
          ffu(i) = ffu(i) + ugwg(j) * fiu(i,j)
          ffd(i) = ffd(i) + ugwg(j) * fid(i,j)
        enddo
      enddo
      return
      end subroutine
! 11/4/95 (end)


!
!                        8/14/95, 4/1/97 , 2/10/2000
!
!  **********************************************************************
!  Subroutine to create aerosol optical properties.  There are several
!  inputs and 6 outputs.  
!
!    INPUTS FROM COMMON BLOCKS OR HEADER FILE:
!
!    a_tau(nwi) :  The input column aerosol optical depth
!    (real)           (common block "aer_tau" - see header file).
!
!    a_wli(nwi) :  Wavelength in microns corresponding to aerosol tau in "a_tau"
!
!    aprof(# layers): The input aerosol optical depth profile - LAYERS
!    (real)           (common block "aer_prof").
!
!    itp:       Aerosol type, given in header file rad_0598.h.
!
!    ifg:       The table will compute vertical distributions based on
!    (integer)  relative humidity (see explanation below).  If ifg is
!               set to 0, each layer will have properties calculated
!               based on the relative humidity of that layer.  If ifg
!               is set equal to another integer (1 through the number of
!               relative humidities given in the block data "aerosol")
!               the routine will calculate a vertical profile of optical
!               properties based on the relative humidity corresponding
!               to the index given.  The indices are: 1: 0%; 2: 50%;
!               3: 70%; 4: 80%; 5:90%; 6: 95%; 7: 98%; and 8: 99%.
!               If the number of relative humidities changes, these
!               numbers will have to be modified.
!
!    ivd:       Vertical tau distribution flag.  If set to zero, the 
!               distribution is based on Jim Spinhirne's marine 
!               distribution formulation, and no user input is required.  
!               If set to one, the user's own vertical distribution is 
!               used, and must be present in the array aprof(nlayers).
!               NOTE: This vertical distribution is used as a weighting 
!               factor ONLY, to distribute input column optical depths!
!
! ---------------------------------------------------------------------------
!    a_ssa, a_ext, a_asy:  Input single-scattering albedos, extinction
!           coefficients, and asymmetry parameters.  These variables 
!           are dimensioned (# of bands, # of relative humidities,
!           # of aerosol types). An x or y is appended on these 
!           variable names: if x, the numbers correspond to the 18 
!           original bands.  If y, the numbers are for the 10 
!           sub-intervals in the first shortwave band (.2-.7 microns).  
!           All of these variables come from the block data statements 
!           aerosol# (# corresponds to an integer, eg. aerosol1) and 
!           are in common blocks aer_optx and aer_opty.
!
!    nv,mb,pp,pt,ph,dz: number of layers, number of bands, and the
!           pressure, temperature, humidity and thickness profiles.
!           These are shared by several subroutines.
!
!    OUTPUTS:
!
!    a_tau1,a_ssa1,a_asy1:  The optical depth, single-scattering albedo,
!       and asymmetry parameter vertical profiles for 18 bands.  These
!       are dimensioned (nvx, 18)  These are in the common block
!       aer_initx, which is shared by the subroutine "aerosolx".  
!
!    a_tau2,a_ssa2,a_asy2:  Properties for SW band 1's 10 subintervals.  
!       These are dimensioned (nvx, 10)  These are in the common block
!       aer_inity, which is shared by the subroutine "aerosoly".  
!
!  **********************************************************************
!      USE RadParams
      subroutine aerosol_init(pp,pt,ph,po,dz,        &
                              a_tau1,a_ssa1,a_asy1,  &
                              a_tau2,a_ssa2,a_asy2,  &
                              a_wlis,a_taus,aprofs   &
                             )
       
!##      include 'rad_0698.h'
      use  fu_liou_gu_table, only: nv,nv1,nvx,mbx,mby,nrh,  &
                                   mxat,mxac,naer,n_atau,   &
                                   itps,ivd,ifg,mxac,iaform,&
                                   a_ssax,a_extx,a_asyx,    &
                                   a_ssay,a_exty,a_asyy
      implicit none
                                         
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: dz(nv)
      
      integer :: iq,mtop,n,m,ict,ix,iy,irh,krh,iac,itp
!      real, dimension(mbx,nrh,naer) :: a_ssax,a_extx,a_asyx
!      real, dimension(mby,nrh,naer) :: a_ssay,a_exty,a_asyy

      real, dimension(nvx)          :: tauxxx
      real, dimension(nvx,mbx,mxac) :: a_tau1,a_ext1,a_ssa1,a_asy1
      real, dimension(nvx,mby,mxac) :: a_tau2,a_ext2,a_ssa2,a_asy2

      real ,dimension(nvx)          :: taux1,taux2,rh,ht,rhp
      real                          :: sumxxx

      real,dimension(mxat)          :: a_wli,a_tau
      real,dimension(nvx)           :: aprof
      real,dimension(nvx,mbx)       :: wvd_x
      real,dimension(nvx,mby)       :: wvd_y

      real :: p1,h1,z,sig,tp
      real :: rhx(nrh) = (/0.,50.,70.,80.,90.,95.,98.,99./)
      real :: wts(4) = (/.23015,.28274,.25172,.23539/)
      real :: tau3(2),tau3y(4)
      real :: aotf(15),wlf(15),sump,rirh
!      real, external :: spinhirne_sig, spinhirne_tau


      real,dimension(mxat,mxac) :: a_wlis,a_taus      
      real,dimension(nvx,mxac)  :: aprofs
    

 

!  Initialize.

      rh     = -9999.
      a_ssa1 = 0. ; a_ext1 = 0. ; a_asy1 = 0. ; a_tau1 = 0.
      a_ssa2 = 0. ; a_ext2 = 0. ; a_asy2 = 0. ; a_tau2 = 0.

!      if ( nac < 0 .or. nac > mxac ) stop !?"nac:# Aerosol Constituents"
      if (n_atau<0 .or.n_atau>mxat) stop !?"n_atau:# Aerosol Tau / Wavelengths"
      if (ifg < 0 .or. ifg > 8) stop !?"ifg: Aerosol RH% Flag"
      
      AEROSOL_CONSTITUENTS : do iac = 1,mxac
      if (itps(iac).eq.1) then

        a_wli(1:n_atau) = a_wlis(1:n_atau,iac)
        a_tau(1:n_atau) = a_taus(1:n_atau,iac)
        aprof(1:nv) = aprofs(1:nv,iac)
        itp = iac
        if ( itp < 1 .or. itp > naer ) stop ' itp : Bad Aerosol Type'
!      print*,'CONSTITUENTS',iac,itp

! FOR Aerosol Optical Properties types that are constant with RH       
        if (itp==1  .or. itp==2 .or. itp==3 .or. &
       &      itp==10 .or. itp==12 .or.itp==13 .or. itp==18 ) then
!!       Has already been filled in Block data 
        else
          do krh=2,8
            a_extx(1:mbx,krh,itp)= a_extx(1:mbx,1,itp)
            a_ssax(1:mbx,krh,itp)= a_ssax(1:mbx,1,itp)
            a_asyx(1:mbx,krh,itp)= a_asyx(1:mbx,1,itp)

            a_exty(1:mby,krh,itp)= a_exty(1:mby,1,itp)
            a_ssay(1:mby,krh,itp)= a_ssay(1:mby,1,itp)
            a_asyy(1:mby,krh,itp)= a_asyy(1:mby,1,itp)

          enddo
  
        endif
!      if ( ifg .ne.0) print*,'CHECK',ifg,itp,a_ssax(1:mbx,ifg,itp)

!  ******************************************************************
!  Calculate heights at center of layer - find highest layer to place
!  aerosols (15 km) - calculate relative humidities of each layer as
!  needed.  Values of RH > 99% will be set equal to 99% to make table
!  lookup easier. "mtop" is the highest aerosol layer.
!  ******************************************************************
        z=0.
        m=nv
        iq=0
        do while (iq.eq.0)
          ht(m)=(z*2.+dz(m))/2.
          z=z+dz(m)
          if (z.gt.15.) then
            iq=1
            mtop=m
          endif
          p1=(pp(m)+pp(m+1))/2.
          tp=(pt(m)+pt(m+1))/2.
          h1=(ph(m)+ph(m+1))/2.
          call ql_rh(rh(m),tp,p1,h1) 
          if (rh(m).gt.98.9) rh(m)=98.9
          if ((rh(m).lt..01).and.(rh(m).gt.-999.)) rh(m)=0.
          m=m-1
        end do

!  *************************************************************
!  Calculate vertical distribution of asymmetry, ss albedo and
!  extinction, based on aerosol type and relative humidity.  
!  If ifg is not equal to 0, parameters  will corresponds to a 
!  single RH, as described in header file. Loop 31 deals with 
!  the 18 original bands, loop 32 with the 10 band 1 subintervals.
!  *************************************************************
        do m=mtop,nv
          do n=1,mbx
            if (rh(m).eq.-9999.) then
              a_ext1(m,n,iac)=-9999.
              a_ssa1(m,n,iac)=-9999.
              a_asy1(m,n,iac)=-9999.
            else
              if (ifg.eq.0) then          ! Dependence on layer RH.
                ict=2
                do while (rh(m).ge.rhx(ict))
                  ict=ict+1
                end do
                a_ext1(m,n,iac)=a_extx(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_extx(n,ict,itp)-a_extx(n,ict-1,itp))
                a_ssa1(m,n,iac)=a_ssax(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_ssax(n,ict,itp)-a_ssax(n,ict-1,itp))
                a_asy1(m,n,iac)=a_asyx(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_asyx(n,ict,itp)-a_asyx(n,ict-1,itp))
                rhp(m) = rh(m)
              else                        ! Dependence on prescribed RH.
                a_ext1(m,n,iac)=a_extx(n,ifg,itp)
                a_ssa1(m,n,iac)=a_ssax(n,ifg,itp)
                a_asy1(m,n,iac)=a_asyx(n,ifg,itp)
              endif
            endif
          end do
!-------------------------------------------
          do n=1,mby
            if (rh(m).eq.-9999.) then
              a_ext2(m,n,iac)=-9999.
              a_ssa2(m,n,iac)=-9999.
              a_asy2(m,n,iac)=-9999.
            else
              if (ifg.eq.0) then          ! Dependence on layer RH.
                ict=2
                do while (rh(m).ge.rhx(ict))
                  ict=ict+1
                end do
                a_ext2(m,n,iac)=a_exty(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_exty(n,ict,itp)-a_exty(n,ict-1,itp))
                a_ssa2(m,n,iac)=a_ssay(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_ssay(n,ict,itp)-a_ssay(n,ict-1,itp))
                a_asy2(m,n,iac)=a_asyy(n,ict-1,itp)+(rh(m)-rhx(ict-1))/ &
       &   (rhx(ict)-rhx(ict-1))*(a_asyy(n,ict,itp)-a_asyy(n,ict-1,itp))
              else                        ! Dependence on prescribed RH.
                a_ext2(m,n,iac)=a_exty(n,ifg,itp)
                a_ssa2(m,n,iac)=a_ssay(n,ifg,itp)
                a_asy2(m,n,iac)=a_asyy(n,ifg,itp)
              endif
            endif
          end do

        end do

!  ******************************************************************
!  Vertical distribution of aerosol optical depths - CAGEX and CERES.
!       --------------------------------------------------------------
!       Use Spinhirne's vertical distribution of scattering properties 
!       to calculate vertical distribution of optical depths.  The  
!       distribution gives a scattering coefficient ("sig"). Use this,  
!       along with the single-scattering albedo, to produce an  
!       RH-dependent extinction coefficient (extx, exty, etc.), from  
!       which optical depth is calculated (taux, tauy, etc.).  This  
!       optical depth is summed (sum1, sumy2, sum, etc.) to give  
!       column tau for weighting purposes.
!       --------------------------------------------------------------

        select case (ivd) 
        case default
          stop ' ivd : Aerosol Profile flag'
        case (0)  !! DEFAULT VERTICAL DISTRIBUTION Spinhirne

          sumxxx=0.0

          do  m=mtop,nv
       
            sig = spinhirne_sig( ht(m)) 
            tauxxx(m) = spinhirne_tau(sig,a_ssa2(m,9,iac),dz(m)) 
            sumxxx   = sumxxx + tauxxx(m)
!            print*,m,sig,a_ssa2(m,9,iac)
          enddo

          do m=mtop,nv
            tauxxx(m) = tauxxx(m)  / sumxxx
!!!       aprofs(m,iac) = tauxxx(m) !! See what the Sphinhirne profiles look like
          enddo

! ----------------------------------------------------------------
        case (1)   ! USER'S OWN VERTICAL DISTRIBUTION IVD=1
      
          sump =   sum( aprof(mtop:nv) )
          tauxxx(mtop:nv)= aprof(mtop:nv) / sump 

          if(sump.eq.0.)stop 'No VERTICAL Profile OF AEROSOL TAU '


        case (2)   ! USER'S INPUT VERTICAL DISTRIBUTION IVD=2
      
          sump =   sum( aprof(mtop:nv) )
          tauxxx(mtop:nv)= aprof(mtop:nv) / sump 

          if(sump.eq.0.)stop 'No VERTICAL Profile OF AEROSOL TAU '
       
        end select

!  ********************************************************************
!  IAFORM=2
!
!  Distribute optical depth spectrally into the first 2 Fu-Liou bands.  
!  Band 1 will consist of the first 4 MFRSR bands, weighted with 
!  respect to energy.  Band two will be the fifth MFRSR band. 
!
!  Also, distribute optical depths into 4 of the 10 band 1 subintervals.  
!  Subinterval 7 is directly inserted, since there is one MFRSR 
!  measurement within the range of this band.  Subintervals 7 and 8 
!  straddle the .497 micron MFRSR measurement, so interpolated values 
!  are inserted into these, using .409 and .497 measurements for 7, and 
!  .497 and .606 for 8.  Subinterval 10 contains two MFRSR measurements, 
!  so it is filled using an energy-weighted average.  This is all 
!  hardwired, so we need all of the MFRSR bands (.409, .497, .606, and 
!  .661) for it to work. (The .855 micron band is also needed, but not 
!  for this interval distribution.
!  ********************************************************************

        select case ( iaform )
        case default
          stop ' iaform : Bad value of iaform '
        case(1)        ! CERES
!! No operations necessary

        case(2)        ! For CAGEX
      
          tau3(1)=a_tau(1)*wts(1)+a_tau(2)*wts(2)+ &
       &          a_tau(3)*wts(3)+a_tau(4)*wts(4)
          tau3(2)=a_tau(5)
          tau3y(1)=a_tau(1)      ! For subinterval 7 of 1st band (.409)
          tau3y(2)=a_tau(1)+.6705*(a_tau(2)-a_tau(1)) ! Subi 8 of band 1
          tau3y(3)=a_tau(2)+.4541*(a_tau(3)-a_tau(2)) ! Subi 9 of band 1
          tau3y(4)=a_tau(3)*.5175+a_tau(4)*.4825      ! Subi 10 of band 1
 
        case(3)        ! For AOT_SPLINEFIT
      
          if ( ifg == 0 ) then ! Find Aerosol weighted collumn mean RH index 
            rirh=0
            do m =mtop,nv
              rirh = rirh + rhp(m)* tauxxx(m)  !! Aerosol Profile weighted mean RH
!       print*,m,rhp(m),tauxxx(m)
            enddo 

            irh =1
            do ix= 1,7
              if( rirh >= rhx(ix) .and. rirh < rhx(ix+1) ) irh=ix
            enddo 
            if( rirh >= rhx(8) ) irh =8

          else  ! Use assigned RH index
            irh = ifg
          endif

! Can't handle ZERO in Log interpolation
          where ( a_tau .lt. 1.0E-20) a_tau = 1.0E-20

          call atau_spline_iaform3(a_wli,a_tau,aotf,wlf,irh,itp)

!      write(22,'(a20,15f8.3)') 'AOT in Fu Bands',aotf(1:15)

!!! A!OUNT FOR VERTICAL EXTINCTION VARIABILITY WITH HUMIDITY ABOUT THE MEAN RH "irh"
!!! ( IAFORM==3) only
          do iy = 1,mby
            wvd_y(mtop:nv,iy)=tauxxx(mtop:nv) &
       &           *a_ext2(mtop:nv,iy,iac)/a_exty(iy,irh,itp)
            sump =   sum( wvd_y(mtop:nv,iy) )
            wvd_y(mtop:nv,iy) =  wvd_y(mtop:nv,iy) /sump
          enddo

          do ix = 1,mbx
            wvd_x(mtop:nv,ix)=tauxxx(mtop:nv) &
       &           *a_ext1(mtop:nv,ix,iac)/a_extx(ix,irh,itp)
            sump =   sum( wvd_x(mtop:nv,ix) )
            wvd_x(mtop:nv,ix) =  wvd_x(mtop:nv,ix) /sump
          enddo

        end select


! ----------------------------------------------------------------
!       Use weighted optical depths  to distribute our input 
!       column optical depths vertically and spectrally where needed.  
!       For bands with "measured" input, we simply do the weighting.  
!       For the remaining bands, we weight a!ording to our vertically 
!       distributed extinction coefficients (calculated in loop 30), 
!       which carry all the spectral resolution we need.  a_tau1 is for 
!       the 18 original bands, a_tau2 is for the 10 band 1 subintervals.
! ----------------------------------------------------------------
        VERTICAL : do  m=mtop,nv

          select case ( iaform )
        
          case(1)       ! For CERES

            a_tau1(m,1,iac)   = a_tau(1) * tauxxx(m)
            a_tau1(m,2:18,iac)= a_tau1(m,1,iac)* &
     &                 a_ext1(m,2:18,iac)/a_ext1(m,1,iac)

            a_tau2(m,9,iac)  = a_tau(1) * tauxxx(m)

            a_tau2(m,1:10,iac)=a_tau2(m,9,iac)* &
     &               a_ext2(m,1:10,iac)/a_ext2(m,9,iac)

          case(2)        ! For CAGEX

            a_tau1(m,1:2,iac) = tau3(1:2) * tauxxx(m)
            a_tau1(m,3:18,iac)=a_tau1(m,2,iac)*  &
     &                a_ext1(m,3:18,iac)/a_ext1(m,2,iac)

            a_tau2(m,7:10,iac) = tau3y(1:4) * tauxxx(m)
            a_tau2(m,1:6,iac)  = a_tau2(m,7,iac)*  &
     &                a_ext2(m,1:6,iac)/a_ext2(m,7,iac)

          case(3)       ! For AOT_SPLINEFIT


       
!      a_tau2(m,1:10,iac) = aotf(1:10)  * tauxxx(m)
            a_tau2(m,1:10,iac) = aotf(1:10)  * wvd_y(m,1:10)
!      a_tau1(m,1,iac)    = aotf(9)     * tauxxx(m)
            a_tau1(m,1,iac)    = aotf(9)     * wvd_x(m,1)
!      a_tau1(m,2:6,iac)  = aotf(11:15) * tauxxx(m)
            a_tau1(m,2:6,iac)  = aotf(11:15) * wvd_x(m,2:6)
            a_tau1(m,7:18,iac) =a_tau1(m,2,iac)* &
     &                 a_ext1(m,7:18,iac)/a_ext1(m,2,iac)

          end select

!      print'(3I4,2f8.2,16f7.3)', m,iac,itp,dz(m),rh(m),
!     & (wvd_y(m,iy),iy=1,10),(wvd_x(m,ix),ix=1,6)

        enddo VERTICAL


!------------------------------------------------------------------------------
!!!--- Diagnostic Output of Atau
!      do ii=1,10
!      xxx=0
!       do jj=1,nv
!       xxx =xxx+ a_tau2(jj,ii,iac)
!       enddo
!      aotf(ii)=xxx
!      enddo

!      do ii=2,6
!      xxx=0
!       do jj=1,nv
!       xxx =xxx+ a_tau1(jj,ii,iac)
!       enddo
!      aotf(9+ii)=xxx
!      enddo

!      write(22,'(a20,15f8.3)') 'AOT in Fu Bands',aotf(1:15)
      end if
      enddo AEROSOL_CONSTITUENTS

      return
      end subroutine

!===========================================================================
      subroutine aerosolxy ( ib,cmode,a_tau1,a_ssa1,a_asy1,    &
                             a_tau2,a_ssa2,a_asy2,tae,wae,wwae &
                           )
! *********************************************************************
!                      Modified 2/14/00
!
! tae, wae, and wwae are the optical depth, single scattering albedo,
! and expansion coefficients of the phase function ( 1, 2, 3, and 4 )
! due to the Mie scattering of aerosols for a given layer. 
!
!  This subroutine is called for bands 2 - 18 (ib) 
!  or vis subbands 1-10 (ig)
! *********************************************************************
!      USE RadParams
      use  fu_liou_gu_table, only: nv,nvx,mxac,               &
                                   ifg,ivd,iaform,n_atau,itps
      implicit none

      character*1 :: cmode
      integer     :: i,ib,iac
      real :: x1,x2,x3,x4,y1,y2,y3,y4
      real ,dimension(nvx,18,mxac) :: a_tau1,a_ssa1,a_asy1
      real ,dimension(nvx,10,mxac) :: a_tau2,a_ssa2,a_asy2
      real :: tae(nvx,mxac), wae(nvx,mxac), wwae(nvx,4,mxac)
     
      AEROSOL_CONSTITUENTS  : do iac=1,mxac
      if (itps(iac).eq.1) then

        LEVELS : do  i = 1, nv
          select case (cmode)
          case ('x')
            tae(i,iac) = a_tau1(i,ib,iac)
            wae(i,iac) = a_ssa1(i,ib,iac)
            x1         = a_asy1(i,ib,iac)
          case ('y')
            tae(i,iac) = a_tau2(i,ib,iac)
            wae(i,iac) = a_ssa2(i,ib,iac)
            x1         = a_asy2(i,ib,iac)
          end select

          x2 = x1 * x1
          x3 = x2 * x1
          x4 = x3 * x1
          y1 = 3.0 * x1
          y2 = 5.0 * x2
          y3 = 7.0 * x3
          y4 = 9.0 * x4
  
          wwae(i,1,iac) = y1
          wwae(i,2,iac) = y2
          wwae(i,3,iac) = y3
          wwae(i,4,iac) = y4

        enddo LEVELS
      end if
      enddo AEROSOL_CONSTITUENTS

      return
      end subroutine
!----------------------------------------------------------------
      real function spinhirne_sig(ht)
      implicit none
      real :: ht
      real :: sig0 = 0.025 , &
     &        a    = 0.4   , &
     &        ap   = 2981.0, &
     &        b    = 1.6   , &
     &        bp   = 2.5   , &
     &        f    = 1.5e-7
      real t1, t2, t3, t4, t5, t6
         t1=  sig0*(1+a)**2
         t4 = f*(1+ap)**2

         t2 = exp(ht/b)
         t3 = (a+exp(ht/b))**2
         t5 = exp(ht/bp)
         t6 = (a+exp(ht/bp))**2
         spinhirne_sig=t1*t2/t3+t4*t5/t6   ! scattering coefficient
      return
      end function spinhirne_sig
!---------------------------------------------
      real function spinhirne_tau(sig,ssa,dz)
      implicit none
      real sig, ssa, dz, ext
      ext = sig / ssa
      spinhirne_tau = ext / dz
      return
      end function spinhirne_tau
! --------- 4/1/97 (7) -- NEXT 1142 LINES -- Replaces old 
!                         aerosol1,aerosol2 block data.

!=========================================================================
      subroutine atau_spline_iaform3(wli,aoti,aotf,wlf,irh,itp)
      use  fu_liou_gu_table, only: wlo2=>wlo_5,hkas=>hkas_5,        &
                                   sflx=>sflx_5,nsub,nfuo,nwo,mxat
!      parameter(nsub=25,nfuo=15 ,nwo=nsub*nfuo)
!      common /aot_spect_25/ wlo2(25,15) , hkas(25,15) ,sflx (25,15)  !!! Higer resolution Convolution
      implicit none
      
      integer                    :: irh,itp
      real, dimension(mxat)      :: aoti, wli
      real, dimension(nwo)       :: aoto, wlo
      real, dimension(nsub,nfuo) :: aoto2
      real, dimension(15)        :: aotf, wlf
      
      integer :: ii, jj, kk, i, j
      real    :: zord
!      wlo = reshape(wlo2,(/nwo/))
      kk=0
      do jj=1,nfuo
        do ii=1,nsub
          kk=kk+1
          wlo(kk) = wlo2(ii,jj)
        enddo
      enddo

      call aot_ext &
     &   (aoti,wli,wlo,aoto,irh,itp)

!      aoto2 = reshape(aoto,(/5,15/))
      kk=0
      do jj=1,nfuo
        do ii=1,nsub
          kk=kk+1
          aoto2(ii,jj)=aoto(kk)
        enddo
      enddo


      wlf=0.0 ; aotf =0.0
      zord = 0.0
      do j=1,nfuo
        do i = 1,nsub
          wlf(j) =  wlf(j)+  wlo2(i,j) * hkas(i,j)
          aotf(j)= aotf(j)+ aoto2(i,j) * hkas(i,j)
          zord = zord + sflx (i,j)*exp(-aoto2(i,j)) 
        enddo
      enddo

!-  WRITE OUT interpolated AOTs
      
!      do i=1,nwo
!      write(11) d1,d2,wlo(i),aoto(i),float(irec),log(wlo(i)),log(aoto(i)),float(ityp)
!      enddo
!      print'(A6,f10.3, 3i4)','FLUX= ',zord ,nsub,ityp,irh
      return
      end subroutine
!----------------------------------------------------------------
      subroutine aot_ext (aotin,wlin,wlo,aoto,irh,ityp)
      use  fu_liou_gu_table, only: mxat,nwin=>n_atau,                &
                                   nwo,wld=>wl_dalm,datd=>dat_dalm,  &
     &                             wlt=>wl_mineral,datt=>dat_mineral,&
     &                             wlopac=>wl,datopac=>edat
      implicit none

      integer                   :: irh,ityp
      real ,dimension(mxat)     :: aotin,wlin
!      real ,allocatable,dimension(-100:100) :: aoti,wlix
      real ,dimension(-100:100) :: aoti,wlix
      real ,dimension(nwo)      :: aoto,wlo
      real ,dimension(24)       :: wlp,extp
      integer :: idtl, nes, nel, nb, nwi, iend, i, nq
      integer :: ne = 24
      real :: ext_norm1, ext_norm0
      
!      Wavelengths in MICRONS
!      wlix,aoti = Monotonically increasing


!     aerosol-type-dependent parameters for later uses
      idtl=-1
      if(ityp>= 1.and.ityp<=3)then ! d'Almedia
        wlp=wld
        extp = datd(:,irh,ityp)
        idtl=1
      elseif(ityp>=4.and.ityp<=8)then ! Tegen&Lacis
        wlp  = wlt
        extp = datt(:,ityp)
        idtl=2
      elseif(ityp>=9.and.ityp<=18)then ! OPAC 
        wlp  = wlopac
        if(ityp==10.or.ityp==12.or.ityp==13.or.ityp==18)then
          extp = datopac(:,irh,ityp)
        else
          extp = datopac(:,  1,ityp)
        endif
        idtl=3
      else
        stop ' Bad Aerosol type'
      endif

!     wavelength-dependent parameters
      if(nwin==1)then
        ! nes=-3; nel=19                 ! 1 chan @ 500nm
        if(wlin(1)<=.325.or.wlin(1)>=.675) &
     &                                  stop' OUT OF ALLOWABLE ARANGE'
        nes=-(wlin(1)-0.325)/0.05; 
        if(idtl==3) nes=nes-1  ! OPAC starts at 0.25um instead of 0.30
        nel=22+nes
        ! print*,'NES NEL',nes,nel,wlin(1)
      else
        nes=0  
        if(idtl==1)then         !  >= 2um long d'Almedia
          nel=8
        elseif(idtl==2)then    !  >= 2um long Tegin&Lacis
          nel=11
        elseif(idtl==3)then    !  >= 2um long OPAC
          nel=7
        endif
      endif

      nb=ne+1-nel
      nwi=nwin+nel-nes+1
      iend=nwin+nel

!     if(allocated (aoti) ) deallocate ( aoti )
!     allocate( aoti(nes:iend) )

!     if ( allocated (wlix) ) deallocate ( wlix)
!     allocate(  wlix(nes:iend) )
!     if(icall == 2) stop

      wlix(1:nwin)=wlin(1:nwin)
      aoti(1:nwin)=aotin(1:nwin)


      LONGSIDE: do i=1,ne
        if(wlix(nwin)>=wlp(i).and.wlix(nwin)<=wlp(i+1))then
          ext_norm1=rlnintrp(wlp(i),wlp(i+1),extp(i),extp(i+1), &
     &                                              wlix(nwin))
          ! print*,dy,dx,dx1,yy,ext_norm1
          exit LONGSIDE
        endif
      enddo LONGSIDE
      !wlix(nwin+1:nwi)=wlp(nb:ne)
      !aoti(nwin+1:nwi)=aoti(nwin)*(extp(nb:ne)/ext_norm1)
      wlix(nwin+1:iend)=wlp(nb:ne)
      aoti(nwin+1:iend)=aoti(nwin)*(extp(nb:ne)/ext_norm1)

      if(nwin==1)then
        ! print*,1,wlix(1),aoti(1)
        SHORTSIDE: do i=1,ne
          if(wlix(1)>=wlp(i).and.wlix(1)<=wlp(i+1))then
            ext_norm0= rlnintrp( wlp(i),wlp(i+1), &
     &                 extp(i),extp(i+1),wlix(1))
            ! print*,dy,dx,dx1,yy,ext_norm0
            exit SHORTSIDE
          endif
        enddo SHORTSIDE
        nq=-nes+1
        wlix(nes:0)=wlp(1:nq)
        aoti(nes:0)=aoti(1)*(extp(1:nq)/ext_norm0)
      else
        wlix(0)=0.001
        aoti(0)=1
      endif

!     print'(a18,40f7.3)','Wavelength input= ',wlix(nes:iend)
!     print'(a18,40f7.3)','       AOT input= ',aoti(nes:iend)

!      do i=nes,iend
!      write(10) d1,d2,wlix(i),aoti(i),float(irec),log(wlix(i)),log(aoti(i)),float(ityp)
!      enddo

      call aotspline(nwi,aoti(nes:iend),wlix(nes:iend),wlo,aoto)

!      print'(a18,500f7.3)','Wavelength Out= ',wlo
!      print'(a18,500f7.3)','       AOT Out= ',aoto


      return
      end subroutine
!===================================================================
!===================================================================
      real function rlnintrp(x1,x2,y1,y2, x)
      implicit none
      real :: x, x1, x2, y1, y2, dx, dy, dx1, yy
      dx= log(x2) - log(x1)
      dy= log(y2) - log(y1)
      dx1=log(x)  - log(x1)
      yy= (dy/dx) * dx1
      rlnintrp = exp(log(y1)+yy) 
      return
      end function
!====================================================================
      subroutine aotspline(nwi,aoti,wli,wlo,aoto)
      use  fu_liou_gu_table, only: nwo
      implicit none
      
      integer :: nwi
      real ,dimension(nwi)  :: aoti,wli
      real ,dimension(nwi+1):: xa,ya,y2a
      real ,dimension(nwo)  :: aoto,wlo,aa
      integer :: nwi2, iwo
      real    :: x, y
      real    :: yp1 = 1.0E+32, ypn = 1.0E+32
      
      nwi2=nwi+1

      xa(2:nwi+1)=log(wli(1:nwi))
      ya(2:nwi+1)=log(aoti(1:nwi))
      xa(1)=log(1.0E-6) !; xa(nwi2)=log(1.0E+6) !TENSION
      ya(1)=0           !; ya(nwi2)= ya(nwi+1)!TENSION      

      call spline(xa,ya,nwi2,yp1,ypn,y2a)

      do iwo = 1,nwo
        x=log(wlo(iwo))
        call splint(xa,ya,y2a,nwi2,x,y)
        aoto(iwo)=exp(y) 
      enddo        

      return
      end subroutine
!------------------------------------------------------
      real function alphav(aot1,aot2,wl1,wl2)
      implicit none
      real :: aot1, aot2, wl1, wl2, ar, wr
      ar= aot1/aot2
      wr= wl1/wl2
      alphav = - log(ar)/ log(wr)
      return
      end function
!---------------------------------------------------------------
      SUBROUTINE spline(x,y,n,yp1,ypn,y2)
      implicit none
      INTEGER :: n
      REAL    :: yp1,ypn,x(n),y(n),y2(n)
      INTEGER :: i,k
      REAL    :: p,qn,sig,un,u(500)
      
      if (yp1.gt..99e30) then
        y2(1)=0.
        u(1)=0.
      else
        y2(1)=-0.5
        u(1)=(3./(x(2)-x(1)))*((y(2)-y(1))/(x(2)-x(1))-yp1)
      endif
      do i=2,n-1
        sig=(x(i)-x(i-1))/(x(i+1)-x(i-1))
        p=sig*y2(i-1)+2.
        y2(i)=(sig-1.)/p
        u(i)=(6.*((y(i+1)-y(i))/(x(i+1)- &
     &        x(i))-(y(i)-y(i-1))/(x(i)-x(i-1)))/(x(i+1)-x(i-1))- &
     &        sig*u(i-1))/p
11    end do
      if (ypn.gt..99e30) then
        qn=0.
        un=0.
      else
        qn=0.5
        un=(3./(x(n)-x(n-1)))*(ypn-(y(n)-y(n-1))/(x(n)-x(n-1)))
      endif
      y2(n)=(un-qn*u(n-1))/(qn*y2(n-1)+1.)
      do k=n-1,1,-1
        y2(k)=y2(k)*y2(k+1)+u(k)
12    end do
      return
      END SUBROUTINE
!  (!) Copr. 1986-92 Numerical Recipes Software .
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE splint(xa,ya,y2a,n,x,y)
      implicit none
      INTEGER :: n
      REAL    :: x,y,xa(n),y2a(n),ya(n)
      INTEGER :: k,khi,klo
      REAL    :: a,b,h
      klo=1
      khi=n
      do while (khi-klo.gt.1)
        k=(khi+klo)/2
        if(xa(k).gt.x)then
          khi=k
        else
          klo=k
        endif
      end do
      h=xa(khi)-xa(klo)
      if (h.eq.0.) stop 'bad xa input in splint'
      a=(xa(khi)-x)/h
      b=(x-xa(klo))/h
      y=a*ya(klo)+b*ya(khi)+((a**3-a)*y2a(klo)+(b**3-b)*y2a(khi))*(h** &
     &  2)/6.
      return
      END subroutine
!  (!) Copr. 1986-92 Numerical Recipes Software .
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE polint(xa,ya,n,x,y,dy)
      implicit none
      INTEGER :: n
      REAL    :: dy,x,y,xa(n),ya(n)
      INTEGER :: i,m,ns
      REAL    :: den,dif,dift,ho,hp,w,c(10),d(10)
      ns=1
      dif=abs(x-xa(1))
      do i=1,n
        dift=abs(x-xa(i))
        if (dift.lt.dif) then
          ns=i
          dif=dift
        endif
        c(i)=ya(i)
        d(i)=ya(i)
11    end do
      y=ya(ns)
      ns=ns-1
      do m=1,n-1
        do i=1,n-m
          ho=xa(i)-x
          hp=xa(i+m)-x
          w=c(i+1)-d(i)
          den=ho-hp
          if(den.eq.0.)stop 'failure in polint'
          den=w/den
          d(i)=hp*den
          c(i)=ho*den
12      end do
        if (2*ns.lt.n-m)then
          dy=c(ns+1)
        else
          dy=d(ns)
          ns=ns-1
        endif
        y=y+dy
13    end do
      return
      END SUBROUTINE
!  (!) Copr. 1986-92 Numerical Recipes Software .
!=============================================================

      subroutine ql_rh(rh,tl,pl,ql)
      implicit none
      real :: rh, tl, pl, ql
      real :: es, ws
!      rh (0-100)
!      tl (K)
!      pl (mb)
!      q (g/g)

      es=satvap(tl)
      ws=0.622*es/(pl-es)
      rh= ql/ws *100.
      return
      end subroutine

      real function satvap(temp2)
      implicit none
      real :: temp2, temp, toot, toto, eilog, tsot,  &
     &        ewlog, ewlog2, ewlog3, ewlog4
      temp = temp2-273.155
      if (temp.lt.-20.) then   !!!! ice saturation
        toot = 273.16 / temp2
        toto = 1 / toot
        eilog = -9.09718 * (toot - 1) - 3.56654 * (log(toot) / &
     &    log(10.)) + .876793 * (1 - toto) + (log(6.1071) / log(10.))
        satvap = 10 ** eilog
      else
        tsot = 373.16 / temp2
        ewlog = -7.90298 * (tsot - 1) + 5.02808 * &
     &             (log(tsot) / log(10.))
        ewlog2 = ewlog - 1.3816e-07 * &
     &             (10 ** (11.344 * (1 - (1 / tsot))) - 1)
        ewlog3 = ewlog2 + .0081328 * &
     &             (10 ** (-3.49149 * (tsot - 1)) - 1)
        ewlog4 = ewlog3 + (log(1013.246) / log(10.))
        satvap = 10 ** ewlog4
      end if
      return
      end function


      subroutine gases_new ( ib, ig1, ig2, hk,pp,pt,ph,po,tg )
! *********************************************************************
! tg(nv) are the optical depthes due to nongray gaseous absorption, in
! nv layers for a given band ib and cumulative probability ig. 
! *********************************************************************
      use  fu_liou_gu_table, only:nv1,nv,             &
                        &  umco2,umch4,umn2o,umo2,      & 
                        &  umno,umso2,umno2,umch3cl,     &
                        &  umco,no2s,umCFC11,umCFC12,    &
                        &  nco2s,nso2s,nch4s,nnol,       &
                        &  nno2l,nso2l,nch3cll,ncos,     &
                        &  nn2os,nh2ocs,nh2os,no3s,      &
                        &  nh2ol,no3l,nco2l,nn2ol,       &
                        &  nch4l,nCFC11l,nCFC12l,        &
                        &  hk1=>hk_1_new,fk1o3=>fko3_1_new, &
                        &  hk2=>hk_2_new,c2hh2=>coehh22_2_new, &
                        &  c2o2=>coeo2_2_new,c2h2o=>coeh2o_2_new, &
                        &  hk3=>hk_3_new,c3hh2=>coehh32_3_new, &
                        &  c3h2o=>coeh2o_3_new, &
                        &  hk4=>hk_4_new,c4hh2=>coehh42_4_new, &
                        &  c4co2=>coeco2_4_new,c4co=>coeco_4_new, &
                        &  c4h2o=>coeh2o_4_new, &
                        &  hk5=>hk_5_new,c5hh2=>coehh52_5_new, &
                        &  c5co2=>coeco2_5_new,c5n2o=>coen2o_5_new, &
                        &  c5ch4=>coech4_5_new,c5h2o=>coeh2o_5_new, &
                        &  hk6=>hk_6_new,c6hh2=>coehh62_6_new,  &
                        &  c6so2=>coeso2_6_new,c6h2o=>coeh2o_6_new, &
                        &  hk7=>hk_7_new,c7h2o=>coeh2o_7_new, &
                        &  hk8=>hk_8_new,c8h2o=>coeh2o_8_new, &
                        &  c8no=>coeno_8_new, &
                        &  hk9=>hk_9_new,c9h2o=>coeh2o_9_new, &
                        &  c9no2=>coeno2_9_new, &
                        &  hk10=>hk_10_new,c10h2o=>coeh2o_10_new, &
                        &  c10ch4=>coech4_10_new,c10n2o=>coen2o_10_new, &
                        &  c10so2=>coeso2_10_new, &
                        &  hk11=>hk_11_new,c11h2o=>coeh2o_11_new, &
                        &  c11ch4=>coech4_11_new,c11n2o=>coen2o_11_new, &
                        &  c11CFC11=>c11CFC11_11_new, &
                        &  c11CFC12=>c11CFC12_11_new, &
                        &  hk12=>hk_12_new,c12o3=>coeo3_12_new, &
                        &  c12h2o=>coeh2o_12_new, &
                        &  c12CFC11=>c12CFC11_12_new, &
                        &  c12CFC12=>c12CFC12_12_new, &
                        &  hk13=>hk_13_new,c13h2o=>coeh2o_13_new, &
                        &  c13CFC11=>c13CFC11_13_new, &
                        &  c13CFC12=>c13CFC12_13_new, &
                        &  hk14=>hk_14_new,c14hca=>coehca_14_new, &
                        &  c14hcb=>coehcb_14_new, &
                        &  c14ch3cl=>coech3cl_14_new, &
                        &  hk15=>hk_15_new,c15hca=>coehca_15_new, &
                        &  c15hcb=>coehcb_15_new, &
                        &  hk16=>hk_16_new,c16h2o=>coeh2o_16_new, &
                        &  hk17=>hk_17_new,c17h2o=>coeh2o_17_new, &
                        &  hk18=>hk_18_new,c18h2o=>coeh2o_18_new
      implicit none
                          
      
      real, dimension(nv1) :: pp, pt, ph, po
      real    :: tg(nv)
      integer :: ib, ig, ig1, ig2
      real    :: hk
      
      real, dimension(nv1) :: fkg, fkga, fkgb, fkgc, fkgd, fkge,  &
     &                        pq, fkg1
      real, dimension(nv)  :: tg1, tg2, tg3, tg4, tg5
      real    :: fk
      integer :: i
 
      select case(ib)
      case default
        stop
      case(1)
1       ig=ig1
        if(no3s.eq.1) then
          fk = fk1o3(ig)
          call qopo3s ( fk,tg,pp,pt,ph,po )
!        write(*,*)'tg=',tg
        else
          do i=1,nv
            tg(i)=0.0
          end do
        end if
        hk = 619.618 * hk1(ig)
! In this band ( 50000 - 14500 cm**-1 ), we have considered the nongray
! gaseous absorption of O3.    619.618 is the solar energy contained in
! the band in units of Wm**-2.
      case(2)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2nd --- 6 nd bands have been changed by Z.F.in Jun.,2003 
!
2       do i=1,nv1
          fkg(i)=0.0
        end do
        call qks ( c2hh2(1,1,ig1), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkgb(i)*ph(i)
        end do
        call qophc ( fkg, tg1,pp,pt,ph,po )
        call qks(c2o2(1,1,ig2),fkgb,pp,pt,ph,po )
        call qopo2 (fkgb, tg2,pp,pt,ph,po )
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)*umo2/2.0948E+05
        end do
        hk = 484.295 * hk2(ig1)*hk2(ig2)
! In this band ( 14500 - 7700 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.  484.295 is the solar energy contained in
! the band in units of Wm**-2.
      case(3)
3       ig=ig1
        do i=1,nv1
          fkg(i)=0.0
        end do
        call qks ( c3hh2(1,1,ig), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkgb(i)*ph(i)
        end do
        call qophc ( fkg, tg,pp,pt,ph,po)
        hk = 149.845 * hk3(ig)
! In this band ( 7700 - 5250 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 149.845 is the solar energy contained in
! the band in units of Wm**-2.
      case(4)
4       do i=1,nv1
          fkg(i)=0.0
        end do
        call qks ( c4hh2(1,1,ig1), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkgb(i)*ph(i)
        end do
        call qophc ( fkg, tg1,pp,pt,ph,po)
        call qks ( c4co2(1,1,ig2), fkgb,pp,pt,ph,po )
        call qopco2(fkgb,tg2,pp,pt,ph,po)
        call qks(c4co,fkgc,pp,pt,ph,po)
        call qopco(fkgc,tg3,pp,pt,ph,po)
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)/330.*umco2+tg3(i)/0.16*umco
        end do
        hk = 48.7302 * hk4(ig1)*hk4(ig2)
! In this band ( 5250 - 4000 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 48.7302 is the solar energy contained in
! the band in units of Wm**-2.
      case(5)
5       do i=1,nv1
          fkg(i)=0.0
        end do
        call qks ( c5hh2(1,1,ig1), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkgb(i)*ph(i)
        end do
        call qophc ( fkg, tg1,pp,pt,ph,po)
        call qks ( c5co2(1,1,ig2), fkgb,pp,pt,ph,po )
        call qopco2(fkgb,tg2,pp,pt,ph,po)
        call qks(c5n2o,fkgc,pp,pt,ph,po)
        call qopn2o(fkgc,tg3,pp,pt,ph,po)
        call qks(c5ch4,fkgd,pp,pt,ph,po)
        call qopch4(fkgd,tg4,pp,pt,ph,po)
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)/330.*umco2+tg3(i)/0.28*umn2o+ &
         &      tg4(i)/1.6*umch4
        end do
        hk = 31.6576 * hk5(ig1)*hk5(ig2)
! In this band ( 4000 - 2850 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 31.6576 is the solar energy contained in
! the band in units of Wm**-2.
      case(6)
6       ig=ig1
        do i=1,nv1
          fkg(i)=0.0
        end do
        call qks ( c6hh2(1,1,ig), fkgb,pp,pt,ph,po )
        do i = 1, nv1
          fkg(i) = fkgb(i)*ph(i)
        end do
        call qophc ( fkg, tg1,pp,pt,ph,po)
        call qks(c6so2,fkgb,pp,pt,ph,po)
        call qopso2(fkgb,tg2,pp,pt,ph,po)
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)/0.001*umso2
        end do
        hk = 5.79927 * hk6(ig)
! In this band ( 2850 - 2500 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O. 5.79927 is the solar energy contained in
! the band in units of Wm**-2.
      case(7)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!cZ.F.
7       ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c7h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg,pp,pt,ph,po )
        else
          do i=1,nv
            tg(i)=0.0
          end do
        end if
        hk = hk7(ig)
! In this band ( 2200 - 1900 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(8)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 8th---10th bands have been changed by Z.F. in Jun.2003
!
8       ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c8h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        call qki(c8no,fkgb,pp,pt,ph,po)
        call qopno(fkgb,tg2,pp,pt,ph,po)
!      print *, 'band 8, no, tg1=, tg2=', tg1,tg2
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)*umno/0.0005
        end do
        hk = hk8(ig)
! In this band ( 1900 - 1700 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(9)
9       ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c9h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        call qki(c9no2,fkgb,pp,pt,ph,po)
        call qopno(fkgb,tg2,pp,pt,ph,po)
!      print *, 'band 9, no, tg2=', tg1, tg2
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)*umno2/0.001
        end do
        hk = hk9(ig)
! In this band ( 1700 - 1400 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(10)
10      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c10h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        if(nch4l.eq.1) then
          call qki ( c10ch4, fkg,pp,pt,ph,po )
          call qopch4 ( fkg, tg2,pp,pt,ph,po )
        else
          do i=1,nv
            tg2(i)=0.0
          end do
        end if
        if(nn2ol.eq.1) then
          call qki ( c10n2o, fkg,pp,pt,ph,po )
          call qopn2o ( fkg, tg3,pp,pt,ph,po )
        else
          do i=1,nv
            tg3(i)=0.0
          end do
        end if
        call qki(c10so2,fkgb,pp,pt,ph,po)
        call qopso2(fkgb,tg4,pp,pt,ph,po)
        do i=1,nv
          tg(i) = tg1(i) + tg2(i)/1.6*umch4 + tg3(i)/0.28*umn2o &
         &       +tg4(i)/0.001*umso2
        end do
        hk = hk10(ig)
! In this band ( 1400 - 1250 cm**-1 ), we have considered the overlapping
! absorption of H2O, CH4, and N2O by approach one of Fu(1991).
! In this band ( 1400 - 1250 cm**-1 ), we have considered the overlapping
! absorption of H2O, CH4, and N2O by approach one of Fu(1991).
      case(11)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Z.F.
11      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c11h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        if(nch4l.eq.1) then 
          call qki ( c11ch4, fkg,pp,pt,ph,po )
          call qopch4 ( fkg, tg2,pp,pt,ph,po )
        else
          do i=1,nv
            tg2(i)=0.0
          end do
        end if
        if(nn2ol.eq.1) then
          call qki ( c11n2o, fkg,pp,pt,ph,po )
          call qopn2o ( fkg, tg3,pp,pt,ph,po )
        else
          do i=1,nv
            tg3(i)=0.0
          end do
        end if
        if(nCFC11l.eq.1) then
          call qopCFC11(c11CFC11,tg4,pp,pt,ph,po)
        else
          do i=1,nv
            tg4(i)=0.0
          enddo
        end if
        if(nCFC12l.eq.1) then
          call qopCFC12(c11CFC12,tg5,pp,pt,ph,po)
        else
          do i=1,nv
            tg5(i)=0.0
          enddo
        end if
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i)/1.6*umch4 + tg3(i)/0.28*umn2o + &
         &        tg4(i)/0.22e-3*umCFC11 + tg5(i)/0.375e-3*umCFC12         
        end do
        hk = hk11(ig)
! In this band ( 1250 - 1100 cm**-1 ), we have considered the overlapping
! absorption of H2O, CH4, N2O, CFC11 and CFC12  by approach one of Fu(1991).
      case(12)
12      ig=ig1
        if(no3l.eq.1) then
          call qkio3 ( c12o3(1,1,ig), fkg,pp,pt,ph,po )
          call qopo3i ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        if(nh2ol.eq.1) then 
          call qki ( c12h2o, fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg2,pp,pt,ph,po )
        else
          do i=1,nv
            tg2(i)=0.0
          end do
        end if
        if(nCFC11l.eq.1) then
          call qopCFC11(c12CFC11,tg3,pp,pt,ph,po)
        else
          do i=1,nv
            tg3(i)=0.0
          enddo
        end if
        if(nCFC12l.eq.1) then
          call qopCFC12(c12CFC12,tg4,pp,pt,ph,po)
        else
          do i=1,nv
            tg4(i)=0.0
          enddo
        end if
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i) + tg3(i)/0.22e-3*umCFC11 &
         &       +tg4(i)/0.375e-3*umCFC12
        end do
        hk = hk12(ig)
! In this band ( 1100 - 980 cm**-1 ), we have considered the overlapping
! absorption of H2O and O3, CFC11, CFC12 by approach one of Fu(1991).
      case(13)
13      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c13h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg1,pp,pt,ph,po )
        else
          do i=1,nv
            tg1(i)=0.0
          end do
        end if
        if(nCFC11l.eq.1) then
          call qopCFC11(c13CFC11,tg2,pp,pt,ph,po)
        else
          do i=1,nv
            tg2(i)=0.0
          enddo
        end if
        if(nCFC12l.eq.1) then
          call qopCFC12(c13CFC12,tg3,pp,pt,ph,po)
        else
          do i=1,nv
            tg3(i)=0.0
          enddo
        end if
        do i = 1, nv
          tg(i) = tg1(i) + tg2(i)/0.22e-3*umCFC11 + &
         &        tg3(i)/0.375e-3*umCFC12
      enddo
      hk = hk13(ig)
! In this band ( 980 - 800 cm**-1 ), we have considered the overlapping 
! absorption of H2O, CFC11 and CFC12 by approach one of fu (1991).
      case(14)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!c
! 14th band has been changed by Z.F. in Jun,2003
!
14      ig=ig1
        do i = 1, nv1
          if ( pp(i) .ge. 63.1 ) then
            pq(i) = ph(i)
          else
            pq(i) = 0.0
          endif
333     end do
        if(nco2l.eq.1) then
          call qki ( c14hca(1,1,ig), fkga,pp,pt,ph,po )
        else
          do i=1,nv1
            fkga(i)=0.0
          end do
        end if
        if(nh2ol.eq.1) then
          call qki ( c14hcb(1,1,ig), fkgb,pp,pt,ph,po )
        else
          do i=1,nv1
            fkgb(i)=0.0
          end do
        end if
        do i = 1, nv1
          fkg(i) = fkga(i)/330.0*umco2 + pq(i) * fkgb(i)
343     end do
        call qophc ( fkg, tg1,pp,pt,ph,po)
        call qki(c14ch3cl,fkgb,pp,pt,ph,po)
        call qopch3cl(fkgb,tg2,pp,pt,ph,po)
        do i=1,nv
          tg(i)=tg1(i)+tg2(i)*umch3cl/0.5e-3
        end do
        hk = hk14(ig)
! In this band ( 800 - 670 cm**-1), we have considered the overlapping
! absorption of H2O and CO2 by approach two of Fu(1991).
      case(15)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Z.F.
15      ig=ig1
        do i = 1, nv1
          if ( pp(i) .ge. 63.1 ) then
            pq(i) = ph(i)
          else
            pq(i) = 0.0
          endif
353     end do
        if(nco2l.eq.1) then
          call qki ( c15hca(1,1,ig), fkga,pp,pt,ph,po )
        else
          do i=1,nv1
            fkga(i)=0.0
          end do
        end if
        if(nh2ol.eq.1) then
          call qki ( c15hcb(1,1,ig), fkgb,pp,pt,ph,po )
        else
          do i=1,nv1
            fkgb(i)=0.0
          end do
        end if
        do i = 1, nv1
          fkg(i) = fkga(i)/330.0*umco2 + pq(i) * fkgb(i)
363     end do
        call qophc ( fkg, tg,pp,pt,ph,po)
        hk = hk15(ig)
! In this band ( 670 - 540 cm**-1), we have considered the overlapping
! absorption of H2O and CO2 by approach two of Fu(1991).
      case(16)
16      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c16h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg,pp,pt,ph,po )
        else
          do i=1,nv
            tg(i)=0.0
          end do
        end if
        hk = hk16(ig)
! In this band ( 540 - 400 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(17)
17      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c17h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg,pp,pt,ph,po )
        else
          do i=1,nv
            tg(i)=0.0
          end do
        end if
        hk = hk17(ig)
! In this band ( 400 - 280 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
      case(18)
18      ig=ig1
        if(nh2ol.eq.1) then
          call qki ( c18h2o(1,1,ig), fkg,pp,pt,ph,po )
          call qoph2o ( fkg, tg,pp,pt,ph,po )
        else
          do i=1,nv
            tg(i)=0.0
          end do
        end if
        hk = hk18(ig)
! In this band ( 280 - 000 cm**-1 ), we have considered the nongray
! gaseous absorption of H2O.
20    end select
      return
      end subroutine

end module fu_liou_gu
