################################################
# PARAMETERS FOR TEMPORAL DIFFUSION MODEL RUN
# TD --> TEMPORAL DIFFUSION
##############################################
run_ID = 'TD_run'

###########################
# SPATIAL GRID
'''
H --> total depth
dz --> vertical spacing
z --> grid
N --> number of vertical levels
'''
############################
H = 1 
dz = 0.01
################################
# TEMPORAL GRID
'''
tend_days ---> number of days 
               to run simulation
dt --> time step (seconds)
'''
################################
tend_days =3/86400. 
dt = 1./100
###############################


##################################
# DIFFUSION COEFFICIENT
'''
Kv    ---> vertical mixing coefficient (m^2/s)
Kv0   ---> base amplitude of vertical mixing

DIFFERENT CHOICES FOR TEMPORAL SHAPE
OF MIXING (Kv_time_choice)
1) 'sine'--> sine wave
'''
##################################
Kv_time_choice ='sine'
Kv0 = (H**2) / 10.
Kdiff = Kv0
omega = (2*np.pi) 
phase_shift = np.pi/2


################################
# INITIAL CONDITION v(z,t=0)
'''
SYMM_ZERO --> linear, symmetric about zero
              profile
'''
###############################
v_IC_choice = 'SYMM_ZERO'
v0 = 1 


##########################
# FORCING TERM
'''
F(t,z) --> forcing term on R.H.S.
'''
###########################
F0 = 0.




