#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine v3dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for ETA-component velocity
! v(:,:,:,nnew) 
!
      implicit none
      integer istr,iend,jstr,jend, i,j,k
      real grad(PRIVATE_2D_SCRATCH_ARRAY), cff,eps,
     &      cx,cy, dft,dfx,dfy, tau,tau_in,tau_out
      parameter (eps=1.E-20)
# include "param.h"
# include "grid.h"
# include "ocean3d.h"
# include "climat.h"
# include "scalars.h"
# include "boundary.h"
!
# include "compute_auxiliary_bounds.h"
!
# if defined M3_FRC_BRY || defined M3NUDGING
      tau_in=dt*tauM_in
      tau_out=dt*tauM_out
# endif

# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
#  ifdef OBC_SOUTH
#   ifdef OBC_M3ORLANSKI
        do k=1,N                            ! Southern edge radiation
          do i=istr,iend+1                  ! ======== ==== =========
            grad(i,jstr  )=(v(i,jstr  ,k,nstp)-v(i-1,jstr  ,k,nstp))
#    ifdef MASKING
     &                                                *pmask(i,jstr)
#    endif
            grad(i,jstr+1)=(v(i,jstr+1,k,nstp)-v(i-1,jstr+1,k,nstp))
#    ifdef MASKING
     &                                              *pmask(i,jstr+1)
#    endif
          enddo
          do i=istr,iend
            dft=v(i,jstr+1,k,nstp)-v(i,jstr+1,k,nnew)
            dfx=v(i,jstr+1,k,nnew)-v(i,jstr+2,k,nnew)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                      ! <-- cancel cx, if inflow
#    if defined M3_FRC_BRY || defined M3NUDGING
              tau=tau_in
            else
              tau=tau_out
#    endif
            endif
 
            if (dft*(grad(i,jstr+1)+grad(i+1,jstr+1)) .gt. 0.) then
              dfy=grad(i,jstr+1)
            else
              dfy=grad(i+1,jstr+1)
            endif
 
#    ifdef OBC_RAD_NORMAL
            dfy=0.
#    endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#    ifdef OBC_RAD_NPO
            cy=0.
#    else
            cy=min(cff,max(dft*dfy,-cff))
#    endif
 
            v(i,jstr,k,nnew)=( cff*v(i,jstr,k,nstp)
     &                        +cx*v(i,jstr+1,k,nnew)
     &                    -max(cy,0.)*grad(i  ,jstr)
     &                    -min(cy,0.)*grad(i+1,jstr)
     &                                   )/(cff+cx)
#    if defined M3_FRC_BRY  || defined M3NUDGING 
            v(i,jstr,k,nnew)=(1.-tau)*v(i,jstr,k,nnew)
#     ifdef M3_FRC_BRY
     &                               +tau*v_south(i,k)
#     else     
     &                             +tau*vclm(i,jstr,k)
#     endif
#    endif
#    ifdef MASKING
            v(i,jstr,k,nnew)=v(i,jstr,k,nnew)*vmask(i,jstr)
#    endif
          enddo
        enddo
#   else           /* alternative open */
        do k=1,N
          do i=istr,iend
#    ifdef OBC_M3SPECIFIED
            v(i,jstr,k,nnew)=vclm(i,jstr,k)      ! specified
#    else
            v(i,jstr,k,nnew)=v(i,jstr+1,k,nnew)  ! gradient (default)
#    endif
#    ifdef MASKING
     &                           *vmask(i,jstr)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                               ! Southern edge closed
          do i=istr,iend                       ! ======== ==== ======
            v(i,jstr,k,nnew)=0.                !  (no-flux: default)
          enddo
        enddo
#  endif              /* OBC_SOUTH */
      endif         !<-- SOUTHERN_EDGE
 
 
 
      if (NORTHERN_EDGE) then
#  ifdef OBC_NORTH
#   ifdef OBC_M3ORLANSKI
        do k=1,N                            ! Northern edge radiation
          do i=istr,iend+1                  ! ======== ==== =========
            grad(i,jend  )=(v(i,jend  ,k,nstp)-v(i-1,jend  ,k,nstp))
#    ifdef MASKING
     &                                                *pmask(i,jend)
#    endif
            grad(i,jend+1)=(v(i,jend+1,k,nstp)-v(i-1,jend+1,k,nstp))
#    ifdef MASKING
     &                                              *pmask(i,jend+1)
#    endif
          enddo
          do i=istr,iend
            dft=v(i,jend,k,nstp)-v(i,jend  ,k,nnew)
            dfx=v(i,jend,k,nnew)-v(i,jend-1,k,nnew)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                       ! <-- cancel cx, if inflow
#    if defined M3_FRC_BRY || defined M3NUDGING
              tau=tau_in
            else
              tau=tau_out
#    endif
            endif
 
            if (dft*(grad(i,jend)+grad(i+1,jend)) .gt. 0.) then
              dfy=grad(i,jend)
            else
              dfy=grad(i+1,jend)
            endif
 
#    ifdef OBC_RAD_NORMAL
            dfy=0.
#    endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#    ifdef OBC_RAD_NPO
            cy=0.
#    else
            cy=min(cff,max(dft*dfy,-cff))
#    endif
 
            v(i,jend+1,k,nnew)=( cff*v(i,jend+1,k,nstp)
     &                              +cx*v(i,jend,k,nnew)
     &                      -max(cy,0.)*grad(i  ,jend+1)
     &                      -min(cy,0.)*grad(i+1,jend+1)
     &                                      )/(cff+cx)
#    if defined M3_FRC_BRY  || defined M3NUDGING 
            v(i,jend+1,k,nnew)=(1.-tau)*v(i,jend+1,k,nnew)
#     ifdef M3_FRC_BRY
     &                                   +tau*v_north(i,k)
#     else     
     &                               +tau*vclm(i,jend+1,k)
#     endif
#    endif
#    ifdef MASKING
            v(i,jend+1,k,nnew)=v(i,jend+1,k,nnew)*vmask(i,jend+1)
#    endif
          enddo
        enddo
#   else                /* alternative open */
        do k=1,N
          do i=istr,iend
#    ifdef OBC_M3SPECIFIED
            v(i,jend+1,k,nnew)=vclm(i,jend+1,k)  ! specified
#    else
            v(i,jend+1,k,nnew)=v(i,jend,k,nnew)  ! gradient (default)
#    endif
#    ifdef MASKING
     &                         *vmask(i,jend+1)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                               ! Northern edge closed
          do i=istr,iend                       ! ======== ==== ======
            v(i,jend+1,k,nnew)=0.              !   (no-flux: default)
          enddo
        enddo
#  endif
      endif     !<--  NORTHERN_EDGE
# endif          /* !NS_PERIODIC */
 
 
 
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
#  ifdef OBC_WEST
#   ifdef OBC_M3ORLANSKI
        do k=1,N                             ! Western edge radiation
          do j=jstrV-1,jend                  ! ======= ==== =========
            grad(istr-1,j)=v(istr-1,j+1,k,nstp)-v(istr-1,j,k,nstp)
            grad(istr  ,j)=v(istr  ,j+1,k,nstp)-v(istr  ,j,k,nstp)
          enddo
          do j=jstrV,jend
            dft=v(istr,j,k,nstp)-v(istr  ,j,k,nnew)
            dfx=v(istr,j,k,nnew)-v(istr+1,j,k,nnew)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                       ! <-- cancel cx, if inflow
#    if defined M3_FRC_BRY || defined M3NUDGING
              tau=tau_in
            else
              tau=tau_out
#    endif
            endif
 
            if (dft*(grad(istr,j-1)+grad(istr,j)) .gt. 0.) then
              dfy=grad(istr,j-1)
            else
              dfy=grad(istr,j  )
            endif
 
#    ifdef OBC_RAD_NORMAL
            dfy=0.
#    endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#    ifdef OBC_RAD_NPO
            cy=0.
#    else
            cy=min(cff,max(dft*dfy,-cff))
#    endif
 
            v(istr-1,j,k,nnew)=( cff*v(istr-1,j,k,nstp)
     &                              +cx*v(istr,j,k,nnew)
     &                      -max(cy,0.)*grad(istr-1,j-1)
     &                      -min(cy,0.)*grad(istr-1,j  )
     &                                       )/(cff+cx)
#    if defined M3_FRC_BRY  || defined M3NUDGING 
            v(istr-1,j,k,nnew)=(1.-tau)*v(istr-1,j,k,nnew)
#     ifdef M3_FRC_BRY
     &                                    +tau*v_west(j,k)
#     else     
     &                               +tau*vclm(istr-1,j,k)
#     endif
#    endif
#    ifdef MASKING
            v(istr-1,j,k,nnew)=v(istr-1,j,k,nnew)*vmask(istr-1,j)
#    endif
          enddo
        enddo
#   else
        do k=1,N
          do j=jstrV,jend
#    ifdef OBC_M3SPECIFIED
            v(istr-1,j,k,nnew)=vclm(istr-1,j,k)  ! specified
#    else
            v(istr-1,j,k,nnew)=v(istr,j,k,nnew)  ! gradient (default)
#    endif
#    ifdef MASKING
     &                         *vmask(istr-1,j)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef NS_PERIODIC
#    define J_RANGE jstrV,jend
#   else
#    define J_RANGE jstr,jendR
#   endif
        do k=1,N                        ! Wall: free-slip (gamma2=+1)
          do j=J_RANGE                  ! =====   no-slip (gamma2=-1)
            v(istr-1,j,k,nnew)=gamma2*v(istr,j,k,nnew)
#   ifdef MASKING
     &                                *vmask(istr-1,j)
#   endif
          enddo
        enddo
#   undef J_RANGE
#  endif
      endif          !<-- WESTERN_EDGE
 
 
 
      if (EASTERN_EDGE) then
#  ifdef OBC_EAST
#   ifdef OBC_M3ORLANSKI
        do k=1,N                             ! Eastern edge radiation
          do j=jstrV-1,jend                  ! ======= ==== =========
            grad(iend  ,j)=v(iend  ,j+1,k,nstp)-v(iend  ,j,k,nstp)
            grad(iend+1,j)=v(iend+1,j+1,k,nstp)-v(iend+1,j,k,nstp)
          enddo
          do j=jstrV,jend
            dft=v(iend,j,k,nstp)-v(iend  ,j,k,nnew)
            dfx=v(iend,j,k,nnew)-v(iend-1,j,k,nnew)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                       ! <-- cancel cx, if inflow
#    if defined M3_FRC_BRY || defined M3NUDGING
              tau=tau_in
            else
              tau=tau_out
#    endif
            endif
 
            if (dft*(grad(iend,j-1)+grad(iend,j)) .gt. 0.) then
              dfy=grad(iend,j-1)
            else
              dfy=grad(iend,j  )
            endif
 
#    ifdef OBC_RAD_NORMAL
            dfy=0.
#    endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#    ifdef OBC_RAD_NPO
            cy=0.
#    else
            cy=min(cff,max(dft*dfy,-cff))
#    endif
 
            v(iend+1,j,k,nnew)=( cff*v(iend+1,j,k,nstp)
     &                              +cx*v(iend,j,k,nnew)
     &                      -max(cy,0.)*grad(iend+1,j-1)
     &                      -min(cy,0.)*grad(iend+1,j  )
     &                                       )/(cff+cx)
#    if defined M3_FRC_BRY  || defined M3NUDGING 
            v(iend+1,j,k,nnew)=(1.-tau)*v(iend+1,j,k,nnew)
#     ifdef M3_FRC_BRY
     &                                    +tau*v_east(j,k)
#     else     
     &                               +tau*vclm(iend+1,j,k)
#     endif
#    endif
#    ifdef MASKING
            v(iend+1,j,k,nnew)=v(iend+1,j,k,nnew)*vmask(iend+1,j)
#    endif
          enddo
        enddo
#   else               /* alternative open */
        do k=1,N
          do j=jstr,jend
#    ifdef OBC_M3SPECIFIED
            v(iend+1,j,k,nnew)=vclm(iend+1,j,k)  ! specified
#    else
            v(iend+1,j,k,nnew)=v(iend,j,k,nnew)  ! gradient (default)
#    endif
#    ifdef MASKING
     &                         *vmask(iend+1,j)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef NS_PERIODIC
#    define J_RANGE jstrV,jend
#   else
#    define J_RANGE jstr,jendR
#   endif
        do k=1,N                        ! Wall: free-slip (gamma2=+1)
          do j=J_RANGE                  ! ====    no-slip (gamma2=-1)
            v(iend+1,j,k,nnew)=gamma2*v(iend,j,k,nnew)
#   ifdef MASKING
     &                                *vmask(iend+1,j)
#   endif
          enddo
        enddo
#   undef J_RANGE
#  endif
      endif     !<-- EASTERN_EDGE
# endif          /* !EW_PERIODIC */
 
                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========
 
# if defined OBC_SOUTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        do k=1,N
          v(istr-1,jstr,k,nnew)=0.5*( v(istr-1,jstr+1,k,nnew)
     &                               +v(istr  ,jstr  ,k,nnew))
        enddo
      endif
# endif
# if defined OBC_SOUTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        do k=1,N
          v(iend+1,jstr,k,nnew)=0.5*( v(iend+1,jstr+1,k,nnew)
     &                               +v(iend  ,jstr  ,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        do k=1,N
          v(istr-1,jend+1,k,nnew)=0.5*( v(istr-1,jend,k,nnew)
     &                                 +v(istr,jend+1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        do k=1,N
          v(iend+1,jend+1,k,nnew)=0.5*( v(iend+1,jend,k,nnew)
     &                                 +v(iend,jend+1,k,nnew))
        enddo
      endif
# endif
      return
      end
#else
      subroutine v3dbc_empty
      end
#endif /* SOLVE3D */
 
