#include "cppdefs.h"
 
      subroutine v2dbc (tile)
      implicit none
      integer tile
#include "param.h"
#include "private_scratch.h"
#include "compute_tile_bounds.h"
      call v2dbc_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine v2dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for the barotropic (i.e.
! vertically integrated) ETA-component velocity vbar(:,:,knew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps,cff,
     &                           cx,cy, dft,dfx,dfy
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "scalars.h"
#include "climat.h"
!
#include "compute_auxiliary_bounds.h"
!
#ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then            ! Southern edge radiation BC
# ifdef OBC_SOUTH
#  ifdef OBC_M2ORLANSKI
        do i=istr,iend+1
          grad(i,jstr  )=(vbar(i,jstr  ,kstp)-vbar(i-1,jstr  ,kstp))
#   ifdef MASKING
     &                                                *pmask(i,jstr)
#   endif
          grad(i,jstr+1)=(vbar(i,jstr+1,kstp)-vbar(i-1,jstr+1,kstp))
#   ifdef MASKING
     &                                              *pmask(i,jstr+1)
#   endif
        enddo
        do i=istr,iend
          dft=vbar(i,2,kstp)-vbar(i,2,knew)
          dfx=vbar(i,2,kstp)-vbar(i,3,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i,2)+grad(i+1,2)) .gt. 0.) then
            dfy=grad(i  ,2)
          else
            dfy=grad(i+1,2)
          endif
 
 
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(i,1,knew)=( (1.-cx)*vbar(i,1,kstp)+cx*vbar(i,2,kstp)
     &                                       -max(cy,0.)*grad(i  ,1)
     &                                       -min(cy,0.)*grad(i+1,1)
     &                                                             )
#   ifdef MASKING
     &                                              *vmask(i,1)
#   endif
        enddo
#  else
        do i=istr,iend                    ! Northern edge gradient BC
          vbar(i,1,knew)=vbar(i,2,knew)   ! ======== ==== ======== ==
#   ifdef MASKING
     &                       *vmask(i,1)
#   endif
        enddo
#  endif
# else
        do i=istrR,iendR
          vbar(i,jstrV-1,knew)=0.   ! Southern edge normal no-flux BC
        enddo                       ! ======== ==== ====== ======= ==
# endif          /* OBC_SOUTH */
      endif      !<-- SOUTHERN_EDGE
 
 
      if (NORTHERN_EDGE) then            ! Northern edge radiation BC
# ifdef OBC_NORTH
#  ifdef OBC_M2ORLANSKI
        do i=istr,iend+1
          grad(i,jend  )=(vbar(i,jend  ,kstp)-vbar(i-1,jend  ,kstp))
#   ifdef MASKING
     &                                                *pmask(i,jend)
#   endif
          grad(i,jend+1)=(vbar(i,jend+1,kstp)-vbar(i-1,jend+1,kstp))
#   ifdef MASKING
     &                                              *pmask(i,jend+1)
#   endif
        enddo
        do i=istr,iend
          dft=vbar(i,jend,kstp)-vbar(i,jend,knew)
          dfx=vbar(i,jend,kstp)-vbar(i,jend-1,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i,jend)+grad(i+1,jend)) .gt. 0.) then
            dfy=grad(i  ,jend)
          else
            dfy=grad(i+1,jend)
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(i,jend+1,knew)=( (1.-cx)*vbar(i,jend+1,kstp)
     &                                       +cx*vbar(i,jend,kstp)
     &                                  -max(cy,0.)*grad(i  ,jend+1)
     &                                  -min(cy,0.)*grad(i+1,jend+1)
     &                                                           )
#   ifdef MASKING
     &                                 *vmask(i,jend+1)
#   endif
        enddo
#  else                                   ! Northern edge gradient BC
        do i=istr,iend                    ! ======== ==== ======== ==
          vbar(i,jend+1,knew)=vbar(i,jend,knew)
#   ifdef MASKING
     &                       *vmask(i,jend+1)
#   endif
        enddo
#  endif
# else
        do i=istrR,iendR
          vbar(i,jend+1,knew)=0.    ! Northern edge normal no-flux BC
        enddo                       ! ======== ==== ====== ======= ==
# endif                  /* OBC_NORTH */
      endif         !<--  NORTHERN_EDGE
#endif               /* !NS_PERIODIC */
 
 
 
#ifndef EW_PERIODIC
      if (WESTERN_EDGE) then              ! Western edge radiation BC
# ifdef OBC_WEST
#  ifdef OBC_M2ORLANSKI
        do j=jstrV-1,jend
          grad(0,j)=(vbar(0,j+1,kstp)-vbar(0,j,kstp))
          grad(1,j)=(vbar(1,j+1,kstp)-vbar(1,j,kstp))
        enddo
        do j=jstrV,jend
          dft=vbar(1,j,kstp)-vbar(1,j,knew)
          dfx=vbar(1,j,kstp)-vbar(2,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(1,j-1)+grad(1,j)) .gt. 0.) then
            dfy=grad(1,j-1)
          else
            dfy=grad(1,j  )
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(0,j,knew)=( (1.-cx)*vbar(0,j,kstp)+cx*vbar(1,j,kstp)
     &                                        -max(cy,0.)*grad(0,j-1)
     &                                        -min(cy,0.)*grad(0,j  )
     &                                                              )
#   ifdef MASKING
     &                                            *vmask(0,j)
#   endif
        enddo
#  else
        do j=jstrV,jend                    ! Western edge gradient BC
          vbar(0,j,knew)=vbar(1,j,knew)    ! ======= ==== ======== ==
#   ifdef MASKING
     &                      *vmask(0,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_TANG_RANGE jstrV,jend
#  else
#   define J_TANG_RANGE jstr,jendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do j=J_TANG_RANGE          ! ====== ===   no-slip (gamma2=-1)
          vbar(0,j,knew)=gamma2*vbar(1,j,knew)
#  ifdef MASKING
     &                             *vmask(0,j)
#  endif
        enddo
#  undef J_TANG_RANGE
# endif              /* OBC_WEST */
      endif        !<-- WESTERN_EDGE
 
 
      if (EASTERN_EDGE) then              ! Eastern edge radiation BC
# ifdef OBC_EAST
#  ifdef OBC_M2ORLANSKI
        do j=jstrV-1,jend
          grad(iend  ,j)=vbar(iend  ,j+1,kstp)-vbar(iend  ,j,kstp)
          grad(iend+1,j)=vbar(iend+1,j+1,kstp)-vbar(iend+1,j,kstp)
        enddo
        do j=jstrV,jend
          dft=vbar(iend,j,kstp)-vbar(iend  ,j,knew)
          dfx=vbar(iend,j,kstp)-vbar(iend-1,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(iend,j-1)+grad(iend,j)) .gt. 0.) then
            dfy=grad(iend,j-1)
          else
            dfy=grad(iend,j  )
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(iend+1,j,knew)=( (1.-cx)*vbar(iend+1,j,kstp)
     &                                       +cx*vbar(iend,j,kstp)
     &                                  -max(cy,0.)*grad(iend+1,j-1)
     &                                  -min(cy,0.)*grad(iend+1,j  )
     &                                                           )
#   ifdef MASKING
     &                                 *vmask(iend+1,j)
#   endif
        enddo
#  else                                    ! Eastern edge gradient BC
        do j=jstrV,jend                    ! ======= ==== ======== ==
          vbar(iend+1,j,knew)=vbar(iend,j,knew)
#   ifdef MASKING
     &                        *vmask(iend+1,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_TANG_RANGE jstrV,jend
#  else
#   define J_TANG_RANGE jstr,jendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do j=J_TANG_RANGE          ! ====== ===   no-slip (gamma2=-1)
          vbar(iend+1,j,knew)=gamma2*vbar(iend,j,knew)
#  ifdef MASKING
     &                       *vmask(iend+1,j)
#  endif
        enddo
#  undef J_TANG_RANGE
# endif                  /* OBC_EAST */
      endif            !<-- EASTERN_EDGE
#endif               /* !EW_PERIODIC */
 
                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========
   
#if defined OBC_SOUTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        vbar(istr-1,jstr,knew)=0.5*( vbar(istr-1,jstr+1,knew)
     &                              +vbar(istr  ,jstr  ,knew))
      endif
#endif
#if defined OBC_SOUTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        vbar(iend+1,jstr,knew)=0.5*( vbar(iend+1,jstr+1,knew)
     &                              +vbar(iend  ,jstr  ,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    NORTHERN_EDGE) then               
        vbar(istr-1,jend+1,knew)=0.5*( vbar(istr-1,jend,knew)
     &                                +vbar(istr,jend+1,knew))
      endif
#endif    
#if defined OBC_NORTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        vbar(iend+1,jend+1,knew)=0.5*( vbar(iend+1,jend,knew)
     &                                +vbar(iend,jend+1,knew))
      endif
#endif      
      return
      end
 
