#include "cppdefs.h"
 
      subroutine u2dbc (tile)
      implicit none
      integer tile
#include "param.h"
#include "private_scratch.h"
#include "compute_tile_bounds.h"
      call u2dbc_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine u2dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for the barotropic (i.e.
! vertically integrated) XI-component velocity ubar(:,:,knew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps,cff,
     &                           cx,cy, dft,dfx,dfy
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "scalars.h"
#include "climat.h"
!
#include "compute_auxiliary_bounds.h"
!
#ifndef EW_PERIODIC
      if (WESTERN_EDGE) then              ! Western edge radiation BC
# ifdef OBC_WEST
#  ifdef OBC_M2ORLANSKI
        do j=jstr,jend+1
          grad(istr  ,j)=(ubar(istr  ,j,kstp)-ubar(istr  ,j-1,kstp))
#   ifdef MASKING
     &                                                *pmask(istr,j)
#   endif
          grad(istr+1,j)=(ubar(istr+1,j,kstp)-ubar(istr+1,j-1,kstp))
#   ifdef MASKING
     &                                              *pmask(istr+1,j)
#   endif
        enddo
        do j=jstr,jend
          dft=ubar(istrU,j,kstp)-ubar(istrU ,j,knew)
          dfx=ubar(istrU,j,kstp)-ubar(istrU+1,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(istrU,j)+grad(istrU,j+1)) .gt. 0.) then
            dfy=grad(istrU,j  )
          else
            dfy=grad(istrU,j+1)
          endif
 
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=min(dft*dfx, cff)
          cy=min(cff, max(dft*dfy,-cff))
 
          ubar(istrU-1,j,knew)=( (cff-cx)*ubar(istrU-1,j,kstp)
     &                                   +cx*ubar(istrU,j,kstp)
     &       -max(cy,0.)*grad(istr,j)-min(cy,0.)*grad(istr,j+1)
     &                                                    )/cff
#   ifdef MASKING
     &                                             *umask(1,j)
#   endif
        enddo
#  else
        do j=jstr,jend                        ! Western edge gradient
          ubar(istr,j,knew)=ubar(istrU,j,knew)! ======= ==== ========
#   ifdef MASKING
     &                          *umask(istr,j)
#   endif
        enddo
#  endif
# else
        do j=jstrR,jendR
          ubar(istrU-1,j,knew)=0.    ! Western edge normal no-flux BC
        enddo                        ! ======= ==== ====== ======= ==
# endif           /* OBC_WEST */
      endif       !<-- WESTERN_EDGE
 
 
      if (EASTERN_EDGE) then              ! Eastern edge radiation BC
# ifdef OBC_EAST
#  ifdef OBC_M2ORLANSKI
        do j=jstr,jend+1
          grad(iend  ,j)=(ubar(iend  ,j,kstp)-ubar(iend  ,j-1,kstp))
#   ifdef MASKING
     &                                                *pmask(iend,j)
#   endif
          grad(iend+1,j)=(ubar(iend+1,j,kstp)-ubar(iend+1,j-1,kstp))
#   ifdef MASKING
     &                                              *pmask(iend+1,j)
#   endif
        enddo
        do j=jstr,jend
          dft=ubar(Lm,j,kstp)-ubar(Lm,j,knew)
          dfx=ubar(Lm,j,kstp)-ubar(Lm-1,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(Lm,j)+grad(Lm,j+1)) .gt. 0.) then
            dfy=grad(Lm,j)
          else
            dfy=grad(Lm,j+1)
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          ubar(Lm+1,j,knew)=( (1.-cx)*ubar(Lm+1,j,kstp)
     &                                      +cx*ubar(Lm,j,kstp)
     &                                  -max(cy,0.)*grad(Lm+1,j  )
     &                                  -min(cy,0.)*grad(Lm+1,j+1)
     &                                                           )
#   ifdef MASKING
     &                                   *umask(Lm+1,j)
#   endif
        enddo
#  else                                    ! Eastern edge gradient BC
        do j=jstr,jend                     ! ======= ==== ======== ==
          ubar(Lm+1,j,knew)=ubar(Lm,j,knew)
#   ifdef MASKING
     &                       *umask(Lm+1,j)
#   endif
        enddo
#  endif
# else
        do j=jstrR,jendR
          ubar(Lm+1,j,knew)=0.       ! Eastern edge normal no-flux BC
        enddo                        ! ======= ==== ====== ======= ==
# endif                   /* OBC_EAST */
      endif            !<-- EASTERN_EDGE
#endif               /* !EW_PERIODIC */
 
 
 
#ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then            ! Southern edge radiation BC
# ifdef OBC_SOUTH
#  ifdef OBC_M2ORLANSKI
        do i=istrU-1,iend
          grad(i,0)=(ubar(i+1,0,kstp)-ubar(i,0,kstp))
          grad(i,1)=(ubar(i+1,1,kstp)-ubar(i,1,kstp))
        enddo
        do i=istrU,iend
          dft=ubar(i,1,kstp)-ubar(i,1,knew)
          dfx=ubar(i,1,kstp)-ubar(i,2,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i-1,1)+grad(i,1)) .gt. 0.) then
            dfy=grad(i-1,1)
          else
            dfy=grad(i  ,1)
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          ubar(i,0,knew)=( (1.-cx)*ubar(i,0,kstp)+cx*ubar(i,1,kstp)
     &                                        -max(cy,0.)*grad(i-1,0)
     &                                        -min(cy,0.)*grad(i  ,0)
     &                                                              )
#   ifdef MASKING
     &                                               *umask(i,0)
#   endif
        enddo
#  else
        do i=istrU,iend                   ! Northern edge gradient BC
          ubar(i,0,knew)=ubar(i,1,knew)   ! ======== ==== ======== ==
#   ifdef MASKING
     &                       *umask(i,0)
#   endif
        enddo
#  endif
# else
#  ifdef EW_PERIODIC
#   define I_TANG_RANGE istrU,iend
#  else
#   define I_TANG_RANGE istr,iendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do i=I_TANG_RANGE          ! ====== ===   no-slip (gamma2=-1)
          ubar(i,0,knew)=gamma2*ubar(i,1,knew)
#  ifdef MASKING
     &                             *umask(i,0)
#  endif
        enddo
#  undef I_TANG_RANGE
# endif              /* OBC_SOUTH */
      endif          !<-- SOUTHERN_EDGE
 
 
      if (NORTHERN_EDGE) then            ! Northern edge radiation BC
# ifdef OBC_NORTH
#  ifdef OBC_M2ORLANSKI
        do i=istrU-1,iend
          grad(i,Mm)=(ubar(i+1,Mm,kstp)-ubar(i,Mm,kstp))
          grad(i,Mm+1)=(ubar(i+1,Mm+1,kstp)-ubar(i,Mm+1,kstp))
        enddo
        do i=istrU,iend
          dft=ubar(i,Mm,kstp)-ubar(i,Mm,knew)
          dfx=ubar(i,Mm,kstp)-ubar(i,Mm-1,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i-1,Mm)+grad(i,Mm)) .gt. 0.) then
            dfy=grad(i-1,Mm)
          else
            dfy=grad(i  ,Mm)
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          ubar(i,Mm+1,knew)=( (1.-cx)*ubar(i,Mm+1,kstp)
     &                                    +cx*ubar(i,Mm,kstp)
     &                              -max(cy,0.)*grad(i-1,Mm+1)
     &                              -min(cy,0.)*grad(i  ,Mm+1)
     &                                                       )
#   ifdef MASKING
     &                                 *umask(i,Mm+1)
#   endif
        enddo
#  else                                   ! Northern edge gradient BC
        do i=istrU,iend                   ! ======== ==== ======== ==
          ubar(i,Mm+1,knew)=ubar(i,Mm,knew)
#   ifdef MASKING
     &                       *umask(i,Mm+1)
#   endif
        enddo
#  endif
# else
#  ifdef EW_PERIODIC
#   define I_TANG_RANGE istrU,iend
#  else
#   define I_TANG_RANGE istr,iendR
#  endif                          !  Closed BC: free-slip (gamma2=+1)
        do i=I_TANG_RANGE         !  ====== ===   no-slip (gamma2=-1)
          ubar(i,Mm+1,knew)=gamma2*ubar(i,Mm,knew)
#  ifdef MASKING
     &                              *umask(i,Mm+1)
#  endif
        enddo
#  undef I_TANG_RANGE
# endif                  /* OBC_NORTH */
      endif           !<-- NORTHERN_EDGE
#endif               /* !NS_PERIODIC */
 
                                              ! Open corners (if any)
                                              ! ==== ======= === ====
 
#if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        ubar(1,0,knew)=0.5*(ubar(2,0,knew)+ubar(1,1,knew))
      endif
#endif
#if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        ubar(Lm+1,0,knew)=0.5*(ubar(Lm,0,knew)+ubar(Lm+1,1,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        ubar(1,Mm+1,knew)=0.5*(ubar(2,Mm+1,knew)+ubar(1,Mm,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        ubar(Lm+1,Mm+1,knew)=0.5*(ubar(Lm  ,Mm+1,knew)
     &                           +ubar(Lm+1,Mm  ,knew))
      endif
#endif
      return
      end
 
