#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine t3dbc_tile (istr,iend,jstr,jend, itrc, grad)
!
! Set lateral boundary conditions for tracer field t(:,:,:,itrc)
!
      implicit none
      integer istr,iend,jstr,jend, itrc, i,j,k
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps, cff,
     &       cx,cy, dft,dfx,dfy, tau,tau_in,tau_out
      parameter (eps=1.E-20)
# include "param.h"
# include "grid.h"
# include "ocean3d.h"
# include "climat.h"
# include "scalars.h"
# include "boundary.h"
!
# include "compute_auxiliary_bounds.h"
!
# if defined T_FRC_BRY || defined TNUDGING
      tau_in=dt*tauT_in
      tau_out=dt*tauT_out
# endif

# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
#  if defined OBC_WEST && defined OBC_TORLANSKI
        do k=1,N
          do j=jstr,jend+1
            grad(istr-1,j)=( t(istr-1,j  ,k,nstp,itrc)
     &                      -t(istr-1,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                 *vmask(istr-1,j)
#   endif
            grad(istr  ,j)=( t(istr  ,j  ,k,nstp,itrc)
     &                      -t(istr  ,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                   *vmask(istr,j)
#   endif
          enddo
          do j=jstr,jend
            dft=t(istr,j,k,nstp,itrc)-t(istr  ,j,k,nnew,itrc)
            dfx=t(istr,j,k,nnew,itrc)-t(istr+1,j,k,nnew,itrc)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                  ! <-- cancel, if inflow 
#   if defined T_FRC_BRY || defined TNUDGING
              tau=tau_in
            else
              tau=tau_out
#   endif
            endif
 
            if (dft*(grad(istr,j)+grad(istr,j+1)) .gt. 0.) then
              dfy=grad(istr,j)
            else
              dfy=grad(istr,j+1)
            endif
 
#   ifdef OBC_RAD_NORMAL
            dfy=0.
#   endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#   ifdef OBC_RAD_NPO
            cy=0.
#   else
            cy=min(cff,max(dft*dfy,-cff))
#   endif
            t(istr-1,j,k,nnew,itrc)=( cff*t(istr-1,j,k,nstp,itrc)
     &                                   +cx*t(istr,j,k,nnew,itrc)
     &                                -max(cy,0.)*grad(istr-1,j  )
     &                                -min(cy,0.)*grad(istr-1,j+1)
     &                                                 )/(cff+cx)
#   if defined T_FRC_BRY || defined TNUDGING
            t(istr-1,j,k,nnew,itrc)=(1.-tau)*t(istr-1,j,k,nnew,itrc)
#    ifdef T_FRC_BRY
     &                                    +tau*t_west(j,k,itrc)     
#    else
     &                                    +tau*tclm(istr-1,j,k,itrc)
#    endif
#   endif
#   ifdef MASKING
            t(istr-1,j,k,nnew,itrc)=t(istr-1,j,k,nnew,itrc)
     &                                      *rmask(istr-1,j)
#   endif
          enddo
        enddo
#  else
        do k=1,N
          do j=jstr,jend
#   if defined OBC_WEST && defined OBC_TSPECIFIED
            t(istr-1,j,k,nnew,itrc)=tclm(istr-1,j,k,itrc)
#   else
            t(istr-1,j,k,nnew,itrc)=t(istr,j,k,nnew,itrc)
#   endif
#   ifdef MASKING
     &                                   *rmask(istr-1,j)
#   endif
          enddo
        enddo
#  endif
      endif     ! <-- WESTERN_EDGE


      if (EASTERN_EDGE) then
#  if defined OBC_EAST && defined OBC_TORLANSKI
!
!                                        !  Eastern edge radiation BC
        do k=1,N                         !  ======= ==== ========= ==
          do j=jstr,jend+1
           grad(iend  ,j)=( t(iend  ,j  ,k,nstp,itrc)
     &                     -t(iend  ,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                  *vmask(iend,j)
#   endif
           grad(iend+1,j)=( t(iend+1,j  ,k,nstp,itrc)
     &                     -t(iend+1,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                *vmask(iend+1,j)
#   endif
          enddo
          do j=jstr,jend
            dft=t(iend,j,k,nstp,itrc)-t(iend  ,j,k,nnew,itrc)
            dfx=t(iend,j,k,nnew,itrc)-t(iend-1,j,k,nnew,itrc)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                  ! <-- cancel, if inflow 
#   if defined T_FRC_BRY || defined TNUDGING
              tau=tau_in
            else
              tau=tau_out
#   endif
            endif
 
            if (dft*(grad(iend,j)+grad(iend,j+1)) .gt. 0.) then
              dfy=grad(iend,j)
            else
              dfy=grad(iend,j+1)
            endif
 
#   ifdef OBC_RAD_NORMAL
            dfy=0.
#   endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#   ifdef OBC_RAD_NPO
            cy=0.
#   else
            cy=min(cff,max(dft*dfy,-cff))
#   endif
 
            t(iend+1,j,k,nnew,itrc)=( cff*t(iend+1,j,k,nstp,itrc)
     &                                   +cx*t(iend,j,k,nnew,itrc)
     &                                -max(cy,0.)*grad(iend+1,j  )
     &                                -min(cy,0.)*grad(iend+1,j+1)
     &                                                 )/(cff+cx)
#   if defined T_FRC_BRY || defined TNUDGING
            t(iend+1,j,k,nnew,itrc)=(1.-tau)*t(iend+1,j,k,nnew,itrc)
#    ifdef T_FRC_BRY
     &                                         +tau*t_east(j,k,itrc)
#    else
     &                                    +tau*tclm(iend+1,j,k,itrc)
#    endif
#   endif
#   ifdef MASKING
            t(iend+1,j,k,nnew,itrc)=t(iend+1,j,k,nnew,itrc)
     &                                     *rmask(iend+1,j)
#   endif
          enddo
        enddo
#  else
        do k=1,N
          do j=jstr,jend
#   if defined OBC_EAST && defined OBC_TSPECIFIED
            t(iend+1,j,k,nnew,itrc)=tclm(iend+1,j,k,itrc)
#   else
            t(iend+1,j,k,nnew,itrc)=t(iend,j,k,nnew,itrc)
#   endif
#   ifdef MASKING
     &                                   *rmask(iend+1,j)
#   endif
          enddo
        enddo
#  endif
      endif    ! <-- EASTERN_EDGE
# endif        /* !EW_PERIODIC */

 
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
#  if defined OBC_SOUTH && defined OBC_TORLANSKI
        do k=1,N
          do i=istr,iend+1
            grad(i,jstr  )=( t(i  ,jstr  ,k,nstp,itrc)
     &                      -t(i-1,jstr  ,k,nstp,itrc))
#   ifdef MASKING
     &                                   *umask(i,jstr)
#   endif
            grad(i,jstr-1)=( t(i  ,jstr-1,k,nstp,itrc)
     &                      -t(i-1,jstr-1,k,nstp,itrc))
#   ifdef MASKING
     &                                *umask(i,jstr-1)
#   endif
          enddo
          do i=istr,iend
            dft=t(i,jstr,k,nstp,itrc)-t(i,jstr  ,k,nnew,itrc)
            dfx=t(i,jstr,k,nnew,itrc)-t(i,jstr+1,k,nnew,itrc)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                   ! <-- cancel, if inflow 
#   if defined T_FRC_BRY || defined TNUDGING
              tau=tau_in
            else
              tau=tau_out
#   endif
            endif
 
            if (dft*(grad(i,jstr)+grad(i+1,jstr)) .gt. 0.) then
              dfy=grad(i,jstr)
            else
              dfy=grad(i+1,jstr)
            endif
 
#   ifdef OBC_RAD_NORMAL
            dfy=0.
#   endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#   ifdef OBC_RAD_NPO
            cy=0.
#   else
            cy=min(cff,max(dft*dfy,-cff))
#   endif
 
            t(i,jstr-1,k,nnew,itrc)=( cff*t(i,jstr-1,k,nstp,itrc)
     &                                   +cx*t(i,jstr,k,nnew,itrc)
     &                                -max(cy,0.)*grad(i  ,jstr-1)
     &                                -min(cy,0.)*grad(i+1,jstr-1)
     &                                                 )/(cff+cx)
#   if defined T_FRC_BRY || defined TNUDGING
            t(i,jstr-1,k,nnew,itrc)=(1.-tau)*t(i,jstr-1,k,nnew,itrc)
#    ifdef T_FRC_BRY
     &                                        +tau*t_south(i,k,itrc)
#    else
     &                                    +tau*tclm(i,jstr-1,k,itrc)
#    endif
#   endif
#   ifdef MASKING
            t(i,jstr-1,k,nnew,itrc)=t(i,jstr-1,k,nnew,itrc)
     &                                     *rmask(i,jstr-1)
#   endif
          enddo
        enddo
#  else
        do k=1,N
          do i=istr,iend
#   if defined OBC_SOUTH && defined OBC_TSPECIFIED
            t(i,jstr-1,k,nnew,itrc)=tclm(i,jstr-1,k,itrc)
#   else
            t(i,jstr-1,k,nnew,itrc)=t(i,jstr,k,nnew,itrc)
#   endif
#   ifdef MASKING
     &                                   *rmask(i,jstr-1)
#   endif
          enddo
        enddo
#  endif
      endif    ! <-- SOUTHERN_EDGE


      if (NORTHERN_EDGE) then
#  if defined OBC_NORTH && defined OBC_TORLANSKI
        do k=1,N
          do i=istr,iend+1
            grad(i,jend  )=( t(i  ,jend  ,k,nstp,itrc)
     &                      -t(i-1,jend  ,k,nstp,itrc))
#   ifdef MASKING
     &                                   *umask(i,jend)
#   endif
            grad(i,jend+1)=( t(i  ,jend+1,k,nstp,itrc)
     &                      -t(i-1,jend+1,k,nstp,itrc))
#   ifdef MASKING
     &                                 *umask(i,jend+1)
#   endif
          enddo
          do i=istr,iend
            dft=t(i,jend,k,nstp,itrc)-t(i,jend  ,k,nnew,itrc)
            dfx=t(i,jend,k,nnew,itrc)-t(i,jend-1,k,nnew,itrc)
 
            if (dfx*dft .lt. 0.) then
              dft=0.                          ! <-- cancel, if inflow 
#   if defined T_FRC_BRY || defined TNUDGING
              tau=tau_in
            else
              tau=tau_out
#   endif
            endif
 
            if (dft*(grad(i,jend)+grad(i+1,jend)) .gt. 0.) then
              dfy=grad(i,jend)
            else
              dfy=grad(i+1,jend)
            endif
 
#   ifdef OBC_RAD_NORMAL
            dfy=0.
#   endif
            cff=max(dfx*dfx+dfy*dfy, eps)
            cx=dft*dfx
#   ifdef OBC_RAD_NPO
            cy=0.
#   else
            cy=min(cff,max(dft*dfy,-cff))
#   endif
            t(i,jend+1,k,nnew,itrc)=( cff*t(i,jend+1,k,nstp,itrc)
     &                                 +cx*t(i,jend  ,k,nnew,itrc)
     &                                -max(cy,0.)*grad(i  ,jend+1)
     &                                -min(cy,0.)*grad(i+1,jend+1)
     &                                                 )/(cff+cx)
#   if defined T_FRC_BRY || defined TNUDGING
            t(i,jend+1,k,nnew,itrc)=(1.-tau)*t(i,jend+1,k,nnew,itrc)
#    ifdef T_FRC_BRY
     &                                        +tau*t_north(i,k,itrc)
#    else
     &                                    +tau*tclm(i,jend+1,k,itrc)
#    endif
#   endif
#   ifdef MASKING
            t(i,jend+1,k,nnew,itrc)=t(i,jend+1,k,nnew,itrc)
     &                                     *rmask(i,jend+1)
#   endif
          enddo
        enddo
#  else
        do k=1,N
          do i=istr,iend
#   if defined OBC_NORTH && defined OBC_TSPECIFIED
            t(i,jend+1,k,nnew,itrc)=tclm(i,jend+1,k,itrc)
#   else
            t(i,jend+1,k,nnew,itrc)=t(i,jend,k,nnew,itrc)
#   endif
#   ifdef MASKING
     &                                   *rmask(i,jend+1)
#   endif
          enddo
        enddo
#  endif
      endif    ! <-- NORTHERN_EDGE
# endif /* ! NS_PERIODIC */

                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========

# if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and.
     &     WESTERN_EDGE) then
        do k=1,N
          t(istr-1,jstr-1,k,nnew,itrc)=0.5*( t(istr,jstr-1,k,nnew,
     &                           itrc)+t(istr-1,jstr,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and.
     &    EASTERN_EDGE) then
        do k=1,N
          t(iend+1,jstr-1,k,nnew,itrc)=0.5*(t(iend,jstr-11,k,nnew,
     &                           itrc)+t(iend+1,jstr,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and.
     &    WESTERN_EDGE) then
        do k=1,N
          t(istr-1,jend+1,k,nnew,itrc)=0.5*( t(istr,jend+1,k,nnew,
     &                           itrc)+t(istr-1,jend,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and.
     &    EASTERN_EDGE) then
        do k=1,N
          t(iend+1,jend+1,k,nnew,itrc)=0.5*( t(iend,jend+1,k,nnew,
     &                           itrc)+t(iend+1,jend,k,nnew,itrc))
        enddo
      endif
# endif
      return
      end
#else
      subroutine t3dbc_empty
      end
#endif /* SOLVE3D */
