! This is include file "scalars.h"
!----- -- ------- ---- -----------
! The following common block contains time variables and indices
! for 2D (k-indices) and 3D (n-indices) computational engines. Since
! they are changed together, they are placed into the same cache line
! despite their mixed type, so that only one cachene is being
! invalidated and has to be propagated accross the cluster.
! Additionally, variables proc and CPU_time are to hold process ID
! numbers of individual threads and to measure CPU time consumed by
! each of them during the whole model run (these are for purely
! diagnostic/performance measurements and do not affect the model
! results.)
!
! Note that real values are placed first into the common block before
! integers. This is done to prevent misallignment of the 8-byte
! objects in the case when an uneven number of 4-byte integers is
! placed before a 8-byte real (in the case when default real size is
! set to 8 Bytes). Although misallignment is not formally a violation
! of fortran standard, it may cause performance degradation and/or
! make compiler issue a warning message (Sun, DEC Alpha) or even
! crash (Alpha).
!
      real*4 CPU_time(4)
      real WallClock, time, tdays
      integer proc(2), numthreads, iic, kstp, knew, next_kstp
#ifdef SOLVE3D
     &                           , iif, nstp, nnew, nrhs
#endif
#ifdef FLOATS
     &                      , nfp1, nf, nfm1, nfm2, nfm3
#endif

      common /priv_scalars/ WallClock, CPU_time, proc,
     &    time, tdays, numthreads, iic, kstp, knew, next_kstp
#ifdef SOLVE3D
     &                           , iif, nstp, nnew, nrhs
#endif
#ifdef FLOATS
     &                       ,nfp1, nf, nfm1, nfm2, nfm3
#endif
C$OMP THREADPRIVATE(/priv_scalars/)
!
! Slowly changing variables: these are typically set in the beginning
! of the run and either remain unchanged, or are changing only in
! association with the I/0.
!
! dt       Time step for 3D primitive equations [seconds];
! dtfast   Time step for 2D (barotropic) mode [seconds];
!
! xl, el   Physical size (m) of domain box in the XI-,ETA-directions.
!
! theta_s  S-coordinate surface control parameter, [0<theta_s<20].
! theta_b  S-coordinate bottom control parameter, [0<theta_b<1].
! hc       S-coordinate critical depth (in meters)
! sc_w,Cs_w  S-coordinate independent variable and stretched S-curves
! sc_r,Cs_r         at vertical W- and  RHO-points [-1 < sc,Cs < 0]
!
! rho0      Boussinesque Approximation Mean density [kg/m^3].
! R0,T0,S0  Background constant density [kg/m^3], temperature [deg C]
!           and salinity [PSU] for analytical fields and linear EOS.
! Tcoef     Thermal expansion and sSaline contraction coefficients
!                                                   for linear EOS;
! rdrg,rdrg2    Linear and quadratic bottom drag coefficients.
! gamma2   Slipperiness parameter, either 1. (free-slip)
!
! ntstart  Starting timestep in evolving the 3D primitive equations;
!                              usually 1, if not a restart run.
! ntimes   Number of timesteps for the 3D primitive equations in
!                                                    the current run.
! ndtfast  Number of timesteps for 2-D equations between each "dt".
!
! nrst     Number of timesteps between storage of restart fields.
! nwrt     Number of timesteps between writing of fields into
!                                                     history file.
! ninfo    Number of timesteps between print of single line
!                                   information to standard output.
! nsta     Number of timesteps between storage of station data.
! navg     Number of timesteps between storage of time-averaged
!                                                           fields.
! ntsavg   Starting timestep for accumulation of output time-
!                                                 averaged fields.
! nrrec    Counter of restart time records to read from disk,
!                   the last is used as the initial conditions.
! ldefhis  Logical switch to create a new history file: if .true.
!              create a new file, otherwise append an existing one.
! levsfrc  Deepest and shallowest level to apply surface momentum
! levbfrc                                stress as as bodyforce.
! got_tini Array of logical flags to signal that each particular
!                   tracer field has been successfully read from
!                   input file; if not, create it analytically.
!
      real start_time, dt, dtfast, time_avg, xl, el,
     &     rho0,  rdrg, rdrg2,  visc2, visc4,  gamma2
#ifdef SOLVE3D
     &   , rx0, rx1,  theta_s, theta_b, hc,   sc_w(0:N)
     &   , Cs_w(0:N), sc_r(N), Cs_r(N), tnu2(NT), tnu4(NT)
 
# if !defined LMD_MIXING && !defined BVF_MIXING\
  && !defined MY2_MIXING && !defined MY25_MIXING\
                         && !defined PP_MIXING
     &                      , Akv_bak,   Akt_bak(NT)
# endif
# ifdef MY25_MIXING
     &                      , Akq_bak,   q2nu2,   q2nu4
# endif
# ifndef NONLIN_EOS
     &                      , R0,T0,S0,  Tcoef,   Scoef
# endif
     &                      , weight(2,256)
#endif
#ifdef SPONGE
     &                      , x_sponge,   v_sponge
#endif
# if  defined T_FRC_BRY  || defined M2_FRC_BRY || \
      defined M3_FRC_BRY || defined Z_FRC_BRY  || \
      defined TNUDGING   || defined M2NUDGING  || \
      defined M3NUDGING  || defined ZNUDGING
     &             , tauT_in, tauT_out, tauM_in,  tauM_out
#endif
 
      integer ntstart,   ntimes,  ndtfast,  nfast,
     &        nrrec,     nrst,    ninfo,    nwrt
#ifdef AVERAGES
     &                                 , ntsavg,  navg
#endif
#ifdef STATIONS
     &                                 , nsta
#endif
#ifdef BODYFORCE
     &                      , levbfrc,   levsfrc
#endif
#ifdef FLOATS
      integer nflt
#endif
      logical ldefhis
#ifdef SOLVE3D
      logical got_tini(NT)
#endif
#ifdef FLOATS
      logical ldefflt
#endif
 
      common /scalars_main/
     &     start_time, dt, dtfast, time_avg, xl, el,
     &     rho0,  rdrg, rdrg2,  visc2, visc4, gamma2
#ifdef SOLVE3D
     &   , rx0, rx1,  theta_s, theta_b, hc,   sc_w
     &   , Cs_w,      sc_r,    Cs_r,    tnu2, tnu4
 
# if !defined LMD_MIXING && !defined BVF_MIXING\
  && !defined MY2_MIXING && !defined MY25_MIXING\
                         && !defined PP_MIXING
     &                      , Akv_bak,   Akt_bak
# endif
# ifdef MY25_MIXING
     &                      , Akq_bak,  q2nu2,    q2nu4
# endif
# ifndef NONLIN_EOS
     &                      , R0,T0,S0, Tcoef,    Scoef
# endif
     &                      , weight
#endif
#ifdef SPONGE
     &                      , x_sponge,   v_sponge
#endif
# if  defined T_FRC_BRY  || defined M2_FRC_BRY || \
      defined M3_FRC_BRY || defined Z_FRC_BRY  || \
      defined TNUDGING   || defined M2NUDGING  || \
      defined M3NUDGING  || defined ZNUDGING
     &           , tauT_in,   tauT_out, tauM_in,  tauM_out
#endif
     &           , ntstart,   ntimes,   ndtfast,  nfast
     &           , nrrec,     nrst,     ninfo,    nwrt
#ifdef AVERAGES
     &                                , ntsavg,   navg
#endif
#ifdef STATIONS
     &                      , nsta
#endif
#ifdef BODYFORCE
     &                      , levbfrc,   levsfrc
#endif
#ifdef FLOATS
     &                      , nflt
#endif
     &                      , ldefhis
#ifdef SOLVE3D
     &                      , got_tini
#endif
#ifdef FLOATS
     &                      , ldefflt
#endif
!
! This following common block contains a set of globally accessable
! variables in order to allow information exchange between parallel
! threads working on different subdomains.
!
! Global summation variables are declared with 16 byte precision
! to avoid accumulation of roundoff errors, since roundoff  error
! depends on the order of summation, which is undeterministic in
! the case of summation between the parallel threads; not doing so
! would make itimpossible to pass an ETALON CHECK test if there is
! a feedback of these sums into the dynamics of the model, such as
! in the case when global mass conservation is enforced.
!
! One sunny sping day, somewhen in 1989 an american tourist, who
! happened to be an attorney, was walking along a Moscow street.
! Because it was the period of 'Perestroika' (which literally means
! 'remodelling'), so that a lot of construction was going on in
! Moscow, dozens of holes and trenches were open on the street. He
! felt into one of them, broke his leg, ended up in a hospital and
! complaining: In my country if a construction firm would not place
! little red flags around the construction zone to warn passers-by
! about the danger, I will sue em for their negligence! The doctror,
! who was performing surgery on his leg replied to him: Did not you
! see the one big red flag above the whole country at the first time?
!
! WARNING: FRAGILE ALIGNMENT SEQUENCE: In the following common block:
! since real objects are grouped in pairs and integer*4 are grouped
! in quartets, it is guaranteed that 16 Byte objects are aligned
! in 16 Byte boundaries and 8 Byte objects are aligned in 8 Byte
! boundaries. Removing or introduction of variables with violation
! of parity, as well as changing the sequence of variables in the
! common block may cause violation of alignment.
!
      real*QUAD  area,   volume,  avzeta,  avke,    avpe,
     &           avke2b, avke3bc, avkesrf, avkp,    bc_crss
#ifdef OBC_VOLCONS
     &                                   , bc_flux, ubar_xs
#endif
#ifdef BIOLOGY
     &                                   , global_sum
#endif
      real hmin, hmax,   grdmin,  grdmax,  Cu_min,  Cu_max,
     &           Cu_Cor, Cu_visc, v2d_max, v3d_max, v3bc_max
      real*4 CPU_time_ALL(4)
      integer trd_count, tile_count,       bc_count,
     &                   first_time,       may_day_flag
      logical synchro_flag
      common /communicators/
     &           area,   volume,  avzeta,  avke,    avpe,
     &           avke2b, avke3bc, avkesrf, avkp,    bc_crss
#ifdef OBC_VOLCONS
     &                                   , bc_flux, ubar_xs
#endif
#ifdef BIOLOGY
     &                                   , global_sum(0:15)
#endif
     &   , hmin, hmax,   grdmin,  grdmax,  Cu_min,  Cu_max,
     &           Cu_Cor, Cu_visc, v2d_max, v3d_max, v3bc_max,
     &     CPU_time_ALL, trd_count,    tile_count,  bc_count,
     &     first_time,   may_day_flag,     synchro_flag
 
 
#ifdef MPI
!
! MPI rlated variables
! === ====== =========
!
      logical EAST_INTER, WEST_INTER, NORTH_INTER, SOUTH_INTER
      integer mynode, ii,jj, p_W,p_E,p_S,p_N, p_SW,p_SE, p_NW,p_NE
      common /comm_setup/ mynode, ii,jj, p_W,p_E,p_S,p_N, p_SW,p_SE,
     &  p_NW,p_NE, EAST_INTER, WEST_INTER, NORTH_INTER, SOUTH_INTER
#endif
!
! Physical constants:  Earth radius, m; Aceleration of gravity
! ======== ==========  duration of the day in seconds; Specific
! heat [Joules/kg/degC] for seawater (it is approximately 4000,
! and varies only slightly, see Gill, 1982, Appendix 3);
! von Karman constant.
!
      real pi, Eradius,g, Cp,vonKar, deg2rad,rad2deg,day2sec,sec2day
      parameter (pi=3.14159265358979323, Eradius=6371315.,
     &           deg2rad=pi/180., rad2deg=180./pi, day2sec=86400.,
     &                   sec2day=1./86400., Cp=3985., vonKar=0.41)
#ifdef SOLITON
      parameter (g=1.)   ! nondimensional
#else
      parameter (g=9.81) ! m/s^2
#endif
 
