#ifndef WRITER
# include "cppdefs.h"
      integer function nf_fread  (A, ncid, varid, record, type)
#else
      integer function nf_fwrite (A, ncid, varid, record, type)
#endif
!
! Read/Write a floating point array from/into an input/output
! NetCDF file.
!
! Arguments: A       real array of standard horizontal dimensions
!                             which is to be read or written.
!            ncid    NetCDF ID of in the file.
!            varid   variable ID of that variable in NetCDF file.
!            record  record number.
!            type    type of the grid (RHO-, U, V, W, PSI etc.)
!
! Because significant portion of the code calculates starting and
! stopping indices for the subarray (which are exactly the same for
! both read and write operations) the code has been unified to
! guarantee that both functions are exactly adjoint.
!
      implicit none
#include "param.h"
      real A(GLOBAL_2D_ARRAY,N+1)
CSDISTRIBUTE_RESHAPE  A(BLOCK_PATTERN,*) BLOCK_CLAUSE
      integer ncid, varid, record, type,  i,j,k, shft, ierr
      integer xtype, ndims, dimid(8), natts
      character*12 vname
#include "netcdf.inc"
#include "buffer.h"
#if defined MPI
# include "scalars.h"
#endif
#include "compute_starts_counts.h"
!
! Read/Write array from the disk.
!===== ===== ===== ==== === =====
!
      if (ierr.eq.0) then
#ifndef WRITER
        ierr=nf_get_vara_FTYPE (ncid, varid, start, count, buff)
        if (ierr .ne. nf_noerr) then
          write(*,'(/1x,2A,I5/1x,3A,I4/)') 'ERROR in nf_fread: ',
     &                 'nf_get_vara netCDF error code =', ierr,
     &                 'Cause of error: ', nf_strerror(ierr)
     &                  MYID
        endif
#endif
        if (ierr.eq.0) then
          do k=1,count(3)
            do j=jmin,jmax
              shft=1-imin+count(1)*(j-jmin+(k-1)*count(2))
              do i=imin,imax
#ifdef WRITER
                buff(i+shft)=A(i,j,k)
#else
                A(i,j,k)=buff(i+shft)
#endif
              enddo
            enddo
          enddo
        endif
#ifdef WRITER
        ierr=nf_put_vara_FTYPE (ncid, varid, start, count, buff)
        if (ierr.ne.nf_noerr) then
          write(*,'(/1x,2A,I5/1x,3A,I4/)') 'ERROR in nf_fwrite: ',
     &                 'nf_put_vara netCDF error code =', ierr,
     &                 'Cause of error: ', nf_strerror(ierr)
     &                  MYID
          write(*,'(A,I7,3x,A,I7)') 'ncid =',ncid, 'varid =',varid
          write(*,'(1x,A,I3,7I6)')
     &                 'start,count =', (start(i),count(i), i=1,4)
 
          ierr=nf_inq_var (ncid, varid, vname, xtype, ndims,
     &                                       dimid, natts)
          if (ierr.eq.nf_noerr) then
            write(*,'(1x,2A,1x,A,I2,2x,A,I3,2x,A,8I3)') 'vname = ',
     &                   vname, 'xtype =', xtype, 'ndims =', ndims,
     &                  'dimid =', (dimid(i), i=1,ndims)
            do i=1,ndims
              ierr=nf_inq_dim (ncid, dimid(i), vname, j)
              write(*,'(8x,A,I5)') vname, j
            enddo
          endif
        endif
#endif
!
! Exchange periodic and computational margins (reader only).
!
#ifndef WRITER
# if defined EW_PERIODIC || defined NS_PERIODIC  || defined MPI
        if (horiz_type.eq.0 .and. vert_type.eq.0) then
          call exchange_r2d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.1 .and. vert_type.eq.0) then
          call exchange_u2d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.2 .and. vert_type.eq.0) then
          call exchange_v2d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.3 .and. vert_type.eq.0) then
          call exchange_p2d_tile (1,Lm,1,Mm, A)
#  ifdef SOLVE3D
        elseif (horiz_type.eq.0 .and. vert_type.eq.1) then
          call exchange_r3d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.1 .and. vert_type.eq.1) then
          call exchange_u3d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.2 .and. vert_type.eq.1) then
          call exchange_v3d_tile (1,Lm,1,Mm, A)
        elseif (horiz_type.eq.3 .and. vert_type.eq.1) then
          call exchange_p3d_tile (1,Lm,1,Mm, A)
 
        elseif (horiz_type.eq.0 .and. vert_type.eq.2) then
          call exchange_w3d_tile (1,Lm,1,Mm, A)
#  endif
        endif
# endif
#endif
      else
#ifdef WRITER
        write(*,'(/1x,2A,I4/)') 'ERROR in nf_fwrite: ',
#else
        write(*,'(/1x,2A,I4/)')  'ERROR in nf_fread: ',
#endif
     &                     'illegal grid type', type
      endif
#ifdef WRITER
      nf_fwrite=ierr
#else
      nf_fread=ierr
#endif
      return
      end
 
#ifndef WRITER
# define WRITER
# include "nf_fread.F"
#endif
 
