#include "cppdefs.h"
#if defined SOLVE3D && (!defined ANA_STFLUX || !defined ANA_SSFLUX)
 
                                          ! Read surface flux for
      subroutine get_stflux (itrc, ierr)  ! tracer itrc from forcing
      implicit none                       ! netCDF file.
# define STFLUX_DATA
# include "param.h"
# include "forces.h"
# include "scalars.h"
# include "ncvars.h"
# include "netcdf.inc"
      real cff
      integer itrc, ierr,   i, lstr,lvar,lenstr, nf_fread
!
! Initialization: Check, whether forcing netCDF file is already
!===============  opened, an if not, open it. Find and save netCDF
! IDs for relevant variables. Determine whether there is cycling to
! reuse the input data and what is cycling period "stf_cycle", find
! initial cycling index "stf_ncycle", and record index "stf_rec".
! Set initial value for time index "itstf" and set both time record
! bounds to large artificial negative values, to trigger the logic
! in reading part below.
!
      ierr=nf_noerr
      if (FIRST_TIME_STEP) then
        lstr=lenstr(frcname)
        if (ncidfrc.eq.-1) then
          ierr=nf_open (frcname(1:lstr), nf_nowrite, ncidfrc)
          if (ierr.ne.nf_noerr) write(stdout,'(/1x,4A/)') 'ERROR ',
     &                'in get_smflux: can not open netCDF file ''',
     &                                     frcname(1:lstr),   '''.'
        endif
        if (ierr.eq.nf_noerr) then
          if (itrc.eq.itemp) then
            ierr=nf_inq_varid (ncidfrc, 'shf_time', stf_tid(itrc))
# ifdef SALINITY
          elseif (itrc.eq.isalt) then
            ierr=nf_inq_varid (ncidfrc, 'swf_time', stf_tid(itrc))
# endif
          endif
          if (ierr.eq.nf_noerr) then
            lvar=lenstr(vname(1,indxSHFl+itrc-1))
            ierr=nf_inq_varid (ncidfrc, vname(1,indxSHFl+itrc-1),
     &                                              stf_id(itrc))
            if (ierr .eq. nf_noerr) then
              call set_cycle (ncidfrc, stf_tid(itrc), ntstf(itrc),
     &                          stf_cycle(itrc), stf_ncycle(itrc),
     &                                       stf_rec(itrc), ierr)
              itstf(itrc)=1
              stf_time(1,itrc)=-1.E+20
              stf_time(2,itrc)=-1.E+20
            else
              write(stdout,1) vname(1,indxSHFl+itrc-1),
     &                                    itrc, frcname(1:lstr)
            endif
          else
            if (itrc.eq.itemp) then
              write(stdout,1) 'shf_time', itrc, frcname(1:lstr)
# ifdef SALINITY
            elseif (itrc.eq.isalt) then
              write(stdout,1) 'swf_time', itrc, frcname(1:lstr)
# endif
            endif
          endif
        endif
      endif
  1   format(/1x,'ERROR in get_smflux: cannot find variable ''', A,
     &  ''', itrc =', I3/7x, 'in forcing netCDF file ''', A, '''.')
 
!
! Read data from the file:  Check if model time is bounded by past
!===== ==== ==== === =====  and future data times: if not, increment
! record and cycling indices, flip time index and read a new portion
! of data. Repeat until model time falls between the two data times.
!
      do while (stf_time(itstf(itrc),itrc).lt.time+dt .and.
     &                                       ierr.eq.nf_noerr)
        call advance_cycle (stf_cycle(itrc),  ntstf(itrc),
     &                  stf_ncycle(itrc), stf_rec(itrc), ierr)
        if (ierr.eq.nf_noerr) then
          ierr=nf_get_var1_FTYPE(ncidfrc, stf_tid(itrc),
     &                               stf_rec(itrc), cff)
          if (ierr.eq.nf_noerr) then
            itstf(itrc)=min(3-itstf(itrc),ntstf(itrc))
            stf_time(itstf(itrc),itrc)=cff*day2sec
     &                     + stf_cycle(itrc)*stf_ncycle(itrc)
 
            ierr=nf_fread (stflxg(START_2D_ARRAY,itstf(itrc),itrc),
     &                 ncidfrc, stf_id(itrc), stf_rec(itrc), r2dvar)
            if (ierr .eq. nf_noerr) then
              write(stdout,'(6x,A,I2,1x,A,G12.4,1x,A,I4)')
     &           'get_stflux -- read surface flux for tracer', itrc,
     &           'stf_time =', cff MYID
              if (ntstf(itrc).eq.1) return
            else
              write(stdout,2) 'stflux', itrc, stf_rec
            endif
          else
            write(stdout,2) 'stf_time', itrc, stf_rec(itstf(itrc))
          endif
        else
          write(stdout,'(/1x,A,I4,1x,A,I4/7x,4A/7x,2(A,G12.4)/)')
     &  'ERROR in get_stflux: requested time record ', stf_rec(itrc),
     &  'exeeds the last record',    ntstf(itrc),    'available in ',
     &  'netCDF file ''',    frcname(1:lstr),    '''',    'tdays = ',
     &   tdays, '  but the last available  stf_time =',
     &                          stf_time(itstf(itrc),itrc)*sec2day
        endif
      enddo
  2   format(/1x,'ERROR in get_stflux: cannot read variable ''',
     &                 A, ''', itrc =', I2, ' for record ', I4/)
      return
      end
 
      subroutine set_stflux_tile (istr,iend,jstr,jend, itrc, ierr)
!
! Set-up surface tracer flux for current tile.
!
      implicit none
      integer istr,iend,jstr,jend, itrc, ierr, i,j, it1,it2
      real cff, cff1, cff2
# define STFLUX_DATA
# include "param.h"
# include "scalars.h"
# include "ocean3d.h"
# include "forces.h"
!
# include "compute_extended_bounds.h"
!
! Set coefficients for interpolation. Check that for the next time
! step [when time=time+dt] both weights will still be positive, and
! if not, set synchro_flag to signal that new data should be read
! from an appropriate netCDF input file (master thread only).
! After that either load time-invariant data, or interpolate in time
! or complain about error and signal to quit, if interpolation is
! needed, but not possible.
!
      it1=3-itstf(itrc)
      it2=itstf(itrc)
      cff1=stf_time(it2,itrc)-time
      cff2=time-stf_time(it1,itrc)
      if (ZEROTH_TILE .and. cff1.lt.dt) synchro_flag=.true.
 
      if (ntstf(itrc).eq.1) then           ! Load time-invariant
        if (itrc.eq.itemp) then            ! surface tracer flux
          cff=1./(rho0*Cp)
          do j=jstrR,jendR
            do i=istrR,iendR
              stflx(i,j,itemp)=cff*stflxg(i,j,itstf(itemp),itemp)
            enddo
          enddo
# ifdef SALINITY
        elseif (itrc.eq.isalt) then
          cff=0.01/86400.
          do j=jstrR,jendR
            do i=istrR,iendR
              stflx(i,j,isalt)=cff*stflxg(i,j,itstf(isalt),isalt)
     &                                       *t(i,j,N,nrhs,isalt)
            enddo
          enddo
# endif
        endif                                   ! Interpolate surface
      elseif (cff1.ge.0. .and. cff2.ge.0.) then ! tracer fluxes in
        if (itrc.eq.itemp) then                 ! time.
          cff=1./(rho0*Cp*(cff1+cff2))
          cff1=cff1*cff
          cff2=cff2*cff
          do j=jstrR,jendR
            do i=istrR,iendR
              stflx(i,j,itemp)=cff1*stflxg(i,j,it1,itemp)
     &                        +cff2*stflxg(i,j,it2,itemp)
            enddo
          enddo
# ifdef SALINITY
        elseif (itrc.eq.isalt) then      ! fresh water flux: convert
          cff=0.01/(86400.*(cff1+cff2))  ! from [cm/day] to [PSU m/s]
          cff1=cff1*cff                  ! and multiply by surface
          cff2=cff2*cff                  ! salinity.
          do j=jstrR,jendR
            do i=istrR,iendR
              stflx(i,j,isalt)=t(i,j,N,nrhs,isalt)*(
     &                     cff1*stflxg(i,j,it1,isalt)
     &                    +cff2*stflxg(i,j,it2,isalt)
     &                                             )
            enddo
          enddo
# endif
        endif
      elseif (ZEROTH_TILE) then
        write(stdout,'(/1x,2A/3(1x,A,F16.10)/)')
     &            'SET_STFLUX_TILE - current model time is outside ',
     &            'bounds of ''stf_time''.',
     &                    'STF_TSTART=',  stf_time(it1,itrc)*sec2day,
     &                    'TDAYS=',       tdays,
     &                    'STF_TEND=',    stf_time(it2,itrc)*sec2day
        ierr=ierr+1
      endif
      return
      end
#else
      subroutine get_stflux_empty
      end
#endif /* SOLVE3D  && !ANA_STFLUX || (SALINITY && !ANA_SSFLUX) */
 
