#include "cppdefs.h"
#if defined QCORRECTION && !defined ANA_SST
 
      subroutine get_sst (ierr) ! Read sea surface temperature
      implicit none
# define SST_DATA
# include "param.h"
# include "forces.h"
# include "scalars.h"
# include "netcdf.inc"
# include "ncvars.h"
      real cff
      integer ierr, i, lstr,lvar,lenstr, nf_fread
!
! Initialization: Check, whether forcing netCDF file is already
!===============  opened, an if not, open it. Find and save netCDF
! IDs for relevant variables, and determine whether sst data exists
! as 2D field or scalar. After that determine whether there is
! cycling to reuse the input data and what is cycling period
! "sst_cycle", set initial cycling index "sst_ncycle", record index
! "sst_rec", and time index "itsst" and both time record bounds to
! large negative artificial values, so that it will trigger logic in
! reading part below.
!
      ierr=nf_noerr
      if (FIRST_TIME_STEP) then
        lstr=lenstr(frcname)
        if (ncidfrc.eq.-1) then
          ierr=nf_open(frcname(1:lstr), nf_nowrite, ncidfrc)
          if (ierr.ne.nf_noerr) write(stdout,'(/1x,4A/)') 'ERROR ',
     &                   'in get_sst: can not open netCDF file ''',
     &                                       frcname(1:lstr), '''.'
        endif
        if (ierr .eq. nf_noerr) then
          ierr=nf_inq_varid (ncidfrc, 'sst_time', sst_tid)
          if (ierr .eq. nf_noerr) then
            lvar=lenstr(vname(1,indxSST))
            ierr=nf_inq_varid (ncidfrc, vname(1,indxSST)(1:lvar),
     &                                                   sst_id)
            if (ierr .eq. nf_noerr) then
              call set_cycle (ncidfrc, sst_tid, ntsst, sst_cycle,
     &                                 sst_ncycle, sst_rec, ierr)
              itsst=1
              sst_time(1)=-1.E+20
              sst_time(2)=-1.E+20
            else
              write(stdout,1) vname(1,indxSST)(1:lvar),
     &                                  frcname(1:lstr)
            endif
          else
            write(stdout,1) 'sst_time', frcname(1:lstr)
          endif
        endif
      endif
  1   format(/1x,'ERROR in get_sst: cannot find variable ''',
     &     A, ''''/7x, 'in forcing netCDF file ''', A, '''.')
!
! Reading data from the forcing file:  Get out, if model time is
!======== ==== ==== === ======= =====  already within the interval
! set by the past and future data times. Otherwise flip the time
! index, increment record and cyclin indices and read a new portion
! of data. Repeat it until model time is between the two times from
! data.
!
      do while (sst_time(itsst).lt.time+dt .and. ierr.eq.nf_noerr)
        call advance_cycle (sst_cycle, ntsst, sst_ncycle,
     &                                 sst_rec,     ierr)
        if (ierr .eq. nf_noerr) then
          ierr=nf_get_var1_FTYPE (ncidfrc, sst_tid, sst_rec, cff)
          if (ierr .eq. nf_noerr) then
            itsst=3-itsst
            sst_time(itsst)=cff*day2sec + sst_cycle*sst_ncycle
            ierr=nf_fread (sstg(START_2D_ARRAY,itsst), ncidfrc,
     &                                 sst_id, sst_rec, r2dvar)
            if (ierr .eq. nf_noerr) then
              write(stdout,'(6x,2A,G12.4,1x,A,I4)') 'get_sst    --',
     &                 ' read SST                       for time =',
     &                   cff MYID
            else
              write(stdout,2) 'SST', sst_rec
            endif
          else
            write(stdout,2) 'sst_time', sst_rec
          endif
        else
          write(stdout,'(/1x,A,I4,1x,A,I4/7x,4A/7x,2(A,G12.4)/)')
     &   'ERROR in get_sst: requested time record ',      sst_rec,
     &   'exeeds the last record', ntsst, 'available in forcing ',
     &   'netCDF file ''',   frcname(1:lstr),   '''',  'tdays = ',
     &    tdays,        '  but the last available  sst_time =',
     &                                    sst_time(itsst)*sec2day
        endif
      enddo
  2   format(/1x,'ERROR in get_sst: cannot read variable ''', A,
     &                                    ''' for record ', I4/)
      return
      end
 
 
      subroutine apply_qcorr_tile (istr,iend,jstr,jend, ierr)
!
! Apply dQdSST*(T_model-SST_data) correction terms to surface
! heat flux, and, possibly, to salinity flux.
!
      implicit none
      integer istr,iend,jstr,jend, ierr, i,j, it1,it2,it3,it4,it5,it6
      real cff, cff1,cff2, cff3,cff4, cff5,cff6, dSdt,  sst,dqdt
# define SST_DATA
# include "param.h"
# include "scalars.h"
# include "ocean3d.h"
# include "forces.h"
# include "climat.h"
!
# include "compute_extended_bounds.h"
!
! Set coefficients for interpolation. Check that for the next time
! step [when time=time+dt] both weights will still be positive, and
! if not, set synchro_flag to signal that new data should be read
! from an appropriate netCDF input file (master thread only).
! After that either load time-invariant data, or interpolate in time
! or complain about error and signal to quit, if interpolation is
! needed, but not possible.
!
      dSdt=1./(30.*day2sec) ! relaxation time for surface salinity 

      it1=3-itsst
      it2=itsst
      cff1=sst_time(it2)-time
      cff2=time-sst_time(it1)

      it3=3-itdqdt
      it4=itdqdt
      cff3=dqdt_time(it4)-time
      cff4=time-dqdt_time(it3)

c*    it5=3-itsss
c*    it6=itsss
c*    cff5=sss_time(it6)-time
c*    cff6=time-sss_time(it5)

      cff5=cff3
      cff6=cff4

      if (ZEROTH_TILE  .and. ( cff1.lt.dt .or.
     &    cff3.lt.dt .or. cff5.lt.dt )) synchro_flag=.true.
 
      if (cff1.ge.0. .and. cff2.ge.0. .and. cff3.ge.0. .and.
     &    cff4.ge.0. .and. cff5.ge.0. .and. cff6.ge.0.) then

        cff=1./(cff1+cff2)
        cff1=cff1*cff                ! Interpolate SST and dQdSST
        cff2=cff2*cff                ! data to model time.  Convert
                                     ! units of dQdSST from
        cff=1./(rho0*Cp*(cff3+cff4)) ! [Watts/(m^2*deg C)] to [m/sec]
        cff3=cff3*cff                ! so that product (T-SST)*dQdSST
        cff4=cff4*cff                ! has units of kinematic flux.

        cff=1./(cff5+cff6)
        cff5=cff5*cff
        cff6=cff6*cff

        do j=jstrR,jendR             !
          do i=istrR,iendR
            sst=cff1*sstg(i,j,it1)   +cff2*sstg(i,j,it2)
            dqdt=cff3*dqdtg(i,j,it3) +cff4*dqdtg(i,j,it4)
c*          sss=cff5*sssg(i,j,it5)   +cff6*sssg(i,j,it6)
 
            stflx(i,j,itemp)=stflx(i,j,itemp) + dqdt
     &                     *(t(i,j,N,nrhs,itemp)-sst)
 
# if defined SALINITY && defined SFLX_CORR && defined TCLIMATOLOGY
#  if defined USWEST || defined PACIFIC
c** Patrick formulation, basically apply relaxation toward observed
c** climatology with the same rate as for temperature (physics??)
/*

            stflx(i,j,isalt)=stflx(i,j,isalt) + dqdt*(
     &              t(i,j,N,nrhs,isalt)-tclm(i,j,N,isalt))
c*   &              t(i,j,N,nrhs,isalt)-sss)

*/
#  elif defined DAMEE_B
!
! Hernan: ad hoc, just use constant, prescribed relaxation time.
!
            stflx(i,j,isalt)= !!! stflx(i,j,isalt)
     &        -dSdt*Hz(i,j,N)*(t(i,j,N,nrhs,isalt)-tclm(i,j,N,isalt))
#  endif

# endif
          enddo
        enddo
      elseif (ZEROTH_TILE) then
        write(stdout,'(/1x,2A/3(1x,A,F16.10)/)')
     &       'SET_SST_TILE - current model time is outside bounds ',
     &       'of ''sst_time''.', 'SST_TSTART=',sst_time(it1)*sec2day,
     &                           'TDAYS=',     tdays,
     &                           'SST_TEND=',  sst_time(it2)*sec2day
        ierr=ierr+1
      endif
      return
      end
#else
      subroutine get_sst_empty
      end
#endif /* QCORRECTION && !ANA_SST */
 
