#include "cppdefs.h"
#ifdef MPI
 
      subroutine MPI_Setup (ierr)
      implicit none
      integer ierr, nsize, ii_W, ii_E, jj_S, jj_N
# include "param.h"
# include "scalars.h"
# include "ncvars.h"
# include "mpif.h"
 
      call MPI_Comm_size (MPI_COMM_WORLD, nsize,  ierr)
      call MPI_Comm_rank (MPI_COMM_WORLD, mynode, ierr)
 
                                ! Check whether the number of nodes
      if (nsize.eq.NNODES) then ! specified as -np argument to mpirun
        ii=mod(mynode,NP_XI)    ! command is consistent with the code
        jj=mynode/NP_XI         ! parameter settings, and if so, find
                                ! indices ii,jj identifying location
        if (NP_XI.eq.1) then    ! of the subdomain to be work on by
          WEST_INTER=.false.    ! MPI process with rank mynode on the
          EAST_INTER=.false.    ! "processor grid". Depending on this
        else                    ! location find out whether this
# ifdef EW_PERIODIC
          WEST_INTER=.true.     ! subdomain has neighbours on the
          EAST_INTER=.true.     ! four sides around it and set
# else
          if (ii.eq.0) then     ! the four corresponding logical
            WEST_INTER=.false.  ! flags. Here WEST_INTER.eqv..true.
          else                  ! means that I [MPI process with rank
            WEST_INTER=.true.   ! mynode] have neighbor on west side,
          endif                    ! so I have to send message to him
          if (ii.eq.NP_XI-1) then  ! and expect incoming messages
            EAST_INTER=.false.     ! from him. Meaning of the three
          else                  ! others, EAST_INTER, SOUTH_INTER,
            EAST_INTER=.true.   ! NORTH_INTER is the same, except
          endif                 ! they refer to the different sides.
# endif
        endif                   ! Note: periodic boundary conditions
                                ! are treated exclussively via
        if (NP_ETA.eq.1) then   ! exchange of computational margins,
          SOUTH_INTER=.false.   ! so that communication takes place
          NORTH_INTER=.false.   ! even is the subdomain is located
        else                    ! on the side of the grid.
# ifdef NS_PERIODIC
          SOUTH_INTER=.true.
          NORTH_INTER=.true.
# else
          if (jj.eq.0) then
            SOUTH_INTER=.false.
          else
            SOUTH_INTER=.true.
          endif
          if (jj.eq.NP_ETA-1) then
            NORTH_INTER=.false.
          else
            NORTH_INTER=.true.
          endif
# endif
        endif
 
        ii_W=mod(ii-1+NP_XI,NP_XI)
        ii_E=mod(ii+1       ,NP_XI)
        jj_S=mod(jj-1+NP_ETA,NP_ETA)
        jj_N=mod(jj+1       ,NP_ETA)
 
        p_W=ii_W +NP_XI*jj      ! Determine MPI-ranks of my neighbors
        p_E=ii_E +NP_XI*jj      ! from the sides and corners, which
        p_S=ii   +NP_XI*jj_S    ! will later be used to designate
        p_N=ii   +NP_XI*jj_N    ! sources of incoming and targets for
                                ! outgoing messages. Here they are
        p_NW=ii_W+NP_XI*jj_N    ! set as for double-periodic grid
        p_SW=ii_W+NP_XI*jj_S    ! regardless of the actual boundary
        p_NE=ii_E+NP_XI*jj_N    ! conditions. There is no ambiguity,
        p_SE=ii_E+NP_XI*jj_S    ! since WEST_INTER...etc logic blocks
                                ! the annecessary messages.
#ifdef PARALLEL_FILES
# ifndef EW_PERIODIC
        xi_rho=Lm
        xi_u=xi_rho
        if (ii.eq.0) xi_rho=xi_rho+1
        if (ii.eq.NP_XI-1) then
          xi_rho=xi_rho+1
          xi_u=xi_u+1
        endif
# endif
# ifndef NS_PERIODIC
        eta_rho=Mm
        eta_v=eta_rho
        if (jj.eq.0) eta_rho=eta_rho+1
        if (jj.eq.NP_ETA-1) then
          eta_rho=eta_rho+1
          eta_v=eta_v+1
        endif
# endif
#endif
        ierr=0
      else
        MPI_master_only write(stdout,'(/1x,A,I4,1x,A,I3,A/)')
     &     'ERROR in MPI_Setup: number of MPI-nodes should be',
     &                         NNODES, 'instead of', nsize, '.'
        ierr=99
      endif
      return
      end
 
 
 
c---#define CHECK_MPI
# ifdef CHECK_MPI
 
      subroutine MPI_Test
      implicit none
#  include "param.h"
      integer tile
      do tile=0,NSUB_X*NSUB_E-1
        call MPI_Test1 (tile)
      enddo
      return
      end
 
      subroutine MPI_Test1 (tile)
      implicit none
      integer tile
#  include "param.h"
#  include "compute_tile_bounds.h"
      call MPI_Test1_tile  (istr,iend,jstr,jend)
      return
      end
 
      subroutine MPI_Test1_tile (istr,iend,jstr,jend)
      implicit none
      integer istr,iend,jstr,jend
#  include "param.h"
#  include "scalars.h"
#  include "mpif.h"
 
      integer i,j,k,ierr
      real temp2D(GLOBAL_2D_ARRAY),
     &     temp3D(GLOBAL_2D_ARRAY,0:N)
      common /MPI_Test_Arr/ temp2D,temp3D
      character string(128)
!
#  include "compute_extended_bounds.h"
!
      do j=jstrR,jendR
        do i=istrR,iendR
c          temp2D(i,j)=1.*mynode+0.5
           temp2D(i,j)=-1.*(mynode+1)
        enddo
      enddo
      do j=jstr,jend
        do i=istr,iend
          temp2D(i,j)=1.*mynode+1.
c          temp2D(i,j)=i+ii*Lm
c          temp2D(i,j)=j+jj*Mm
        enddo
      enddo
 
 
      call MessPass2D_tile (istr,iend,jstr,jend, temp2D)
 
      do i=mynode,NNODES
        call MPI_Barrier (MPI_COMM_WORLD, ierr)
      enddo
      write(*,*)
      write(*,*)
      write(*,'(A5,I3,2I4)') 'node=',mynode, ii,jj
      write(*,*)
      do j=jendR,jstrR,-1
       write(string,'(I3,3x,20F4.1)') j, (temp2D(i,j), i=istrR,iendR)
        do i=7,6+4*(iendR-istrR+1)
         if (string(i-1).eq.'.' .and. string(i).eq.'0') string(i)=' '
        enddo
       write(*,'(128A1)') (string(i), i=1,6+4*(iendR-istrR+1))
      enddo
      write(*,*)
        write(*,'(5x,20I4)') (i,i=istrR,iendR)
      write(*,*)
      write(*,*)
      do i=0,mynode
        call MPI_Barrier (MPI_COMM_WORLD, ierr)
      enddo
 
 
c      return
 
 
      do k=0,N
        do j=jstrR,jendR
          do i=istrR,iendR
            temp3D(i,j,k)=-1.*(mynode+1)
          enddo
        enddo
        do j=jstr,jend
          do i=istr,iend
            temp3D(i,j,k)=1.*mynode+1.
             temp3D(i,j,k)=0.1*( float(j-1+(jend-jstr+1)*mynode) )
          enddo
        enddo
      enddo
 
      call MessPass3D_tile (istr,iend,jstr,jend, temp3D,N+1)
 
      do k=0,N
        write(*,*) 'k=',k
        do i=mynode,NNODES
          call MPI_Barrier (MPI_COMM_WORLD, ierr)
        enddo
        write(*,*)
        write(*,*)
        write(*,'(A5,I3,2I4)') 'node=',mynode, ii,jj
        write(*,*)
        do j=jendR,jstrR,-1
        write(string,'(I3,3x,20F4.1)')j,(temp3D(i,j,k),i=istrR,iendR)
         do i=7,6+4*(iendR-istrR+1)
          if (string(i-1).eq.'.'.and.string(i).eq.'0') string(i)=' '
         enddo
        write(*,'(128A1)') (string(i), i=1,6+4*(iendR-istrR+1))
        enddo
        write(*,*)
        write(*,'(5x,20I4)') (i,i=istrR,iendR)
        write(*,*)
        write(*,*)
        do i=0,mynode
          call MPI_Barrier (MPI_COMM_WORLD, ierr)
        enddo
      enddo
      return
      end
# endif        /* CHECK_MPI */
#else
      subroutine MPI_Setup_empty
      end
#endif    /* MPI */
 
 
