#include "cppdefs.h"
 
      subroutine v2dbc (tile)
      implicit none
      integer tile
#include "param.h"
#include "private_scratch.h"
#include "compute_tile_bounds.h"
      call v2dbc_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine v2dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for the barotropic (i.e.
! vertically integrated) ETA-component velocity vbar(:,:,knew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps,cff, cx,cy,
     &            dft,dfx,dfy, tau,tau_in,tau_out, uv_crss
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "climat.h"
#include "scalars.h"
# include "boundary.h"
!
#include "compute_auxiliary_bounds.h"
!
#if defined M2_FRC_BRY || defined M2NUDGING
      tau_in=dtfast*tauM_in
      tau_out=dtfast*tauM_out
#endif
#ifdef OBC_FLUX_CORR
      uv_crss=ubar_xs*dtfast/tau_obc
#endif

#ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
# ifdef OBC_SOUTH
#  ifdef OBC_M2ORLANSKI
        do i=istr,iend+1
          grad(i,jstr  )=(vbar(i,jstr  ,kstp)-vbar(i-1,jstr  ,kstp))
#   ifdef MASKING
     &                                                *pmask(i,jstr)
#   endif
          grad(i,jstr+1)=(vbar(i,jstr+1,kstp)-vbar(i-1,jstr+1,kstp))
#   ifdef MASKING
     &                                              *pmask(i,jstr+1)
#   endif
        enddo
        do i=istr,iend
          dft=vbar(i,jstr+1,kstp)-vbar(i,jstr+1,knew)
          dfx=vbar(i,jstr+1,knew)-vbar(i,jstr+2,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                       ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(i,jstr+1)+grad(i+1,jstr+1)) .gt. 0.) then
            dfy=grad(i  ,jstr+1)
          else
            dfy=grad(i+1,jstr+1)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          vbar(i,jstr,knew)=( cff*vbar(i,jstr,kstp)
     &                       +cx*vbar(i,jstr+1,knew)
     &                    -max(cy,0.)*grad(i  ,jstr)
     &                    -min(cy,0.)*grad(i+1,jstr)
     &                                   )/(cff+cx)
#   ifdef OBC_FLUX_CORR
     &                                    -uv_crss
#   endif
#   if defined M2_FRC_BRY || defined M2NUDGING
          vbar(i,jstr,knew)=(1.-tau)*vbar(i,jstr,knew)
#    ifdef M2_FRC_BRY
     &                              +tau*vbar_south(i)
#    else
     &                              +tau*vbclm(i,jstr)
#    endif
#   endif
#   ifdef MASKING
          vbar(i,jstr,knew)=vbar(i,jstr,knew)*vmask(i,jstr)
#   endif
        enddo
#  else         /* alternative open: Flather, specified, gradient */
        do i=istr,iend
#    if defined OBC_M2FLATHER
          vbar(i,jstr,knew)=vbclm(i,jstr)
     &                  -sqrt(2.*g/(h(i,jstr)+h(i,jstr-1)))*(
     &               0.5*( zeta(i,jstr-1,kstp)+zeta(i,jstr,kstp))
     &                                        -zeta_south(i) )
#   elif defined OBC_M2SPECIFIED
          vbar(i,jstr,knew)=vbclm(i,jstr)
#   else
          vbar(i,jstr,knew)=vbar(i,jstr+1,knew)
#   endif
#   ifdef MASKING
          vbar(i,jstr,knew)=vbar(i,jstr,knew)*vmask(i,jstr)
#   endif
        enddo
#  endif
# else
        do i=istr,iend                        ! Southern edge closed
          vbar(i,jstr,knew)=0.                ! ======== ==== ======
        enddo                                 !  (no-flux, default)
# endif          /* OBC_SOUTH */
      endif   !<-- SOUTHERN_EDGE
 
 
 
      if (NORTHERN_EDGE) then
# ifdef OBC_NORTH
#  ifdef OBC_M2ORLANSKI
!                                          Northern edge radiation BC
!                                          ======== ==== ========= ==
        do i=istr,iend+1
          grad(i,jend  )=(vbar(i,jend  ,kstp)-vbar(i-1,jend  ,kstp))
#   ifdef MASKING
     &                                                *pmask(i,jend)
#   endif
          grad(i,jend+1)=(vbar(i,jend+1,kstp)-vbar(i-1,jend+1,kstp))
#   ifdef MASKING
     &                                              *pmask(i,jend+1)
#   endif
        enddo
        do i=istr,iend
          dft=vbar(i,jend,kstp)-vbar(i,jend  ,knew)
          dfx=vbar(i,jend,knew)-vbar(i,jend-1,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                         ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(i,jend)+grad(i,jend+1)) .gt. 0.) then
            dfy=grad(i  ,jend)
          else
            dfy=grad(i+1,jend)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          vbar(i,jend+1,knew)=( cff*vbar(i,jend+1,kstp)
     &                             +cx*vbar(i,jend,knew)
     &                      -max(cy,0.)*grad(i  ,jend+1)
     &                      -min(cy,0.)*grad(i+1,jend+1)
     &                                      )/(cff+cx)
#   ifdef OBC_FLUX_CORR
     &                                      +uv_crss
#   endif
#   if defined M2_FRC_BRY || defined M2NUDGING
          vbar(i,jend+1,knew)=(1.-tau)*vbar(i,jend+1,knew)
#    ifdef M2_FRC_BRY
     &                                  +tau*vbar_north(i)
#    else
     &                                +tau*vbclm(i,jend+1)
#    endif
#   endif
#   ifdef MASKING
          vbar(i,jend+1,knew)=vbar(i,jend+1,knew)*vmask(i,jend+1)
#   endif
        enddo
#  else          /* alternative open: Flather, specified, gradient */
        do i=istr,iend
#   if defined OBC_M2FLATHER
          vbar(i,jend+1,knew)=vbclm(i,jend+1)
     &                       +sqrt(2.*g/(h(i,jend+1)+h(i,jend)))*(
     &                 0.5*( zeta(i,jend,kstp)+zeta(i,jend+1,kstp))
     &                                             -zeta_north(i) )
#   elif defined OBC_M2SPECIFIED
          vbar(i,jend+1,knew)=vbclm(i,jend+1)
#   else
          vbar(i,jend+1,knew)=vbar(i,jend,knew)
#   endif
#   ifdef MASKING
          vbar(i,jend+1,knew)=vbar(i,jend+1,knew)*vmask(i,jend+1)
#   endif
        enddo
#  endif
# else
        do i=istr,iend                        ! Northern edge closed
          vbar(i,jend+1,knew)=0.              ! ======== ==== ======
        enddo                                 !  (no-flux: default)
# endif /* OBC_NORTH */
      endif          !<--  NORTHERN_EDGE
#endif                  /* !NS_PERIODIC */
 
 
 
#ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
# ifdef OBC_WEST
#  if defined OBC_M2ORLANSKI
!                                           Western edge radiation BC
!                                           ======= ==== ========= ==
        do j=jstrV-1,jend
          grad(istr-1,j)=vbar(istr-1,j+1,kstp)-vbar(istr-1,j,kstp)
          grad(istr  ,j)=vbar(istr  ,j+1,kstp)-vbar(istr  ,j,kstp)
        enddo
        do j=jstrV,jend
          dft=vbar(istr,j,kstp)-vbar(istr  ,j,knew)
          dfx=vbar(istr,j,knew)-vbar(istr+1,j,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                        ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(istr,j-1)+grad(istr,j)) .gt. 0.) then
            dfy=grad(istr,j-1)
          else
            dfy=grad(istr,j  )
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          vbar(istr-1,j,knew)=( cff*vbar(istr-1,j,kstp)
     &                             +cx*vbar(istr,j,knew)
     &                      -max(cy,0.)*grad(istr-1,j-1)
     &                      -min(cy,0.)*grad(istr-1,j  )
     &                                       )/(cff+cx)
#   if defined M2_FRC_BRY || defined M2NUDGING
          vbar(istr-1,j,knew)=(1.-tau)*vbar(istr-1,j,knew)
#    ifdef M2_FRC_BRY
     &                                   +tau*vbar_west(j)
#    else
     &                                +tau*vbclm(istr-1,j)
#    endif
#   endif
#   ifdef MASKING
          vbar(istr-1,j,knew)=vbar(istr-1,j,knew)*vmask(istr-1,j)
#   endif
        enddo
#  else          /* alternative open: Chapman, specified, gradient */
        do j=jstrV,jend
#   if defined OBC_M2FLATHER
          cx=dtfast*sqrt(0.5*g*(h(istr-1,j-1)+h(istr-1,j)))
     &                    *0.5*(pm(istr-1,j-1)+pm(istr-1,j))
          vbar(istr-1,j,knew)=( vbar(istr-1,j,kstp)
     &               +cx*vbar(istr,j,knew) )/(1.+cx)
#   elif defined OBC_M2SPECIFIED
          vbar(istr-1,j,knew)=vbclm(istr-1,j)
#   else
          vbar(istr-1,j,knew)=vbar(istr,j,knew)
#   endif
#   ifdef MASKING
          vbar(istr-1,j,knew)=vbar(istr-1,j,knew)*vmask(istr-1,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_RANGE jstrV,jend
#  else
#   define J_RANGE jstr,jendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do j=J_RANGE               ! ====== ===   no-slip (gamma2=-1)
          vbar(istr-1,j,knew)=gamma2*vbar(istr,j,knew)
#  ifdef MASKING
     &                                *vmask(istr-1,j)
#  endif
        enddo
#  undef J_RANGE
# endif              /* OBC_WEST */
      endif       !<-- WESTERN_EDGE
 
 
 
      if (EASTERN_EDGE) then
# ifdef OBC_EAST
#  if defined OBC_M2ORLANSKI
!                                           Eastern edge radiation BC
!                                           ======= ==== ========= ==
        do j=jstrV-1,jend
          grad(iend  ,j)=vbar(iend  ,j+1,kstp)-vbar(iend  ,j,kstp)
          grad(iend+1,j)=vbar(iend+1,j+1,kstp)-vbar(iend+1,j,kstp)
        enddo
        do j=jstrV,jend
          dft=vbar(iend,j,kstp)-vbar(iend  ,j,knew)
          dfx=vbar(iend,j,knew)-vbar(iend-1,j,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                                 ! <-- INFLOW
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(iend,j-1)+grad(iend,j)) .gt. 0.) then
            dfy=grad(iend,j-1)
          else
            dfy=grad(iend,j  )
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          vbar(iend+1,j,knew)=( cff*vbar(iend+1,j,kstp)
     &                             +cx*vbar(iend,j,knew)
     &                      -max(cy,0.)*grad(iend+1,j-1)
     &                      -min(cy,0.)*grad(iend+1,j  )
     &                                       )/(cff+cx)
#   if defined M2_FRC_BRY || defined M2NUDGING
          vbar(iend+1,j,knew)=(1.-tau)*vbar(iend+1,j,knew)
#    ifdef M2_FRC_BRY
     &                                   +tau*vbar_east(j)
#    else
     &                                +tau*vbclm(iend+1,j)
#    endif
#   endif
#   ifdef MASKING
          vbar(iend+1,j,knew)=vbar(iend+1,j,knew)*vmask(iend+1,j)
#   endif
        enddo
#  else          /* alternative open: Chapman, specified, gradient */
        do j=jstrV,jend
#   if defined OBC_M2FLATHER
          cx=dtfast*sqrt(0.5*g*(h(iend+1,j-1)+h(iend+1,j)))
     &                    *0.5*(pm(iend+1,j-1)+pm(iend+1,j))
          vbar(iend+1,j,knew)=( vbar(iend+1,j,kstp)
     &                +cx*vbar(iend,j,knew))/(1.+cx)
#   elif defined OBC_M2SPECIFIED
          vbar(iend+1,j,knew)=vbclm(iend+1,j)
#   else
          vbar(iend+1,j,knew)=vbar(iend,j,knew)
#   endif
#   ifdef MASKING
          vbar(iend+1,j,knew)=vbar(iend+1,j,knew)*vmask(iend+1,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_RANGE jstrV,jend
#  else
#   define J_RANGE jstr,jendR
#  endif                                ! Wall: free-slip (gamma2=+1)
        do j=J_RANGE                    ! =====   no-slip (gamma2=-1)
          vbar(iend+1,j,knew)=gamma2*vbar(iend,j,knew)
#  ifdef MASKING
     &                                *vmask(iend+1,j)
#  endif
        enddo
#  undef J_RANGE
# endif            /* OBC_EAST */
      endif      !<-- EASTERN_EDGE
#endif             /* !EW_PERIODIC */
 
                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========
 
#if defined OBC_SOUTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        vbar(istr-1,jstr,knew)=0.5*( vbar(istr-1,jstr+1,knew)
     &                              +vbar(istr  ,jstr  ,knew))
      endif
#endif
#if defined OBC_SOUTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        vbar(iend+1,jstr,knew)=0.5*( vbar(iend+1,jstr+1,knew)
     &                              +vbar(iend  ,jstr  ,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        vbar(istr-1,jend+1,knew)=0.5*( vbar(istr-1,jend,knew)
     &                                +vbar(istr,jend+1,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        vbar(iend+1,jend+1,knew)=0.5*( vbar(iend+1,jend,knew)
     &                                +vbar(iend,jend+1,knew))
      endif
#endif
      return
      end
 
