#include "cppdefs.h"
 
      subroutine u2dbc (tile)
      implicit none
      integer tile
#include "param.h"
#include "private_scratch.h"
#include "compute_tile_bounds.h"
      call u2dbc_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine u2dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for the barotropic (i.e.
! vertically integrated) XI-component velocity ubar(:,:,knew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps,cff, cx,cy,
     &            dft,dfx,dfy, tau,tau_in,tau_out, uv_crss
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "climat.h"
#include "scalars.h"
# include "boundary.h"
!
#include "compute_auxiliary_bounds.h"
!
#if defined M2_FRC_BRY || defined M2NUDGING
      tau_in=dtfast*tauM_in
      tau_out=dtfast*tauM_out
#endif
#ifdef OBC_FLUX_CORR
      uv_crss=ubar_xs*dtfast/tau_obc
#endif

#ifndef EW_PERIODIC
      if (WESTERN_EDGE) then                
# ifdef OBC_WEST                  
#  ifdef OBC_M2ORLANSKI
        do j=jstr,jend+1
          grad(istr  ,j)=(ubar(istr  ,j,kstp)-ubar(istr  ,j-1,kstp))
#   ifdef MASKING
     &                                                *pmask(istr,j)
#   endif
          grad(istr+1,j)=(ubar(istr+1,j,kstp)-ubar(istr+1,j-1,kstp))
#   ifdef MASKING
     &                                              *pmask(istr+1,j)
#   endif
        enddo
        do j=jstr,jend
          dft=ubar(istr+1,j,kstp)-ubar(istr+1,j,knew)
          dfx=ubar(istr+1,j,knew)-ubar(istr+2,j,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                       ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(istr+1,j)+grad(istr+1,j+1)) .gt. 0.) then
            dfy=grad(istr+1,j  )
          else
            dfy=grad(istr+1,j+1)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          ubar(istr,j,knew)=( cff*ubar(istr,j,kstp)
     &                       +cx*ubar(istr+1,j,knew)
     &                    -max(cy,0.)*grad(istr,j  )
     &                    -min(cy,0.)*grad(istr,j+1)
     &                                   )/(cff+cx)
#   ifdef OBC_FLUX_CORR
     &                                    -uv_crss
#   endif
#   if defined M2_FRC_BRY || defined M2NUDGING
          ubar(istr,j,knew)=(1.-tau)*ubar(istr,j,knew)
#    ifdef M2_FRC_BRY
     &                               +tau*ubar_west(j)
#    else
     &                              +tau*ubclm(istr,j)
#    endif
#   endif
#   ifdef MASKING
          ubar(istr,j,knew)=ubar(istr,j,knew)*umask(istr,j)
#   endif
        enddo
#  else          /* alternative open: Flather, specified, gradient */
        do j=jstr,jend
#   if defined OBC_M2FLATHER
          ubar(istr,j,knew)=ubar_west(j)
     &                     -sqrt(2.*g/(h(istr-1,j)+h(istr,j)))*(
     &                0.5*(zeta(istr-1,j,kstp)+zeta(istr,j,kstp))
     &                                            -zeta_west(j) )            
#   elif defined OBC_M2SPECIFIED
c**       ubar(istr,j,knew)=ubclm(istr,j)
          ubar(istr,j,knew)=ubar_west(j)
#   else
          ubar(istr,j,knew)=ubar(istr+1,j,knew)
#   endif
#   ifdef MASKING
          ubar(istr,j,knew)=ubar(istr,j,knew)*umask(istr,j)
#   endif
        enddo
#  endif
# else
        do j=jstr,jend                          ! Western edge closed
          ubar(istr,j,knew)=0.                  ! ======= ==== ======
        enddo                                   !  (no-flux, default)
# endif           /* OBC_WEST */
      endif     !<-- WESTERN_EDGE
 
 
 
      if (EASTERN_EDGE) then
# ifdef OBC_EAST
#  ifdef OBC_M2ORLANSKI
!                                           Eastern edge radiation BC
!                                           ======= ==== ========= ==
        do j=jstr,jend+1
          grad(iend  ,j)=(ubar(iend  ,j,kstp)-ubar(iend  ,j-1,kstp))
#   ifdef MASKING 
     &                                                *pmask(iend,j)
#   endif
          grad(iend+1,j)=(ubar(iend+1,j,kstp)-ubar(iend+1,j-1,kstp))
#   ifdef MASKING
     &                                              *pmask(iend+1,j)
#   endif
        enddo
        do j=jstr,jend
          dft=ubar(iend,j,kstp)-ubar(iend  ,j,knew)
          dfx=ubar(iend,j,knew)-ubar(iend-1,j,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                       ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(iend,j)+grad(iend,j+1)) .gt. 0.) then
            dfy=grad(iend,j)
          else
            dfy=grad(iend,j+1)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          ubar(iend+1,j,knew)=( cff*ubar(iend+1,j,kstp)
     &                             +cx*ubar(iend,j,knew)
     &                      -max(cy,0.)*grad(iend+1,j  )
     &                      -min(cy,0.)*grad(iend+1,j+1)
     &                                       )/(cff+cx)
#   ifdef OBC_FLUX_CORR
     &                                       +uv_crss
#   endif
#   if defined M2_FRC_BRY || defined M2NUDGING
          ubar(iend+1,j,knew)=(1.-tau)*ubar(iend+1,j,knew)
#    ifdef M2_FRC_BRY
     &                                   +tau*ubar_east(j)
#    else
     &                                +tau*ubclm(iend+1,j)
#    endif
#   endif
#   ifdef MASKING
          ubar(iend+1,j,knew)=ubar(iend+1,j,knew)*umask(iend+1,j)
#   endif
        enddo
#  else          /* alternative open: Flather, specified, gradient */
        do j=jstr,jend
#   if defined OBC_M2FLATHER
          ubar(iend+1,j,knew)=ubclm(iend+1,j)
     &                       +sqrt(2.*g/(h(iend+1,j)+h(iend,j)))*(
     &                 0.5*( zeta(iend,j,kstp)+zeta(iend+1  ,j,kstp))
     &                                -zeta_east(j) )
#   elif defined OBC_M2SPECIFIED
          ubar(iend+1,j,knew)=ubclm(iend+1,j)
#   else
          ubar(iend+1,j,knew)=ubar(iend,j,knew)
#   endif
#   ifdef MASKING
          ubar(iend+1,j,knew)=ubar(iend+1,j,knew)*umask(iend+1,j)
#   endif
        enddo
#  endif
# else
        do j=jstr,jend                       ! Eastern edge closed BC
          ubar(iend+1,j,knew)=0.             ! ======= ==== ====== ==
        enddo
# endif /* OBC_EAST */
      endif         !<-- EASTERN_EDGE
#endif              /* !EW_PERIODIC */
 
 
 
#ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
# ifdef OBC_SOUTH
#  if defined OBC_M2ORLANSKI
!                                          Southern edge radiation BC
!                                          ======== ==== ========= ==
        do i=istrU-1,iend
          grad(i,jstr-1)=ubar(i+1,jstr-1,kstp)-ubar(i,jstr-1,kstp)
          grad(i,jstr  )=ubar(i+1,jstr  ,kstp)-ubar(i,jstr  ,kstp)
        enddo
        do i=istrU,iend
          dft=ubar(i,jstr,kstp)-ubar(i,jstr  ,knew)
          dfx=ubar(i,jstr,knew)-ubar(i,jstr+1,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                        ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(i-1,jstr)+grad(i,jstr)) .gt. 0.) then
            dfy=grad(i-1,jstr)
          else
            dfy=grad(i  ,jstr)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          ubar(i,jstr-1,knew)=( cff*ubar(i,jstr-1,kstp)
     &                             +cx*ubar(i,jstr,knew)
     &                      -max(cy,0.)*grad(i-1,jstr-1)
     &                      -min(cy,0.)*grad(i  ,jstr-1)
     &                                       )/(cff+cx)
#   if defined M2_FRC_BRY || defined M2NUDGING
          ubar(i,jstr-1,knew)=(1.-tau)*ubar(i,jstr-1,knew)
#    ifdef M2_FRC_BRY
     &                                  +tau*ubar_south(i)
#    else
     &                                +tau*ubclm(i,jstr-1)
#    endif
#   endif
#   ifdef MASKING
          ubar(i,jstr-1,knew)=ubar(i,jstr-1,knew)*umask(i,jstr-1)
#   endif
        enddo
#  else          /* alternative open: Chapman, specified, gradient */
        do i=istrU,iend
#   if defined OBC_M2FLATHER
          cx=dtfast*sqrt(0.5*g*(h(i-1,jstr-1)+h(i,jstr-1)))
     &                    *0.5*(pn(i-1,jstr-1)+pn(i,jstr-1))
          ubar(i,jstr-1,knew)=( ubar(i,jstr-1,kstp)
     &               +cx*ubar(i,jstr,knew) )/(1.+cx)
#   elif defined OBC_M2SPECIFIED
          ubar(i,jstr-1,knew)=ubclm(i,jstr-1)
#   else
          ubar(i,jstr-1,knew)=ubar(i,jstr,knew)
#   endif
#   ifdef MASKING
          ubar(i,jstr-1,knew)=ubar(i,jstr-1,knew)*umask(i,jstr-1)
#   endif
        enddo
#  endif
# else
#  ifdef EW_PERIODIC
#   define I_RANGE istrU,iend
#  else
#   define I_RANGE istr,iendR
#  endif                                ! Wall: free-slip (gamma2=+1)
        do i=I_RANGE                    ! ====    no-slip (gamma2=-1)
          ubar(i,jstr-1,knew)=gamma2*ubar(i,jstr,knew)
#  ifdef MASKING
     &                                *umask(i,jstr-1)
#  endif
        enddo
#  undef I_RANGE
# endif              /* OBC_SOUTH */
      endif          !<-- SOUTHERN_EDGE
 
 
 
      if (NORTHERN_EDGE) then
# ifdef OBC_NORTH
#  if defined OBC_M2ORLANSKI
!                                          Northern edge radiation BC
!                                          ======== ==== ========= ==
        do i=istrU-1,iend
          grad(i,jend  )=ubar(i+1,jend  ,kstp)-ubar(i,jend,kstp  )
          grad(i,jend+1)=ubar(i+1,jend+1,kstp)-ubar(i,jend+1,kstp)
        enddo
        do i=istrU,iend
          dft=ubar(i,jend,kstp)-ubar(i,jend  ,knew)
          dfx=ubar(i,jend,knew)-ubar(i,jend-1,knew)
 
          if (dfx*dft .lt. 0.) then
            dft=0.                        ! <-- cancel cx, if inflow
#   if defined M2_FRC_BRY || defined M2NUDGING
            tau=tau_in
          else
            tau=tau_out
#   endif
          endif
 
          if (dft*(grad(i-1,jend)+grad(i,jend)) .gt. 0.) then
            dfy=grad(i-1,jend)
          else
            dfy=grad(i  ,jend)
          endif
 
#   ifdef OBC_RAD_NORMAL
          dfy=0.
#   endif
          cff=max(dfx*dfx+dfy*dfy, eps)
          cx=dft*dfx
#   ifdef OBC_RAD_NPO
          cy=0.
#   else
          cy=min(cff,max(dft*dfy,-cff))
#   endif
 
          ubar(i,jend+1,knew)=( cff*ubar(i,jend+1,kstp)
     &                             +cx*ubar(i,jend,knew)
     &                      -max(cy,0.)*grad(i-1,jend+1)
     &                      -min(cy,0.)*grad(i  ,jend+1)
     &                                       )/(cff+cx)
#   if defined M2_FRC_BRY || defined M2NUDGING
          ubar(i,jend+1,knew)=(1.-tau)*ubar(i,jend+1,knew)
#    ifdef M2_FRC_BRY
     &                                  +tau*ubar_north(i)
#    else
     &                                +tau*ubclm(i,jend+1)
#    endif
#   endif
#   ifdef MASKING
          ubar(i,jend+1,knew)=ubar(i,jend+1,knew)*umask(i,jend+1)
#   endif
        enddo
#  else          /* alternative open: Chapman, specified, gradient */
        do i=istrU,iend
#   if defined OBC_M2FLATHER
          cx=dtfast*sqrt(0.5*g*(h(i-1,jend+1)+h(i,jend+1)))
     &                    *0.5*(pn(i-1,jend+1)+pn(i,jend+1))
          ubar(i,jend+1,knew)=( ubar(i,jend+1,kstp)
     &                +cx*ubar(i,jend,knew))/(1.+cx)
#   elif defined OBC_M2SPECIFIED
c**          ubar(i,jend+1,knew)=ubclm(i,jend+1)
             ubar(i,jend+1,knew)=ubar_north(i)
#   else
          ubar(i,jend+1,knew)=ubar(i,jend,knew)
#   endif
#   ifdef MASKING
          ubar(i,jend+1,knew)=ubar(i,jend+1,knew)*umask(i,jend+1)
#   endif
        enddo
#  endif
# else
#  ifdef EW_PERIODIC
#   define I_RANGE istrU,iend
#  else
#   define I_RANGE istr,iendR
#  endif                               !  Wall: free-slip (gamma2=+1)
        do i=I_RANGE                   !  =====   no-slip (gamma2=-1)
          ubar(i,jend+1,knew)=gamma2*ubar(i,jend,knew)
#  ifdef MASKING
     &                                *umask(i,jend+1)
#  endif
        enddo
#  undef I_RANGE
# endif               /* OBC_NORTH */
      endif          !<-- NORTHERN_EDGE
#endif                /* !NS_PERIODIC */
 
                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========
 
#if defined OBC_SOUTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        ubar(istr,jstr-1,knew)=0.5*( ubar(istr+1,jstr-1,knew)
     &                                  +ubar(istr,jstr,knew))
      endif
#endif
#if defined OBC_SOUTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        ubar(iend+1,jstr-1,knew)=0.5*( ubar(iend,jstr-1,knew)
     &                                +ubar(iend+1,jstr,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_WEST
      if (WESTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        ubar(istr,jend+1,knew)=0.5*( ubar(istr+1,jend+1,knew)
     &                                  +ubar(istr,jend,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_EAST
      if (EASTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        ubar(iend+1,jend+1,knew)=0.5*( ubar(iend,jend+1,knew)
     &                                +ubar(iend+1,jend,knew))
      endif
#endif
      return
      end
 
