#include "cppdefs.h"
#ifdef SOLVE3D
# ifdef TCLIMATOLOGY
 
      subroutine rho_clim (tile)
      implicit none
      integer tile
#  include "param.h"
#  include "private_scratch.h"
#  include "compute_tile_bounds.h"
      call rho_clim_tile (istr,iend,jstr,jend, A2d(1,1), A2d(1,2),
     &                                         A2d(1,3), A2d(1,4))
      return
      end
 
      subroutine rho_eos1_tile (istr,iend,jstr,jend, rho1, K0,K1,K2)
!
! The same as rho_eos, density anomaly is computed using
! climatological arrays as input.
!
      implicit none
#  include "param.h"
      integer istr,iend,jstr,jend, i,j,k
      real rho1(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       K0(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       K1(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       K2(PRIVATE_1D_SCRATCH_ARRAY,0:N)
#  include "grid.h"
#  include "ocean3d.h"
#  include "climat.h"
#  include "scalars.h"
#  ifdef NONLIN_EOS
      real A00, A01, A02, A03, A04, A10, A11, A12, A13, Tt,
     &          AS0, AS1, AS2, B00, B01, B02, B03, B10, B11, Ts,
     &          B12, BS1, E00, E01, E02, E10, E11, E12, sqrtTs
      parameter (A00=+19092.56 ,  A01=+209.8925   , A02=-3.041638 ,
     &          A03=-1.852732e-3, A04=-1.361629e-5, A10=104.4077   ,
     &          A11=-6.500517   , A12=+0.1553190  , A13=2.326469e-4 ,
     &          AS0=-5.587545   , AS1=+0.7390729  , AS2=-1.909078e-2,
     &          B00=+4.721788e-1, B01=+1.028859e-2, B02=-2.512549e-4,
     &          B03=-5.939910e-7, B10=-1.571896e-2, B11=-2.598241e-4,
     &          B12=+7.267926e-6, BS1=+2.042967e-3,
     &          E00=+1.045941e-5, E01=-5.782165e-10,E02=+1.296821e-7,
     &          E10=-2.595994e-7, E11=-1.248266e-9, E12=-3.508914e-9)
      real QR, Q01, Q02, Q03, Q04, Q05, Q10, Q11,
     &         Q12, Q13, Q14, QS0, QS1, QS2, Q20
      parameter (QR=+999.842594 , Q01=+6.793952e-2, Q02=-9.095290e-3,
     &          Q03=+1.001685e-4, Q04=-1.120083e-6, Q05=+6.536332e-9,
     &          Q10=+0.824493   , Q11=-4.08990e-3 , Q12=+7.64380e-5 ,
     &          Q13=-8.24670e-7 , Q14=+5.38750e-9 , QS0=-5.72466e-3 ,
     &          QS1=+1.02270e-4 , QS2=-1.65460e-6 , Q20=+4.8314e-4 )
#  endif
!
#  include "compute_auxiliary_bounds.h"
!
#  ifdef NONLIN_EOS
        do j=jstrR,jendR                                 ! NONLINEAR
          do k=1,N                                       !  EQUATION
            do i=istrR,iendR                             !  OF STATE
              Tt=tclm(i,j,k,itemp)
#   ifdef SALINITY
              Ts=tclm(i,j,k,isalt)
              sqrtTs=sqrt(Ts)
#   else
              Ts=0.
              sqrtTs=0.
#   endif
              K0(i,k)=A00+Tt*(A01+Tt*(A02+Tt*(A03+Tt*A04)))
     &                   +Ts*(A10+Tt*(A11+Tt*(A12+Tt*A13))
     &                       +sqrtTs*(AS0+Tt*(AS1+Tt*AS2)))
              K1(i,k)=B00+Tt*(B01+Tt*(B02+Tt*B03))
     &                   +Ts*(B10+Tt*(B11+Tt*B12)+sqrtTs*BS1)
              K2(i,k)=E00+Tt*(E01+Tt*E02)
     &                   +Ts*(E10+Tt*(E11+Tt*E12))
              rho1(i,k)=QR+Tt*(Q01+Tt*(Q02+Tt*(Q03+Tt*(Q04+Tt*Q05))))
     &                    +Ts*(Q10+Tt*(Q11+Tt*(Q12+Tt*(Q13+Tt*Q14)))
     &                          +sqrtTs*(QS0+Tt*(QS1+Tt*QS2))+Ts*Q20)
            enddo
            do i=istrR,iendR
              rho(i,j,k)=rho1(i,k)/( 1.0+0.1*z_r(i,j,k)/( K0(i,k)
     &                       -z_r(i,j,k)*(K1(i,k)-z_r(i,j,k)*K2(i,k))
     &                                                       ))-rho0
#   ifdef MASKING
              rho(i,j,k)=rho(i,j,k)*rmask(i,j)
#   endif
            enddo
          enddo
        enddo
#  else
        do k=1,N                                         ! LINEAR
          do j=jstrR,jendR                               ! EQUATION
            do i=istrR,iendR                             ! OF STATE
              rho(i,j,k)=R0+Tcoef*tclm(i,j,k,itemp)
#   ifdef SALINITY
     &                     +Scoef*tclm(i,j,k,isalt)
#   endif
#   ifdef MASKING
              rho(i,j,k)=rho(i,j,k)*rmask(i,j)
#   endif
            enddo
          enddo
        enddo
#  endif /* NONLIN_EOS */
# endif /* TCLIMATOLOGY */
#endif /* SOLVE3D */
      return
      end
 
 
 
 
