#include "cppdefs.h"
#if defined SGI || defined __IFC || defined ALPHA || defined AIX \
 || defined PGI 
!
! Sort out machine-dependent implementation issues: on some
! platforms Open MP threads are kernel-level threads, which means
! that they have different pids and their CPU times can be measured
! separately (in this case summation of the CPU times is performed);
! on other platforms they are user-level threads (like mandated by
! POSIX standard), hence it is no longer possible to distinguish
! CPU time consumed by individual threads; no summation will be
! performed in this case. Additionally, Open MP (standard v. 2.0)
! function omp_get_wtime may not be implemented on some platforms,
! so its use is avoided.
!
# if defined SGI || defined __IFC || defined ALPHA || defined PGI
c--#  define KERNEL_THREADS
c--# else
#  undef KERNEL_THREADS
# endif
# if defined SGI || defined PGI
#  undef OMP_GET_WTIME
# else
#  define OMP_GET_WTIME
# endif
# ifdef AIX 
#  define ETIME etime_
# else
#  define ETIME etime
# endif


                                        ! Initialize timers for all 
      subroutine start_timers (ierr)    ! threads. NOTE: for some
      implicit none                     ! reason SGI does not support 
      integer ierr, getpid              ! OpenMP wall clock timing
# include "param.h"
# include "scalars.h"
# ifdef OMP_GET_WTIME
C$    real*8 omp_get_wtime              ! function, so it is avoided.
# endif
      real*4 ETIME

      if (mod(NSUB_X*NSUB_E,numthreads).eq.0) then
        ierr=0
        if (proc(1).eq.0) then
          proc(1)=getpid()
# ifdef OMP_GET_WTIME 
C$        WallClock=omp_get_wtime()
# endif
          CPU_time(1) = ETIME (CPU_time(2))
C$OMP CRITICAL (start_timers_cr_rgn)
          if (trd_count.eq.0) then
C$          MPI_master_only write(stdout,'(/1x,A/)')
C$   &            'Version compiled using OpenMP library.'
            MPI_master_only write(stdout,'(3(1x,A,I3))')
     &                   'NUMBER OF THREADS:', numthreads,
     &                   'BLOCKING:', NSUB_X, 'x', NSUB_E
          endif
          trd_count=trd_count+1
# ifdef MPI
          write(stdout,'(1x,A,I3,A,I3,A,I10,A)') 'Process ',mynode,
     &        ' thread', proc(2), ' (pid=', proc(1), ') is active.'
# else
          write(stdout,'(1x,A,I3,A,i10,A)') 'Thread #', proc(2),
     &                           ' (pid=', proc(1), ') is active.'
# endif
          if (trd_count.eq.numthreads) trd_count=0
C$OMP END CRITICAL (start_timers_cr_rgn)
        endif
      else
# ifdef MPI
        if (proc(2).eq.0 .and. mynode.eq.0) then
# else
        if (proc(2).eq.0) then
# endif
          write(stdout,'(/1x,A,3(1x,A,I3),A/)') 'ERROR: wrong',
     &         'choice of numthreads =', numthreads,
     &         'while NSUB_X =', NSUB_X, 'NSUB_E =', NSUB_E,'.'
        endif
        ierr=1
      endif
      return
      end
 
      subroutine stop_timers()            ! Finalize timings
      implicit none                       ! for all threads.
# include "param.h"
# include "scalars.h"
# ifdef OMP_GET_WTIME 
C$    real*8 omp_get_wtime
# endif
      real*4 ETIME

      if (proc(1).ne.0) then
        proc(1)=0
# ifdef OMP_GET_WTIME 
C$      WallClock = omp_get_wtime() - WallClock 
# endif
        CPU_time(1) = ETIME (CPU_time(2)) - CPU_time(1) 
C$OMP CRITICAL (stop_timers_cr_rgn)
        if (trd_count.eq.0) write(*,*)
# ifdef MPI
        write(stdout,'(1x,A,I3,2x,A,I3,2(2x,A,F12.2),2x,A,F10.2)')
     & 'Process ', mynode, 'thread', proc(2),  'net:', CPU_time(1),
     &                   'cpu:', CPU_time(2),  'sys:', CPU_time(3)

# else
        write(stdout,'(12x,A,I3,2(2x,A,F12.2),2x,A,F10.2)')
     &               'Thread #', proc(2),  'net:', CPU_time(1),
     &               'cpu:', CPU_time(2),  'sys:', CPU_time(3)
# endif

# ifdef KERNEL_THREADS
        CPU_time_ALL(1)=CPU_time_ALL(1) +CPU_time(1)
        CPU_time_ALL(2)=CPU_time_ALL(2) +CPU_time(2)
        CPU_time_ALL(3)=CPU_time_ALL(3) +CPU_time(3)
# else
        CPU_time_ALL(1)=max(CPU_time_ALL(1), CPU_time(1))
        CPU_time_ALL(2)=max(CPU_time_ALL(2), CPU_time(2))
        CPU_time_ALL(3)=max(CPU_time_ALL(3), CPU_time(3))
# endif
        trd_count=trd_count+1
        if (trd_count.eq.numthreads) then
          trd_count=0
          write(stdout,'(20x,A,F15.2,F18.2,F16.2)') 'TOTAL:',
     &      CPU_time_ALL(1), CPU_time_ALL(2), CPU_time_ALL(3)
# ifdef OMP_GET_WTIME 
C$        write(stdout,'(3x,2A,F12.2)') 'Wall Clock (elapsed) ',
C$   &                                    'Time:',  WallClock
# endif
        endif
C$OMP END CRITICAL (stop_timers_cr_rgn)
      endif
      return
      end
#else
      subroutine start_timers()
      return
      end
      subroutine stop_timers()
      return
      end
#endif
 
 
