#include "cppdefs.h"
 
      implicit none
      character filename*128, label*6, string*64
      integer*4 iin,max_length, last_arg,iargc, ne, is,ie, i,j,n,
     &        ndots, iic, solid_line, dashed_line, dotted_line,
     &        icolor, iocheck,ipa
      parameter (iin=11, max_length=100000)
      real*4 xx(max_length), xmin,xmax, tmin,tmax, t,dt, tdays,
     &       yy(max_length), ymin,ymax, emin,emax, y,de, PA(16),
     &       level, thin_line, medium_line, thick_line
      parameter (xmin=0.15, xmax=0.95, ymin=0.15, ymax=0.95)
      parameter (solid_line=1,   dashed_line=2,    dotted_line=3,
     &           thin_line=0.6,  medium_line=1.1,  thick_line=2.)
      data icolor/1/  ipa/1/
      logical start_range, inside_range, log_scale
 
c--#define POSTSCRIPT
#ifdef POSTSCRIPT
      integer ngpswk
      call gopks(6,i)
      call ngsetc('ME','energy.ps')
      call gopwk(1,2,ngpswk('PS','PORTRAIT','COLOR')) !!'MONOCHROME'))
      call gacwk(1)
#else
      call opngks
#endif
      last_arg=iargc()
      if (last_arg.eq.0) stop 'NO FILE TO PROCESS'
 
#if defined SEAMOUNT
      tmin=0.
      tmax=250.
 
      ipa=1
 
      if (ipa.eq.1 .or. ipa.eq.2) then
        log_scale=.true.
        emin=3.E-6
        emax=1.1E-3
         emin=3.E-10
 
c        emin=3.E-10
c        emax=0.12E-3
 
 
c        emin=3.E-7    ! Comparison
c        emax=0.3E-3   ! among 30.XXXh
 
 
      elseif (ipa.ge.3 .and. ipa.le.5) then
        log_scale=.false.
        emin=0.
        emax=0.35
        emax=0.175   ! 30.XXXh
      elseif (ipa.eq.6) then
        log_scale=.false.
        emin=0.
        emax=1.05
      endif
 
 
 
 
#elif defined DAMEE_B
      tmin=0.
      tmax=tmin + 360.*20.
# ifdef REST_STATE_TEST
      emin=0.2E-5
      emax=2.0E-4
      log_scale=.true.
# else
      emin=0.5E-3
      emax=2.25E-3
      log_scale=.false.
# endif
#elif defined PACIFIC
      tmin=345.
      tmax=12500.
      emin=0.
      emax=0.0035
      ipa=1
#endif
 
      ne=7
      de=(emax-emin)/float(ne)
 
      call set (xmin,xmax, ymin,ymax, tmin,tmax, emin,emax, 1)
      call gsclip (0)
      call gslwsc (thin_line)
      call line(tmin,emin, tmax,emin)
      call line(tmin,emin, tmin,emax)
 
      if (tmax-tmin.gt.719.) then
        dt=360.
      elseif (tmax-tmin.gt.89.) then
        dt=30.
      elseif (tmax-tmin.gt.29.) then
        dt=10.
      else
        dt=1.
      endif
 
      t=tmin
  1    write(label,'(I6)') int(t-tmin)
        is=1
        do while (label(is:is).eq.' ' .and. is.lt.6)
          is=is+1
        enddo
        call gslwsc (thick_line)
        call plchhq(t,emin-0.03*(emax-emin),label(is:6),0.01,0.,0.)
        call gslwsc (thin_line)
        call line(t,emin,t, emin-0.01*(emax-emin))
        call gsln (dotted_line)
        call line (t,emin, t,emax)
        call gsln (solid_line)
       t=t+dt
      if (t.le.tmax) goto 1
 
      if (ipa.eq.1) then
        string=':F9:E:BF7:kin:N:,m:S:2:N:s:S:-2'
      elseif (ipa.eq.2) then
        string=':F9:E:BF7:bar:N:,m:S:2:N:s:S:-2'
      elseif (ipa.eq.3) then
        string=':F9:V:BF7:max:N:,ms:S:-1'
      elseif (ipa.eq.4) then
        string=':F9:<V>:BF7:max:N:,ms:S:-1'
      elseif (ipa.eq.5) then
        string=':F9:(V-<V>):BF7:max:N:,ms:S:-1'
      elseif (ipa.eq.6) then
        string=':F9:E:BF7:bar:N:/:F9:E:BF7:kin:N:'
 
      elseif (ipa.eq.3) then
        string=':F9:E:BF7:bcn:N:,m:S:2:N:s:S:-2'
      endif
 
      call gslwsc (thick_line)
      call plchhq(tmin+0.025*(tmax-tmin),emax, string, 0.025,0.,-1.)
      if (log_scale) then
        call set (xmin,xmax, ymin,ymax, tmin,tmax, emin,emax, 2)
        do j=-10,+10
          level=10.D0**j
          if (emin.le.level .and. level.le.emax) then
            write(label,'(PE6.0)') level
            call gslwsc (thick_line)
            call plchhq(tmin-0.025*(tmax-tmin),level, label,
     &                                           0.012, 0., +1.)
            call gslwsc (thin_line)
            call line(tmin,level, tmin-0.015*(tmax-tmin), level)
            call gsln (dotted_line)
            call line(tmin,level, tmax,level)
            call gsln (solid_line)
            do i=2,9
              y=0.1*level*float(i)
              if (emin.le.y .and. y.le.emax) call line(tmin,y,
     &                            tmin-0.005*(tmax-tmin), y)
            enddo
          endif
        enddo
      else
        do j=1,ne
          level=emin+j*de
          write(label,'(F6.4)') level
          call gslwsc (thick_line)
          call plchhq(tmin-0.025*(tmax-tmin),level,label,0.012,0.,+1.)
          call gslwsc (thin_line)
          call line(tmin,level, tmin-0.015*(tmax-tmin), level)
        enddo
      endif
      call gsclip (1)
c*      goto 100
 
      do n=1,last_arg
        filename=' '
        call getarg(n,filename)
        write(*,'(1x,2A)') 'Processing ', filename
        open(unit=iin,file=filename,form='formatted')
        ndots=0
        start_range=.false.
        inside_range=.true.
        do while (inside_range)
          if (start_range) then
            read(iin,*,iostat=iocheck,end=98) iic,
#ifdef SEAMOUNT
     &                        tdays, (PA(i), i=1,6)
#else
     &                        tdays, (PA(i), i=1,4)
#endif
            if (iocheck.eq.0) then
              if (tdays.gt.tmax) inside_range=.false.
              ndots=ndots+1
              xx(ndots)=tdays
              yy(ndots)=PA(ipa)
            endif
          else
            read(iin,'(A)',iostat=iocheck) string
            if (string(2:5).eq.'STEP') start_range=.true.
          endif
        enddo
  98    close (iin)
        write(*,*) 'ndots=',ndots
        if (ndots.gt.1) then
          if (xx(1)-tmin .lt. 0.01*(tmax-tmin)) then
c            call set_new_color (icolor, last_arg)
          endif
          call gslwsc (medium_line)
          call curved (xx,yy,ndots)
c**       do i=1,ndots
c**         write(*,*) i, xx(i),yy(i)
c**       enddo
        endif
 
        is=1
        do while (filename(is:is).eq.' ')
          is=is+1
        enddo
        i=is+1
        do while (filename(i:i).ne.' ')
          ie=i
          i=i+1
        enddo
        if (filename(is:is+4).eq.'trace') is=is+5
        if (filename(is:is).eq.'.'.or.filename(is:is).eq.'_') is=is+1
        call plchhq (xx(ndots)+0.01*(tmax-tmin), yy(ndots),
     &                              filename(is:ie), 0.0085, 0., -1.)
      enddo
 
 100  call frame
#ifdef POSTSCRIPT
      call gdawk(1)
      call gclwk(1)
      call gclks
#else
      call clsgks
      call system ('idt gmeta &')
#endif
      stop
      end
 
      subroutine set_new_color (icolor, maxcolor)
      implicit none
      integer*4 icolor, maxcolor, i
      real*4 RGB(3,30), frac
      data RGB/0.15,0.00,0.37,  0.07,0.05,0.47,  0.00,0.10,0.56,
     &         0.07,0.20,0.64,  0.20,0.30,0.71,  0.25,0.40,0.77,
     &         0.25,0.50,0.80,  0.35,0.60,0.85,  0.50,0.70,0.90,
     &         0.50,0.80,0.75,  0.50,0.80,0.60,  0.50,0.80,0.55,
     &         0.50,0.80,0.30,  0.50,0.85,0.30,  0.50,0.90,0.30,
     &         0.65,0.90,0.15,  0.80,0.90,0.00,  0.80,0.85,0.00,
     &         0.80,0.80,0.00,  0.85,0.75,0.00,  0.90,0.70,0.00,
     &         0.93,0.60,0.00,  0.95,0.50,0.00,  0.95,0.40,0.00,
     &         0.93,0.30,0.00,  0.88,0.15,0.00,  0.82,0.00,0.04,
     &         0.73,0.00,0.13,  0.66,0.00,0.20,  0.60,0.00,0.30/
      frac=30.*float(icolor)/float(maxcolor)
      i=1+frac
      frac=frac-float(i-1)
      icolor=icolor+1
      write(*,*) icolor,i,frac
      call gscr (1, icolor+1, (1.-frac)*RGB(1,i)+frac*RGB(1,i+1),
     &                        (1.-frac)*RGB(2,i)+frac*RGB(2,i+1),
     &                        (1.-frac)*RGB(3,i)+frac*RGB(3,i+1))
      call gsplci (icolor+1)
      return
      end
 
