! Dimensions of Physical Grid and array dimensions:
! =========== == ======== ==== === ===== ============
! LLm,MMm  Number of the internal points of the PHYSICAL grid.
!          in the XI- and ETA-directions [physical side boundary
!          points and peroodic ghost points (if any) are excluded].
!
! Lm,Mm    Number of the internal points [see above] of array
!          covering a Message Passing subdomain. In the case when
!          no Message Passing partitioning is used, these two are
!          the same as LLm,MMm.
!
! N        Number of vertical levels.
!

      integer  LLm,Lm,  MMm,Mm, N
# if defined GRID_LEVEL && GRID_LEVEL < MAX_GRID_LEVEL
     &    , imin_child,imax_child, jmin_child,jmax_child
# endif
      parameter (
#if defined BASIN
     &               LLm=180, MMm=140, N=12
#elif defined CANYON_A
     &               LLm=65,  MMm=48,  N=10
#elif defined CANYON_B
     &               LLm=66,  MMm=48,  N=12
#elif defined DAMEE_B
     &               LLm=128, MMm=128, N=20
c**  &               LLm=256, MMm=256, N=20
#elif defined GRAV_ADJ
     &               LLm=128, MMm=2,   N=32
c     &               LLm=256, MMm=2,   N=64
#elif defined NJ_BIGHT
c*   &               LLm=98,  MMm=206, N=12
     &               LLm=24,  MMm=34,  N=10
#elif defined PACIFIC
c     &               LLm=384, MMm=224, N=30
     &               LLm=768, MMm=512, N=40

#elif defined PACIFIC_2D
     &               LLm=768, MMm=512, N=1
c    &               LLm=1520, MMm=1088, N=1

#elif defined OVERFLOW
     &               LLm=4,   MMm=128, N=20
#elif defined SEAMOUNT
     &               LLm=48,  MMm=48,  N=16
c    &               LLm=96,  MMm=96,  N=22
c    &               LLm=192, MMm=96,  N=22
#elif defined ISWAKE
     &               LLm=360, MMm=160, N=20
c     &               LLm=720, MMm=320, N=20
#elif defined SHELFRONT
     &               LLm=4,   MMm=40,  N=12
#elif defined SOLITON
c     &               LLm=96,  MMm=32,  N=1
c     &               LLm=192, MMm=64,  N=1
     &               LLm=384, MMm=128, N=1
c     &               LLm=768, MMm=256, N=1
#elif defined TASMAN_SEA
     &               LLm=128, MMm=128, N=4
#elif defined RIVER
     &               LLm=40,  MMm=160,  N=16
c     &                LLm=60,  MMm=240,  N=24
#elif defined UPWELLING
     &               LLm=20,  MMm=80,  N=16
#elif defined USWEST
# ifdef GRID_LEVEL
#  if GRID_LEVEL == 1
     &               LLm=83,  MMm=168, N=20,         ! Monteray Bay,
     &               imin_child=40,  imax_child=71,  ! Level 1, 15 km
     &               jmin_child=54,  jmax_child=117
#  elif GRID_LEVEL == 2
     &               LLm=93,  MMm=189, N=20          ! Level 2, 5 km 
#  endif 
# else  

     &               LLm=62,   MMm=126, N=40      ! SCB L0 grid 
c**  &               LLm=83,   MMm=168, N=20      ! MB_L1
c**  &               LLm=126,  MMm=254, N=20      ! USWEST grid 16 

# endif
#else
     &                LLm=??, MMm=??, N=??
#endif
     &                                      )
!
! Domain subdivision parameters:
! ====== =========== ===========
! NNODES          total number of MPI processes (nodes);
! NP_XI,  NP_ETA  number of MPI subdomains in XI-, ETA-directions;
! NSUB_X, NSUB_E  number of shared memory subdomains (tiles) in
!                                      XI- and ETA-directions;
      integer NSUB_X, NSUB_E
#ifdef MPI
     &      , NP_XI,  NP_ETA, NNODES
      parameter (NP_XI=2, NP_ETA=2, NNODES=NP_XI*NP_ETA,
     &                              Lm=LLm/NP_XI, Mm=MMm/NP_ETA)
      parameter (NSUB_X=1, NSUB_E=1)
#else
      parameter (NSUB_X=6, NSUB_E=128,      Lm=LLm, Mm=MMm)
#endif
!
! Number of tracers and tracer identification indices:
! ====== == ======= === ====== ============== ========
!
#ifdef SOLVE3D
      integer NT, itemp
# ifdef SALINITY
     &          , isalt
# endif
# ifdef BIOLOGY
     &          , iNO3_, iNH4_, iDet_, iPhyt, iZoo_
# endif
      parameter (itemp=1,
# ifdef SALINITY
     &           isalt=2,
#  ifdef BIOLOGY
     &           NT=7, iNO3_=3, iNH4_=4, iDet_=5, iPhyt=6, iZoo_=7
#  else
     &           NT=2
#  endif
# else
#  ifdef BIOLOGY
     &           NT=6, iNO3_=2, iNH4_=3, iDet_=4, iPhyt=5, iZoo_=6
#  else
     &           NT=1
#  endif
# endif
     &           )
#endif /*SOLVE3D */
#ifdef PSOURCE
      integer Msrc         ! Number of point sources, if any
      parameter (Msrc=10)
#endif
#ifdef STATIONS
      integer NS           ! Number of output stations (if any).
      parameter (NS=5)
#endif
#ifdef FLOATS
       integer Mfloats          ! Maximum number of floats
       parameter (Mfloats=32000)! ====== == ====== ========
#endif
!
! Derived dimension parameters.
!
      integer stdout, padd_X,padd_E
      parameter (stdout=6, padd_X=(Lm+2)/2-(Lm+1)/2,
     &                     padd_E=(Mm+2)/2-(Mm+1)/2)
 
