#include "cppdefs.h"
#ifdef LMD_KPP
 
      subroutine lmd_wscale_tile (istr,iend,jstr,jend,
     &                            imin,imax,jmin,jmax,
     &                     ustar, Bfsfc,zscale, wm,ws)
!
! Compute the urbulent velocity scales for momentum and tracer
! using a 2D-lookup table as a function of "ustar" and "zetahat".
!
! input:  Bfsfc   boyancy forcing
!          zscale  boundary layer depth [m].
!
! output: wm   turbulent velocity scale [m/s] for momentum
!         ws   turbulent velocity scale [m/s] for tracer
!
! This routine was adapted from Bill Large 1995 code.
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mixing.h"
# include "scalars.h"
 
      integer istr,iend,jstr,jend, imin,imax,jmin,jmax, i,j
      real ustar(PRIVATE_2D_SCRATCH_ARRAY),
     &     Bfsfc(PRIVATE_2D_SCRATCH_ARRAY),   eps,
     &    zscale(PRIVATE_2D_SCRATCH_ARRAY),   ustar3,   r2,
     &        wm(PRIVATE_2D_SCRATCH_ARRAY),   zetahat,  r3,
     &        ws(PRIVATE_2D_SCRATCH_ARRAY),   zetapar,  r4
      parameter (eps=1.E-20, r2=0.5, r3=1./3., r4=0.25)
 
      real zetam,zetas, am,cm, as,cs
      parameter (
     &    zetam=-0.2, ! Maximum stability parameters "zeta"
     &    zetas=-1.0, ! value of the 1/3 power law regime of
                          ! flux profile for momentum and tracers
     &    am=1.257,
     &    as=-28.86,  ! Coefficients of flux profile
     &    cm=8.360,   ! for momentum and tracers in their
     &    cs=98.96)   ! 1/3 power law regime;
 
 
      do j=jmin,jmax
        do i=imin,imax
          ustar3=ustar(i,j)*ustar(i,j)*ustar(i,j)
          zetahat=vonKar*zscale(i,j)*Bfsfc(i,j)
          zetapar=zetahat/(ustar3+eps)
# ifdef MASKING
          zetahat=zetahat*rmask(i,j)
          zetapar=zetapar*rmask(i,j)
# endif
!
!  Stable regime.
!
          if (zetahat.ge.0.) then
            wm(i,j)=vonKar*ustar(i,j)/(1.+5.*zetapar)
            ws(i,j)=wm(i,j)
!
!  Unstable regime.
!
          else
            if (zetapar.gt.zetam) then
              wm(i,j)=vonKar*ustar(i,j)*(1.-16.*zetapar)**r4
            else
              wm(i,j)=vonKar*(am*ustar3-cm*zetahat)**r3
            endif
            if (zetapar.gt.zetas) then
              ws(i,j)=vonKar*ustar(i,j)*(1.-16.*zetapar)**r2
            else
              ws(i,j)=vonKar*(as*ustar3-cs*zetahat)**r3
            endif
          endif
        enddo       /* !!! This loop wan not pipelined. */
      enddo
      return
      end
#else
      subroutine lmd_wscale
      end
#endif /* LMD_KPP */
 
