#include "cppdefs.h"
#if defined SOLVE3D && defined QCORRECTION && !defined ANA_SST
 
      subroutine get_sss (ierr)     ! Read sea surface salinity
      implicit none
# define SST_DATA
# include "param.h"
# include "forces.h"
# include "scalars.h"
# include "netcdf.inc"
# include "ncvars.h"
      real cff
      integer ierr, i, lstr,lvar,lenstr, nf_fread
!
! Initialization: Check, whether forcing netCDF file is already
!===============  opened, an if not, open it. Find and save netCDF
! IDs for relevant variables, and determine whether sss data exists
! as 2D field or scalar. After that determine whether there is
! cycling to reuse the input data and what is cycling period
! "sss_cycle", set initial cycling index "sss_ncycle", record index
! "sss_rec", and time index "itsss" and both time record bounds to
! large negative artificial values, so that it will trigger logic in
! reading part below.
!
      ierr=nf_noerr
      if (FIRST_TIME_STEP) then
        lstr=lenstr(frcname)
        if (ncidfrc.eq.-1) then
          ierr=nf_open(frcname(1:lstr), nf_nowrite, ncidfrc)
          if (ierr.ne.nf_noerr) write(stdout,'(/1x,4A/)') 'ERROR ',
     &                   'in get_sss: can not open netCDF file ''',
     &                                       frcname(1:lstr), '''.'
        endif
        if (ierr .eq. nf_noerr) then
          ierr=nf_inq_varid (ncidfrc, 'sss_time', sss_tid)
          if (ierr .eq. nf_noerr) then
            lvar=lenstr(vname(1,indxSSS))
            ierr=nf_inq_varid (ncidfrc, vname(1,indxSSS)(1:lvar),
     &                                                   sss_id)
            if (ierr .eq. nf_noerr) then
              call set_cycle (ncidfrc, sss_tid, ntsss, sss_cycle,
     &                                 sss_ncycle, sss_rec, ierr)
              itsss=1
              sss_time(1)=-1.E+20
              sss_time(2)=-1.E+20
            else
              write(stdout,1) vname(1,indxSSS)(1:lvar),
     &                                     frcname(1:lstr)
            endif
          else
            write(stdout,1) 'sss_time', frcname(1:lstr)
          endif
        endif
      endif
  1   format(/1x,'ERROR in get_sss: cannot find variable ''',
     &     A, ''''/7x, 'in forcing netCDF file ''', A, '''.')
!
! Reading data from the forcing file:  Get out, if model time is
!======== ==== ==== === ======= =====  already within the interval
! set by the past and future data times. Otherwise flip the time
! index, increment record and cycling indices and read a new portion
! of data. Repeat it until model time is between the two times from
! data.
!
      do while (sss_time(itsss).lt.time+dt .and. ierr.eq.nf_noerr)
        call advance_cycle (sss_cycle, ntsss, sss_ncycle,
     &                                 sss_rec,     ierr)
        if (ierr .eq. nf_noerr) then
          ierr=nf_get_var1_FTYPE (ncidfrc, sss_tid, sss_rec, cff)
          if (ierr .eq. nf_noerr) then
            itsss=3-itsss
            sss_time(itsss)=cff*day2sec + sss_cycle*sss_ncycle
            ierr=nf_fread (sssg(START_2D_ARRAY,itsss), ncidfrc,
     &                                 sss_id, sss_rec, r2dvar)
            if (ierr .eq. nf_noerr) then
              write(stdout,'(6x,2A,G12.4,1x,A,I4)') 'get_sss   --',
     &               '  read SSS                       for time =',
     &                  cff MYID
            else
              write(stdout,2) 'SSS', sss_rec
            endif
          else
            write(stdout,2) 'sss_time', sss_rec
          endif
        else
          write(stdout,'(/1x,A,I4,1x,A,I4/7x,4A/7x,2(A,G12.4)/)')
     &   'ERROR in get_sss: requested time record ',      sss_rec,
     &   'exeeds the last record', ntsss, 'available in forcing ',
     &   'netCDF file ''',   frcname(1:lstr),   '''',  'tdays = ',
     &    tdays,        '  but the last available  sss_time =',
     &                                    sss_time(itsss)*sec2day
        endif
      enddo
  2   format(/1x,'ERROR in get_sss: cannot read variable ''', A,
     &                                    ''' for record ', I4/)
      return
      end
#else
      subroutine get_sss_empty
      end
#endif /* QCORRECTION && !ANA_SST */
