#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine u3dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for XI-component velocity
! u(:,:,:,nnew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j,k
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps, cff,
     &                            cx,cy, dft,dfx,dfy
      parameter (eps=1.E-20)
# include "param.h"
# include "grid.h"
# include "ocean3d.h"
# include "scalars.h"
!
# include "compute_auxiliary_bounds.h"
!
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
#  ifdef OBC_WEST
#   ifdef OBC_M3ORLANSKI
!                                        !  Western edge radiation BC
        do k=1,N                         !  ======= ==== ========= ==
          do j=jstr,jend+1
            grad(1,j)=(u(1,j,k,nstp)-u(1,j-1,k,nstp))
            grad(2,j)=(u(2,j,k,nstp)-u(2,j-1,k,nstp))
          enddo
          do j=jstr,jend
            dft=u(2,j,k,nstp)-u(2,j,k,nnew)
            dfx=u(2,j,k,nstp)-u(3,j,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(2,j)+grad(2,j+1)) .gt. 0.) then
              dfy=grad(2,j)
            else
              dfy=grad(2,j+1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            u(1,j,k,nnew)=( (1.-cx)*u(1,j,k,nstp)+cx*u(2,j,k,nstp)
     &                                      -max(cy,0.)*grad(1,j  )
     &                                      -min(cy,0.)*grad(1,j+1)
     &                                                            )
#    ifdef MASKING
            u(1,j,k,nnew)=u(1,j,k,nnew)*umask(1,j)
#    endif
          enddo
        enddo
#   else
        do k=1,N                           ! Western edge gradient BC
          do j=jstr,jend                   ! ======= ==== ======== ==
            u(1,j,k,nnew)=u(2,j,k,nnew)
#    ifdef MASKING
     &                      *umask(1,j)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                            !  Western edge closed BC
          do j=jstr,jend                    !  ======= ==== ====== ==
            u(1,j,k,nnew)=0.
          enddo
        enddo
#  endif              /* OBC_WEST */
      endif         !<-- WESTERN_EDGE
 
      if (EASTERN_EDGE) then
#  ifdef OBC_EAST
#   ifdef OBC_M3ORLANSKI
!                                           Eastern edge radiation BC
        do k=1,N                         !  ======= ==== ========= ==
          do j=jstr,jend+1
            grad(Lm,j)=(u(Lm,j,k,nstp)-u(Lm,j-1,k,nstp))
            grad(Lm+1,j)=(u(Lm+1,j,k,nstp)-u(Lm+1,j-1,k,nstp))
          enddo
          do j=jstr,jend
            dft=u(Lm,j,k,nstp)-u(Lm,j,k,nnew)
            dfx=u(Lm,j,k,nstp)-u(Lm-1,j,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(Lm,j)+grad(Lm,j+1)) .gt. 0.) then
              dfy=grad(Lm,j)
            else
              dfy=grad(Lm,j+1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            u(Lm+1,j,k,nnew)=( (1.-cx)*u(Lm+1,j,k,nstp)
     &                                    +cx*u(Lm  ,j,k,nstp)
     &                               -max(cy,0.)*grad(Lm+1,j  )
     &                               -min(cy,0.)*grad(Lm+1,j+1)
     &                                                        )
#    ifdef MASKING
            u(Lm+1,j,k,nnew)=u(Lm+1,j,k,nnew)*umask(Lm+1,j)
#    endif
          enddo
        enddo
#   else
        do k=1,N                           ! Eastern edge gradient BC
          do j=jstr,jend                   ! ======= ==== ======== ==
          u(Lm+1,j,k,nnew)=u(Lm,j,k,nnew)
#    ifdef MASKING
     &                     *umask(Lm+1,j)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                             ! Eastern edge closed BC
          do j=jstr,jend                     ! ======= ==== ====== ==
            u(Lm+1,j,k,nnew)=0.
          enddo
        enddo
#  endif
      endif         !<-- EASTERN_EDGE
# endif             /* !EW_PERIODIC */
 
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
#  ifdef OBC_SOUTH
#   ifdef OBC_M3ORLANSKI
!                                          Southern edge radiation BC
        do k=1,N                         ! ======== ==== ========= ==
          do i=istrU-1,iend
            grad(i,0)=(u(i+1,0,k,nstp)-u(i,0,k,nstp))
            grad(i,1)=(u(i+1,1,k,nstp)-u(i,1,k,nstp))
          enddo
          do i=istrU,iend
            dft=u(i,1,k,nstp)-u(i,1,k,nnew)
            dfx=u(i,1,k,nstp)-u(i,2,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i-1,1)+grad(i,1)) .gt. 0.) then
              dfy=grad(i-1,1)
            else
              dfy=grad(i  ,1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            u(i,0,k,nnew)=( (1.-cx)*u(i,0,k,nstp)+cx*u(i,1,k,nstp)
     &                                      -max(cy,0.)*grad(i-1,0)
     &                                      -min(cy,0.)*grad(i  ,0)
     &                                                            )
#    ifdef MASKING
            u(i,0,k,nnew)=u(i,0,k,nnew)*umask(i,0)
#    endif
          enddo
        enddo
#   else
        do k=1,N                          ! Southern edge gradient BC
          do i=istrU,iend                 ! ======== ==== ======== ==
            u(i,0,k,nnew)=u(i,1,k,nnew)
#    ifdef MASKING
     &                      *umask(i,0)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef EW_PERIODIC
#    define I_RANGE istrU,iend
#   else
#    define I_RANGE istr,iendR
#   endif                         !  Closed BC: free-slip (gamma2=+1)
        do k=1,N                  !  ====== ===   no-slip (gamma2=-1)
          do i=I_RANGE
            u(i,0,k,nnew)=gamma2*u(i,1,k,nnew)
#   ifdef MASKING
     &                             *umask(i,0)
#   endif
          enddo
        enddo
#   undef I_RANGE
#  endif
      endif             !<-- SOUTHERN_EDGE
 
      if (NORTHERN_EDGE) then
#  ifdef OBC_NORTH
#   ifdef OBC_M3ORLANSKI
!                                          Northern edge radiation BC
        do k=1,N                         ! ======== ==== ========= ==
          do i=istrU-1,iend
            grad(i,Mm)=u(i+1,Mm,k,nstp)-u(i,Mm,k,nstp)
            grad(i,Mm+1)=u(i+1,Mm+1,k,nstp)-u(i,Mm+1,k,nstp)
          enddo
          do i=istrU,iend
            dft=u(i,Mm,k,nstp)-u(i,Mm,k,nnew)
            dfx=u(i,Mm,k,nstp)-u(i,Mm-1,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i-1,Mm)+grad(i,Mm)) .gt. 0.) then
              dfy=grad(i-1,Mm)
            else
              dfy=grad(i  ,Mm)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            u(i,Mm+1,k,nnew)=( (1.-cx)*u(i,Mm+1,k,nstp)
     &                                       +cx*u(i,Mm,k,nstp)
     &                                -max(cy,0.)*grad(i-1,Mm+1)
     &                                -min(cy,0.)*grad(i  ,Mm+1)
     &                                                         )
#    ifdef MASKING
            u(i,Mm+1,k,nnew)=u(i,Mm+1,k,nnew)*umask(i,Mm+1)
#    endif
          enddo
        enddo
#   else                                  ! Northern edge gradient BC
        do k=1,N                          ! ======== ==== ======== ==
          do i=istrU,iend
            u(i,Mm+1,k,nnew)=u(i,Mm,k,nnew)
#    ifdef MASKING
     &                       *umask(i,Mm+1)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef EW_PERIODIC
#    define I_RANGE istrU,iend
#   else
#    define I_RANGE istr,iendR
#   endif                         !  Closed BC: free-slip (gamma2=+1)
        do k=1,N                  !  ====== ===   no-slip (gamma2=-1)
          do i=I_RANGE
            u(i,Mm+1,k,nnew)=gamma2*u(i,Mm,k,nnew)
#   ifdef MASKING
     &                              *umask(i,Mm+1)
#   endif
          enddo
        enddo
#   undef I_RANGE
#  endif
      endif   !<-- NORTHERN_EDGE
# endif        /* !NS_PERIODIC */
!                                   Corners (except periodic), if any
!                                   ======= ======= ========== == ===
# if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          u(1,0,k,nnew)=0.5*(u(2,0,k,nnew)+u(1,1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          u(Lm+1,0,k,nnew)=0.5*(u(Lm,0,k,nnew)+u(Lm+1,1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          u(1,Mm+1,k,nnew)=0.5*(u(2,Mm+1,k,nnew)+u(1,Mm,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          u(Lm+1,Mm+1,k,nnew)=0.5*(u(Lm  ,Mm+1,k,nnew)+
     &                             u(Lm+1,Mm  ,k,nnew))
        enddo
      endif
# endif
#else
      subroutine u3dbc_empty
#endif /* SOLVE3D */
      return
      end
 
