#include "cppdefs.h"
#if defined SGI || defined __IFC || ALPHA 
 
      subroutine start_timers (ierr)       ! Initialize timing
      implicit none                        ! for all threads.
      integer ierr, getpid
      real*4 etime
#include "param.h"
#include "scalars.h"
      if (mod(NSUB_X*NSUB_E,numthreads).eq.0) then
        ierr=0
        if (proc(1).eq.0) then
          proc(1)=getpid()
          CPU_time(1)=etime(CPU_time(2))
C$OMP CRITICAL (start_timers_cr_rgn)
          if (trd_count.eq.0) then
C$          MPI_master_only write(stdout,'(/1x,A/)')
C$   &            'Version compiled using OpenMP library.'
            MPI_master_only write(stdout,'(3(1x,A,I3))')
     &                   'NUMBER OF THREADS:', numthreads,
     &                   'BLOCKING:', NSUB_X, 'x', NSUB_E
          endif
          trd_count=trd_count+1
# ifdef MPI
          write(stdout,'(1x,A,I3,A,I3,A,I10,A)') 'Process ',mynode,
     &        ' thread', proc(2), ' (pid=', proc(1), ') is active.'
# else
          write(stdout,'(1x,A,I3,A,i10,A)') 'Thread #', proc(2),
     &                           ' (pid=', proc(1), ') is active.'
# endif
          if (trd_count.eq.numthreads) trd_count=0
C$OMP END CRITICAL (start_timers_cr_rgn)
        endif
      else
# ifdef MPI
        if (proc(2).eq.0 .and. mynode.eq.0) then
# else
        if (proc(2).eq.0) then
# endif
          write(stdout,'(/1x,A,3(1x,A,I3),A/)') 'ERROR: wrong',
     &         'choice of numthreads =', numthreads,
     &         'while NSUB_X =', NSUB_X, 'NSUB_E =', NSUB_E,'.'
        endif
        ierr=1
      endif
      return
      end
 
      subroutine stop_timers()            ! Finalize timings
      implicit none                       ! for all threads.
      real*4 etime
#include "param.h"
#include "scalars.h"
      if (proc(1).ne.0) then
        proc(1)=0
        CPU_time(1) = etime(CPU_time(2)) - CPU_time(1)
C$OMP CRITICAL (stop_timers_cr_rgn)
# ifdef MPI
        write(stdout,'(A8,I3,A7,I3,A5,F12.3,A5,F10.3,A5,F12.5)')
     & 'Process ',mynode,' thread', proc(2), ' CPU:', CPU_time(2),
     &                 ' sys:', CPU_time(3), ' net:', CPU_time(1)
# else
        write(stdout,'(A8,I3,A5,F12.3,A5,F10.3,A5,F12.5)')
     &               'Thread #',  proc(2), ' CPU:', CPU_time(2),
     &               ' sys:', CPU_time(3), ' net:', CPU_time(1)
# endif
        trd_count=trd_count+1
        CPU_time_ALL(1)=CPU_time_ALL(1)+CPU_time(1)
        CPU_time_ALL(2)=CPU_time_ALL(2)+CPU_time(2)
        CPU_time_ALL(3)=CPU_time_ALL(3)+CPU_time(3)
        if (trd_count.eq.numthreads) then
          trd_count=0
          write(stdout,'(A6,8x,F14.3,3x,F12.3,1x,F14.3)') 'TOTAL:',
     &           CPU_time_ALL(2), CPU_time_ALL(3), CPU_time_ALL(1)
        endif
C$OMP END CRITICAL (stop_timers_cr_rgn)
      endif
      return
      end
#else
      subroutine start_timers()
      return
      end
      subroutine stop_timers()
      return
      end
#endif
 
 
