!
! There is no mistake in formula (2.15) on page 3218 of 1998 paper
! of Tony Song. I was able to reproduce all derivation on pages 3217
! and 3218 and found that it is all correct. The code below also
! proves it, as well as the fact that there is no inconsistency
! between ROMS code and 1998 paper of Tony Song. Just save this
! file as a fortran program, compile it and run to verify that if
! WJ_GRADP is set to 0.25, then prs_exact and prsgrd coinside.
! No other setting of WJ_GRADP is able to reproduce this property.
!
! Background:  Similarly to POM standard Jacobian, Weighted Jacobian
!------------  of Tony Song is prodices zero pressure gradient if
!
!                          rho = LinearFunction(z)              (1)
!
!              In addition to that Weighted Jacobian of Tony Song
!              is capable to reproduce exact DYNAMICAL pressure
!              gradient if
!                          rho(x,z) = R0(x) + R1(x)*z           (2)
!
!              where R0 and R1 are arbitrary functions of horizontal
!              coordinate. All other schemes (POM, etc) fail to do
!              so. (this property is verified in the fortran code
!              for the specific setting
!
!                          rho(x,z) = x*z                       (3)
!
!              which also proves that there is no discrepancy between
!              ROMS code and 1998 paper of Tony Song (provided that
!              WJ_GRADP is set to 0.25).
!
!
! Therefore:
!===========
!
! 1. The setting of WJ_GRADP = 0.125 which was empirically
!    discovered to produce minimal pressure gradient error for
!    several applications including ROMS setup of Seamount problem,
!    USWEST, etc [which is significantly smaller than either
!    WJ_GRADP = 0 (standard, POM jacobian) or 0.25 original setting
!    of Tony Song] remain UNEXPLAINED and DOES NOT correspond to
!    1998 paper.
!
!    It is possible that optimality of 0.125 is just accidental
!    due to particular conditions of stratification and grid
!    stretching, etc... But robustness of this optimum accross
!    several application is quite striking.
!
!
!
! 2. The value/importance/relevance/wisdom or advantage to have
!    property (2) becomes questionable. Perhaps something else
!    plays a more significant role.
!
!    My long standing belief that coefficient 4 in denominator of
!    (2.15) on page 3218 should be changed to 8 [thus admitting
!    typo or an algebraic mistake in the paper, but confirming the
!    importance of the general idea of the paper in practice]
!    turned out to be incorrect.
!
!--------------------------------------------------------------------
!
      implicit none
      integer i,j,k, icase
      parameter (j=1)
      real*16 z_r(2,1,2), rho(2,1,2), Quarter, Half,
     &                 One, gamma,  prsgrd,  prs_exact,
     &              area, zstar, rleft, rright, prsgrd1
      parameter (Quarter=0.25Q0, Half=0.5Q0, One=1.Q0)
      data z_r/0.Q0, 1.05464Q0, 0.47674Q0, 1.2659576Q0/
 
 
      do icase=0,4
        write(*,*) 'icase =',icase
        if (icase.eq.0) then
          do k=1,2
            do i=1,2
              rho(i,j,k)=z_r(i,j,k)*qfloat(i)
            enddo
          enddo
        else
          do k=1,2
            do i=1,2
              rho(i,j,k)=0.Q0
            enddo
          enddo
          k=(icase-1)/2
          rho(icase-2*k,j,k+1)=1.Q0
        endif
        write(*,*) rho
 
      i=2
      k=1
 
          prs_exact=Quarter*( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                       +z_r(i,j,k  )+z_r(i-1,j,k  ))
 
     &                *Half*( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                       -z_r(i,j,k  )-z_r(i-1,j,k  ))
 
#define WJ_GRADP 0.25Q0
# ifdef WJ_GRADP
            gamma=WJ_GRADP *( z_r(i  ,j,k+1)-z_r(i-1,j,k+1)
     &                       +z_r(i  ,j,k  )-z_r(i-1,j,k  ))
 
     &                     *( z_r(i  ,j,k+1)-z_r(i-1,j,k+1)
     &                       -z_r(i  ,j,k  )+z_r(i-1,j,k  ))
 
     &                     /( (z_r(i  ,j,k+1)-z_r(i  ,j,k))
     &                       *(z_r(i-1,j,k+1)-z_r(i-1,j,k)))
# endif
            prsgrd=Quarter*(
# ifdef WJ_GRADP
     &           ( (One+gamma)*(rho(i,j,k+1)-rho(i-1,j,k+1))
     &            +(One-gamma)*(rho(i,j,k  )-rho(i-1,j,k  )))
     &                        *( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                          -z_r(i,j,k  )-z_r(i-1,j,k  ))
 
     &                        -( rho(i,j,k+1)+rho(i-1,j,k+1)
     &                          -rho(i,j,k  )-rho(i-1,j,k  ))
     &          *( (One+gamma)*(z_r(i,j,k+1)-z_r(i-1,j,k+1))
     &            +(One-gamma)*(z_r(i,j,k  )-z_r(i-1,j,k  )))
# else
     &                         ( rho(i,j,k+1)-rho(i-1,j,k+1)
     &                          +rho(i,j,k  )-rho(i-1,j,k  ))
     &                        *( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                          -z_r(i,j,k  )-z_r(i-1,j,k  ))
 
     &                        -( rho(i,j,k+1)+rho(i-1,j,k+1)
     &                          -rho(i,j,k  )-rho(i-1,j,k  ))
     &                        *( z_r(i,j,k+1)-z_r(i-1,j,k+1)
     &                          +z_r(i,j,k  )-z_r(i-1,j,k  ))
# endif
     &                                                      )
 
      write(*,*) 'gamma =', gamma
      write(*,*) 'prsgrd =', prsgrd
      write(*,*) ' exact =', prs_exact
      write(*,*) ' difference =', prsgrd-prs_exact
 
 
           zstar=Quarter*( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                    +z_r(i,j,k  )+z_r(i-1,j,k  ))
 
               area=Half*( z_r(i,j,k+1)+z_r(i-1,j,k+1)
     &                    -z_r(i,j,k  )-z_r(i-1,j,k  ))
 
           rleft=( rho(i-1,j,k)*(z_r(i-1,j,k+1)-zstar)
     &            +rho(i-1,j,k+1)*(zstar-z_r(i-1,j,k))
     &                 )/(z_r(i-1,j,k+1)-z_r(i-1,j,k))
 
              rright=( rho(i,j,k)*(z_r(i,j,k+1)-zstar)
     &                +rho(i,j,k+1)*(zstar-z_r(i,j,k))
     &                     )/(z_r(i,j,k+1)-z_r(i,j,k))
 
           prsgrd1=(rright-rleft)*area
 
        write(*,*)'prsgrd1 =', prsgrd1, 'error =', prsgrd1-prsgrd
 
      enddo
      stop
      end
 
 
