#include "cppdefs.h"
 
      subroutine sg_bbl96
#ifdef SG_BBL96
!
!--------------------------------------------------------------------
!  This subroutine computes kinematic bottom momentum stress using
c  Styles and Glenn bottom boundary layer formulation.
c
c  Calls:  sg_ubab
c
c  Reference:
c
c    Styles, R. and. S.M. Glenn, 1996:  Observation and modeling of
c      sediment transport events in the Middle Atlantic Bight,  8th
c      International conference on Physics of estuaries and coastal
c      seas. Submitted.
!--------------------------------------------------------------------
!
      implicit none
# include "param.h"
# include "pconst.h"
# include "bblm.h"
# include "forces.h"
# include "grid.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
# include "work.h"
 
      integer Siter, i, j
      real Sconv, UcoUw, Uratio, UstarCn, UstarCW, UstarWm, fwlim,
     &        term1, term2, z1, z2, z3
      real Uc(Lm,Mm),    Zc(Lm,Mm),     brlen(Lm,Mm),
     &     brscl(Lm,Mm), chi(Lm,Mm),    fw(Lm,Mm),     phic(Lm,Mm),
     &     phir(Lm,Mm),  rippht(Lm,Mm), rsden(L,M)
      equivalence (Uc,a2d), (Zc,b2d), (brlen,f2d), (brscl,g2d),
     &            (chi,f2d), (fw,h2d), (phic,c2d), (phir,d2d),
     &            (rippht,e2d), (rsden,e2d)
 
      real a1, a2, a3, a4, av2, av4
#include "avg.h"
 
 
 
      integer sg_Siter
      real sg_Seps, sg_brlmin, sg_alpha, sg_nu
      parameter (
 
     &    sg_Siter=20,    ! Maximum number of iterations in the
                          ! computation of stress due to bottom
                          ! friction velocity.
     &    sg_Seps= ???? used to be       c 1 4 m 4
                          ! Convergence criterion for the computation
                          !   of the stress due to bottom friction
                          ! velocity via the Newton-Raphson method.
 
     &    sg_brlmin=0.01, ! Minimum allowed bottom roughness length
                          ! (m).
 
     &    sg_alpha=0.5,   ! Free parameter indicating the constant
                          ! stress region of the wave boundary layer.
 
     &    sg_nu=1.19e-6)  ! Kinematic viscosity of seawater (m^2/s).
 
 
 
 
 
!
!  On first pass, initialize several quantities.
!-------------------------------------------------------------------
!
      if (iic.eq.ntstart) then
        do j=1,Mm
          do i=1,Lm
            UstarC(i,j)=0.
            Cr(i,j)=1.
          enddo
        enddo
      endif
!
!--------------------------------------------------------------------
!  Compute wave maximum bottom speed "Ub" and wave bottom excursion
!  amplitude "Ab" at RHO-points.
!--------------------------------------------------------------------
!
      call sg_ubab
!
!--------------------------------------------------------------------
!  Compute bottom horizontal current magnitude UC and direction PHIC
!  at height ZC above bottom at RHO-points.
!--------------------------------------------------------------------
!
      do j=1,Mm
        do i=1,Lm
          Uc(i,j)=sqrt(av2(u(i,j,1),u(i+1,j,1))**2+
     &                 av2(v(i,j,1),v(i,j+1,1))**2)
          phic(i,j)=atan2(av2(v(i,j,1),v(i,j+1,1)),
     &                    av2(u(i,j,1),u(i+1,j,1)))
          Zc(i,j)=h(i,j)+z_r(i,j,1)
        enddo
      enddo
!
!--------------------------------------------------------------------
!  Compute angle between currents and wind induced waves (radians).
!--------------------------------------------------------------------
!
      do j=1,Mm
        do i=1,Lm
          phir(i,j)=abs(Dwave(i,j)-phic(i,j))
        enddo
      enddo
!
!--------------------------------------------------------------------
!  Compute bottom roughness parameters.
!--------------------------------------------------------------------
!
!  Compute relative sediment density RSDEN.
!
      do j=1,Mm
        do i=1,Lm
          rsden(i,j)=Sdens(i,j)/rho(i,j,1)
        enddo
      enddo
c
c  Compute bottom roughness CHI (nondimensional).
c
      do j=1,Mm
        do i=1,Lm
          chi(i,j)=c4*sg_nu*Ub(i,j)*Ub(i,j)/
     &             (Ssize(i,j)*(g*Ssize(i,j)*(rsden(i,j)-1.))**1.5)
        enddo
      enddo
c
c  Compute ripple height RIPPHT (m).
c
      do j=1,Mm
        do i=1,Lm
          if (chi(i,j).lt.c3) then
            rippht(i,j)=Ab(i,j)*0.27*(chi(i,j)**(-0.5))
          else
            rippht(i,j)=Ab(i,j)*0.52*(chi(i,j)**(-1.1))
          endif
        enddo
      enddo
!
!  Compute bottom roughness length BRLEN (m) and bottom roughness
!  scale BRSCL height where the mean current is zero (m). Limit
!  BRLEN by it threshold value.
!
      do j=1,Mm
        do i=1,Lm
          brlen(i,j)=c4*rippht(i,j)
          if (brlen(i,j).lt.sg_brlmin) then
            brlen(i,j)=sg_brlmin
          endif
          brscl(i,j)=brlen(i,j)/c30
        enddo
      enddo
!
!--------------------------------------------------------------------
!  Compute momentum stress at the top of the bottom boundary layer.
!  Iterate until convergence or to maximum number of iterations. Use
!  Newton-Raphson method.
!--------------------------------------------------------------------
!
      Siter=0
      Sconv=sg_Seps
c
c  Determine time-averaged near-bottom friction current USTARC from
c  given mean horizontal current UC at height ZC above the bottom via
c  Newton-Raphson method.
c
      do while ((Siter.le.sg_Siter).and.(Sconv.ge.sg_Seps))
        Siter=Siter+1
        do j=1,Mm
          do i=1,Lm
c
c  Avoid computing variables associated with wind induced waves in
c  99 percent dominant current regimes.
c
            if (Ub(i,j).lt.(r100*Uc(i,j))) then
              UstarC(i,j)=Uc(i,j)*vonKar/log(Zc(i,j)/brscl(i,j))
            else
c
c  Compute friction factor FW due to wind induced waves using Madsen
c  (1994) formulation.
c
              fwlim=Cr(i,j)*Ab(i,j)/brlen(i,j)
              if (fwlim.le.100.) then
                fw(i,j)=Cr(i,j)*exp(-8.82+7.02*fwlim**(-0.078))
              else
                fw(i,j)=Cr(i,j)*exp(-7.30+5.61*fwlim**(-0.109))
              endif
c
c  Compute maximum wave friction speed USTARWM (m/s), combined
c  current/wave friction speed USTARCW (m/s), and CR.
c
              UstarWm=sqrt(0.5*Cr(i,j)*fw(i,j))*Ub(i,j)
              Uratio=UstarC(i,j)/UstarWm
              Cr(i,j)=sqrt(1.+2.*cos(phir(i,j))*Uratio**2+Uratio**4)
              UstarCW=UstarWm*sqrt(Cr(i,j))
c
c  Compute new time-averaged near-bottom friction current USTARC (m/s)
c  from given horizontal current UC (m/s) at height ZC (m) above the
c  bottom.
c
              UcoUw=UstarC(i,j)/UstarCW
              z1=sg_alpha*vonKar*UstarCW*Ab(i,j)/Ub(i,j)
              z2=z1/brscl(i,j)
              z3=UcoUw*Zc(i,j)/z1
              term1=UstarC(i,j)*(1.+log(z3)+UcoUw*(log(z2)-1.))
     &                         /vonKar - Uc(i,j)
              term2=(log(z3)+2.*(1.+UcoUw*(log(z2)-1.)))/vonKar
              UstarCn=UstarC(i,j)-term1/term2
              Sconv=max(Sconv,abs(UstarCn-UstarC(i,j)))
              UstarC(i,j)=UstarCn
            endif
          enddo
        enddo
      enddo
!
!--------------------------------------------------------------------
!  Compute kinematic bottom momentum stress (m^2/s^2) in the XI- and
!  ETA-directions.
!--------------------------------------------------------------------
!
      do j=1,Mm
        do i=1,Lm
          bustr(i,j)=-UstarC(i,j)*UstarC(i,j)*cos(phic(i,j))
          bvstr(i,j)=-UstarC(i,j)*UstarC(i,j)*sin(phic(i,j))
        enddo
      enddo
#endif /* SG_BBL96 */
      return
      end
 
