/* This is "global_definitions.h": It contains a set of predetermined
 macro definitions which are inserted into the individual files by
 C-preprocessor. General user is strongly discouraged from attempts
 to modify anything below this line.
------------------------------------------------------------------ */
 
/* Switch to mixed [tiled + single-block] execution. Activation of
 this switch enables special logical branch in "compute_tile_bounds"
 which recognizes tile=NSUB_X*NSUB_E as covering the whole model
 grid, and it increases sizes of arrays declared in "private_scratch"
 to accomodate enough workspace accordingly. This switch is used for
 debugging purposes only and normally should be undefined.
*/
 
c--#define ALLOW_SINGLE_BLOCK_MODE
#ifdef ALLOW_SINGLE_BLOCK_MODE
# define SINGLE NSUB_X*NSUB_E,NSUB_X*NSUB_E !!!
#endif
 
 
/* Take into account nonuniform density in barotropic mode pressure-
 gradient terms. If not activated, then Shallow Water Equation (SWE)
 term is used.  This switch has no effect for a 2D problem.
*/
 
#define VAR_RHO_2D
 
 
/* Switch ON/OFF double precision for real type variables (since this
 is mostly controlled by mpc and/or compuler options, this CPP-switch
 affects only on the correct choice of netCDF functions, see below)
 and the use QUAD precision for global summation variables, which is
 always desirable, but some compilers do not support it.
*/
 
#define DBLEPREC
 
 
/* Turn ON/OFF MPI parallelization. If not activated,the code becomes
 shared memory parallel code. The second switch makes each MPI
 process create its own output file (this switch has no effect if MPI
 is not defined).
*/
 
c--#define MPI
c--#define PARALLEL_FILES
 
/* Define standard dimensions for the model arrays (vertical
 dimensions are inserted explicitly in the code, when needed).
 Periodic and nonperiodic versions may differ by the number of
 ghost points on each edge (2 or 1 respectively). This distinction
 is present only in the purely SHARED MEMORY code. In the case of
 message passing, when array dimensions correspond to a portion of
 the physical domain (as opposite to the whole domain), so two
 ghost zones are always provided on the each side. These data for
 these two ghost zones is then exchanged by message passing.
*/
 
#ifdef MPI
# define GLOBAL_2D_ARRAY -1:Lm+2+padd_X,-1:Mm+2+padd_E
# define START_2D_ARRAY -1,-1
#else
# ifdef EW_PERIODIC
#  ifdef NS_PERIODIC
#   define GLOBAL_2D_ARRAY -1:Lm+2+padd_X,-1:Mm+2+padd_E
#   define START_2D_ARRAY -1,-1
#  else
#   define GLOBAL_2D_ARRAY -1:Lm+2+padd_X,0:Mm+1+padd_E
#   define START_2D_ARRAY -1,0
#  endif
# else
#  ifdef NS_PERIODIC
#   define GLOBAL_2D_ARRAY 0:Lm+1+padd_X,-1:Mm+2+padd_E
#   define START_2D_ARRAY 0,-1
#  else
#   define GLOBAL_2D_ARRAY 0:Lm+1+padd_X,0:Mm+1+padd_E
#   define START_2D_ARRAY 0,0
#  endif
# endif
#endif
 
#define PRIVATE_1D_SCRATCH_ARRAY istr-2:iend+2
#define PRIVATE_2D_SCRATCH_ARRAY istr-2:iend+2,jstr-2:jend+2
 
/* The following definitions contain fortran logical expressions
 equivalent to the question: ''Am I the thread working on subdomain
 [tile] which is adjacent to the WESTERN [EASTERN/SOUTHERN/NORTHERN]
 edge of the model domain?'' These logical expressions are used to
 control loop bounds over a subdomain [tile], so that boundary points
 are included, if needed and if the subdomain is adjacent to the
 boundary. They are also used to decide which thread is updating the
 segment of the boundary [bcs2d,bcs3d] to avoid mutual overlap. In
 the case when there is only one subdomain all four of these logical
 expressions have value .true.
 
 Alternative message passing and shared memory versions.
*/
 
#ifdef MPI
# define WESTERN_EDGE istr.eq.1 .and. .not.WEST_INTER
# define EASTERN_EDGE iend.eq.Lm .and. .not.EAST_INTER
# define SOUTHERN_EDGE jstr.eq.1 .and. .not.SOUTH_INTER
# define NORTHERN_EDGE jend.eq.Mm .and. .not.NORTH_INTER
#else
# define WESTERN_EDGE istr.eq.1
# define EASTERN_EDGE iend.eq.Lm
# define SOUTHERN_EDGE jstr.eq.1
# define NORTHERN_EDGE jend.eq.Mm
#endif
 
/* Sometimes an operation needs to be restricted to one MPI process,
 the master process. Typically this occurs when it is desirable to
 avoid redundant write of the same message by all MPI processes into
 stdout.  Also occasionally it is needed to include MPI-node number
 into printed message. To do it conditionally (MPI code only) add
 MYID (without preceeding comma) into the end of the message to be
 printed.
*/
 
#ifdef MPI
# define MPI_master_only if (mynode.eq.0)
# define MYID ,' mynode =', mynode
#else
# define MPI_master_only
# define MYID !
#endif
 
/* Similarly, if operation needed to be done by one thread only,
 e.g., copy a redundantly computed private scalar into shared scalar,
 or write an error message in situation where it is guaranteed that
 the error condition is discovered redundantly by every thread (and
 is the same for all) and only one needs to complain.
 
 ZEROTH_TILE is intended to restrict the operation only to thread
 which is working on south-western tile.
 
 Occasinally a subroutine designed to process a tile may be called
 to process the whole domain. If it is necessary to dustinguish
 whether it is being called for the whole domain (SINGLE_TILE_MODE)
 or a tile.
 
 Depending whether it is 2D or 3D configuration, determine what
 time step is the first (in 3D case barotropic mode is "restarted"
 at every 3D step from fast-time-averaged initial conditions) and
 decide which time step of fast variables zeta, ubar, vbar goes
 to output.
 
 All these switches are the same for MPI/nonMPI code.
*/
 
#define ZEROTH_TILE istr+jstr.eq.2
#define SINGLE_TILE_MODE  iend-istr+jend-jstr.eq.Lm+Mm-2
#define FIRST_TIME_STEP iic.eq.ntstart
#ifdef SOLVE3D
# define fast_indx_out kstp
# define FIRST_2D_STEP iif.eq.1
#else
# define fast_indx_out knew
# define FIRST_2D_STEP iic.eq.ntstart
#endif
 
 
/* Turn ON/OFF double precision for real type variables, associated
 intrinsic functions and netCDF library functions. It should be noted
 that because ROMS relies on compiler options and "mpc" program (see
 mpc.F) to generate double precision executable from default
 precision source code, this switch actually does NOT affect the size
 of real data and precision of the computation. Its main effect is to
 select the correct netCDF function (nf_xxxx_double/nf_xxxx_float,
 see below) to work properly, so it must be set consistently with mpc
 settings and compuler flags (if any) according to the intended
 accuracy. Additionally, activate the use QUAD precision for global
 summation variables, which is always desirable, but some compilers
 do not support it.
*/
 
#if defined DBLEPREC && !defined Linux && !defined __IFC
# define QUAD 16
#  define QuadZero 0.Q0
/* #  define QuadZero 0.0_16 */
#else
# define QUAD 8
# define QuadZero 0.D0
#endif
 
c-#ifdef DBLEPREC
c-# define float dfloat
c-# define FLoaT dfloat
c-# define FLOAT dfloat
c-# define sqrt dsqrt
c-# define SQRT dsqrt
c-# define exp dexp
c-# define EXP dexp
c-# define dtanh dtanh
c-# define TANH dtanh
c-#endif
 
/* Model netCDF input/output control: decide whether to put grid data
 into output files (separate choice for each output file) and select
 appropriate double/single precision types for netCDF input
 (controlled by NF_FTYPE) and netCDF output (NF_FOUT) functions.
 
 NOTE: Even if the whole code is compiled with double precision
 accuracy, it is still possible to save history and averages netCDF
 files in single precision in order to save disk space. This happens
 if HIS_DOUBLE switch is undefined. Status of HIS_DOUBLE switch does
 not precision of restart file, which is always kept consistent with
 precision of the code.
*/
 
/* #define HIS_DOUBLE */
#define PUT_GRID_INTO_RESTART
#define PUT_GRID_INTO_HISTORY
#define PUT_GRID_INTO_AVERAGES
 
#ifdef DBLEPREC
# define NF_FTYPE nf_double
# define nf_get_att_FTYPE nf_get_att_double
# define nf_put_att_FTYPE nf_put_att_double
# define nf_get_var1_FTYPE nf_get_var1_double
# define nf_put_var1_FTYPE nf_put_var1_double
# define nf_get_vara_FTYPE nf_get_vara_double
# define nf_put_vara_FTYPE nf_put_vara_double
# ifdef HIS_DOUBLE
#  define NF_FOUT nf_double
# else
#  define NF_FOUT nf_float
# endif
#else
# define NF_FTYPE nf_float
# define nf_get_att_FTYPE nf_get_att_real
# define nf_put_att_FTYPE nf_put_att_real
# define nf_get_var1_FTYPE nf_get_var1_real
# define nf_put_var1_FTYPE nf_put_var1_real
# define nf_get_vara_FTYPE nf_get_vara_real
# define nf_put_vara_FTYPE nf_put_vara_real
# define NF_FOUT nf_float
#endif
 
/* The following definitions are machine dependent macros, compiler
 directives, etc. A proper set of definitions is activated by a
 proper choice C-preprocessor flag, i.e. -DSGI for an SGI computer
 or -DCRAY for a Cray shared memory architecture (Y-MP, C-90, J-90).
 Definitions for other shared memory platforms may be appended here.
*/
#if defined SGI || defined sgi
# define CSDISTRIBUTE_RESHAPE !!
/* # define CSDISTRIBUTE_RESHAPE c$sgi distribute         */
/* # define CSDISTRIBUTE_RESHAPE c$sgi distribute_reshape */
# define BLOCK_PATTERN block,block
# define BLOCK_CLAUSE !! onto(2,*)
# define CVECTOR CDIR$ IVDEP
# define CSDOACROSS C$DOACROSS
# define CAND C$&
#elif defined CRAY || defined cray
# define CVECTOR CDIR$ IVDEP
# define CSDOACROSS CMIC$ DO ALL
# define CAND CMIC$&
# define SHARE SHARED
# define LOCAL PRIVATE
#endif
 
