#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine omega (tile)
      implicit none
      integer tile
# include "param.h"
# include "private_scratch.h"
# include "compute_tile_bounds.h"
      call omega_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine omega_tile (istr,iend,jstr,jend, wrk)
!
! Compute S-coordinate vertical velocity, w=[Hz/(m*n)]*omega [m^3/s],
! which has meaning of FINITE_VOLUME WATER FLUX across MOVING grid-
! box interfaces of RHO-boxes. To do so, we integrate divergence of
! horizontal mass fluxes from bottom up, starting with the no-normal
! flow boundary condition at the bottom (k=0); Once this operation is
! complete, W(:,:,N) contains vertical velocity at the free surface,
! which is the time-tendency of the free surface, d_zeta/d_t;
! To convert it into S-coordinate vertical velocity, one needs to
! subtract the vertical velocities of moving S-coordinate surfaces,
! which are proportional the product of d_zeta/d_t and the fraction
! of the distance from the point to the bottom divided by the total
! depth of water column, i.e. the whole S-coordinate system is
! "brethes" by linear in Z-space expansion and contraction set by
! variation in free surface.
!
      implicit none
      integer istr,iend,jstr,jend, i,j,k
# include "param.h"
      real wrk(PRIVATE_1D_SCRATCH_ARRAY), cff
# include "grid.h"
# include "ocean3d.h"
# include "scalars.h"
!
# include "compute_auxiliary_bounds.h"
!
      do j=jstr,jend         !!! WARNING: Setting old-new must be
        do i=istr,iend       !!!          consistent with similar
          W(i,j,0)=0.        !!!          setting in set_depth.F
        enddo
        do k=1,N,+1
          do i=istr,iend
            W(i,j,k)=W(i,j,k-1) -Huon(i+1,j,k)+Huon(i,j,k)
     &                          -Hvom(i,j+1,k)+Hvom(i,j,k)
          enddo
        enddo
 
        do i=istr,iend                                        !< new
          wrk(i)=W(i,j,N)/(z_w(i,j,N)-z_w(i,j,0))             !< new
        enddo                                                 !< new
 
        do k=N-1,1,-1
c**       cff=float(k)/float(N)                               !> old
          do i=istr,iend
c**         W(i,j,k)=W(i,j,k)-cff*W(i,j,N)                    !> old
 
            W(i,j,k)=W(i,j,k)-wrk(i)*(z_w(i,j,k)-z_w(i,j,0))  !< new
          enddo
        enddo
        do i=istr,iend
          W(i,j,N)=0.
        enddo
      enddo

# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then                       ! Set lateral
        do k=0,N                                   ! boundary 
          do j=jstr,jend                           ! conditions
            W(istr-1,j,k)=W(istr,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=0,N
          do j=jstr,jend
            W(iend+1,j,k)=W(iend,j,k)
          enddo
        enddo
      endif
# endif
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
        do k=0,N
          do i=istr,iend
            W(i,jstr-1,k)=W(i,jstr,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=0,N
          do i=istr,iend
            W(i,jend+1,k)=W(i,jend,k)
          enddo
        enddo
      endif
#  ifndef EW_PERIODIC
      if (WESTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        do k=0,N
          W(istr-1,jstr-1,k)=W(istr,jstr,k)
        enddo
      endif
      if (WESTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        do k=0,N
          W(istr-1,jend+1,k)=W(istr,jend,k)
        enddo
      endif
      if (EASTERN_EDGE .and.
     &    SOUTHERN_EDGE) then
        do k=0,N
          W(iend+1, jstr-1,k)=W(iend,jstr,k)
        enddo
      endif
      if (EASTERN_EDGE .and.
     &    NORTHERN_EDGE) then
        do k=0,N
          W(iend+1,jend+1,k)=W(iend,jend,k)
        enddo
      endif
#  endif
# endif
# if defined EW_PERIODIC || defined NS_PERIODIC  || defined MPI
      call exchange_w3d_tile (istr,iend,jstr,jend, W)
# endif
      return
      end
#else
      subroutine omega_empty
      end
#endif /* SOLVE3D */
 
