#include "cppdefs.h"
#ifdef LMD_KPP
 
      subroutine lmd_swfrac_tile (istr,iend,jstr,jend, Zscale,Z,swdk)
!
! Computes the fraction of solar shortwave flux penetrating to
! specified depth (times Zscale) due to exponential decay in Jerlov
! water type using Paulson and Simpson (1977) two-wavelength band
! solar  absorption model.
!
! input: Zscale   scale factor to apply to depth array
!        Z        vertical height [meters, negative] for
!                        desired solar short-wave fraction.
! output: swdk    shortwave (radiation) fractional decay.
!
! Reference:  Paulson, C.A., and J.J. Simpson, 1977: Irradiance
! meassurements in the upper ocean, J. Phys. Oceanogr., 7, 952-956.
!
!  This routine was adapted from Bill Large 1995 code.
!
      implicit none
# include "param.h"
# include "scalars.h"
      integer istr,iend,jstr,jend, i,j, Jwt
      real Zscale, Z(PRIVATE_2D_SCRATCH_ARRAY),
     &             swdk(PRIVATE_2D_SCRATCH_ARRAY)
      real mu1(5), mu2(5), r1(5), cff1 , cff2, cff3, cff4
 
      mu1(1)=0.35    !  Define reciprocal of the absorption
      mu1(2)=0.6     !  coefficient for each of two solar
      mu1(3)=1.0     !  wavelength bands as a function
      mu1(4)=1.5     !  of water type (Ref: Paulson and
      mu1(5)=1.4     !  Simpson, 1977).
 
      mu2(1)=23.0
      mu2(2)=20.0
      mu2(3)=17.0
      mu2(4)=14.0
      mu2(5)=7.9
 
      r1(1)=0.58     !  Define fraction of the total radiance
      r1(2)=0.62     !  for wavelength band 1 as a function of
      r1(3)=0.67     !  Jerlov water type. The fraction for
      r1(4)=0.77     !  wavelength band 2 is r2=1-r1.
      r1(5)=0.78
                     !  Set Jerlov water type to assign
      Jwt=1      !  everywhere; an integer from 1 to 5.
 
      do j=jstr,jend
        do i=istr,iend
          cff1=Z(i,j)*Zscale/mu1(Jwt)
          cff2=Z(i,j)*Zscale/mu2(Jwt)
          if (cff1.ge.-20.) then         ! Quick fix to avoid
            cff3=r1(Jwt) *exp(cff1)      ! computing exp(-15000)
          else
            cff3=0.
          endif
          if (cff2.ge.-20.) then
            cff4=(1.-r1(Jwt)) *exp(cff2)
          else
            cff4=0.
          endif
          swdk(i,j)=cff3+cff4
        enddo
      enddo
      return
      end
#else
      subroutine lmd_swfrac_empty
      end
#endif /* LMD_KPP */
 
 
