! This is "cross_matrix": analyzer of dependencies to build
!                         table of dependencies "Make.depend"
!------------------------------------------------------------------
! Usage:
!--------       cross_matrix list_of_files
! for example
!               cross_matrix *.F
! or
!               cross_matrix *.F *.h
! or
!               cross_matrix $(SRCS)            inside a makefile
!
! Algorithm:
!-----------
! cross_matrix reads all files from the list arguments it is given,
! and searches for the CPP command #include. If #include commands
! are found, in interprets names within the "..." as new files to be
! open and searched for #include inside it and so on.
!
! cross_matrix investigates chained include statements, for example,
! if file1 contains statement #include "file2", and file2 contains
! statement #include "file3", therefore file3 will be included into
! list of dependencies of "file1"
!
! Optionally, files which are not in the list of arguments AND
! which are not in the present working directory can be excluded
! from the list of dependencies (CPP switch EXCLUDE). A warning
! message will be issued about each file excluded from analysis.
!
#define EXCLUDE
#define WARN_NONSTANDARD
#define TRAP_DOUBLE_SLASH
c--#define VERBOSE
 
      implicit none
      integer max_name_size, max_names, max_string_size,
     &                               stdout, input, iout, test
      parameter (max_name_size=32, max_names=256, max_string_size=72,
     &                          stdout=6, input=11, iout=12, test=13)
      character*32 fname(max_names)
      character string*80, quote*1, double_quote*1, backslash*1
      integer nsize(max_names), size, line, nmax, lines_all,cpps_all,
     & empty_all,comm_all, n_disc, last_arg, iargc, iocheck, i,j,k,n
      logical matrix(max_names,max_names), new_name, not_end_of_file
      common /xxxx/ nsize, matrix /yyyy/fname
#ifdef EXCLUDE
      integer exc_names,nexc
      parameter (exc_names=16)
      integer exc_size(exc_names)
      character*32 exc_name(exc_names)
#endif
 
      last_arg=iargc()
      if (last_arg.eq.0) then
        write(stdout,'(/2(1x,A)/)') 'CROSS_MATRIX ERROR:',
     &                              'no files to process.'
        stop
      elseif (last_arg.gt.max_names) then
        goto 98                               !--> ERROR
      endif
 
      write(stdout,'(/2(1x,A)/)') 'This is CROSS_MATRIX:',
     &              'Creating new version of Make.depend.'
      quote=char(39)          !
      double_quote=char(34)   ! Reset everything:
      backslash=char(92)      !
      lines_all=0             ! <-- line counter all files altogether
      cpps_all=0
      empty_all=0
      comm_all=0
      n_disc=0                ! <-- counter of newly discovered files
#ifdef EXCLUDE
      nexc=0                  ! <-- counter of excluded files
#endif
      do j=1,max_names        !
        nsize(j)=0            ! <-- array of sizes of filenames
        do i=1,max_name_size  !
          fname(j)(i:i)=' '   ! <-- character array of filenames
        enddo                 !
        do i=1,max_names      !
          matrix(i,j)=.false. ! <-- matrix of dependencies:
        enddo                 !
      enddo                   ! Note: matrix(i,j)=.eq..true. means
                              ! that file j depends on i.
!
! The following block simply creates the list of given names and
! their sizes without actually opening the files.
!
      do n=1,last_arg
        call getarg(n,fname(n))
        i=1
        do while (fname(n)(i:i).eq.' ' .and. i.lt.max_name_size)
          i=i+1
        enddo
        j=i
        k=j+1
        do while (fname(n)(k:k).ne.' ' .and. k.lt.max_name_size)
          j=k
          k=j+1
        enddo
        if (i.eq.1) then
          nsize(n)=j
        else
          nsize(n)=j-i+1
          fname(n)(1:j-i+1)=fname(n)(i:j)
        endif
#ifdef VERBOSE
        write(stdout,'(4I3,1x,3A)') n,i,j, nsize(n),
     &            'fname = ''', fname(n)(i:j), '''.'
#endif
      enddo
      nmax=last_arg
!
! Create Make.depend file and write upper portion of the header.
! after which start processing of actual files.
!
      open(unit=iout, file='Make.depend', form='formatted')
      write(iout,'(3(A,1x,A/),A/A/A/A/A/A)')
     &         '# Make.depend: list of dependencies generated by',
     &         'cross_matrix.', '# WARNING: THIS IS A MACHINE',
     &         'GENERATED FILE: DO NOT EDIT !!!!!', '# To create',
     &         'or update this file use commands:', '#',
     &         '#        cross_matrix *.F',         '# or',
     &         '#        cross_matrix *.F *.h',     '# or',
     &         '#        make depend'
      n=0
  1    n=n+1
        line=0
        not_end_of_file=.true.
        open(unit=input, file=fname(n), form='formatted',
     &                               status='old', err=7)
  2     string(1:1)=' '
         read(input,'(A)',iostat=iocheck,end=3) string
         line=line+1
         goto 4
  3      not_end_of_file=.false.
  4      if (iocheck.eq.0 .and. string(1:1).eq.'#') then
           cpps_all=cpps_all+1
           i=2
           do while (string(i:i).eq.' ' .and. i.lt.max_string_size)
             i=i+1
           enddo
           if (string(i:i+6).eq.'include') then
             i=i+7
             do while (string(i:i).ne.double_quote .and.
     &                                        i.lt.max_string_size)
               i=i+1
             enddo
             if (i.lt.max_string_size) then
               j=i+1
               do while (string(j:j).ne.double_quote .and.
     &                                        j.lt.max_string_size)
                 j=j+1
               enddo
               size=j-i-1
               if (size.gt.0) then
                 new_name=.true.
                 do k=i+1,j-1
                   if (string(k:k).eq.' ') new_name=.false.
                 enddo
                 if (new_name) then
                   do k=1,nmax
                     if (size .eq. nsize(k)) then
                       if (string(i+1:j-1).eq.fname(k)(1:size)) then
                         new_name=.false.
                         matrix(k,n)=.true.
                       endif
                     endif
                   enddo
                   if (new_name) then
                     n_disc=n_disc+1
#ifdef EXCLUDE
                     open(unit=test, file=string(i+1:j-1),
     &                                status='old', err=5)
                     close(unit=test)
#endif
                     nmax=nmax+1
                     if (nmax.gt.max_names) goto 98  !--> ERROR
                     nsize(nmax)=size
                     fname(nmax)(1:size)=string(i+1:j-1)
                     matrix(nmax,n)=.true.
#ifdef VERBOSE
                     write(*,'(3A)') 'Discovered new file ''',
     &                       fname(nmax)(1:nsize(nmax)), '''.'
#endif
#ifdef EXCLUDE
                     goto 6
   5                 do k=1,nexc
                       if (size.eq.exc_size(k)) then
                         if (string(i+1:j-1).eq.exc_name(k)(1:size))
     &                                              new_name=.false.
                       endif
                     enddo
                     if (new_name) then
                       nexc=nexc+1
                       if (nexc.gt.exc_names) goto 99 !--> ERROR
                       exc_size(nexc)=size
                       exc_name(nexc)=string(i+1:j-1)
# ifdef VERBOSE
                       write(stdout,'(I4,1x,3A)') nexc, 'Exclude ''',
     &                         exc_name(nexc)(1:exc_size(nexc)),'''.'
# endif
                       write(iout,'(A/A,2x,A/2A)') '#',
     &                               '# WARNING: File is not found:',
     &                              exc_name(nexc)(1:exc_size(nexc)),
     &                               '# This file is excluded from ',
     &                               'the dependency list.'
                      endif
#endif
                   endif
                 endif       ! The following code segment counts
               endif         ! lines of code, comments, empty lines,
             endif           ! etc. This is needed for statistical
           endif             ! purposes only. It does not have any
         else                ! effect on the dependency matrix.
           i=1
           do while (string(i:i).eq.' ' .and. i.lt.max_string_size)
             i=i+1
           enddo
           j=max_string_size
           do while (j.gt.1 .and. string(j:j).eq.' ')
             j=j-1
           enddo
           if (string(j:j).eq.' ') j=j-1
           if (j.eq.0) then
             empty_all=empty_all+1
           elseif (i.eq.j .and. string(i:i).eq.'!') then
             empty_all=empty_all+1
           elseif (i.eq.1 .and. j.eq.1 .and. (string(1:1).eq.'c'
     &                            .or. string(1:1).eq.'C')) then
             empty_all=empty_all+1
           elseif (string(i:i).eq.'!') then
             comm_all=comm_all+1
           elseif (i.eq.1 .and. (string(1:1).eq.'c' .or.
     &                           string(1:1).eq.'C')) then
             comm_all=comm_all+1
           else
             lines_all=lines_all+1
           endif
         endif
#ifdef TRAP_DOUBLE_SLASH
         do i=1,max_string_size-1
           if (string(i:i).eq.'/' .and. string(i+1:i+1).eq.'/') then
              write(*,'(A/2A,I5,1x,3A/A/5(2A/),A)') '*****',
     &       '***** WARNING!!! Double slash /', '/ on line',
     &        line,    'in file ''', fname(n)(1:nsize(n)), '''.',
     &       '*****', '***** Although it is legal in FORTRAN as ',
     &       'string concatenation operator, double',
     &       '***** slash is interpreted as C++ comment line ',
     &       'by GCC C-preprocessor leading to',
     &       '***** possible misinterpritation of fortran code. ',
     &       'It shall be therefore policy',
     &       '***** of this code to eliminate all double slashes. ',
     &       'Use at least one blank ',
     &       '***** space between slashes in fortran ',
     &       'concatenation operator.', '*****'
           endif
         enddo
#endif
#ifdef WARN_NONSTANDARD
         do i=1,max_string_size
           k=ichar(string(i:i))
           if (string(i:i).eq.' ') then

           elseif (k.eq.9) then
             write(*,'(/1x,4A,I5,1x,A,I3,A/)') '***** WARNING!!! ',
     &         'file ', fname(n)(1:nsize(n)),  ' line',  line, ':',
     &          i, '  contains TAB character.'
           elseif (k.lt.33 .or. k.gt.126) then
             write(*,'(/1x,4A,I5,1x,A,I3,1x,A,I4,1X,2A/)') '***** ',
     &         'WARNING!!! file ',  fname(n)(1:nsize(n)),  ' line',
     &          line,':',i, 'nonstandard symbol:',k, string(i:i),'.'
           endif 
         enddo
#endif
   6   if (not_end_of_file) goto 2
       close (unit=input)
   7   if (n.lt.nmax) goto 1
 
      i=0                         ! Investigate possible secondary
   8   do n=1,nmax                ! dependencies. This is equivalent
        do k=1,nmax               ! to operation of logical addition:
          if (matrix(k,n)) then   !
            do j=1,nmax           ! if
              if (matrix(j,k))    !      file1 depends on file2
     &         matrix(j,n)=.true. ! and
            enddo                 !      file2 depends on file3
          endif                   ! then
        enddo                     !      file1 depends on file3
      enddo                       !
      j=0                         ! This is an iterative
      do n=1,nmax                 ! procedure, since staged
        do k=1,nmax               ! include statements are
          if (matrix(k,n)) j=j+1  ! possible. The number of .true.
        enddo                     ! elements in the matrix grows
      enddo                       ! when new dependencies are
      if (i.ne.j) then            ! discovered. The procedure
        i=j                       ! repeats itself until the next
        goto 8                    ! iteration does not discover
      endif                       ! any new dependencies.
!
! Report statistics for all files:
!
      write(iout,'(A/2A,13x,I4/A/A,26x,I4)') '#', '# Number of ',
     &     'files given for dependency analysis:', last_arg, '#',
     &     '# Number of newly discovered files:',  n_disc
#ifdef EXCLUDE
      write(iout,'(A/2A,9x,I4)') '#', '# Number of files ',
     &           'excluded from dependency analysis:', nexc
#endif
      write(iout,'(A,13x,A/A,13x,A,9x,I4/A/A,6x,I6/2A/A/2A,5x,I6/A)')
     &  '#',   '---------------------------------------------------',
     &  '#',   'total files analyzed for dependencies:',  nmax,  '#',
     &  '# Total number of lines of FORTRAN code in all files:',
     &   lines_all, '# (excluding CPP-commands, empty, and comment ',
     &  'lines)',  '#',  '# Total number of CPP-preprocessor lines ',
     &  'in all files:',   cpps_all, '#'
      write(iout,'(A,14x,I6/A/A/A,16x,I6/A/A,38x,A/A,38x,A,7x,I7/A)')
     &  '# Total nimber of comment lines in all files:',   comm_all,
     &  '# (excluding empty and containing only "c", "!" and "C")',
     &  '#', '# Total nimber of empty lines in all files:',empty_all,
     &  '# (including lines containing  only "c", "!" and "C")', '#',
     &             '--------------------------', '#', 'total lines:',
     &                    lines_all+cpps_all+comm_all+empty_all, '#'
!
! Generate list of dependencies. Two styles are supported, both
! work just fine. If XCOMM_FORMAT is defined, the style of the list
! is similar to that of makefiles generated by imake utility
! recommended by $XConsortium. In this case the target file name
! and the column separator ':' are repeated in all lines which
! correspond to the target dependencies, and its name is also
! repeated one time more wit no characters after ':'.
! If XCOMM_FORMAT is NOT defined, the target file name and the
! column separator ':' are not repeated, while backslach symbol is
! used in the end of each line, if the line needs to be  continued
! on the next line.
!
      do n=1,last_arg !!! nmax
        if (nsize(n).gt.0) then
c--#define XCOMM_FORMAT
#ifdef XCOMM_FORMAT
          write(iout,'(A1)') '#'
          k=0
  11      i=nsize(n)
           string(1:i)=fname(n)(1:i)
           if (string(i-1:i).eq.'.F') string(i:i)='o'
           i=i+1
           string(i:i)=':'
  12       i=i+1
            string(i:i)=' '
            if (k.eq.0) then
              if (fname(n)(nsize(n)-1:nsize(n)).eq.'.F') then
                string(i+1:i+nsize(n))=fname(n)(1:nsize(n))
                i=i+nsize(n)+1
                string(i:i)=' '
              endif
            endif
  13        k=k+1
            if (matrix(k,n)) then
              if (i+nsize(k).lt.max_string_size) then
                string(i+1:i+nsize(k))=fname(k)(1:nsize(k))
                i=i+nsize(k)
                goto 12
              else
                write(iout,'(A)') string(1:i)
                goto 11
              endif
            elseif (k.lt.nmax) then
              goto 13
            else
              write(iout,'(A)') string(1:i)
              if (i.gt.nsize(n)+2) then
                write(iout,'(A)') string(1:nsize(n)+1)
              endif
            endif
#else
          if (n.eq.1 .or. j.gt.0) write(iout,*)
          j=0
          i=nsize(n)
          string(1:i)=fname(n)(1:i)
          if (fname(n)(nsize(n)-1:nsize(n)).eq.'.F') then
            string(i:i)='o'
            i=i+1
            string(i:i)=':'
            j=1
            i=i+1
            string(i:i)=' '
            string(i+1:i+nsize(n))=fname(n)(1:nsize(n))
            i=i+nsize(n)
          else                       ! Do not print dependency line,
            i=i+1                    ! if the file oes not depend on
            string(i:i)=':'          ! anything, except itself. To
          endif                      ! detect trivial dependencies,
          k=0                        ! set j=0, then set it to j=1,
  14       k=k+1                     ! when dependency is detected.
           if (matrix(k,n)) then     ! Do not print, if j remains 0.
             j=1
  15         if (i+nsize(k).lt.max_string_size-2) then
               i=i+1
               string(i:i)=' '
               string(i+1:i+nsize(k))=fname(k)(1:nsize(k))
               i=i+nsize(k)
             else
               i=i+1
               string(i:i)=backslash
               write(iout,'(A)') string(1:i)
               i=0
               goto 15
             endif
           endif
           if (k.lt.nmax) goto 14
           if (j.gt.0) write(iout,'(A)') string(1:i)
#endif
        endif
      enddo
      goto 100
 
  98  write(stdout,'(/2(1x,A)/21x,A/)') 'CROSS_MATRIX ERROR:',
     &          'Too many files to process. To fix: increase',
     &   'parameter ''max_names'' in file ''cross_matrix.F''.'
      goto 100
#ifdef EXCLUDE
  99  write(stdout,'(/2(1x,A)/21x,A/)') 'CROSS_MATRIX ERROR:',
     &          'Too many files to process. To fix: increase',
     &   'parameter ''exc_names'' in file ''cross_matrix.F''.'
#endif
 100  close (iout)
      stop
      end
 
