#include "set_global_definitions.h"

      subroutine setup_profile_tile (Istr,Iend,Jstr,Jend, N, rho,z_w)
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k
      real*8 z_w(PRIVATE_2D_SCRATCH_ARRAY, 0:N), pwr,
     &       rho(PRIVATE_2D_SCRATCH_ARRAY,   N), pwr1

#include "phys_param.h"
!
! Specify density profile to a power function of z: rho(z)=z^power,
! where rho and z are understood to be continuous functions (as
! opposite to the values at grid points). Once power is specified,
! compute grid-box averages of density within each grid-box k, by
! analytical integration of it according to formula:
!
!                   z2^(pwr+1)-z1^(pwr+1)
!          rho(k) = --------------------- ;
!                      (pwr+1)*(z2-z1)
!
! where z2 and z1 are the coordinates of the upper and the lower
! facets of grid box Hz.
!
! Similarly, if the density profile is set to be an exponent or
! hyperbolic tangent,
!
!      rho(z)=10^5*exp(Z)       rho(z)=10^3*tanh((z-z_0)/delta)
!
! where z_0 is thermocline depth and delta its thickness, then
! these functions are integrated analytically over each gridbox.
!
      do j=Jstr,Jend
        do k=1,N
          if (icase.eq.itanh) then
            do i=Istr,Iend
              rho(i,j,k)=TANH_amp*delta*dlog(
     &                            dcosh((z_w(i,j,k)-z_0)/delta)
     &                           /dcosh((z_w(i,j,k-1)-z_0)/delta)
     &                                )/(z_w(i,j,k)-z_w(i,j,k-1))
     &    +100.
         write(*,*) k, 0.5*(z_w(i,j,k)+z_w(i,j,k-1)), rho(i,j,k)
            enddo
          elseif (icase.eq.iexp) then
            do i=Istr,Iend
              rho(i,j,k)=EXP_amp*alpha*( dexp(z_w(i,j,k)/alpha)
     &                                  -dexp(z_w(i,j,k-1)/alpha)
     &                                )/(z_w(i,j,k)-z_w(i,j,k-1)) 
         write(*,*) k, 0.5*(z_w(i,j,k)+z_w(i,j,k-1)), rho(i,j,k)

            enddo
          elseif (icase.gt.0.) then
            pwr=icase
            pwr1=pwr+1.D0
            PWR_amp=1000.D0/(z_w(1,1,0)-z_w(1,1,N))**icase
            do i=Istr,Iend
              rho(i,j,k)=PWR_amp*( z_w(i,j,k)**pwr1
     &                             -z_w(i,j,k-1)**pwr1
     &              )/(pwr1*(z_w(i,j,k)-z_w(i,j,k-1)))

            enddo
          endif
        enddo
      enddo
      return
      end
