#include "set_global_definitions.h"

      subroutine setup_grid_tile (Istr,Iend,Jstr,Jend, N,theta_s,z_w)
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k, nmax 
      parameter (nmax=100)
      real*8 z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N), theta_s, theta_b,
     &       Depth, hc, sc_w(0:nmax), Cs_w(0:nmax), cff1, cff2
      parameter (Depth=-2875.D0, hc=200.D0, theta_b=0.D0)
!
! Setup vertical Cs-curves:
!
      if (N.gt.nmax) then
        write(*,*) 'Error in setup_grid: nmax is too small'
        stop 
      endif

      cff1=1.D0/dsinh(theta_s)
      cff2=0.5D0/dtanh(0.5D0*theta_s)
      sc_w(N)=0.D0
      Cs_w(N)=0.D0
      do k=N-1,1,-1
        sc_w(k)=dfloat(k-N)/dfloat(N)
        Cs_w(k)=(1.D0-theta_b)*cff1*dsinh(theta_s*sc_w(k))
     &    +theta_b*(cff2*dtanh(theta_s*(sc_w(k)+0.5D0))-0.5D0)
c**       Cs_w(k)=sc_w(k)  ! <-- uniform vertical grid
      enddo
      sc_w(0)=-1.D0
      Cs_w(0)=-1.D0


      do j=Jstr,Jend
        do i=Istr,Iend
          z_w(i,j,0)=Depth
        enddo
        do k=1,N
          do i=Istr,Iend
            z_w(i,j,k)=hc*(sc_w(k)-Cs_w(k))-Cs_w(k)*z_w(i,j,0)
          enddo
        enddo
      enddo
      return
      end
