#include "set_global_definitions.h"

      subroutine remap0_tile (Istr,Iend,Jstr,Jend, N, rho_new,
     &                                z_w_new, rho,z_w,Hz, FC)
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k, ierr
      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N),
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N),  dz,
     &            FC(PRIVATE_1D_SCRATCH_ARRAY,0:N), Zero
      parameter (Zero=0.D0)
!
! The simplest remapping procedure which assumes that distribution
! of rho(z) is piecewise constant in each grid box, (i.e. similar to
! donor-cell first-order upstream advection).
! In addition to remapping it also checks that grid is not changing
! too fast, i.e. z_new(k) stands within bounds of z(k-1) and z(k+1).
! If this condition is violated, it simply reports the error, but
! calculation proceeds. 
!
      ierr=0
      do j=Jstr,Jend
        do k=1,N-1
          do i=Istr,Iend
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            FC(i,k)=min(dz,Zero)*rho(i,j,k)
     &             +max(dz,Zero)*rho(i,j,k+1)

            if (dz.gt.Zero) then
              if (dz.gt.Hz(i,j,k+1)) ierr=ierr+1
            else
              if (abs(dz).gt.Hz(i,j,k)) ierr=ierr+1
            endif

          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=0.
          FC(i,N)=0.
        enddo
        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1)
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo
      if (ierr.ne.0) then
        write(*,*) 'ERROR: Grid is changing too fast.'
      endif
      return
      end

