#include "set_global_definitions.h"

      implicit none
      integer Istr,Iend,Jstr,Jend, N, ntime,new,old, i,j,k
      parameter (Istr=1,Iend=1,Jstr=1,Jend=1, N=40)
      real*8 rho(PRIVATE_2D_SCRATCH_ARRAY, N,2),
     &       z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N,2),
     &        Hz(PRIVATE_2D_SCRATCH_ARRAY, N),

     &         r(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &         d(PRIVATE_1D_SCRATCH_ARRAY,0:N),

     &        A1(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A2(PRIVATE_1D_SCRATCH_ARRAY,0:N), 
     &        A3(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A4(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A5(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A6(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A7(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        A8(PRIVATE_1D_SCRATCH_ARRAY,0:N)


      common /storage/ rho,z_w,Hz, r,d, A1,A2,A3,A4,A5,A6,A7,A8

      real*8 pi, theta_s, dt
      parameter (pi=3.14159265358979323846D0, dt=0.24D0/N)
      integer type
      real*4 Hz4(N), rho4(N), r4(0:N), d4(0:N), time 

#include "phys_param.h"

      call opngks

      theta_s=5.D0
      theta_s=3.D0
      call setup_grid_tile (Istr,Iend,Jstr,Jend, N,theta_s,z_w)
      do k=1,N
        do j=Jstr,Jend
          do i=Istr,Iend
            Hz(i,j,k)=z_w(i,j,k,1)-z_w(i,j,k-1,1)
          enddo
        enddo
      enddo

      icase=itanh
      call setup_profile_tile (Istr,Iend,Jstr,Jend, N,rho,z_w)

      new=1
      do ntime=0,300 !!! 10000
        old=new
        new=3-new
        time=ntime*dt
c        theta_s=5.D0+3.5D0*dsin(2.D0*pi*ntime*dt)
c        call setup_grid_tile (Istr,Iend,Jstr,Jend, N,theta_s,
c     &                                   z_w(Istr,Jstr,0,new))
c        do k=1,N
c          do j=Jstr,Jend
c            do i=Istr,Iend
c              Hz(i,j,k)=z_w(i,j,k,old)-z_w(i,j,k-1,old) 
c            enddo
c          enddo
c        enddo

c--#define PCONST
c--#define LINEAR
c--#define PPM
c--#define SPLINE
c--#define WENO
c--#define QUARTIC
#define SUPER

#if defined PCONST
        type=none
        call remap0_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                                          Hz, A1)
#elif defined LINEAR 
        type=parVL
        call remap1_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                                       Hz, r,d, A1)
#elif defined PPM
        type=parVL
        call remap2PPM_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                                 Hz, r,d, A1,A2,A3)
#elif defined SPLINE
        type=parV
        call remap2S_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                                  Hz, r, A1,A2,A3)
#elif defined WENO
        type=parVL
        call remap2W_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                             Hz, r,d, A1,A2,A3,A4)
#elif defined QUARTIC
        type=quartVD
        call remap4_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), z_w(Istr,Jstr,0,new),
     &        rho(Istr,Jstr,1,old), z_w(Istr,Jstr,0,old),
     &                       Hz, r,d, A1,A2,A3,A4,A5,A6)
#elif defined SUPER
        type=parVL
        call super_tile (Istr,Iend,Jstr,Jend, N,
     &        rho(Istr,Jstr,1,new), rho(Istr,Jstr,1,old),
     &        z_w,Hz, r,d, A1,A2,A3,A4,A5,A6,A7)
#endif

        if (mod(ntime,50).eq.0 .or. time.lt.4.
!!     &     .or. (time.gt.25. and. time.lt.28.)   
     &                                    ) then
          do k=1,N
            Hz4(k)=Hz(Istr,Jstr,k)
            rho4(k)=rho(Istr,Jstr,k,old)
            r4(k)=r(Istr,k)
            d4(k)=d(Istr,k)
          enddo
          r4(0)=r(Istr,0)
          d4(0)=d(Istr,0)
          call plot (Hz4, rho4, r4,d4, N, type, time)
        endif
      enddo
      call clsgks
      stop
      end
