#include "set_global_definitions.h"

      subroutine remap4_tile (Istr,Iend,Jstr,Jend, N,rho_new,z_w_new,
     &                           rho,z_w,Hz, r,d, FC,r1, aR,dR,aL,dL) 
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k
      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),  OneFifth,
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N), Zero,  Half,
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N), One,   Two,
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N), Three, Four,
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N),  Six,   eps, 
 
     &             r(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &             d(PRIVATE_1D_SCRATCH_ARRAY,0:N),

     &            FC(PRIVATE_1D_SCRATCH_ARRAY,0:N), cff,
     &            aR(PRIVATE_1D_SCRATCH_ARRAY,0:N), cffR, deltaR,
     &            dR(PRIVATE_1D_SCRATCH_ARRAY,0:N), cffL, deltaL,
     &            aL(PRIVATE_1D_SCRATCH_ARRAY,0:N), Ampl, alpha, 
     &            dL(PRIVATE_1D_SCRATCH_ARRAY,0:N), Hdd,  rr,
     &            r1(PRIVATE_1D_SCRATCH_ARRAY,0:N), dz

      parameter (OneFifth=0.2D0, Zero=0.D0,  Half=0.5D0, One=1.D0,
     &       Two=2.D0, Three=3.D0, Four=4.D0, Six=6.D0, eps=1.E-8)

!
! Parabolic WENO reconstruction: The second and third loops below
!---------- ---- --------------- compute left and right side limits
! aL,aR of the field rho assuming monotonized parabolic distributions
! within each grid box. Also computed are dL,dR, which are then used
! as a measure of quadratic variation during sabsequent WENO
! reconciliation of side limits.    
!
      do j=Jstr,Jend
        do k=N-1,1,-1
          do i=Istr,Iend
            FC(i,k)=One/(Hz(i,j,k+1)+Hz(i,j,k))
            d(i,k)=FC(i,k)*(rho(i,j,k+1)-rho(i,j,k))
          enddo
        enddo

        do k=2,N-1
          do i=Istr,Iend
            deltaR=Hz(i,j,k)*d(i,k)
            deltaL=Hz(i,j,k)*d(i,k-1)

            if (deltaR*deltaL .lt. Zero) then
              deltaR=Zero
              deltaL=Zero
            endif
            cff=Hz(i,j,k-1)+Two*Hz(i,j,k)+Hz(i,j,k+1)
            cffR=cff*d(i,k)
            cffL=cff*d(i,k-1)
            if (abs(deltaR) .gt. abs(cffL)) deltaR=cffL
            if (abs(deltaL) .gt. abs(cffR)) deltaL=cffR

            cff=(deltaR-deltaL)/(Hz(i,j,k-1)+Hz(i,j,k)+Hz(i,j,k+1))
            deltaR=deltaR-cff*Hz(i,j,k+1)
            deltaL=deltaL+cff*Hz(i,j,k-1)

            aR(i,k)=rho(i,j,k)+deltaR
            aL(i,k)=rho(i,j,k)-deltaL

            dR(i,k)=( Two*deltaR-deltaL )**2
            dL(i,k)=( Two*deltaL-deltaR )**2
          enddo
        enddo

        do i=Istr,Iend
          aL(i,N)=aR(i,N-1)
          aR(i,N)=Two*rho(i,j,N)-aL(i,N)

          dR(i,N)=( Two*aR(i,N)+aL(i,N)-Three*rho(i,j,N) )**2
          dL(i,N)=( Three*rho(i,j,N)-Two*aL(i,N)-aR(i,N) )**2

          aR(i,1)=aL(i,2)
          aL(i,1)=Two*rho(i,j,1)-aR(i,1)

          dR(i,1)=( Two*aR(i,1)+aL(i,1)-Three*rho(i,j,1) )**2
          dL(i,1)=( Three*rho(i,j,1)-Two*aL(i,1)-aR(i,1) )**2
        enddo

        do k=1,N-1
          do i=Istr,Iend
             deltaL=max(dL(i,k),eps)
             deltaR=max(dR(i,k+1),eps)
             r1(i,k)=(deltaR*aR(i,k)+deltaL*aL(i,k+1))
     &                                /(deltaR+deltaL)
          enddo
        enddo      !--> discard aR,aL,dR,dL

        do i=Istr,Iend
#ifdef NEUMANN
          r1(i,N)=ThreeHalfth*rho(i,j,N)-Half*r1(i,N-1)
          r1(i,0)=ThreeHalfth*rho(i,j,1)-Half*r1(i,1)
#else
          r1(i,N)=Two*rho(i,j,N)-r1(i,N-1)
          r1(i,0)=Two*rho(i,j,1)-r1(i,1)
#endif
        enddo
!
! Power-law reconciliation: It starts with computation of side
!------ --- --------------- limits dR,dL of the first derivative
! assuming parabolic distributions within each grid box. In this
! version of the code, before doing so (see "else" branch of 3-way
! switch below), in situation when interfacial deviations deltaR
! and deltaL are differ by more than a factor of two (hence
! monotonic parabolic fit becomes impossible), the parabolic
! assumption is switched to power-law function,  such that its
! derivative is zero at one end and, consequently, larger than
! taht of (would be) limited parabolic on the other end. The basic
! parabolic version of the code is commented out, but left here
! for reference.
!
        do k=1,N
          do i=Istr,Iend
c**         cff=Two/Hz(i,j,k)
c**         dR(i,k)=cff*(Two*r1(i,k)+r1(i,k-1)-Three*rho(i,j,k))
c**         dL(i,k)=cff*(Three*rho(i,j,k)-Two*r1(i,k-1)-r1(i,k))
c**         cff=r1(i,k)-r1(i,k-1)
c**         if (cff*dR(i,k).lt.Zero) dR(i,k)=Zero
c**         if (cff*dL(i,k).lt.Zero) dL(i,k)=Zero

            deltaR=r1(i,k)-rho(i,j,k)
            deltaL=rho(i,j,k)-r1(i,k-1)
            cff=deltaR*deltaL
            if (cff.gt.eps) then
              cff=(deltaR+deltaL)/cff
            else
              cff=Zero
            endif
            cffL=cff*deltaL
            cffR=cff*deltaR

            if (cffL.gt.Three) then
              cffL=cffL*deltaL
              cffR=Zero
            elseif (cffR.gt.Three) then
              cffL=Zero
              cffR=cffR*deltaR
            else
              cffL=Four*deltaL-Two*deltaR
              cffR=Four*deltaR-Two*deltaL
            endif
            cff=One/Hz(i,j,k)
            dR(i,k)=cff*cffR
            dL(i,k)=cff*cffL
          enddo
        enddo
!
! Compute final value of derivative at each interface by reconciling
! two side limits dR(k) and dL(k+1) coming from adjacent grid boxes.
! the difference between these two also causes change of interfacial
! value r(k) by Ampl. The commented code (left here for reference)
! computes the exact value of Ampl assuming power law reconciliation
! and solving associated quadratic equation. The code segment below  
! it corresponds to Pade fit to exact solution, which avoids
! computation of sqrt for the sake of computational efficiency.
!

        do k=N-1,1,-1
          do i=Istr,Iend
            d(i,k)=FC(i,k)*(Hz(i,j,k+1)*dL(i,k+1)+Hz(i,j,k)*dR(i,k))

            cffR=8.*(dR(i,k)+Two*dL(i,k))
            cffL=8.*(dL(i,k+1)+Two*dR(i,k+1))
            if (abs(d(i,k)).gt.abs(cffR)) d(i,k)=cffR
            if (abs(d(i,k)).gt.abs(cffL)) d(i,k)=cffL

            if ((dL(i,k+1)-dR(i,k))*(rho(i,j,k+1)
     &               -rho(i,j,k)) .gt. Zero) then
              Hdd=Hz(i,j,k)*(d(i,k)-dR(i,k))
              rr=rho(i,j,k)-r1(i,k-1)
            else
              Hdd=Hz(i,j,k+1)*(dL(i,k+1)-d(i,k))
              rr=r1(i,k+1)-rho(i,j,k+1)
            endif
            rr=abs(rr)

c**         Ampl=TwoFifth*Hdd*rr
c**         Hdd=abs(Hdd)
c**         cff=rr*(rr+0.16*Hdd)
c**         if (cff.gt.eps) Ampl=Ampl/(rr+sqrt(cff))

            Ampl=OneFifth*Hdd*rr
            Hdd=abs(Hdd)
            cff=rr*rr+0.0763636363636363636*Hdd
     &                *(rr+0.004329004329004329*Hdd)
            if (cff.gt.eps) then
              Ampl=Ampl*(rr+0.0363636363636363636*Hdd)/cff
            else
              Ampl=Zero
            endif

            r(i,k)=r1(i,k)+Ampl
          enddo
        enddo
        do i=Istr,Iend
#ifdef NEUMANN
          r(i,0)=ThreeHalfs*rho(i,j,1)-Half*r(i,1)
          r(i,N)=ThreeHalfs*rho(i,j,N)-Half*r(i,N-1)
          d(i,0)=Zero
          d(i,N)=Zero
#else
          r(i,0)=Two*rho(i,j,1)-r(i,1)
          r(i,N)=Two*rho(i,j,N)-r(i,N-1)
          d(i,0)=d(i,1)
          d(i,N)=d(i,N-1)
#endif
        enddo !--> discard everything, except r and d.
!
! Remapping step: This operation consists essentially of three
!---------- ----- stages: (1) whithin each grid box compute three
! auxiliary fields, which are analogous to approximations for the
! second, third and fourth derivatives (stored in scratch arrays
! aR, dR and dL respectively); then (2) compute interfacial fluxes
! FC; and (3) apply these fluxes to complete remapping step.
!
        do k=1,N
          do i=Istr,Iend
            aR(i,k)=r(i,k) + r(i,k-1) - Two*rho(i,j,k)
            dR(i,k)=Hz(i,j,k)*(d(i,k)+d(i,k-1))-Two*(r(i,k)-r(i,k-1))
            dL(i,k)=Hz(i,j,k)*(d(i,k)-d(i,k-1)) - Six*aR(i,k)
          enddo
        enddo

        do k=1,N-1
          do i=Istr,Iend
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            if (dz.gt.Zero) then
              alpha=Hz(i,j,k+1)   
              cff=aR(i,k+1)
              cffR=dR(i,k+1)
              cffL=dL(i,k+1)
            else
              alpha=-Hz(i,j,k)
              cff=aR(i,k)
              cffR=-dR(i,k)
              cffL=dL(i,k)
            endif
            alpha=dz/alpha


            FC(i,k)=dz*( r(i,k)+Half*dz*d(i,k) +alpha*alpha*(
     &                             cff - cffR*(0.5-0.25*alpha)
     &                       +cffL*(1.-alpha*(1.25-0.5*alpha))
     &                                                      ))
          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=0.
          FC(i,N)=0.
        enddo

        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1) 
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo  ! <-- j
      return
      end
