#include "set_global_definitions.h"

      subroutine remap2W_tile (Istr,Iend,Jstr,Jend, N,rho_new,
     &                 z_w_new, rho,z_w,Hz, aR,aL, dR,dL, FC,r)
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k
      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),   Zero, One,
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N),  Half,  Two,
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N),  Three, 
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N),  ThreeHalfth, 
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N), 

     &            aR(PRIVATE_1D_SCRATCH_ARRAY,0:N),  cff,
     &            aL(PRIVATE_1D_SCRATCH_ARRAY,0:N),  cffR, deltaR, 

     &            dR(PRIVATE_1D_SCRATCH_ARRAY,0:N),  cffL, deltaL,
     &            dL(PRIVATE_1D_SCRATCH_ARRAY,0:N),  dz,   alpha,

     &            FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),  eps,    
     &             r(PRIVATE_1D_SCRATCH_ARRAY,0:N)

      parameter (Zero=0.D0, Half=0.5D0, One=1.D0, Two=2.D0,
     &           ThreeHalfth=1.5D0,  Three=3.D0, eps=1.D-8)

!
! Parabolic WENO reconstruction: The second and third loops below
!---------- ---- --------------- compute left and right side limits
! aL,aR of the field rho assuming monotonized parabolic distributions
! within each grid box. Also computed are dL,dR, which are then used
! as a measure of quadratic variation during sabsequent WENO
! reconciliation of side limits.
!

c-#define NEUMANN
c-#define LIMIT_INTERIOR


      do j=Jstr,Jend
        do k=N-1,1,-1
          do i=Istr,Iend
            FC(i,k)=(rho(i,j,k+1)-rho(i,j,k))/(Hz(i,j,k+1)+Hz(i,j,k))
          enddo
        enddo

        do k=2,N-1
          do i=Istr,Iend
            deltaR=Hz(i,j,k)*FC(i,k)
            deltaL=Hz(i,j,k)*FC(i,k-1)

            if (deltaR*deltaL .lt. Zero) then
              deltaR=Zero
              deltaL=Zero
            endif
            cff=Hz(i,j,k-1)+Two*Hz(i,j,k)+Hz(i,j,k+1)
            cffR=cff*FC(i,k)
            cffL=cff*FC(i,k-1)
            if (abs(deltaR) .gt. abs(cffL)) deltaR=cffL
            if (abs(deltaL) .gt. abs(cffR)) deltaL=cffR

            cff=(deltaR-deltaL)/(Hz(i,j,k-1)+Hz(i,j,k)+Hz(i,j,k+1))
            deltaR=deltaR-cff*Hz(i,j,k+1)
            deltaL=deltaL+cff*Hz(i,j,k-1)

            aR(i,k)=rho(i,j,k)+deltaR
            aL(i,k)=rho(i,j,k)-deltaL

            dR(i,k)=( Two*deltaR-deltaL )**2
            dL(i,k)=( Two*deltaL-deltaR )**2
          enddo
        enddo

        do i=Istr,Iend
          aL(i,N)=aR(i,N-1)
          aR(i,N)=Two*rho(i,j,N)-aL(i,N)

          dR(i,N)=( Two*aR(i,N)+aL(i,N)-Three*rho(i,j,N) )**2
          dL(i,N)=( Three*rho(i,j,N)-Two*aL(i,N)-aR(i,N) )**2

          aR(i,1)=aL(i,2)
          aL(i,1)=Two*rho(i,j,1)-aR(i,1)

          dR(i,1)=( Two*aR(i,1)+aL(i,1)-Three*rho(i,j,1) )**2
          dL(i,1)=( Three*rho(i,j,1)-Two*aL(i,1)-aR(i,1) )**2
        enddo
                                          ! Reconcile interfacial
        do k=1,N-1                        ! values aR,aL using WENO 
          do i=Istr,Iend                  ! procedure.
             deltaL=max(dL(i,k),eps)
             deltaR=max(dR(i,k+1),eps)
             r(i,k)=(deltaR*aR(i,k)+deltaL*aL(i,k+1))/(deltaR+deltaL)
          enddo
        enddo

        do i=Istr,Iend
#ifdef NEUMANN
          r(i,N)=ThreeHalfth*rho(i,j,N)-Half*r(i,N-1)
          r(i,0)=ThreeHalfth*rho(i,j,1)-Half*r(i,1)
#else
          r(i,N)=Two*rho(i,j,N)-r(i,N-1)
          r(i,0)=Two*rho(i,j,1)-r(i,1)
#endif
        enddo




!
! Remapping step: This operation consists essentially of three
!---------------- stages: (1) whithin each grid box compute averaged 
! slope (stored as dR) and curvature (stored as dL); then (2) compute
! interfacial fluxes FC; and (3) apply these fluxes to complete
! remapping step.
!
        do k=1,N
          do i=Istr,Iend
#ifdef LIMIT_INTERIOR                         ! Constrain parabolic
            deltaR=r(i,k)-rho(i,j,k)          ! segment monotonicity
            deltaL=rho(i,j,k)-r(i,k-1)        ! like in PPM. 
            if (deltaR*deltaL.lt.Zero) then
              deltaR=Zero
              deltaL=Zero
            elseif (abs(deltaR).gt.Two*abs(deltaL)) then
              deltaR=Two*deltaL
            elseif (abs(deltaL).gt.Two*abs(deltaR)) then
              deltaL=Two*deltaR
            endif
            aR(i,k)=rho(i,j,k)+deltaR
            aL(i,k)=rho(i,j,k)-deltaL
#else
            aR(i,k)=r(i,k)
            aL(i,k)=r(i,k-1)
#endif
            dL(i,k)=Half*(aR(i,k)-aL(i,k))
            FC(i,k)=Half*(aR(i,k)+aL(i,k))-rho(i,j,k)
          enddo
        enddo

        do k=1,N-1,+1       !<-- irreversible 
          do i=Istr,Iend
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            if (dz.gt.Zero) then
              alpha=Hz(i,j,k+1)
              cff=aL(i,k+1)
              cffL=dL(i,k+1)
              cffR=FC(i,k+1)
            else
              alpha=-Hz(i,j,k)
              cff=aR(i,k)
              cffL=-dL(i,k)
              cffR=FC(i,k)
            endif
            alpha=dz/alpha
            FC(i,k)=dz*(cff+alpha*(cffL-cffR*(Three-Two*alpha)))
          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=Zero
          FC(i,N)=Zero
        enddo

        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1) 
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo  ! <-- j
      return
      end
