#include "set_global_definitions.h"

      subroutine remap2S_tile (Istr,Iend,Jstr,Jend, N, rho_new,
     &                       z_w_new, rho,z_w, Hz, r, FC,dR,dL)
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k
      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),  Zero,
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N), Half,
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N), One,
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N), Two,
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N),  Three,
 
     &            r(PRIVATE_1D_SCRATCH_ARRAY,0:N),  ThreeHalfth,

     &           FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),  dz, alpha, 
     &           dR(PRIVATE_1D_SCRATCH_ARRAY,0:N), cff,cff1,
     &           dL(PRIVATE_1D_SCRATCH_ARRAY,0:N)

      parameter (Zero=0.D0, Half=0.5D0, One=1.D0,
     &   ThreeHalfth=1.5D0, Two=2.D0,  Three=3.D0)
!
! Basic parabolic spline reconstruction
!------ --------- ------ --------------
!
#define NEUMANN
c--#define LINEAR_CONTINUATION
c--#define PARABOLIC_CONTINUATION


      do j=Jstr,Jend
        do i=Istr,Iend
#if defined NEUMANN
          FC(i,1)=Half
          r(i,0)=ThreeHalfth*rho(i,j,1)
#elif defined LINEAR_CONTINUATION
          FC(i,1)=One
          r(i,0)=Two*rho(i,j,1)
#elif defined PARABOLIC_CONTINUATION
          cff=Hz(i,j,1)/Hz(i,j,2)
          FC(i,1)=One+cff
          r(i,0)=Two*rho(i,j,1)+cff*( rho(i,j,1)
     &                    +cff*rho(i,j,2) )/FC(i,1)
#endif
        enddo
        do k=1,N-1,+1
          do i=Istr,Iend
            cff=One/(Two*Hz(i,j,k)+Hz(i,j,k+1)*(Two-FC(i,k)))
            FC(i,k+1)=cff*Hz(i,j,k)
            r(i,k)=cff*( Three*( rho(i,j,k+1)*Hz(i,j,k)
     &                               +rho(i,j,k)*Hz(i,j,k+1))
     &                               -Hz(i,j,k+1)*r(i,k-1))
          enddo
        enddo
        do i=Istr,Iend
#if defined PARABOLIC_CONTINUATION
          cff=Hz(i,j,N)/Hz(i,j,N-1)
          cff1=One+cff
          r(i,N)=(    cff*(rho(i,j,N)+cff*rho(i,j,N-1))
     &                 +cff1*(Two*rho(i,j,N)-cff1*r(i,N-1))
     &                            )/(cff1*(One-cff1*FC(i,N)))
#elif defined LINEAR_CONTINUATION
          r(i,N)=(  Two*rho(i,j,N)-r(i,N-1))/(One-FC(i,N))
#elif defined NEUMANN
          r(i,N)=(Three*rho(i,j,N)-r(i,N-1))/(Two-FC(i,N))
#endif
        enddo
        do k=N-1,0,-1
          do i=Istr,Iend
            r(i,k)=r(i,k)-FC(i,k+1)*r(i,k+1)
          enddo
        enddo
!
! Remapping step: This operation consists essentially of three
!---------------- stages: (1) whithin each grid box compute averaged 
! slope (stored as dR) and curvature (stored as dL); then (2) compute
! interfacial fluxes FC; and (3) apply these fluxes to complete
! remapping step.
!
        do k=1,N
          do i=Istr,Iend
            dR(i,k)=Half*(r(i,k)-r(i,k-1))
            dL(i,k)=Half*(r(i,k)+r(i,k-1))-rho(i,j,k)
          enddo
        enddo

        do k=1,N-1
          do i=Istr,Iend
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            if (dz.gt.Zero) then
              alpha=Hz(i,j,k+1)   
              cff=dR(i,k+1)
              cff1=dL(i,k+1)
            else
              alpha=Hz(i,j,k)
              cff=dR(i,k)
              cff1=-dL(i,k)
            endif
            alpha=dz/alpha
            FC(i,k)=dz*( r(i,k)+alpha*( cff-cff1*(
     &                     Three-Two*abs(alpha) )))
          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=0.
          FC(i,N)=0.
        enddo

        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1) 
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo  ! <-- j
      return
      end
