#include "set_global_definitions.h"

      subroutine remap2PPM_tile (Istr,Iend,Jstr,Jend, N,
     &         rho_new,z_w_new, rho,z_w,Hz, aR,aL, CF, FC,FC1) 
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k, k1,k2

      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),   Zero,
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N),  Half, One,
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N),  Two,  Three, 
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N),  ThreeHalfth, 
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N),
 
     &            aR(PRIVATE_1D_SCRATCH_ARRAY,0:N),    cff,
     &            aL(PRIVATE_1D_SCRATCH_ARRAY,0:N),    cffR,  dR, 

     &            CF(PRIVATE_1D_SCRATCH_ARRAY,0:N),    cffL,  dL, 
     &            FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),    alpha,
     &           FC1(PRIVATE_1D_SCRATCH_ARRAY,0:N),    dz

      parameter (Zero=0.D0, Half=0.5D0, One=1.D0,
     &           ThreeHalfth=1.3D0, Two=2.D0, Three=3.D0)

!
! Reconstruction by PPM code of Colella--Woodward, 1984.
!
#define NEUMANN
#define LIMIT_SLOPES
#define LIMIT_INTERIOR

      do j=Jstr,Jend
        do k=1,N-1
          do i=Istr,Iend
            cff=One/(Hz(i,j,k)+Hz(i,j,k+1))
            CF(i,k)=cff*( rho(i,j,k+1)*Hz(i,j,k)
     &                   +rho(i,j,k)*Hz(i,j,k+1))
            FC(i,k)=cff*(rho(i,j,k+1)-rho(i,j,k))
          enddo
        enddo
        do k=2,N-1
          do i=Istr,Iend
            cff=Hz(i,j,k)*( (Two*Hz(i,j,k-1)+Hz(i,j,k))*FC(i,k)
     &                     +(Two*Hz(i,j,k+1)+Hz(i,j,k))*FC(i,k-1)
     &                      )/(Hz(i,j,k-1)+Hz(i,j,k)+Hz(i,j,k+1))
#ifdef LIMIT_SLOPES
            cffR=Two*(rho(i,j,k+1)-rho(i,j,k))
            cffL=Two*(rho(i,j,k)-rho(i,j,k-1))
            if (cffR*cffL.gt.Zero) then
              if (abs(cffL).lt.abs(cff)) cff=cffL
              if (abs(cffR).lt.abs(cff)) cff=cffR
            else
              cff=Zero
            endif
#endif
            FC1(i,k)=cff
          enddo
        enddo
        do i=Istr,Iend
          FC1(i,N)=Hz(i,j,N)*FC(i,N-1)
          FC1(i,1)=Hz(i,j,1)*FC(i,1)
        enddo

        do k=1,N-1
         k1=max(k-1,1)
         k2=min(k+2,N)
          do i=Istr,Iend
            cff=Hz(i,j,k1)+Hz(i,j,k)+Hz(i,j,k+1)+Hz(i,j,k2)
            cffL=(Hz(i,j,k1)+Hz(i,j,k)) /(cff*(
     &                          Two*Hz(i,j,k)+Hz(i,j,k+1) ))
            cffR=(Hz(i,j,k+1)+Hz(i,j,k2)) /(cff*(
     &                          Hz(i,j,k)+Two*Hz(i,j,k+1) ))

            aR(i,k)=CF(i,k) + Two*Hz(i,j,k)*Hz(i,j,k+1)
     &                                 *(cffL-cffR)*FC(i,k)
     &                            -cffL*Hz(i,j,k)*FC1(i,k+1)
     &                            +cffR*Hz(i,j,k+1)*FC1(i,k)
            aL(i,k+1)=aR(i,k)    
          enddo
        enddo
        do i=Istr,Iend
#ifdef NEUMANN
          aR(i,N)=ThreeHalfth*rho(i,j,N)-Half*aL(i,N)
          aL(i,1)=ThreeHalfth*rho(i,j,1)-Half*aR(i,1)
#else
          aR(i,N)=Two*rho(i,j,N)-aL(i,N)
          aL(i,1)=Two*rho(i,j,1)-aR(i,1)
#endif
        enddo

#ifdef LIMIT_INTERIOR
        do k=1,N
          do i=Istr,Iend
            dR=aR(i,k)-rho(i,j,k)
            dL=rho(i,j,k)-aL(i,k)
            if (dR*dL.lt.Zero) then
              dR=Zero
              dL=Zero
            endif
            if (abs(dR).gt.Two*abs(dL)) dR=Two*dL
            if (abs(dL).gt.Two*abs(dR)) dL=Two*dR
            aR(i,k)=rho(i,j,k)+dR
            aL(i,k)=rho(i,j,k)-dL
          enddo
        enddo
#endif



!
! Remapping step: This operation consists essentially of three
!---------------- stages: (1) whithin each grid box compute averaged 
! slope (stored as CF) and curvature (stored as FC); then (2) compute
! interfacial fluxes FC; and (3) apply these fluxes to complete
! remapping step.
!
        do k=1,N
          do i=Istr,Iend
            CF(i,k)=Half*(aR(i,k)-aL(i,k))
            FC(i,k)=Half*(aR(i,k)+aL(i,k))-rho(i,j,k)
          enddo
        enddo

        do k=1,N-1,+1       !<-- irreversible 
          do i=Istr,Iend
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            if (dz.gt.Zero) then
              alpha=Hz(i,j,k+1)   
              cff=aL(i,k+1)
              cffR=CF(i,k+1)
              cffL=FC(i,k+1)
            else
              alpha=-Hz(i,j,k)
              cff=aR(i,k)
              cffR=-CF(i,k)
              cffL=FC(i,k)
            endif
            alpha=dz/alpha
            FC(i,k)=dz*(cff+alpha*(cffR-cffL*(Three-Two*alpha)))
          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=Zero
          FC(i,N)=Zero
        enddo

        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1) 
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo  ! <-- j
      return
      end
