#include "set_global_definitions.h"

      subroutine remap1_tile (Istr,Iend,Jstr,Jend, N,rho_new,z_w_new,
     &                                         rho,z_w, Hz, aR,aL,FC) 
      implicit none
      integer Istr,Iend,Jstr,Jend, N, i,j,k, iter
      real*8 rho_new(PRIVATE_2D_SCRATCH_ARRAY, N),  Zero,
     &       z_w_new(PRIVATE_2D_SCRATCH_ARRAY,0:N), Half,
     &           rho(PRIVATE_2D_SCRATCH_ARRAY,  N), 
     &           z_w(PRIVATE_2D_SCRATCH_ARRAY,0:N),  cff,
     &            Hz(PRIVATE_2D_SCRATCH_ARRAY, N),   cff1,
 
     &            aR(PRIVATE_1D_SCRATCH_ARRAY,0:N),  dh,dz,
     &            aL(PRIVATE_1D_SCRATCH_ARRAY,0:N),  dR,dL,
     &            FC(PRIVATE_1D_SCRATCH_ARRAY,0:N)

      parameter (Zero=0.D0, Half=0.5D0)
!
! Remapping procedure using piecewise-linear reconstruction: 
!---------- --------- ----- --------- ------ ---------------
! MINMOD version: The distribution in each grid-box is assumed to be
!        linear with the slope equal to the smaller of two elementary
!        slopes computed by linear differencing (set to 0, if the two
!        slopes are of different signs. This method is commonly known
!        as that of van Leer. It guarantees monotonicity.
!                                                              2*X*Y
! default version: minmod(X,Y) is replaced with harmonic mean -------
!                                                              X + Y
#define NEUMANN
#define MINMOD
c--#define ENHANCE

      do j=Jstr,Jend
        do k=N-1,1,-1
          do i=Istr,Iend
            FC(i,k)=(rho(i,j,k+1)-rho(i,j,k))/(Hz(i,j,k+1)+Hz(i,j,k))
          enddo
        enddo
        do i=Istr,Iend
#ifdef NEUMANN
          FC(i,0)=Zero
          FC(i,N)=Zero
#else
          FC(i,0)=FC(i,1)
          FC(i,N)=FC(i,N-1)
#endif
        enddo

        do k=1,N
          do i=Istr,Iend
            if (FC(i,k)*FC(i,k-1).lt.Zero) then
              cff=Zero
#ifdef MINMOD
            elseif (abs(FC(i,k)).lt.abs(FC(i,k-1))) then
              cff=FC(i,k)
            else
              cff=FC(i,k-1)
#else
            else
              cff=2.*FC(i,k)*FC(i,k-1)/(FC(i,k)+FC(i,k-1))
#endif
            endif

            aR(i,k)=rho(i,j,k)+cff*Hz(i,j,k)
            aL(i,k)=rho(i,j,k)-cff*Hz(i,j,k)
          enddo
        enddo     !--> discard FC

#ifdef ENHANCE
        do iter=1,10                             ! Reconcile side 
          do k=1,N-1                             ! values at each 
            do i=Istr,Iend                       ! interface, then 
              FC(i,k)=Half*(aR(i,k)+aL(i,k+1))   ! use minmod limiter 
            enddo                                ! again to maintain
          enddo                                  ! monotonicity
          do i=Istr,Iend
            FC(i,N)=aR(i,N)
            FC(i,0)=aL(i,1)
          enddo
          do k=1,N
            do i=Istr,Iend
              dR=FC(i,k)-rho(i,j,k)
              dL=rho(i,j,k)-FC(i,k-1)
              if (dR*dL.lt.Zero) then
                cff=Zero
              elseif (abs(dR).gt.abs(dL)) then
                cff=dL
              else
                cff=dR
              endif 
              aR(i,k)=rho(i,j,k)+cff
              aL(i,k)=rho(i,j,k)-cff
            enddo
          enddo
        enddo
#endif
                                            ! Remapping: compute
        do k=1,N-1                          ! finite volume fluxes
          do i=Istr,Iend                    ! FC and then apply them.
            dz=z_w_new(i,j,k)-z_w(i,j,k)
            if (dz.gt.Zero) then
              cff=aL(i,k+1)
              cff1=aR(i,k+1)-aL(i,k+1)
              dh=Hz(i,j,k+1)
            else
              cff=aR(i,k)
              cff1=aR(i,k)-aL(i,k)
              dh=Hz(i,j,k)
            endif
            FC(i,k)=dz*(cff+Half*cff1*dz/dh)
          enddo
        enddo
        do i=Istr,Iend
          FC(i,0)=Zero
          FC(i,N)=Zero
        enddo

        do k=1,N
          do i=Istr,Iend
            rho_new(i,j,k)=( Hz(i,j,k)*rho(i,j,k)+FC(i,k)-FC(i,k-1) 
     &                           )/(z_w_new(i,j,k)-z_w_new(i,j,k-1))
          enddo
        enddo
      enddo  ! <-- j
      return
      end
