      subroutine plot (Hz, rho,r,d, N, type, time)
      implicit none
      integer N, type
      real*4 Hz(N), rho(N),r(0:N),d(0:N), time
!
! Meaning of input arguments:
!   Hz   -- array of grid-box sizes;
!   rho  -- set of grid box averaged values of field to be plotted; 
!   r,d  -- interpretation depends on type:
!   type -- type of polynomial fit: may be either
!           parV -- parabolic, continuous at interfaces [r(k) are 
!                   interpreted as interfacial values; d is ignored];
!           parVL-- piecewise parabolic [discontinuities  are
!                   allowed at grid-box interfaces; r(k),d(k) are
!                   interpreted as right and left limits of parabolic
!                   segments defined withing each grid box];
!            quartVD -- quartic [r(k),d(k) are interpreted as
!                        interfacial values and derivatives]; 
!  time -- time label foe each plot frame
!      
      integer nsegm, k, m
      parameter (nsegm=20)
      real*4 xspline(0:nsegm), zspline(0:nsegm),z(0:N), WL,WR,WB,WT,
     &       E,DH1,CH2,BH3,AH4, cff0,cff1,cff2,cff3, x, zeta,dzeta,
     &       z_cntr,dz, thin_line, medium_line, thick_line
      parameter (thin_line=0.5, medium_line=1.0, thick_line=1.5)
      character*7 label

#include "phys_param.h"

      z(N)=0.
      do k=N,1,-1
        z(k-1)=z(k)-Hz(k)
      enddo
      WT=0.
      WB=z(0)

      if (icase.eq.iexp) then
        WL=-0.0625*EXP_amp
        WR=+0.1*EXP_amp
      elseif (icase.eq.itanh) then
        WL=-1.0625*TANH_amp
        WR=+1.0625*TANH_amp
      elseif (icase.gt.0) then
        x=abs(PWR_amp) * abs(z(0))**icase
        WL=-0.0625*x
        WR=+1.0625*x
      endif
      if (WR.lt.WL) then
        x=WL
        WL=WR
        WR=x
      endif
      call set (0.05,0.95,0.05,0.95, WL,WR,WB,WT, 1) 

      call gscr (1,2, 0.,0.5,1.)             ! Draw series
      call gsplci (2)                        ! of grid boxes
      call gslwsc (thin_line)
      do k=N,1,-1
        if (k.eq.N) call line (0.,z(N), rho(N),z(N)) 
        if (k.gt.1) then
          if (rho(k)*rho(k-1) .lt. 0.) then
            call line (rho(k),z(k-1), rho(k-1),z(k-1))
          else 
            if (abs(rho(k)) .gt. abs(rho(k-1))) then
              x=rho(k)
            else
              x=rho(k-1)
            endif
            call line (0.,z(k-1), x,z(k-1))
          endif
        else
          call line (0.,z(0), rho(1),z(0))
        endif
        call line (rho(k),z(k-1), rho(k),z(k))
      enddo
                                             ! Draw cursor pointer
      call gscr (1,3, 1.,1.,1.)              ! to a selected point
      call gsplci (3)                        ! in order to visualize
      call gslwsc (thick_line)               ! its movement.
      k=N/2
      if (abs(rho(k)) .gt. abs(rho(k-1))) then
        x=rho(k)
      else
        x=rho(k-1)
      endif
      call cursor (x,z(k-1), WL,WR,WB,WT)

                                             ! Draw EXACT analytical
      call gscr (1,4, 0.,1.,0.)              ! profile: this one
      call gsplci (4)                        ! should stay unchanged
      call gslwsc (medium_line)              ! at all times.
      do k=1,N
        dz=(z(k)-z(k-1))/float(nsegm)
        do m=0,nsegm
          zspline(m)=z(k-1)+dz*m 
          if (icase.eq.iexp) then
            xspline(m)=EXP_amp*dexp(zspline(m)/alpha)
          elseif (icase.eq.itanh) then
            xspline(m)=TANH_amp*dtanh((zspline(m)-z_0)/delta)
          elseif (icase.gt.0) then
            xspline(m)=PWR_amp*zspline(m)**icase
          endif
        enddo
        call curved(xspline,zspline,nsegm+1)
      enddo
                                             ! Draw reconstructed 
      if (type.ne.none) then                 ! profile, as is seen
        call gscr (1,5, 1.,0.,0.)            ! by either parabolic
        call gsplci (5)                      ! or quartic
        call gslwsc (thick_line)             ! reconstruction
        do k=1,N                             ! algorithm.
          if (type.eq.parV) then
            E=1.5*rho(k)-0.25*(r(k)+r(k-1))
            DH1=r(k)-r(k-1)
            CH2=3.*(r(k)+r(k-1)) -6.*rho(k)
            BH3=0.
            AH4=0.
          elseif (type.eq.parVL) then
            E=1.5*rho(k)-0.25*(r(k)+d(k))
            DH1=r(k)-d(k)
            CH2=3.*(r(k)+d(k)) -6.*rho(k)
            BH3=0.
            AH4=0.
          elseif (type.eq.quartVD) then
            cff0=0.5*(r(k)+r(k-1))-rho(k)
            cff1=r(k)-r(k-1)
            cff2=(d(k)+d(k-1))*Hz(k)
            cff3=(d(k)-d(k-1))*Hz(k)

            E=rho(k)-(7./8.)*cff0+cff3/32.
            DH1=                           1.5*cff1-0.25*cff2
            CH2=      15.*cff0-0.75*cff3
            BH3=                                -2.*cff1+cff2
            AH4=     -30.*cff0 +2.5*cff3
          endif
          dz=z(k)-z(k-1)
          z_cntr=0.5*(z(k)+z(k-1))
          dzeta=1./float(nsegm)
          do m=0,nsegm
            zeta=dzeta*m-0.5
            zspline(m)=z_cntr+zeta*dz
            xspline(m)=E+zeta*(DH1+zeta*(CH2+zeta*(BH3+zeta*AH4))) 
          enddo
          call curved(xspline,zspline,nsegm+1)
        enddo
      endif
                                             ! Draw time label
      call gsplci (1)
      write(label,'(F7.3)') time 
      call plchhq (WR-0.025*(WR-WL), WB+0.025*(WT-WB),
     &                           label,  0.02, 0.,+1.) 
      call frame
                                             ! Save few sampling
                                             ! values to for Fig.1

c      if (time.gt.0.99 .and. time.lt.1.03) then
c        write(*,'(6(F9.4,A))')  (Hz(k), ',', k=1,7)
c        write(*,'(6(F9.5,A))') (rho(k), ',', k=1,7)
c        write(*,'(7(F9.5,A))')   (r(k), ',', k=0,7)
c        if (time.gt. 1.01) stop
c      endif

      return
      end

      subroutine cursor (x,y, WL,WR,WB,WT)
      implicit none
      real*4 x,y, WL,WR,WB,WT, size
      parameter (size=0.025)
      call line (x,y, x+size*(WR-WL),      y-size*(WT-WB))
      call line (x,y, x+0.5*size*(WR-WL),  y-0.25*size*(WT-WB))
      call line (x,y, x+0.25*size*(WR-WL),  y-0.5*size*(WT-WB))
      return
      end
