!
! This programs creates Fig. 1 illustrating remapping procedure. 
!
      implicit none
      integer N, old,new, k,iframe, step, step1,step2
      parameter (N=6, old=1,new=2)
      real*4 Hz(N,2), rho(N,2), r(0:N,2), z_w(0:N,2), z_min,z_max


      parameter (z_min=2000., z_max=2550.)
      data Hz/862.7681, 595.3237,412.4977,287.5550,202.2251,144.0299,
     &        928.3021, 617.7076,412.9790,278.0557,189.1729,130.6748/
      data rho
     &   /-99.99948,-99.98533,-99.79956,-97.91107,-77.81989,-3.10445,
     &    -99.99941,-99.97835,-99.65247,-95.61125,-54.38778,30.48862/
      data r
     &  /-100.,-99.9994,-99.9654,-99.5380,-95.2493,-48.3435,38.15282,
     &   -100.,-99.9994,-99.9488,-99.1963,-89.9372,-7.46438,62.78357/

      

/*
      parameter (z_min=2100., z_max=2580.)
      data Hz/1159.36951, 671.23700, 391.62610, 231.46324, 139.72652,
     &        1206.02954, 677.21619, 383.52573, 220.41899, 129.83803/

      data rho /-99.99894, -99.90910, -97.45235, -51.28969, 49.83481,
     &          -99.99878, -99.87858, -96.20834, -32.17221, 61.89120/

      data r/-99.999,-99.99894,-99.78635,-94.08929,13.49031,76.23812,
     &       -99.999,-99.99878,-99.71516,-91.18811,32.85102,82.67986/
*/
      real*4 WT,WL, x, z1,z2
      integer nsegm, m, wsize,isize
      parameter (WL=-110., nsegm=64,  wsize=100, isize=100)
      integer iwrk(isize)
      real*4 wrk(wsize), FC(0:N)
      real*4 xspline(0:nsegm), A,B,C, thin_line, medium_line,
     &       zspline(0:nsegm), z_cntr,dz, zeta,dzeta, thick_line
      parameter (thin_line=0.625, medium_line=1.25, thick_line=2.5)

#define POSTSCRIPT
#ifdef POSTSCRIPT
      integer ngpswk, unused
      call gopks(6,unused)
      call ngsetc('ME','RemappingFig.ps')
      call gopwk(1,2,ngpswk('PS','PORTRAIT','COLOR'))
      call gacwk(1)
#else
      call opngks
#endif

      z_w(0,old)=0.
      z_w(0,new)=0.
      do k=1,N
        z_w(k,old)=z_w(k-1,old)+Hz(k,old)
        z_w(k,new)=z_w(k-1,new)+Hz(k,new)
      enddo
      WT=max(z_w(N,old),z_w(N,new))


      do iframe=0,2
        x=0.35*iframe
        call set (x,0.3+x, 0.35,0.975,  WL,r(N,new), z_min,z_max, 1)  

                                 ! Visualize interfacial
        if (iframe.eq.0) then    ! fluxes by shading.
          do k=1,N
            A=1.5*rho(k,old)-0.25*(r(k,old)+r(k-1,old))
            B=r(k,old)-r(k-1,old)
            C=3.*(r(k,old)+r(k-1,old))-6.*rho(k,old)
            zeta=-0.5+(z_w(k-1,new)-z_w(k-1,old))/Hz(k,old)
            do m=0,10
              zspline(m)=z_w(k-1,old) +0.1*m*( z_w(k-1,new)
     &                                        -z_w(k-1,old))
              zeta=-0.5+(zspline(m)-z_w(k-1,old))/Hz(k,old)
              xspline(m)=A+zeta*(B+zeta*C)
            enddo

            FC(k-1)=0.05*(xspline(0)+xspline(10))
            do m=1,9
              FC(k-1)=FC(k-1)+0.1*xspline(m)
            enddo

            zspline(11)=zspline(10)
            xspline(11)=WL
            zspline(12)=zspline(0)
            xspline(12)=WL

            call gsfais (1)
            call gscr(1,2, 0.85,0.85,0.85)
            call gsfaci(2)
            call gfa(13,xspline,zspline)
            call gslwsc (thin_line)
            call line (WL,zspline(10), xspline(10),zspline(10))
          enddo
        endif

        if (iframe.eq.0) then                ! Draw staircase
          step1=old
          step2=old
        elseif (iframe.eq.1) then
          step1=old
          step2=new
        elseif (iframe.eq.2) then
          step1=new
          step2=new
        endif
        do step=step1,step2
          call gslwsc (thin_line)
          call gsln(1+step2-step)
          do k=1,N
            z1=max(z_w(k-1,step), z_min)
            z2=min(z_w(k  ,step), z_max)
            call line (rho(k,step),z1, rho(k,step),z2)
            x=max(rho(k,step), rho(k+1,step))
            call line (WL,z_w(k,step), x,z_w(k,step))
          enddo
        enddo

        if (iframe.ne.1) then             ! Draw smooth
          step1=old                       ! reconstructed profiles
          if (iframe.eq.0) then
            step2=old
          elseif (iframe.eq.2) then
            step2=new
          endif
          do step=step1,step2
            if (step.eq.step2) then
              call gslwsc (thick_line)
              call gsln(1)
            else
              call gslwsc (medium_line)
              call gsln(3)
            endif
            do k=1,N
              A=1.5*rho(k,step)-0.25*(r(k,step)+r(k-1,step))
              B=r(k,step)-r(k-1,step)
              C=3.*(r(k,step)+r(k-1,step)) -6.*rho(k,step)

              dz=z_w(k,step)-z_w(k-1,step)
              z_cntr=0.5*(z_w(k,step)+z_w(k-1,step))
              dzeta=1./float(nsegm)
              do m=0,nsegm
                zeta=dzeta*m-0.5
                zspline(m)=z_cntr+zeta*dz
                xspline(m)=A+zeta*(B+zeta*C)
              enddo
              call curved(xspline,zspline,nsegm+1)
            enddo
          enddo
        endif 

        if (iframe.ne.2) then               ! Draw fluxes as
          call gslwsc (thin_line)           ! hatched rectangles
          call gsln (1+2*iframe)
          do k=1,N
            xspline(0)=WL
            xspline(1)=FC(k-1)
            xspline(2)=xspline(1)
            xspline(3)=xspline(0)
            zspline(0)=z_w(k-1,old)
            zspline(1)=zspline(0)
            zspline(2)=z_w(k-1,new)
            zspline(3)=zspline(2)
            call line (xspline(1),zspline(1), xspline(2),zspline(2))
            call sfsetr('SP -spacing between fill lines', 0.008)
            call sfsetr('AN - angle of fill lines', -45.)
            call sfwrld (xspline,zspline,4, wrk,wsize, iwrk,isize)
          enddo
        endif       
      enddo
      call frame
#ifdef POSTSCRIPT
      call gdawk(1)
      call gclwk(1)
      call gclks
      call system ('ghostview RemappingFig.ps')
#else
      call clsgks
      call system ('idt gmeta')
#endif
      stop
      end
