      subroutine zisopyc (day,depths,s1,s2,file,isoden,idfld)
!
! Compute the depths of requested isopycnal.  This is used for
! plotting fields along isopycnic surfaces.
!
! input:  day      Day to read (real).                                   ===
!         s1,s2    scratch arrays (real).                                 ===
!         file     netCDF file ID to read (history or reference)
!         isoden   isopycnal value to process (real; kg/m3, >1000)
!         idfld    identification of field to read (integer).
!
! output: depths    Depths of isopycnal (m)
!
! Copyright (c) 1998 Rutgers University
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ndimen.h"
      integer file, idfld, idsigt, igrid, n, np
      real day, dval, isoden, level
      real depths(NH), s1(NV), s2(NV)
!
! Determine field ID for sigma-t.
!
      do n=1,nvarids
        if (vcode(n).eq.'IDSIGT') idsigt=n
      enddo
!
! Compute density: sigma-t.
!
      level=0.
      call get_3dfld (day,x,y,z,s1,s2,np,igrid,file,idsigt,level)
!
! Extract depths of requested isopycnal. Notice that isopycnal is
! converted to density anomaly.
!
      dval=isoden-1000.
      call depth_iso (depths,dval,s1,z,im,jm,km,spval1)
      return
      end
