      subroutine zgrid (zpos,im,jm,km, z,iz,jz,kz, igrid)
!
! Compute requested horizontal grid from curvilinear metric
! coefficients.
!
! input: im,jm,km  Sizes of XI-, ETA- and S-dimensions for "zpos".
!        z         3D depths at horizontal RHO-points.
!        iz,jz,kz  Sizes of XI-, ETA- and S-dimensions for "z".
!        igrid     Staggered C grid type:
!                          igrid=0  => None.
!                          igrid=1  => density points.
!                          igrid=2  => streamfunction points.
!                          igrid=3  => u-velocity points.
!                          igrid=4  => v-velocity points.
!                          igrid=5  => w-velocity points.
!                          igrid=6  => w-velocity points, range 0:N.
!                          igrid=7  => interior density points.
!
! output: zpos     Depths of current field.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer im,jm,km, iz,jz,kz, igrid, i,j,k
      real z(iz,jz,kz), zpos(im,jm,km)

      if (igrid.eq.1 .or. igrid.eq.5  .or.    ! Compute depths
     &    igrid.eq.6 .or. igrid.eq.7) then    ! at density points.
        do k=1,km
          do j=1,jm
            do i=1,im
              zpos(i,j,k)=z(i,j,k)
            enddo
          enddo
        enddo
      elseif (igrid.eq.2) then            ! at streamfunction points.
        do k=1,km
          do j=1,jm
            do i=1,im
              zpos(i,j,k)=0.25*(z(i,j  ,k)+z(i+1,j  ,k)+
     &                          z(i,j+1,k)+z(i+1,j+1,k))
            enddo
          enddo
        enddo
      elseif (igrid.eq.3) then            ! at U-velocity points.
        do k=1,km
          do j=1,jm
            do i=1,im
              zpos(i,j,k)=0.5*(z(i,j,k)+z(i+1,j,k))
            enddo
          enddo
        enddo
      elseif (igrid.eq.4) then            ! at V-velocity points.
        do k=1,km
          do j=1,jm
            do i=1,im
              zpos(i,j,k)=0.5*(z(i,j,k)+z(i,j+1,k))
            enddo
          enddo
        enddo
      endif
      return
      end
