      subroutine xsection (sec, is,ks, fld, xfld,yfld,zfld,
     &                              im,jm,km, vintrp, spval)
!
! Extract a data section from a 3-D field using bicubic interpolation
! in the horizontal and linear or cubic splines interpolation in the
! vertical.
!
! input:  xsec   section X-coordinate (km).
!         ysec   section Y-coordinate (km).
!         is,ks  number of section points in horizontal
!         ks                     and vertical directions 
!         fld    field from which the section is extracted.
!         xfld   X-positions of field "fld" (km).
!         yfld   Y-positions of field "fld" (km).
!         zfld   depths of field "fld" (meters).
!         im     number of field points in the X-direction.
!         jm     number of field points in the Y-direction.
!         km     number of field points in the Z-direction.
!         vintrp vertical interpolation switch (integer):
!                  [0] linear, [1] cubic spline.
!         spval  special value to flag missing data.
!
! output: sec     extracted section (real).
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "pltncar.h"
#include "fields.h"
#include "secbath.h"
#include "secpos.h"
      integer is,ks, im,jm,km, vintrp
      real sec(is,ks), fld(im,jm,km), xfld(im,jm),
     &           yfld(im,jm), zfld(im,jm,km), spval,
     &           dxi(NH),  deta(NH)
      integer isec(NH), jsec(NH), i, ip, k, kstr, kend,
     &                      kpts, ierr,  vindices, nz
      parameter (nz=200)
      real fk(nz), wk(nz), zk(nz), dd,  delz, val,
     &     xdist, ydist, zbot, ztop, bcintrp, geodist

!
! Set the (i,j) indices of the 3D grid cell cointaining
! point (x,y) to interpolate horizontally.
!
      call hindices (isec,jsec, dxi,deta, xsec,ysec,ims,
     &                                  xfld,yfld, im,jm)
!
! Extract section bath curve.
!
      do i=1,ims
        sbth(i)=bcintrp (isec(i),jsec(i), dxi(i),deta(i),
     &                                bath, im,jm, spval)
c**     write(*,*) i,sbth(i)
      enddo
!
! Extract requested section: Perform horizontal interpolation first.
! Set depths to be positive so the first coordinate of the data
! entering the splines routines is in ascending order. 
!
      do i=1,ims
        do k=1,km
          fk(k)=bcintrp (isec(i),jsec(i), dxi(i),deta(i),
     &                           fld(1,1,k), im,jm, spval)
          zk(k)=bcintrp (isec(i),jsec(i), dxi(i),deta(i),
     &                          zfld(1,1,k), im,jm, spval)
c**       write(*,*) i,k,fk(k),zk(k)
        enddo
!
! Check viable vertical indices in extracted profile.
!
        ierr=vindices (fk,km,spval,kstr,kend)
        kpts=kend-kstr+1
        ztop=zk(kend)
        zbot=zk(kstr)                         ! Restrict the limits,
        if (abs(szbot) .gt. abs(sztop)) then  ! but only if sztop and
          ztop=min( ztop,  -abs(sztop))       ! szbot have legitimate 
          zbot=max( zbot,  -abs(szbot))       ! values. 
        endif
!
! Set depths to be used in contour location routine CPMPXY.
!
        delz=(ztop-zbot)/float(kms-1)
        do k=1,kms
          f5(i+(k-1)*ims)=zbot+delz*float(k-1)
        enddo
        f5(i+(kms-1)*ims)=ztop
!
! Perform vertical interpolation.  First, check viable indices in 
! extracted vertical profile.
!
        if (ierr.eq.0) then
          if (vintrp.eq.0) then            
#if VERBOSE > 4
             write(*,*) 'xsection: Linear vertical interpolation'
#endif
            do k=1,kms
              ip=i+(k-1)*ims
              call lintrp (zk(kstr), fk(kstr), kpts, f5(ip),
     &                                      sec(i,k), spval)
            enddo
          elseif (vintrp.eq.1) then
#if VERBOSE > 4 
            write(*,*)'xsection: Cubic spline vertical interpolation'
#endif
            call spline (zk(kstr),fk(kstr),kpts,spval,spval,spval,wk)
            do k=1,kms
              ip=i+(k-1)*ims
              if (ztop.ge.f5(ip) .and. f5(ip).ge.zbot) then
                call splint (zk(kstr), fk(kstr), wk, kpts, f5(ip),
     &                                           sec(i,k), dd)
              else
                sec(i,k)=spval
              endif
            enddo
          endif
        else
          do k=1,kms
            sec(i,k)=spval
          enddo
        endif
      enddo
!
! Set section positions as used by contour location routine CPMPXY.
! Cartesian axis (grid units or km).
!
      axistype=0
      if (isecpos.eq.0 .or. isecpos.eq.1) then
        x(1)=0.
        do i=2,ims
          x(i)=x(i-1)+sqrt( (xsec(i)-xsec(i-1))**2
     &                     +(ysec(i)-ysec(i-1))**2)
        enddo
!
! Spherical axis (metric or degrees units).
!
      elseif (isecpos.eq.2) then
        if (xsec(1) .eq. xsec(ims)) then
          axistype=2
          do i=1,ims
            x(i)=ysec(i)
          enddo
        elseif (ysec(1) .eq. ysec(ims)) then
          axistype=1
          do i=1,ims
            x(i)=xsec(i)
          enddo
        else
          if (secaxis.ne.0) then
            xdist=geodist(xsec(1),ysec(1),   xsec(ims),ysec(1))
     &           +geodist(xsec(1),ysec(ims), xsec(ims),ysec(ims))

            ydist=geodist(xsec(1),ysec(1),   xsec(1),ysec(ims))
     &           +geodist(xsec(ims),ysec(1), xsec(ims),ysec(ims))

            if (ydist.gt.xdist) then
              axistype=2
            elseif (xdist.gt.ydist) then
              axistype=1
            endif
          endif
          x(1)=0.
          do i=2,ims
            x(i)=x(i-1)+geodist(xsec(i-1),ysec(i-1), xsec(i),ysec(i))
          enddo
        endif
      endif
      do k=1,kms-1                ! Fill in the rest
        do i=1,ims                ! of two-dimensional
         x(i+k*ims)=x(i)          ! array x(ims,kms).
        enddo
      enddo

      do i=1,ims*kms
        y(i)=f5(i)
      enddo
      return
      end


!
! The following function computes distance between two points on
! the surface of the sphere. The distance is defined as length of
! arc of big circle connecting the two points.
!
      real function geodist (lon1,lat1, lon2,lat2)
      implicit none
      real lon1,lat1, lon2,lat2
      real*8  x1,y1,z1,  x2,y2,z2,
     &     xn,yn,zn, csn,snn, alpha, pi,deg2rad,radius 
      parameter (pi=3.14159265358979323846,
     &        deg2rad=pi/180., radius=6371.315)

      z1=sin(deg2rad*lat1)
      csn=cos(deg2rad*lat1)
      x1=csn*cos(deg2rad*lon1)
      y1=csn*sin(deg2rad*lon1)

      z2=sin(deg2rad*lat2)
      csn=cos(deg2rad*lat2)
      x2=csn*cos(deg2rad*lon2)
      y2=csn*sin(deg2rad*lon2)

      csn=x1*x2 + y1*y2 + z1*z2

      xn=y1*z2-y2*z1
      yn=z1*x2-z2*x1
      zn=x1*y2-x2*y1
      snn=sqrt(xn*xn + yn*yn + zn*zn)

      if (snn .lt. 0.5) then
        alpha=asin(snn)
        if (csn .lt. 0.) alpha=pi-alpha
      else
        alpha=acos(csn)
        if (snn .lt. 0.) alpha=-alpha
      endif

c**   write(*,*) alpha,snn,csn

      geodist=radius*abs(alpha)
      return
      end



