      subroutine xhslice (f2d,depth, z,f3d, im,jm,km, vintrp,spval)
!
! This routine extracts a horizontal slice from a 3D field at the
! requested depth via interpolation.
!
! input: depth    Depth to interpolate.
!        f3d      3D field.
!        z        Depths of 3D field.
!        im,jm    horizontal dimensions
!        km       number of vertical levels
!        vintrp   interpolation scheme, 0 ==> linear,
!                                       1 ==> cubic spline
! output: f2d     interpolated 2d field
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
      integer im,jm,km, vintrp, i,j,k
      real  f2d(im,jm), depth(im,jm), z(im,jm,km), f3d(im,jm,km),
     &        fk(NK), zk(NK), wk(NK), spval, dd 

      if (vintrp.eq.0) then
#if VERBOSE > 2
        write(*,*) 'xhslice: Linear vertical interpolation'
#endif
        do j=1,jm
          do i=1,im
            do k=1,km
              fk(k)=f3d(i,j,k)
              zk(k)=z(i,j,k)
            enddo
            call lintrp (zk,fk,km, depth(i,j),f2d(i,j), spval)
          enddo
        enddo
      elseif (vintrp.eq.1) then
#if VERBOSE > 2
        write(*,*) 'xhslice: Cubic spline vertical interpolation' 
#endif
        do j=1,jm
          do i=1,im
            do k=1,km
              fk(k)=f3d(i,j,k)
              zk(k)=z(i,j,k)
            enddo
            call spline (zk,fk,km, spval,spval,spval, wk)
            if (zk(1).le.depth(i,j) .and. depth(i,j).le.zk(km)) then
              call splint (zk,fk,wk,km,depth(i,j),f2d(i,j), dd)
            else
              f2d(i,j)=spval
            endif
          enddo
        enddo
      endif
      return
      end
