      subroutine what_flds (ncid,ivars,file,ncname)
!
! Report plottable fields and thier times available
! in NetCDF file NCNAME.
!
! Input: ncid       NetCDF file ID (integer).
!        ivars      number of variables in netCDF file (integer).
!        file       flag for primary (FILE=1) or secondary (FILE=2)
!                         NetCDF file (integer).
!        ncname     NetCDF file name (character).
!
! Calls: fldnam2id, lenstr
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "ncinfo.h"
#include "netcdf.inc"
#include "pltio.h"

      integer file, i, idfld, lfld, lstr, n, ncid, ivars,
     &        nvatts, ierr, fldnam2id, lenstr
      character*40 vname
      character*240 long_name 
      character*(*) ncname

      lstr=lenstr(ncname)
      write(stdout,'(/2x,4A/2x,2A)') 'Plottable fields in netCDF ',
     &             'file ''',  ncname(1:lstr), '''',  '========= ',
     &             '====== == ====== ==== ===================='
      do i=1,ivars
        varid=i
        ierr=nf_inq_var(ncid,varid,vname,vartyp,nvdims,vdims,nvatts)
        if (ierr.eq.nf_noerr) then
          idfld=fldnam2id(vname)
          if (idfld.ne.-99) then
            ierr=nf_inq_attlen (ncid, varid, 'long_name', lfld)
            if (ierr.eq.nf_noerr .and. lfld.le.240) then
              ierr=nf_get_att_text (ncid,varid,'long_name',long_name)
              if (ierr.eq.nf_noerr)  write(stdout,'(2x,A,I3,A,1x,A)')
     &                         '[ID=', idfld, ']',  long_name(1:lfld)
            endif
          endif
        endif
      enddo
  30  format(1x,'[',A,i3,']',1x,A)
!
! Report available times.
!
      if (ntime1.gt.0 .or. ntime2.gt.0) then
        write(stdout,'(/2(2x,A/))') 'Available times:',
     &                              '--------- ------'              
        if (file.eq.1) then
          if (gottime1) then
            write(stdout,'(5G15.7)') (sec2day*time1(i),i=1,ntime1)
          else
            write(stdout,'(5G15.7)') (time1(i),i=1,ntime1)
          endif
        elseif (file.eq.2) then
          if (gottime2) then
            write(stdout,'(5G15.7)') (sec2day*time2(i),i=1,ntime2)
          else
            write(stdout,'(5G15.7)') (time2(i),i=1,ntime2)
          endif
        endif
      endif
!
! Report available levels.
!
c      write(*,*) 'nlev1 =', nlev1, '   nlev2=', nlev2
      if (nlev1.gt.0 .or. nlev2.gt.0) then
        write(stdout,'(/2(2x,A/))') 'Available levels:',
     &                              '--------- -------'
        if (type1(1:5).eq.'ROMS' .or. type1(1:5).eq.'SCRUM' .or.
     &                                type1(1:3).eq.'ICE' ) then
          if (file.eq.1) then
            write(stdout,70) (n,lev1(n), n=1,nlev1)
          elseif (file.eq.2) then
            write(stdout,70) (n,lev2(n), n=1,nlev2)
          endif
        endif
      endif

  70  format(1x,'[',i2,']',1x,'for DATA Level:',1x,i5)
      return
      end



      integer function fldnam2id (varnam)
!
! Returns the field identification index of classification
! CLASS for NetCDF Variable VARNAM.
!
! input:    varnam     variable name from netCDF file
! output:   fldnam2id  corresponding ID fron varids file.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      character*(*) varnam
      integer i, idfld, lvar, lvar1, lenstr
#include "fldsid.h"
      idfld=-99
      lvar=lenstr(varnam)
      if (lvar.gt.0) then
        i=0
        do while (idfld.eq.-99 .and. i.lt.nvarids)
          lvar1=lenstr(vname1(i))
          if (lvar1 .eq. lvar) then
            if (varnam(1:lvar) .eq. vname1(i)(1:lvar1)) then
             idfld=i
            endif
          endif
          i=i+1
        enddo
      endif
      fldnam2id=idfld
      return
      end

