      subroutine vvumxy (xp,yp, u,v,uvm, xb,yb, xe,ye, ierr)
!
! WARNING: This subroutine is not called directly by the plotting
!          package, but rather called internally from NCAR Graphics
!          library (basically it overwrites an internal NCAR library
!          routine. NAME OF THIS SUBROUTINE AS WELL AS NUMBER AND
!          ORDER OF ITS ARGUMENTS MUST NOT BE CHANGED UNDER ANY
!          CIRCUMSTANCES. 
!
! This is a user modifiable routine that allows custom projections
! of the vector space. X and Y give the vector position within the
! domain of the data space.  By default,  this space is coincident
! with the grid space (that is, 1 through dimension lengths of the
! U and V arrays).  The vector end-points are output in fractional
! coordinates (NDC space).
! Note that this is different from the old  MXF and  MYF routines,
! which output in 'plotter coordinate' space. It also differs from
! the Conpack routine CPMPXY, which returns values in user space.
!
! VVUMXY (Velocity Vector -- User Map X, Y) is called whenever the
! internal parameter MAP is set to a value other than 0 to 4.
!
! Based on the magnitude and direction of the vector the start and
! ending points of the vector are returned in NDC space.
!
! input:
!     xp,yp    Vector position in the user coordinate system
!     u,v      Vector components from the U,V arrays for this
!              position.
!     uvm      Magnitude of the U,V components (supplied for
!              convenience and efficiency - but note that many
!              mappings do not need this value).
!
! output:
!
!     xb,yb    Starting point of the vector in fractional
!              coordinates (NDC space).
!     xe,ye    Ending point of the vector in fractional
!              coordinates (NDC space).
!     ierr     Status results of the mapping: 0 indicates success;
!              any non-zero value causes  VVECTR  to discard the
!              vector at this location.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer ierr, i,j, ip,iter
      real xp,yp, u,v,uvm, xb,yb, xe,ye, clt, duv,dv1, sgn, cffX,cffY,
     &     xt,yt, xvt, yvt, cufx,cufy
!
! Parameters (used for the Ezmap projection only):
!
!    prcfac - Precision factor used to resolve float equality
!                 within the precision of a 4 byte REAL.
!    pvfrac - Initial fraction of the vector magnitude used to
!                 determine the differential increment.
!    pfovfl - Floating point overflow value.
!    ipmxct - Number of times to allow the differential to increase.
!    pduvml - Multiplier when the differential is increased.
!    pcstst - Test value for closeness to 90 degree latitude.

      integer ipmxct, ipctst
      real prcfac, pvfrac, pfovfl, pduvml
      parameter (prcfac=1E5, pvfrac=0.001, pfovfl=1E12,
     &           ipmxct=40,  pduvml=2.0, ipctst=prcfac*90)

#include "param.h"
#include "fields.h"
#include "ndimen.h"
#include "vvmap.h"
#if VERBOSE > 3 
c**      write(*,'(1x,A,$)') 'Enter vvumxy...' 
#endif
!
! The following code is adapted from the Ezmap projection code in
! VVMPXY. An iterative technique is used that handles most vectors
! arbitrarily close to the projection limb.  XT is longitude,
! YT is latitude.
!
! Check whether the vector magnitude is too small.
! User spherical coordinate mapping.  Interpolate from User grid.
! Check that indices i,j fall within the domain of the array
! dimensions im,jm.
! Check that latitude is not equal to90 degrees.
! Project the starting value: bail out if outside the window.
!
!
      ierr=0
      if (imap.eq.3) then
        if (ifix(uvm*prcfac+0.5).ne.0) then
          i=int(xp)
          j=int(yp)
          if (i.gt.0 .and. i.lt.im .and. j.gt.0 .and. j.lt.jm) then
            ip=i+(j-1)*im
            cffX=xp-aint(xp)
            cffY=yp-aint(yp)

            xvt=(1.-cffY) * ((1.-cffX)*x(ip   ) + cffX*x(ip+1  ))
     &             +cffY  * ((1.-cffX)*x(ip+im) + cffX*x(ip+im+1))
            yvt=(1.-cffY) * ((1.-cffX)*y(ip   ) + cffX*y(ip+1   ))
     &             +cffY  * ((1.-cffX)*y(ip+im) + cffX*y(ip+im+1))

            if (ifix(abs(yvt)*prcfac+0.5) .ne. ipctst) then
              call maptra (yvt,xvt, xb,yb)
              if (wxmn.le.xb .and. xb.le.wxmx .and.
     &            wymn.le.yb .and. yb.le.wymx) then
!
! Project the incremental distance. If the positive difference does
! not work, try the negative difference. If the difference results
! in a zero length vector, try a number of progressively larger
! increments. The incremental distance is proportional to a small
! fraction of the vector magnitude.
!
                duv=pvfrac/uvm
                clt=cos(yvt*pdtor)
                iter=0
                sgn=1.
  10            call maptra (yvt+sgn*duv*v,xvt+sgn*duv*u/clt, xt,yt)
                dv1=sqrt((xt-xb)*(xt-xb)+(yt-yb)*(yt-yb))

                if (ifix(dv1*prcfac).gt.0  .and. dv1.le.rlen .and.
     &              abs(xt).lt.pfovfl .and. abs(yt).lt.pfovfl) then
                  sgn=sgn*uvm/dv1        !
                  cffX=sgn*sxdc*(xt-xb)  ! Find vector ending
                  cffY=sgn*sydc*(yt-yb)  ! position (xe,ye).
                  xb=cufx(xb)            ! Convert starting and
                  yb=cufy(yb)            ! ending positions to
                  xe=xb+cffX             ! fractional coordinates.
                  ye=yb+cffY             !
                elseif (dv1.gt.rlen .and. sgn.gt.0.) then
                  sgn=-1.
                  goto 10
                elseif (ifix(dv1*prcfac).eq.0 .and.
     &                         iter.lt.ipmxct) then
                  iter=iter+1
                  duv=duv*pduvml
                  goto 10
                elseif (dv1.gt.rlen) then
                  ierr=-4
                elseif (ifix(dv1*prcfac).eq.0) then
                  ierr=-3
                else
                  ierr=-6
                endif
              else
                ierr=-5
              endif
            else
              ierr=-1
          endif
          else
            ierr=-1
          endif
        else
          ierr=-2
        endif
!
! Default mapping in Cartesian coordinates.
! WXMN, WXMX, WYMN, and WYMX contain the minimum and maximum values of
! the user coordinate space. Somewhat inaccurately, the mmenomic 'W'
! implies window coordinate space, which is usually (but not always)
! the same as user coordinate space. But note that even when the
! coordinates are reversed, you are guaranteed that WXMN .lt. WXMX
! and WYMN .lt. WYMX. This eliminates the need to invoke MIN and MAX.
!
      else
        if (xp.ge.wxmn .and. xp.le.wxmx .and. 
     &      yp.ge.wymn .and. yp.le.wymx) then
          xb=cufx(xp)
          yb=cufy(yp)
          xe=xb+u*sxdc
          ye=yb+v*sydc
        else
          ierr=-1
        endif
      endif
  99  continue
#if VERBOSE > 3
c**      write(*,'(10x,A)') '... return from vvumxy.'
#endif
      return
      end
