! WARNING: Common block stmap defined in this file is designed
!          to match internal common block defined inside NCAR
!          graphics library. To avoid mismatch of variables,
!          THERE MUST BE NO ALTERATION OF THIS FILE under any
!          circumstances.
!
! NOTE: all these variables should be considered read-only 
!
!
! Description of VVMAP content:
!------------ -- ----- --------
! imap                - value of the internal parameter 'MAP'
! xvpl,xvpr,yvpb,yvpt - the currently set viewport values. (GETSET
!                       arguments 1, 2, 3, and 4)
! wxmn,wxmx,wymn,wymx - the min and max boundaries of user coordinate
!                       space, (usually but not always equivalent to
!                       window coordinates). WXMN and WYMN are true
!                       minimum values even one or both axes is
!                       inverted. (i.e. they are equivalent to GETSET
!                       arguments 5,6,7, and 8 sorted numerically)
! xlov,xhiv,ylov,yhiv - min and max boundaries of the data space, by
!                       default equivalent to the array grid space.
!                       XLOV and YLOV are not necessarily less than
!                        XHIV and YHIV.
! sxdc,sydc           - Scaling factors for converting vector
!                         component values into lengths in NDC space.
! nxct,nyct           - Length of each dimension of the U and V
!                        component arrays.
! rlen                - Length of the maximum vector in user
!                       coordinates.
! lnlg                - The linear/log mode (GETSET argument 9)
! invx,invy           - User coordinates inversion flags:
!                       0 - not inverted, 1 - inverted
! itrt                - value of the internal parameter TRT
! iwct                - not currently used
! fw2w,fh2h           - scale factors for converting from fraction of
!                           viewport width/height to NDC width/height
! dvmn,dvmx           - min/max vector lengths in NDC
! rbig,ibig           - machine dependent maximum REAL/INTEGER values
!
      integer  imap,       nxct, nyct,         lnlg, invx, invy
      integer  itrt, iwct,                                 ibig
      real                 fw2w, fh2h,   xvpl, xvpr, yvpb, yvpt
      real     wxmn, wxmx, wymn, wymx,   xlov, xhiv, ylov, yhiv
      real     sxdc, sydc,       rlen,   dvmn, dvmx, rbig
      common /vvmap/ imap,               xvpl, xvpr, yvpb, yvpt,
     &         wxmn, wxmx, wymn, wymx,   xlov, xhiv, ylov, yhiv,
     &         sxdc, sydc, nxct, nyct,   rlen, lnlg, invx, invy,
     &         itrt, iwct, fw2w, fh2h,   dvmn, dvmx, rbig, ibig
      save /vvmap/
!
! Mathematical constants:
!
      real pdtor, prtod, p1xpi, p2xpi, p1d2pi, p5d2pi
      parameter (pdtor=0.017453292519943, prtod=57.2957795130823,
     &           p1xpi=3.14159265358979,  p2xpi=6.28318530717959,
     &           p1d2pi=1.57079632679489, p5d2pi=7.85398163397448)



