      function vindices (f,km, spval, kstr,kend)
!
! This routine checks the contents of profile  F(z) and extracts
! the starting and ending indices in such a way that masked data
! will excluded at either end.  This routine is used in the high
! order vertical interpolation of cross-sections.
!
! Input:  f        Field vertical profile (real array).
!         km       Number of points in F (integer).
!         spval    Field special value used during checking (real).
!
! Output  kstr     Starting index (integer).
!         kend     Ending index (integer).
!         vindices check status (integer):
!                    vindices=0  successful extraction.
!                    vindices=1  all profile is masked.
!                    vindices=2  only one or two points are viable.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer vindices, k, kend, km, kstr
      real f(km), spval

      vindices=1
      kstr=km
      kend=km
!
! Get starting index.
!
      do k=1,km
        if (f(k).ne.spval) then
          kstr=k
          goto 10
        endif
      enddo
  10  if (kstr.eq.km) return
!
! Get ending index.
!
      do k=km,kstr+1,-1
        if (f(k).eq.spval) then
          kend=k-1
        endif
      enddo
!
! Check extracted indices.
!
      if (kend-kstr .le. 1) then
        vindices=2
      else
        vindices=0
      endif
      return
      end
