      subroutine viewport (icolor, Xbar,Ybar)
!
! Set viewport coordinates in the fractional system according
! to the number of plots per page and current plot in the page.
!
! input:
!
!  npage     parameter determining the number of plots on each
!            page and their arrangement (i.e. 1x2, 2x1, 2x2...)
!
!  ntitles, ititle(...)  number of main titles and their type (top,
!           left, bottom, right = 0,2,4,6), if any. These cause to 
!           leave some space around the plot to accomodate them.
!
!  ipltpg   index controlling the position on the plot to be
!            drawn on the page.
! output:
!
!   ipltpg      input value of ipltpg incremented by 1.
!   close_page  swich indicating that this is going to be the
!               last plot on tsis page.
!   fl,fr,fb,ft fractional coordinates of left, right, bottom and
!               top boundaries on the current window (viweport).
!   basesize    scale for fonts in semi-proportional scaling  
!               (when the size of the plot decreases because
!               there are more plots on the page, the font size
!               decreases slower than the plot size).
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer icolor,  imax,jmax,  nmax, ii,jj,  tile
      real Xbar,Ybar,  LeftMargin, RightMargin,  SizeX,
     &                 TopMargin,  BottomMargin, SizeY
#include "pltlab.h"
#include "pltfld.h"
#include "pltncar.h"
                                    ! Set default margins to allow
      LeftMargin  =0.01             ! maximum size of the plot, then 
      RightMargin =0.99             ! adjust them to accomodate title 
      TopMargin   =0.99             ! labels by moving margins inward 
      BottomMargin=0.01             ! by the height of title font. 
                                    ! Once this movement is finished, 
      SizeX=0.025*magscale          ! move margines which have been
      do ii=1,ntitles               ! already moved a little bit more 
        jj=ititle(ii)/2             ! to allow space between labels
        if (jj.eq.0) then                        ! and plot itself.
          TopMargin    = TopMargin  -SizeX
        elseif (jj.eq.1) then
          LeftMargin   = LeftMargin  +SizeX
        elseif (jj.eq.2) then
          BottomMargin = BottomMargin +SizeX
        elseif (jj.eq.3) then
          RightMargin  = RightMargin  -SizeX
        endif
      enddo

      SizeX=0.005*magscale
      if (TopMargin    .lt. 0.99) TopMargin    = TopMargin    -SizeX
      if (LeftMargin   .gt. 0.01) LeftMargin   = LeftMargin   +SizeX
      if (BottomMargin .gt. 0.01) BottomMargin = BottomMargin +SizeX
      if (RightMargin  .lt. 0.99) RightMargin  = RightMargin  -SizeX

      if (npage.gt.10  .and. npage.lt.100) then
        imax=npage/10
        jmax=npage-10*imax          ! Normally npage is expected to
      elseif (npage.eq.1) then      ! be a two-digit number, like 23
        imax=1                      ! or so, where the first digit
        jmax=1                      ! indicates the desired number of
      elseif (npage.eq.2) then      ! panels (tiles) in horizontal
        imax=1                      ! direction, while the second
        jmax=2                      ! digit is the number of panels 
      elseif (npage.eq.4) then      ! in vertical direction. 
        imax=2
        jmax=2                      ! This is preferred coding
      else                          ! scheme: all others, npage=1,2,
        imax=0                      ! and 4. are supported solely for
        jmax=0                      ! the reason of compatibility
      endif                         ! with old input files.

      nmax=imax*jmax
      if (nmax.gt.0) then
        ipltpg=ipltpg+1
        if (ipltpg .gt. nmax) ipltpg=1
        if (ipltpg .eq. nmax) then  ! Subdomain indexing convention
          close_page=.true.         ! adopted here is as follows: 
        else                        !
          close_page=.false.        ! (jmax-1,0)  --- (imax-1,jmax-1)
        endif                       !
                                    !        !                !
        tile=ipltpg-1               !        !                !
        if (row_column) then        !        !                !
          jj=tile/imax              !
          ii=tile-imax*jj           !      (0,0)  ------   (imax-1,0)
        else                        !
          ii=tile/jmax              ! so that  tile=ii+jj*imax
          jj=tile-jmax*ii           ! 
        endif 
        jj=jmax-jj-1                ! <-- invert up and down.

        SizeX=(RightMargin-LeftMargin)/float(imax)
        fl=LeftMargin+SizeX*ii
        fr=fl+SizeX

        SizeY=(TopMargin-BottomMargin)/float(jmax)
        fb=BottomMargin+SizeY*jj
        ft=fb+SizeY                           ! Set proportionality
                                              ! scale for font sizes.
        basesize=magscale * (2.*SizeX*SizeY/(SizeX+SizeY))**0.7

        if (ltmarks) then                      ! Adjust viewport to
          if (plttyp.eq.cntplt) then           ! accomodate various
            ft=ft-0.025*basesize               ! labels along the 
            fl=fl+0.033*basesize               ! perimeter of the
          elseif (plttyp.eq.secplt) then       ! plot.
            fl=fl+0.06*basesize
            fb=fb+0.035*basesize
            if (spherical) then
              ft=ft-0.01*basesize
            else
              ft=ft-0.03*basesize
            endif
          endif
        endif                                  ! Make room for field
        if (wrtfield) fb=fb+0.035*basesize     ! name and contour
        if (wrtrang)  fb=fb+0.035*basesize     ! interval message

        if (lclrbar .and. icolor.ne.0) then    ! Determine width of 
          Xbar=0.0575*(fr-fl)+0.045*basesize   ! color bar, either 
          Ybar=0.0825*(ft-fb)+0.035*basesize   ! vertical or 
        else                                   ! horizontal, which 
          Xbar=0.                              ! consists of width 
          Ybar=0.                              ! of color bar itself 
        endif                                  ! and width of labels.

#if VERBOSE > 2
        write(*,'(1x,A,2I3,2(3x,A,2I3)/11x,A,4F7.4,3x,A,F7.4)')
     &     'VIEWPORT: npage,ipltpg =',npage,ipltpg, 'imax,jmax =',
     &     imax,jmax, 'ii,jj =',ii,jj, 'fl,fr,fb,ft=',fl,fr,fb,ft,
     &     'basesize =', basesize
#endif
        return
      else
        write(*,'(/2(1x,A),I3,1x,A/)')  'ERROR: illegal parameter',
     &                       'NPAGE =', npage, 'in the input file.'
        stop
      endif
      end
