      subroutine vecpack (p, u,v, lm, im,jm, smin,smax, icolor)
!
! Draws a a vector field.
!
! Input:  p     Array of scalar data (usually, vector magnitude) that
!                                       may be used to color vectors.
!        u,v    Vector components in the first and second dimensions.
!        lm     size of the first dimension in the calling program.
!       im,jm   number of actually used elements in the first and
!                                                 second dimensions.
!     smin,smax minimum and maximum vector magnitude to plot.
!       icolor  color switch: 0  foreground color: black or white.
!                             1  use NCL colors from palette.
!                             2  single-color overlay plot
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer lm,im,jm, icolor, i, ll
      real p(lm,jm), u(lm,jm), smin, dmx,  vl,vr,vb,vt, xc(5), 
     &     cff,      v(lm,jm), smax, pval, wl,wr,wb,wt, yc(5)

      external colram, vvudmv, fill989 
#include "param.h"
#include "pconst.h"
#include "cntwkspa.h"
#include "fmask.h"
#include "pltfld.h"
#include "pltncar.h"
#if VERBOSE > 2
      write(*,'(1x,A,$)') 'Enter vecpack...'
#endif
!
! Reset all VECPACK parameters to their default values to facilitate
! overlays.
!
      call vvrset
!
! Set VECTORS drawing options.
!-------------------------------
! Prevent VECTORS from setting the viewport.
!
      call vvseti ('SET - do-set-call flag', 0)
c*    call vvseti ('VST - vector statistics output flag', 1)
!
! Set vector positioning mode.
!
      call vvseti('VPO - vector positioning mode',vec_vpo)
!
! Prevent "zero field" text from being displayed.
!
      call vvsetc ('ZFT - zero field text block',' ')
!
! Set mapping to that provided by the User. Set up data coordinate
! boundaries.
!
      if (spherical) then
        call vvseti ('MAP - mapping flag',         3)
        call vvsetr ('XC1 - Lower X Bound',        1.)
        call vvsetr ('XCM - Upper X Bound', float(im))
        call vvsetr ('YC1 - Lower Y Bound',        1.)
        call vvsetr ('YCN - Upper Y Bound', float(jm))
      else
        call vvseti ('MAP - mapping flag',  4)
        call vvsetr ('XC1 - Lower X Bound', ul)
        call vvsetr ('XCM - Upper X Bound', ur)
        call vvsetr ('YC1 - Lower Y Bound', ub)
        call vvsetr ('YCN - Upper Y Bound', ut)
      endif
!
! Set vector grid sampling.
!
      call vvseti ('XIN - X-axis array increment', ivinc)
      call vvseti ('YIN - Y-axis array increment', jvinc)
!
! Set-up vector text block: suppress vector label by setting MNT,MXT
! blank in the case of color plot (magnitudes are shown by vector
! colors in this case). Otherwise (vector overlay or black-and-white
! plot) parameters for vector label.
!
c?      if (icolor.eq.1) then
c?        call vvsetc ('MNT - Minimum vector text block', ' ')
c?        call vvsetc ('MXT - Maximum vector text block', ' ')
c?      else
        call vvsetc ('MNT - Minimum vector text block',' ')
        call vvseti ('MXP - Maximum vector text position mode',-4)
        call vvsetr ('MXS - Maximum vector text block size',0.0095)
        call vvsetr ('MXX - Maximun vector X-coordinate',vec_mxx)
        call vvsetr ('MXY - Maximun vector Y-coordinate',vec_mxy)
        if (vec_vrm.gt.0.) then
c         call vvsetr ('VHC - Vector reference magnitude',-vec_vrm)
          call vvsetr ('VRM - Vector reference magnitude', vec_vrm)
        else
c         call vvsetr ('VHC - Vector reference magnitude',-smax)
          call vvsetr ('VRM - Vector reference magnitude', smax)
        endif
c?      endif
!
! Set special value processing appropriately for the vector field.
!
      call vvseti ('SVF - Special Values Flag',  3)
      call vvsetr ('USV - U Special Value',  spval1)
      call vvsetr ('VSV - V Special Value',  spval1)
      call vvsetr ('PSV - P Special Value',  spval1)
      call vvseti ('SPC - P Special Color',       1)
!
! Set up masking of vectors to an existing area map.
!
      if (lland) then
c        call vvseti ('MSK - Vector Masking', 1)
      else
        call vvseti ('MSK - Vector Masking', 0)
      endif
!
! Set up vector color processing.
!
      if (icolor.eq.1) then
        call vvseti ('CTV - Color Thresholds Value',-2)
        call vvseti ('NLV - Number Of Levels',ncl)
        do i=1,ncl
          pval=smin+(smax-smin)*float(i-1)/float(ncl-1)
          call vvseti ('PAI -- Parameter Array Index', i)
          call vvseti ('CLR -- GKS Color Index',      i+1)
          call vvsetr ('TVL -- Treshold Value',      pval)
        enddo
      elseif (icolor.eq.2) then
        call gsplci (ncl+4)
      endif
!
! Initialize vectors.
!
      call vvinit (u,lm, v,lm, p,lm, im,jm, rwrk,lrwk)
!
! Adjust vector rendering options.
!
!
! Set minimum and maximum vector to Draw. Vectors below and above
! this values are not drawn.
!
      if (smin.gt.0.) then
        call vvsetr ('VLC - Vector Low Cutoff', smin)
      else
        call vvgetr ('VMX - Maximum Vector', cff)
        call vvsetr ('VLC - Vector Low Cutoff', cff*vec_vlc)
      endif
      call vvsetr ('VHC - Vector high cutoff value', smax)

      call vvsetr ('AMN - Arrow Minimum Size', vec_amn)
      call vvsetr ('LWD - Vector Line Width',  vec_lwd)

      call vvgetr ('DMX - Device Maximum Vector Length', dmx)
      call getset (vl,vr,vb,vt, wl,wr,wb,wt, ll)
#if VERBOSE > 2
      write(*,'(A,4F6.3,2x,A,4F10.4)')  'vl,vr,vb,vt=', vl,vr,vb,vt,
     &                                  'wl,wr,wb,wt=', wl,wr,wb,wt
#endif

!
! P. Marchesiello: VRL changed to allow fixed scales in animations
!
      cff=vec_scl*dmx/(vr-vl)
c**   cff=vec_scl* smax/50 *dmx/(vr-vl)
      call vvsetr ('VRL - Vector Realized Length',  cff)
      call vvsetr ('VFR - Vector Fractional Minimum', vec_vfr)

#if VERBOSE > 2
      write(*,'(3x,A,$)') 'Drawing vector field plot...'
#endif
      call vvectr (u,v,p, iam, vvudmv, rwrk)
#if VERBOSE > 2
      write(*,'(3x,A)')                       '...done.'
#endif
!
! Set polyline color back to its foreground color.
!
      if (icolor.eq.2) call gsplci (1)
#if VERBOSE > 2
      write(*,'(10x,A)') '.... done with vecpack.' 
#endif
      return
      end


      subroutine vecmag (p, u,v, im,jm, spval)
!
! Given a vector field with components "u,v", compute field of
! magnitudes "p". Meaning of arguments u,v,p,lm,im,jm is the same
! as in "vecpack" above.
!
      implicit none
      integer im,jm, i,j
      real u(im,jm),v(im,jm), p(im,jm), spval
      do j=1,jm
        do i=1,im
          if (u(i,j).ne.spval .and. v(i,j).ne.spval) then
            p(i,j)=sqrt(u(i,j)*u(i,j)+v(i,j)*v(i,j))
          else
            p(i,j)=spval
          endif
        enddo
      enddo
      return
      end

