      subroutine stumxy (xda,yda, xus,yus, ierr)
!
! WARNING: This subroutine and all other subroutines in this file
!          are not called directly by the plotting package, but 
!          rather called internally from NCAR Graphics library
!          (basically it overwrites an internal NCAR library
!          routine. NAME OF THIS SUBROUTINE AS WELL AS NUMBER AND
!          ORDER OF ITS ARGUMENTS MUST NOT BE CHANGED UNDER ANY
!          CIRCUMSTANCES.
!
! Locate streamlines in the map defined by the user.
!
! input:  xda,yda   Point in data coordinate space.
!
! output: xus,yus   Point in user coordinate space.
!         ierr      Status code indicating success or failure.
!
! Copyright (c) 1998 Rutgers University.
!
      implicit none
      integer ierr, i,j, ip
      real xda,yda, xus,yus, u,v, x1,y1, x2,y2, x3,y3, x4,y4

#include "param.h"
#include "fields.h"
#include "ndimen.h"
#include "stmap.h"

      ierr=0                                  ! Spherical EZMAP
      if (imap.eq.1) then                     ! projections 
        call maptra (yda,xda,xus,yus)
      elseif (imap.eq.2) then                 ! Polar coordinates
        xus=xda*cos(pdtor*yda)
        yus=xda*sin(pdtor*yda)
      elseif (imap.eq.3) then                 ! Spherical curvilinear
        i=int(xda)                            ! grid projections
        j=int(yda)
        u=xda-aint(xda)
        v=yda-aint(yda)
        ip=i+(j-1)*im
        call maptrn (y(ip),x(ip),x1,y1)
        call maptrn (y(ip+1),x(ip+1),x2,y2)
        call maptrn (y(ip+im+1),x(ip+im+1),x3,y3)
        call maptrn (y(ip+im),x(ip+im),x4,y4)
        xus=(1.-u)*(1.-v)*x1+u*(1.-v)*x2+u*v*x3+v*(1.-u)*x4
        yus=(1.-u)*(1.-v)*y1+u*(1.-v)*y2+u*v*y3+v*(1.-u)*y4
      elseif (imap.eq.4) then
        i=int(xda)                            ! Cartesian curvilinear 
        j=int(yda)                            ! grid mapping
        u=xda-aint(xda)
        v=yda-aint(yda)
        ip=i+(j-1)*im
        x1=x(ip)
        x2=x(ip+1)
        x3=x(ip+im+1)
        x4=x(ip+im)
        y1=y(ip)
        y2=y(ip+1)
        y3=y(ip+im+1)
        y4=y(ip+im)
        xus=(1.-u)*(1.-v)*x1+u*(1.-v)*x2+u*v*x3+v*(1.-u)*x4
        yus=(1.-u)*(1.-v)*y1+u*(1.-v)*y2+u*v*y3+v*(1.-u)*y4
      else
        xus=xda                               ! No mapping.
        yus=yda
      endif
!
! Check for out of bound conditions.
!
      if (xus.lt.wxmn .or. xus.gt.wxmx .or.
     &    yus.lt.wymn .or. yus.gt.wymx) then
        ierr=-1
      endif
      return
      end

      subroutine stuixy (xus,yus, xda,yda, ierr)
!
! This routine is used by streamlines for inversely transforming
! a point in user coordinate space to data space.
!
! input:  xus,yus   Point in user coordinate space.
!
! output: xda,yda   Point in data coordinate space.
!         ierr      Status code indicating success or failure.
!
! Copyright (c) 1998 Rutgers University.
!
      implicit none
      integer ierr, i,j  !, ip
      real xus,yus, xda,yda, u,v
c**   real x1,y1, x2,y2, x3,y3, x4,y4
#include "param.h"
#include "fields.h"
#include "ndimen.h"
#include "stmap.h"
!
! Spherical EZMAP mapping projections.
!
      ierr=0
      if (imap.eq.1) then
        call maptri (xus,yus, yda,xda)
        if (xda.eq.1.e12 .or. yda.eq.1.e12) ierr=-1 
!
! Polar coordinates mapping. This mapping has special bounds
! checking requirements. If YDA is less than YLOV, it is possible
! that the user intends to treat some or all of quandrant 3 and 4
! as positive angles (unlike ATAN2). Add 360 in this case.
!
      elseif (imap.eq.2) then
        xda=sqrt(xus*xus+yus*yus)
        yda=prtod*atan2(yus,xus)
        if (yda.lt.ylov) yda=yda+360.0
!
! Curvilinear coordinates: Determine indices (i,j) of the 2D grid
! cell cointaining point (x,y), then interpolate horizontally
!
      elseif (imap.eq.3) then
        call maptri (xus,yus, yda,xda)
        if (xda.lt.1.e12 .and. yda.lt.1.e12) then
          write(*,*) 'calling hindices from stumxy.F'
          call hindices (i,j, u,v, xda,yda,1, x,y,im,jm)
          if (i.gt.0 .and. j.gt.0) then
c*          ip=i+(j-1)*im
c*          x1=x(ip)
c*          x2=x(ip+1)
c*          x3=x(ip+1+im)
c*          x4=x(ip  +im)
c*          y1=y(ip)
c*          y2=y(ip+1)
c*          y3=y(ip+1+im)
c*          y4=y(ip  +im)
c*          xda=(0.5+v)*((0.5-u)*x4+(0.5+u)*x3)
c*   &         +(0.5-v)*((0.5-u)*x1+(0.5+u)*x2)
c*          yda=(0.5+v)*((0.5-u)*y4+(0.5+u)*y3)
c*   &         +(0.5-v)*((0.5-u)*y1+(0.5+u)*y2)

            xda=float(i)+0.5+u
            yda=float(j)+0.5+v
          else
            ierr=-1
          endif
        else
          ierr=-1
        endif
      else
        xda=xus              ! No maping
        yda=yus
      endif
!
! Check for out of bound conditions.
!
      if (ierr.eq.0) then
        if (xda.lt.min(xlov,xhiv) .or. xda.gt.max(xhiv,xlov) .or.
     &      yda.lt.min(ylov,yhiv) .or. yda.gt.max(yhiv,ylov)) ierr=-1
      endif
      return
      end


      subroutine stumta (xda,yda, xus,yus, xnd,ynd, du,dv, ta, ierr)
!
! This routine is used by streamlines for inversely transforming
! point in user coordinate space to data space.
!
! input: xda,yda   Point in data coordinate space.
!        xus,yus   Point in user coordinate space.
!        xnd,ynd   Point in NDC space.
!        du,dv     Differential vector components in data space.
!
! output: ta       Streamline tangent angle in NDC space.
!         ierr     Status code indicating success or failure.
!
! In general the distance over which the angle is measured is
! iteratively adjusted until it is becomes a small (but not too
! small) fraction of the fixed (in NDC space) increment distance.
! The transformation type parameter is implemented for the polar
! mapping only.
!
! Copyright (c) 1998 Rutgers University.
!
      implicit none
      real xda,yda, xus,yus, xnd,ynd, du,dv, ta
      integer ierr 

#include "param.h"
#include "fields.h"
#include "ndimen.h"
#include "stmap.h"
!
! Local parameters:
!
!  PRCFAC - Precision factor used to resolve float equality
!                  within the precision of a 4 byte REAL.
!  PVFRAC - Initial fraction of the vector magnitude used to
!                  determine the differential increment.
!  IPMXCT - Number of times to allow the differential to increase.
!  PDUVML - Multiplier when the differential is increased.
!  PCSTST - Test value for closeness to 90 degree latitude.
!
      integer ipmxct
      real pcstst, pduvml, prcfac, pvfrac
      parameter (ipmxct=40, prcfac=1e5, pvfrac=0.1,
     &             pduvml=2.0, pcstst=prcfac*90.0)
!
! Local variables:
!
! XE,YE   - Current end of the temporary vector (data space).
! XU2,YU2 - Current end of the temporary vector (user space).
! DU2,DV2 - Differential vector components in user space.
! TH      - Angle theta
!
      real xe,ye, xu2,yu2, du2,dv2, th

      ierr=0
      if (imap.eq.0 .or. imap.eq.4) then       ! No mapping: just
        ta=atan2(dv,du)                        ! calculate the angle
      elseif (imap.eq.1 .or. imap.eq.3) then
        xe=xda+du                              ! Spherical mapping 
        ye=yda+dv                              ! projections:
        call stumxy (xe,ye, xu2,yu2, ierr)     ! X is longitude, 
        if (ierr.ne.0) return                  ! Y is latitude. 
        du2=xu2-xus                            ! If Y is 90 degrees
        dv2=yu2-yus                            ! direction cannot
        ta=atan2(dv2,du2)                      ! be computed
      elseif (imap.eq.2) then
        ta=atan2(dv,du)                        ! Polar
        if (itrt.ge.1) then                    ! coordinate
          th=pdtor*yda                         ! mapping.
          ta=th+ta
        endif
      endif
      return
      end
